indexing

	description: "Construct for a printer setting value"
	author: "Glenn Maughan <glennm@insect.sd.monash.edu.au>"
	status: "See notice at end of class"
	date: "1996/01/18 10:02:43"
	revision: "1.1.1.1"

class SETTING 
	
inherit
	
	S_SETTING
		redefine
			post_action
		end
	
	SEMANTIC_INFORMATION
	
creation
	
	make
	
feature {CONSTRUCT} -- Semantics
	
	post_action (level: INTEGER) is
			-- Build a new set option depending on the values stored in info.
			-- Build a range setting if needed.
		local
			set_option: SET_OPTION
			set_option_range: SET_OPTION_RANGE
		do 
			debug ("semantics")
				display_indent (io.output, level)
				io.putstring ("post_action: (storing new set option) ")
				print_name
				io.new_line
			end	 	 
			-- Check whether a range setting option is needed.
			-- Determined by the value of last_lower.
			if info.last_interval_lower /= Void then
				-- we need to build a range value
				!! set_option_range
				set_option_range.set_lower_value (info.last_interval_lower)
				set_option_range.set_upper_value (info.last_interval_upper)
				-- clear used info
				info.set_last_interval_lower (Void)
				info.set_last_interval_upper (Void)
				-- assign the reference to store later
				set_option := set_option_range
			else
				-- we need a normal set option
				!! set_option
				-- check for the other types of values
				if info.last_alpha /= Void then
					set_option.set_value (info.last_alpha)
					-- clear info
					info.set_last_alpha (Void)
				elseif info.last_numeric /= Void then
					set_option.set_value (info.last_numeric)
					-- clear info
					info.set_last_numeric (Void)
				elseif info.last_string /= Void then
					set_option.set_value (info.last_string)
					-- clear info
					info.set_last_string (Void)
				elseif info.last_real /= Void then
					set_option.set_value (info.last_real)
					-- clear info
					info.set_last_real (Void)
				end
			end
			-- store the new set option
			info.set_last_set_option (set_option)
		end -- post_action
	
end -- class SETTING

--| hpmodeset - Print file encapsulation utility.
--| Copyright (C) 1995 Glenn Maughan <glennm@insect.sd.monash.edu.au>
--|
--| This program is free software; you can redistribute it and/or modify
--| it under the terms of the GNU General Public License as published by
--| the Free Software Foundation; either version 2 of the License, or
--| (at your option) any later version.
--|
--| This program is distributed in the hope that it will be useful,
--| but WITHOUT ANY WARRANTY; without even the implied warranty of
--| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--| GNU General Public License for more details.
--|
--| You should have received a copy of the GNU General Public License
--| along with this program; if not, write to the Free Software
--| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
