indexing

	description: "Construct for a printer variable"
	author: "Glenn Maughan <glennm@insect.sd.monash.edu.au>"
	status: "See notice at end of class"
	date: "1996/01/18 10:02:43"
	revision: "1.1.1.1"

class PRINTER_VARIABLE 

inherit
   
	S_PRINTER_VARIABLE
		redefine   
			post_action
		end
	
	SEMANTIC_INFORMATION
	
creation
	
	make
	
feature {CONSTRUCT} -- Semantics
	
	post_action (level: INTEGER) is
			-- Add a new printer variable to the variables table
		local
			variable: PRINTER_SET_VARIABLE
		do 
			debug ("semantics")
				display_indent (io.output, level)
				io.putstring ("post_action: (adding new variable to variable table) ")
				print_name
				io.new_line
			end	 
			-- build new variable 
			!! variable.make
			-- get the syntax
			variable.set_syntax (info.last_variable_syntax)
			-- get the option list
			variable.options.append (info.last_option_list)
			-- get the default
			variable.set_default_option (info.last_default_option)
			-- store the variable indexed on the switch
			info.configuration.variables.put (variable, info.last_switch)
			-- clear used info
			info.set_last_switch (Void)
			info.set_last_variable_syntax (Void)
			info.set_last_option_list (Void)
			info.set_last_default_option (Void)
		end -- post_action
	
end -- class PRINTER_VARIABLE

--| hpmodeset - Print file encapsulation utility.
--| Copyright (C) 1995 Glenn Maughan <glennm@insect.sd.monash.edu.au>
--|
--| This program is free software; you can redistribute it and/or modify
--| it under the terms of the GNU General Public License as published by
--| the Free Software Foundation; either version 2 of the License, or
--| (at your option) any later version.
--|
--| This program is distributed in the hope that it will be useful,
--| but WITHOUT ANY WARRANTY; without even the implied warranty of
--| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--| GNU General Public License for more details.
--|
--| You should have received a copy of the GNU General Public License
--| along with this program; if not, write to the Free Software
--| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
