indexing

	description: "Construct for a list of options"
	author: "Glenn Maughan <glennm@insect.sd.monash.edu.au>"
	status: "See notice at end of class"
	date: "1996/01/18 10:02:43"
	revision: "1.1.1.1"

class OPTIONS 

inherit
   
	S_OPTIONS
		redefine
			pre_action,
			middle_action
		end
	
	SEMANTIC_INFORMATION
	
creation
	
	make
	
feature {CONSTRUCT} -- Semantics    
	
	pre_action (level: INTEGER) is
			-- Build a new option list
		local
			list: LINKED_LIST [SET_OPTION]
		do 
			debug ("semantics")
				display_indent (io.output, level)
				io.putstring ("pre_action: (storing new option list) ")
				print_name
				io.new_line
			end
			-- build list
			!! list.make
			-- store list
			info.set_last_option_list (list)
		end -- pre_action
	
	middle_action (level: INTEGER) is
			-- Add the last option to the option list
		do 
			debug ("semantics")
				display_indent (io.output, level)
				io.putstring ("middle_action: (storing last option in option list) ")
				print_name
				io.new_line
			end
			-- check that the option was set.  A comment
			-- may cause firing of middle_action
			if info.last_set_option /= Void then
				-- append last option to option list
				info.last_option_list.extend (info.last_set_option)
				-- clear info
				info.set_last_set_option (Void)
			end
		end -- middle_action
	
end -- class OPTIONS

--| hpmodeset - Print file encapsulation utility.
--| Copyright (C) 1995 Glenn Maughan <glennm@insect.sd.monash.edu.au>
--|
--| This program is free software; you can redistribute it and/or modify
--| it under the terms of the GNU General Public License as published by
--| the Free Software Foundation; either version 2 of the License, or
--| (at your option) any later version.
--|
--| This program is distributed in the hope that it will be useful,
--| but WITHOUT ANY WARRANTY; without even the implied warranty of
--| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--| GNU General Public License for more details.
--|
--| You should have received a copy of the GNU General Public License
--| along with this program; if not, write to the Free Software
--| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
