indexing

	description: "Printer language construct"
	author: "Glenn Maughan <glennm@insect.sd.monash.edu.au>"
	status: "See notice at end of class"
	date: "1996/01/18 10:02:43"
	revision: "1.1.1.1"
	
class LANGUAGE 
	
inherit
	
	S_LANGUAGE
		redefine   
			post_action
		end
	
	SEMANTIC_INFORMATION
	
creation
	
	make
	
feature {CONSTRUCT} -- Semantics
	
	post_action (level: INTEGER) is
			-- Add a new language object to the languages table of the configuration
		local
			language: PRINTER_LANGUAGE
		do 
			debug ("semantics")
				display_indent (io.output, level)
				io.putstring ("post_action: (adding new language to language table) ")
				print_name
				io.new_line
			end	 
			-- build new printer language 
			!! language
			-- get the language command
			language.set_command (info.last_language_command) 
		        -- get the language leave command
		        language.set_leave_command (info.last_language_leave_command)
		        -- get the magic offset
			check
				integer_interval: info.last_numeric.is_integer
			end
			language.set_magic_offset (info.last_numeric.to_integer)
			-- get the magic string
			language.set_magic_string (info.last_magic_string)
			-- store the new language in the table indexed on language name
			info.configuration.languages.put (language, info.last_alpha)
			-- clear used info
			info.set_last_alpha (Void)
			info.set_last_numeric (Void)
			info.set_last_language_command (Void)
			info.set_last_magic_string (Void) 
			info.set_last_language_leave_command (Void)
		end -- post_action
	
end -- class LANGUAGE

--| hpmodeset - Print file encapsulation utility.
--| Copyright (C) 1995 Glenn Maughan <glennm@insect.sd.monash.edu.au>
--|
--| This program is free software; you can redistribute it and/or modify
--| it under the terms of the GNU General Public License as published by
--| the Free Software Foundation; either version 2 of the License, or
--| (at your option) any later version.
--|
--| This program is distributed in the hope that it will be useful,
--| but WITHOUT ANY WARRANTY; without even the implied warranty of
--| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--| GNU General Public License for more details.
--|
--| You should have received a copy of the GNU General Public License
--| along with this program; if not, write to the Free Software
--| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
