indexing

	description: "Numeric interval construct type"
	author: "Glenn Maughan <glennm@insect.sd.monash.edu.au>"
	status: "See notice at end of class"
	date: "1996/01/18 10:02:43"
	revision: "1.1.1.1"

class INTERVAL_TYPE 
	
inherit
	
	S_INTERVAL_TYPE
		redefine
			action
		end
	
	SEMANTIC_INFORMATION
	
creation
	
	make
	
feature {CONSTRUCT} -- Semantics
	
	Hyphen_character: CHARACTER is '-'
	
	action (level: INTEGER) is
			-- Store the interval as two parts: the lower value and the
			-- upper value.
		local
			s: STRING
			hyphen_position: INTEGER
		do 
			debug ("semantics")
				display_indent (io.output, level)
				io.putstring ("post_action: (storing interval lower and upper values) ")
				print_name
				io.new_line
			end
			-- get the string_value
			s := token.string_value
			-- find the location of the hyphen (range separator).
			hyphen_position := s.index_of (Hyphen_character, 1)
			-- store the lower value to the number before the hyphen
			info.set_last_interval_lower (s.substring (1, hyphen_position - 1))
			-- store the upper value to the number after the hyphen
			info.set_last_interval_upper (s.substring (hyphen_position + 1, s.count))
		end -- action
	
end -- class INTERVAL_TYPE

--| hpmodeset - Print file encapsulation utility.
--| Copyright (C) 1995 Glenn Maughan <glennm@insect.sd.monash.edu.au>
--|
--| This program is free software; you can redistribute it and/or modify
--| it under the terms of the GNU General Public License as published by
--| the Free Software Foundation; either version 2 of the License, or
--| (at your option) any later version.
--|
--| This program is distributed in the hope that it will be useful,
--| but WITHOUT ANY WARRANTY; without even the implied warranty of
--| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--| GNU General Public License for more details.
--|
--| You should have received a copy of the GNU General Public License
--| along with this program; if not, write to the Free Software
--| Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
