.\" @(#)hpmodeset.man
.\"
.TH HPMODESET 1 "18 January 1996"
.UC 4
.SH NAME
hpmodeset - encapsulates printer files within printer control commands
.SH SYNOPSIS
.B hpmodeset
.B -help | -showconfig | -license

.B hpmodeset
.B 
[ 
.B config switches
]
[
.B option switches
]
[
.B printer switches
]
.I filelist
.SH DESCRIPTION
.I hpmodeset
encapsulates each named file in configurable printer control
commands and generates one print file to standard output.  
The printer control commands are selected by user configurable 
command line switches.
.PP 
Options can be overridden by options within the print files
themselves.  Typical examples include the number of copies and the
print orientation.  You should use the printer language controls
whenever possible to avoid unexpected problems.  For example the 
.B dvips
program used to generate PostScript from DVI files can control the
number of copies, the page orientation and a number of other switches.
It should be used to control those options rather than using hpmodeset.
.PP
.B hpmodeset
will leave the printer in its original state after printing.  It only
effects the modified print environment and causes a reset of the
user default environment after every print job.
.SH GENERAL SWITCHES
.TP 0.6i
.B -help
Display a short description of the command line syntax.  This also
lists all printer control switches currently available and their valid options.
.TP 0.6i
.B -showconfig
List the current configuration in the form of each command line
switch, the printer control command, valid options and the default option.
.TP 0.6i
.B -license
Show the copyright and licensing information.
.SH CONFIG SWITCHES
.TP 0.6i
.B -configfile=\fIfile\fP
Use \fIfile\fP as the configuration file.  \fBhpmodeset\fP
will read and parse the configuration settings in \fIfile\fP
and store the resulting configuration in a file named
\fIfile\fP.store.  
Running \fBhpmodeset\fP again with the same configuration file will result
in the store file being read.  The config file will only be read if it
has been modified or the store file has been removed.
.SH OPTION SWITCHES
.TP 0.6i
.B -notext
Do not allow unknown print file languages to be output.  By default,
any print file containing an unknown printer language is output as
straight text (without an enter language command).  This option turns
off this feature.
.TP 0.6i
.B -pjlonly
Only output the PJL commands.  Ignore any file list.  This is useful
for sending SET DEFAULT commands to printers.
.SH PRINTER SWITCHES
The general form of a printer control command line switch is as
follows:

.ti +0.5i
-\fIswitch\fP=[\fIvalue\fP]
.PP
Where \fIswitch\fP is one of the recognised printer switches and
\fIvalue\fP is a valid textual value for that switch.  For example,
\fBhpmodeset\fP may be configured to understand a switch to turn
draft mode on or off.  The user may then add the following switch to
\fBhpmodeset\fP's command line:

.ti +0.5i
-draft=on
.PP
This would encapsulate the printer files in the printer control
command to turn draft mode on.  The \fIvalue\fP is optional.  If the
user does not add a \fIvalue\fP after the equals sign then the default
option is used:

.ti +0.5i
-draft=
.PP
would encapsulate the printer files in the default draft mode printer
control command.
.PP
Any number of printer control switches can be added to the command
line.  The list of file names to encapsulate will be read following
the last valid printer control switch.  Note that the equals sign is
required whether a \fIvalue\fP has been given or not.
.SH FILE LIST
.TP 0.6i
.I filelist
The files containing printer language commands (as understandable by
your printer).  Each file will be encapsulated within the printer
control commands that represent the options selected by the user.  
The resulting file will then be sent to stdout.
If the file name 
.B -
is used then stdin will be read at that position in the file list. 
.SH USAGE
.PP
.I hpmodeset
generates encapsulated printer files to its standard
output.  To determine the switches available in your local
configuration run \fBhpmodeset\fP with the \fB-help\fP switch.  This
will list all available command line switches along with the valid
values for each switch.
.PP
The user can redirect the output of \fBhpmodeset\fP to a file, pipe it
directly to a print command (like \fBlpr\fP), or to another filter for
further processing.

.ti +0.5i
.B hpmodeset file1 > file2

.ti +0.5i
.B hpmodeset -draft=on file1 | lpr
.PP
The first example above encapsulates \fIfile1\fP within printer 
control commands (in this case none) and redirects the output 
to \fIfile2\fP.  The second example pipes the output (encapsulated
in a draft command) to the \fBlpr\fP command.
.PP
To read standard input use the file marker \fB\-\fP, as in the
following example:

.ti +0.5i
.B cat file1 | hpmodeset -draft=on - | lpr
.SH CONFIGURATION
\fBhpmodeset\fP is configured through a text file that defines the
available printer control switches, their command syntax and valid
options. The configuration file is composed of a number of sections.
Each section has the following form:

.ti +0.5i
Section \fISectionName\fP

.ti +1.0i
\fISectionEntry\fP

.ti +0.5i
EndSection
.PP

The valid \fISectionName\fPs are \fBglobals\fP, \fBlanguages\fP, and
\fBvariables\fP.  Each \fISectionEntry\fP has a different format
depending on the section it is contained within.
.PP
The \fBglobals\fP section is mandatory.  It contains a number of
global settings for \fBhpmodeset\fP to function correctly.  The syntax
for \fISectionEntry\fP in the \fBglobals\fP section is as follows:

.ti +0.5i
\fIGlobalVariableName\fP \fIVariableValue\fP
.PP
The \fIGlobalVariableName\fP may be one of \fBjob_header\fP,
\fBjob_trailer\fP, \fBreset_command\fP, \fBend_of_command\fP or
\fBwhite_space\fP.

The \fIVariableValue\fP for each of these settings must be a string of
characters surrounded by double quotes.  There is currently no way to
escape literal characters (This functionality will be fixed in a
later version).  Enter them into the strings as normal characters.
Entries for every \fIGlobalVariableName\fP must appear in the config
file.

The \fBlanguages\fP section defines the languages supported by the
printer and the magic numbers to search for to determine the language
used in a print file.  This section should define the languages that
your printer supports.  The syntax for a \fISectionEntry\fP in the
\fBlanguages\fP section is as follows:

.ti +0.5i
\fILanguage\fP \fIEnterCommand\fP \fILeaveCommand\fP \fIOffset\fP \fIMagicString\fP
.PP

The \fILanguage\fP is an arbitrary name used for the language.  For
example \fBpostscript\fP and \fBpcl\fP are valid language names.  The
\fIEnterCommand\fP is the printer control command to enter the
language in question.  This command should be complete.  ie., the
printer should expect a stream of code in the language specified
immediately after the \fIEnterCommand\fP.

The \fILeaveCommand\fP specifies a command to use when leaving the
language.  For example, PostScript expects a Control-D character after
every PostScript file.  This can be specified in the
\fILeaveCommand\fP.

The \fIOffset\fP specifies the byte to start searching for the
\fIMagicString\fP.  One (1) is the first byte in the file, not zero
(0).  The \fIMagicString\fP is an arbitrary string of characters that
will uniquely determine the type of code in the print file.  For
example, PostScript code can be recognised by the magic string "%!"
starting at byte one (1) of a print file.

The final, and most important section in the config file is the
\fBvariables\fP section.  This section defines the available command
line switches, their valid options, the default option and the printer
command to set the variable.  The syntax for \fISectionEntry\fP in the
\fBvariables\fP section is as follows:

.ti +0.5i
\fISwitch\fP \fIVariable\fP \fIOptions\fP \fIDefault\fP
.PP

The \fISwitch\fP defines the command line syntax for each switch.
This must be a word preceeded by a hyphen (-) character.  The
\fIVariable\fP is the printer command used to set the variable.  This
must be a string of characters surrounded by double quotes (").
The \fIOptions\fP is a comma separated list of valid options in the
form of either a word, a number (optionally signed) or a numeric
interval (in the form "lower-upper").  The \fIDefault\fP option is the
option that will be used if the user specifies the switch with no
value.  

Any number of variables may be specified.  The \fISwitch\fP should not
include the equals sign (=).  This is added automatically by the
\fBhpmodeset\fP utility when parsing the command line.

.SH OPERATION
\fBhpmodeset\fP encapsulates files using the following order:

The job_header is output first: job_header end_of_command  

Followed by each option specified on the command line: Variable
white_space Option end_of_command.

Followed by the relevant language enter command determined by
examining each print file: EnterCommand end_of_command

Followed by the raw print file stream.

This is repeated for each print file.

The complete job is then ended with: job_trailer end_of_command
reset_command

.SH "SEE ALSO"
lpr(1) psnup(1) dvips(1)
.SH AUTHOR
Glenn Maughan <glennm@insect.sd.monash.edu.au>
.SH CONTRIBUTORS
The Linux Community:  The first version released to the public was
version 1.2.  It was released to the Linux community in binary form
only.  It was downloaded approximatelly 400 times in the first 3 
days after release!  Many new ideas and encouragement for a new release
was received in the following weeks.  This release is the result.

Eiffel: The Eiffel language made writing this utility easy.

.SH NOTES
LaserJet, DeskJet, PJL and PCL are registered trademarks of Hewlett-Packard
Company.
PostScript is a registered trademark of Adobe Systems Incorporated.
