/*********************************************************************************/
/*                                                                               */
/*  FenForm - Document Printer                                                   */
/*  Vn 2.0                                                                       */
/*                                                                               */
/*  Project Leader - Mike Eggleston                                              */
/*                                                                               */
/*  Copyright 2005 - 2008 Fenland Software Ltd                                   */
/*  Date: 28/08/2008                                                             */
/*                                                                               */
/*  Configuration & Utilities Module - fenform_cfg.c                             */
/*                                                                               */
/*********************************************************************************/
/*                                                                               */
/*  Licence: GPL Vn2                                                             */
/*                                                                               */
/*  This program is free software; you can redistribute it and/or modify         */
/*  it under the terms of the GNU General Public License as published by         */
/*  the Free Software Foundation; either version 2 of the License, or            */
/*  (at your option) any later version.                                          */
/*                                                                               */
/*  This program is distributed in the hope that it will be useful,              */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of               */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                */
/*  GNU General Public License for more details.                                 */
/*                                                                               */
/*  You should have received a copy of the GNU General Public License            */
/*  along with this program; if not, write to the Free Software                  */
/*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    */
/*                                                                               */
/*                                                                               */
/*                                                                               */
/*********************************************************************************/


#include "fenform.h"

/******************************/
/*  Utility Functions         */
/******************************/

/* Remove all 'new-line' characters from the end of a string */
void FENFORM_CFG_RemoveNewline( char *textline )
{

    while( textline[ strlen( textline )-1 ] == '\n' )
     textline[ strlen( textline )-1 ] = '\0';

}


int FENFORM_CFG_ParseCSV(char *str, char *ary[ ], int num, char separator )
{

    int quote_on = 0,
        n = 0;

    char *s;

    while( n < num )
    {
     while( *str && isblank( *str ) )
      str++;

     if( *str == '\"' ) {
      quote_on = quote_on ? 0 : 1;
      str++;
     }

     /* Remove an initial apostrophe */
     if( *str == '\'' )
      str++;

     s = str;

     while( *str && ( ( *str != separator ) || quote_on ) ) {
      if( *str == '\"' ) {

       if( quote_on )
        *str = '\0';

       quote_on = quote_on ? 0 : 1;
      }
      str++;
     }

     *str++ = '\0';
     ary[ n++ ] = s;
    }

    return( n );

}


int FENFORM_CFG_GetMediaSize( FF_Handle *Hndl )
{

    FILE *media_file_ptr;

    char parm_str[ LINE_LEN + 1 ],
         *parm_array[ 6 ];

    int  elements,
         ret = -1;

    Hndl->cfg.paper_length = -1;
    Hndl->cfg.paper_width = -1;

    if( Hndl->cfg.paper_size_file ) {

     if( media_file_ptr = fopen( Hndl->cfg.paper_size_file, "r" ) ) {
      while( fgets( parm_str, LINE_LEN, media_file_ptr ) ) {
     
       if( strncasecmp( parm_str, Hndl->cfg.paper_size, strlen( Hndl->cfg.paper_size ) ) ) {
        continue;

       } else {

        if( elements = FENFORM_CFG_ParseCSV( parm_str, parm_array, 5, ',' ) >= 5 ) {
         Hndl->cfg.paper_length = atof( parm_array[ 3 ] );
         Hndl->cfg.paper_width = atof( parm_array[ 4 ] );

         ret = 0;
        }

        break;

       }
      }

      fclose( media_file_ptr );

     }
    }

    return( ret );
}


char *FENFORM_CFG_ExtractParameter( char *parm_str )
{
    static char *val = NULL;

    FENFORM_CFG_RemoveNewline( parm_str );

    if( strcspn( parm_str, " \t=" ) < strlen( parm_str ) ) {
     val = parm_str + strcspn( parm_str, " \t=" ) + 1;

     if( isblank( *val ) )
      while( isblank( *(++val) ) );

    } else
     val = NULL;

    *( parm_str + strcspn( parm_str, " \t=" ) ) = '\0';

    return( val );

}


int FENFORM_CFG_ProcessParameters( FF_Handle *Hndl, char *parm, char *c_val )
{

    if( strcasecmp( parm, "FONTMAP" ) == '\0' ) {
     if( c_val ) {
      Hndl->cfg.font_map = malloc( ( strlen( c_val ) + 2 ) * sizeof( char ) );
      strcpy( Hndl->cfg.font_map, c_val );
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t%s\t-- OK\n", parm, c_val );
     } else {
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t*** Error - Value required\n", parm );
     }
     return( 0 );
    }

    if( strcasecmp( parm, "FORMDIR" ) == '\0' ) {
     if( c_val ) {
      Hndl->cfg.forms_dir = malloc( ( strlen( c_val ) + 2 ) * sizeof( char ) );
      strcpy( Hndl->cfg.forms_dir, strcat( c_val, "/" ) );
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t%s\t-- OK\n", parm, c_val );
     } else {
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t*** Error - Value required\n", parm );
     }
     return( 0 );
    }

    if( strcasecmp( parm, "MEDIASIZE" ) == '\0' ) {
     if( c_val ) {
      Hndl->cfg.paper_size = malloc( ( strlen( c_val ) + 2 ) * sizeof( char ) );
      strcpy( Hndl->cfg.paper_size, c_val );
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t%s\t-- OK\n", parm, c_val );
     } else {
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t*** Error - Value required\n", parm );
     }
     return( 0 );
    }

    if( strcasecmp( parm, "MEDIAFILE" ) == '\0' ) {
     if( c_val ) {
      Hndl->cfg.paper_size_file = malloc( ( strlen( c_val ) + 2 ) * sizeof( char ) );
      strcpy( Hndl->cfg.paper_size_file, c_val );
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t%s\t-- OK\n", parm, c_val );
     } else {
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t*** Error - Value required\n", parm );
     }
     return( 0 );
    }

    if( strcasecmp( parm, "STDFONT" ) == '\0' ) {
     if( c_val ) {
      Hndl->cfg.std_font = malloc( ( strlen( c_val ) + 1 ) * sizeof( char ) );
      strcpy( Hndl->cfg.std_font, c_val );
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t%s\t-- OK\n", parm, c_val );
     } else {
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t*** Error - Value required\n", parm );
     }
     return( 0 );
    }

    if( strcasecmp( parm, "BOLDFONT" ) == '\0' ) {
     if( c_val ) {
      Hndl->cfg.bold_font = malloc( ( strlen( c_val ) + 1 ) * sizeof( char ) );
      strcpy( Hndl->cfg.bold_font, c_val );
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t%s\t-- OK\n", parm, c_val );
     } else {
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t*** Error - Value required\n", parm );
     }
     return( 0 );
    }

    if( strcasecmp( parm, "DBLSTRIKEFONT" ) == '\0' ) {
     if( c_val ) {
      Hndl->cfg.dblstrike_font = malloc( ( strlen( c_val ) + 1 ) * sizeof( char ) );
      strcpy( Hndl->cfg.dblstrike_font, c_val );
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t%s\t-- OK\n", parm, c_val );
     } else {
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t*** Error - Value required\n", parm );
     }
     return( 0 );
    }

    if( strcasecmp( parm, "ITALICS" ) == '\0' ) {
     if( c_val ) {
      Hndl->cfg.italic_font = malloc( ( strlen( c_val ) + 1 ) * sizeof( char ) );
      strcpy( Hndl->cfg.italic_font, c_val );
      if( Hndl->run_mode )
       fprintf( stderr,"  %s\t\t%s\t-- OK\n", parm, c_val );
     } else {
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t*** Error - Value required\n", parm );
     }
     return( 0 );
    }

    if( strcasecmp( parm, "BOLDITALICS" ) == '\0' ) {
     if( c_val ) {
      Hndl->cfg.bold_italic_font = malloc( ( strlen( c_val ) + 1 ) * sizeof( char ) );
      strcpy( Hndl->cfg.bold_italic_font, c_val );
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t%s\t-- OK\n", parm, c_val );
     } else {
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t*** Error - Value required\n", parm );
     }
     return( 0 );
    }

    if( strcasecmp(parm, "DBLSTRIKEITALICS" ) == '\0' ) {
     if( c_val ) {
      Hndl->cfg.dblstrike_italic_font = malloc( ( strlen( c_val ) + 1 ) * sizeof( char ) );
      strcpy( Hndl->cfg.dblstrike_italic_font, c_val );
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t%s\t-- OK\n", parm, c_val );
     } else {
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t*** Error - Value required\n", parm );
     }
     return( 0 );
    }

    if( strcasecmp( parm, "NLQFONT" ) == '\0' )
    {
     if( c_val ) {
      Hndl->cfg.nlq_font = malloc( ( strlen( c_val ) + 1 ) * sizeof( char ) );
      strcpy( Hndl->cfg.nlq_font, c_val );
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t%s\t-- OK\n", parm, c_val );
     } else {
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t*** Error - Value required\n", parm );
     }
     return( 0 );
    }

    if( strcasecmp( parm, "BOLDNLQFONT" ) == '\0' ) {
     if( c_val ) {
      Hndl->cfg.bold_nlq_font = malloc( ( strlen( c_val ) + 1 ) * sizeof( char ) );
      strcpy( Hndl->cfg.bold_nlq_font, c_val );
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t%s\t-- OK\n", parm, c_val );
     } else {
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t*** Error - Value required\n", parm );
     }
     return( 0 );
    }

    if( strcasecmp( parm, "DBLSTRIKENLQFONT" ) == '\0' ) {
     if( c_val ) {
      Hndl->cfg.dblstrike_nlq_font = malloc( ( strlen( c_val ) + 1 ) * sizeof( char ) );
      strcpy( Hndl->cfg.dblstrike_nlq_font, c_val);
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t%s\t-- OK\n", parm, c_val );
     } else {
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t*** Error - Value required\n", parm );
     }
     return( 0 );
    }

    if( strcasecmp( parm, "NLQITALICS" ) == '\0' ) {
     if( c_val ) {
      Hndl->cfg.nlq_italic_font = malloc( ( strlen( c_val ) + 1 ) * sizeof( char ) );
      strcpy( Hndl->cfg.nlq_italic_font, c_val );
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t%s\t-- OK\n", parm, c_val );
     } else {
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t*** Error - Value required\n", parm );
     }
     return( 0 );
    }

    if( strcasecmp( parm, "BOLDNLQITALICS" ) == '\0' ) {
     if( c_val ) {
      Hndl->cfg.bold_nlq_italic_font = malloc( ( strlen( c_val ) + 1 ) * sizeof( char ) );
      strcpy( Hndl->cfg.bold_nlq_italic_font, c_val );
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t%s\t-- OK\n", parm, c_val );
     } else {
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t*** Error - Value required\n", parm );
     }
     return( 0 );
    }

    if( strcasecmp( parm, "DBLSTRIKENLQITALICS" ) == '\0' )
    {
     if( c_val ) {
      Hndl->cfg.dblstrike_nlq_italic_font = malloc( ( strlen( c_val ) + 1 ) * sizeof( char ) );
      strcpy( Hndl->cfg.dblstrike_nlq_italic_font, c_val );
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t%s\t-- OK\n", parm, c_val );
     } else {
      if( Hndl->run_mode )
       fprintf( stderr, "  %s\t\t*** Error - Value required\n", parm );
     }
     return( 0 );
    }

    if( strcasecmp( parm, "AUTO_LF" ) == '\0' ) {
     Hndl->cfg.auto_lf = FF_ON;
     if( Hndl->run_mode ) {
      if( c_val )
       fprintf( stderr, "  %s\t%s\t*** Warning - Value not required.\n", parm, c_val  );
      else
       fprintf( stderr, "  %s\t\t\t-- OK\n", parm );
     }
     return( 0 );
    }

    if( strcasecmp( parm, "COLOUR" ) == '\0' ) {
     Hndl->cfg.full_colour = FF_ON;
     if( Hndl->run_mode ) {
      if( c_val )
       fprintf( stderr, "  %s\t%s\t*** Warning - Value not required.\n", parm, c_val  );
      else
      fprintf( stderr,"  %s\t\t\t-- OK\n", parm );
     }
     return( 0 );
    }

    /* If we get here, an unrecognized parameter has been found */
    return( -1 );

}


int FENFORM_CFG_GetUserConfig( FF_Handle *Hndl )
{

    FILE *config_file_ptr;

    char parm_str[ LINE_LEN + 1 ],
         *c_val,
         *cfg_file_name;

    int ret = 0;

    cfg_file_name = malloc( ( strlen( Hndl->pswd->pw_dir ) + 23 ) * sizeof( char ) );
    sprintf( cfg_file_name, "%s/.fenform/fenform.cfg", Hndl->pswd->pw_dir );

    if( Hndl->run_mode )
     fprintf( stderr, "Validating User Configuration file:  %s\n", cfg_file_name );

    if( config_file_ptr = fopen( cfg_file_name, "r" ) ) {
     syslog( LOG_INFO, "Reading User configuration file %s\n", cfg_file_name );

     while( fgets( parm_str, LINE_LEN, config_file_ptr ) ) {
      if( ( *parm_str == '#' ) || ( *parm_str == '\n' ) )
       continue;

      c_val = FENFORM_CFG_ExtractParameter( parm_str );
      if( *parm_str == 0 )
       continue;

      if( FENFORM_CFG_ProcessParameters( Hndl, parm_str, c_val ) == 0 )
       continue;

      /* If we get here, the parameter name is invalid */
      ret = -1;

      if( Hndl->run_mode )
       fprintf( stderr, "Invalid parameter: %s\n", parm_str );
 
     }
     fclose( config_file_ptr );

    } else {

     if( Hndl->run_mode )
      fprintf( stderr,"No User Configuration file.\n" );

     if( Hndl->verbose )
      syslog( LOG_INFO,"No User Configuration file.\n" );

    }

    return( ret );

}


int FENFORM_CFG_GetConfig( FF_Handle *Hndl )
{
    FILE *config_file_ptr;

    char parm_str[ LINE_LEN + 1 ],
         *c_val;

    int ret = 0;

    /* Clear the configuration structure */
    memset( &Hndl->cfg, '\0', sizeof( FF_Config ) );

    /* Set up configuration defaults.  */
    /* These will be overridden by a configuration file  */

    Hndl->cfg.font_map = _FONT_MAP;
    Hndl->cfg.forms_dir = _FORMS;
    Hndl->cfg.paper_size_file = _PAPER_SIZE_FILE;
    Hndl->cfg.paper_size = DFT_PAPER_SIZE;
    Hndl->cfg.paper_orientation = DFT_ORIENTATION;
    Hndl->cfg.std_font = _STDFONT;
    Hndl->cfg.bold_font= _STDBOLD;
    Hndl->cfg.dblstrike_font = _STDDBLSTRIKE;
    Hndl->cfg.italic_font = _STDITALIC;
    Hndl->cfg.bold_italic_font = _STDBOLDITALIC;
    Hndl->cfg.dblstrike_italic_font = _STDDBLSTRIKEITALIC;
    Hndl->cfg.nlq_font = _NLQFONT;
    Hndl->cfg.bold_nlq_font = _NLQBOLD;
    Hndl->cfg.dblstrike_nlq_font = _NLQDBLSTRIKE;
    Hndl->cfg.nlq_italic_font = _NLQITALIC;
    Hndl->cfg.bold_nlq_italic_font = _NLQBOLDITALIC;
    Hndl->cfg.dblstrike_nlq_italic_font = _NLQDBLSTRIKEITALIC;
    Hndl->cfg.auto_lf = FF_OFF;
    Hndl->cfg.full_colour = FF_OFF;
    Hndl->cfg.line_width = BASE_LINEWIDTH;
    Hndl->cfg.allow_override = FF_OFF;

    if( Hndl->config_file ) {

     if( Hndl->run_mode )
      fprintf( stderr, "Validating Configuration file:  %s\n", Hndl->config_file );

     if( config_file_ptr = fopen( Hndl->config_file, "r" ) ) {
      syslog( LOG_INFO, "Reading configuration file %s\n", Hndl->config_file );

      while( fgets( parm_str, LINE_LEN, config_file_ptr ) ) {
   
       if( ( *parm_str == '#' ) || ( *parm_str == '\n' ) )
        continue;

       c_val = FENFORM_CFG_ExtractParameter( parm_str );
       if( *parm_str == 0 )
        continue;

       if( FENFORM_CFG_ProcessParameters( Hndl, parm_str, c_val ) == 0 )
        continue;

       if( strcasecmp( parm_str, "ALLOW_OVERRIDE" ) == '\0' ) {
        Hndl->cfg.allow_override = FF_ON;
        if( Hndl->run_mode ) {
         if( c_val )
          fprintf( stderr, "  %s\t%s\t*** Warning - Value not required.\n", parm_str, c_val  );
         else
          fprintf( stderr, "  %s\t\t%s\t-- OK\n", parm_str, c_val );
        }
        continue;
       }

       /* If we get here, the parameter name is invalid */
       if( Hndl->run_mode )
        fprintf( stderr, "  %s\t\t%s\tERROR Invalid Parameter\n", parm_str, c_val );

       ret = -1;

      } /* End While */

      fclose( config_file_ptr );

     } else {

      ret = 1;

      if( Hndl->run_mode )
       fprintf( stderr, "Configuration file not found - using defaults.\n" );

      syslog( LOG_INFO, "Configuration file (%s) not found - using defaults\n", Hndl->config_file );
     }

    } else {

     if( Hndl->verbose )
      syslog( LOG_INFO, "No configuration file." );

    }

    /* Override main configuration with User's configuration */
    if( Hndl->cfg.allow_override == FF_ON )
     FENFORM_CFG_GetUserConfig( Hndl );

    if( FENFORM_CFG_GetMediaSize( Hndl ) ) {
     if( Hndl->run_mode )
      fprintf( stderr, "Unable to determine media size.\n" );

     syslog( LOG_INFO, "Unable to determine media size.\n" );

     ret = -1;
    } 

    return( ret );

}


/*********************************************************************************/
/*                                                                               */
/*                              Configuration Module                             */
/*                                                                               */
/*                        End of Source Code - fenform_cfg.c                     */
/*                                                                               */
/*********************************************************************************/

