/*********************************************************************************/
/*                                                                               */
/*  FenForm - Document Printer Header File                                       */
/*  Vn 2.0                                                                       */
/*                                                                               */
/*  Project Leader - Mike Eggleston                                              */
/*                                                                               */
/*  Copyright 2005 - 2008 Fenland Software Ltd                                   */
/*  Date: 28/08/2008                                                             */
/*                                                                               */
/*  Main Header File - fenform.h                                                 */
/*                                                                               */
/*********************************************************************************/
/*                                                                               */
/*  Licence: GPL Vn2                                                             */
/*                                                                               */
/*  This program is free software; you can redistribute it and/or modify         */
/*  it under the terms of the GNU General Public License as published by         */
/*  the Free Software Foundation; either version 2 of the License, or            */
/*  (at your option) any later version.                                          */
/*                                                                               */
/*  This program is distributed in the hope that it will be useful,              */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of               */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                */
/*  GNU General Public License for more details.                                 */
/*                                                                               */
/*  You should have received a copy of the GNU General Public License            */
/*  along with this program; if not, write to the Free Software                  */
/*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    */
/*                                                                               */
/*                                                                               */
/*                                                                               */
/*********************************************************************************/

#ifndef __FENFORM_H
#define __FENFORM_H


/******************************/
/*  Program Details           */
/******************************/

#define  COMPANY        "Fenland Software Ltd"
#define  WEB_SITE       "www.fenform.co.uk"
#define  PROGNAME       "FenForm (Vn 2.0)"
#define  COPYRIGHT      "Copyright 2005 - 2008 Fenland Software Ltd"
#define  LICENCE        "GNU General Public Licence - Version 2"

#include <ctype.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <pwd.h>
#include <errno.h>
#include "barcode.h"
#include "pdf417lib.h"
#include <libps/pslib.h>

/*****************************************/
/* Control Codes                         */
/*****************************************/
#define SOH  		'\x01'
#define STX  		'\x02'
#define ETX  		'\x03'
#define EOT		'\x04'
#define ENQ		'\x05'
#define ACK		'\x06'
#define BEL  		'\x07'
#define BS   		'\x08'  
#define HT   		'\x09'
#define LF   		'\x0a'
#define VT   		'\x0b'
#define FF   		'\x0c'
#define CR   		'\x0d'
#define SO   		'\x0e'
#define SI   		'\x0f'
#define DLE  		'\x10'
#define DC1  		'\x11'
#define DC2  		'\x12'
#define DC3  		'\x13'
#define DC4  		'\x14'
#define NAK		'\x15'
#define SYN		'\x16'
#define ETB		'\x17'
#define CAN  		'\x18'
#define EM   		'\x19'
#define SUB		'\x1a'
#define ESC  		'\x1b'
#define FS   		'\x1c'
#define GS		'\x1d'
#define RS		'\x1e'
#define US   		'\x1f'
#define SP   		'\x20'
#define DEL  		'\x7f'
#define BACKSLASH	'\x5c'

#define DFT_FORM_NAME		"A4-Portrait"
#define DFT_ORIENTATION		'P'
#define DFT_PAPER_SIZE		"A4"
#define DFT_LPI			6
#define DFT_CPI			10

#define POINTS_PER_INCH		72	

#define LPI6		12
#define LPI8		9
#define LPI72		1
#define LPI7_72		7
#define LPIn_60		1.2
#define LPIn_180	0.4
#define LPIn_216	POINTS_PER_INCH/216
#define LPIn_360	0.2

#define CPI10		7.2
#define CPI12		6.0
#define CPI15		4.8
#define CPI17		4.21
#define CPI18		4.0
#define CPI20		3.6

#define FF_ON		1
#define FF_OFF		0
#define DFT_HTAB	8
#define SUBSCRIPT	1
#define SUPERSCRIPT	2


/*****************************************/
/* Maximum form version this program can */
/* use.                                  */
/*****************************************/

#define FORM_VERSION	2


/*****************************************/
/* Default field (array) sizes           */
/*****************************************/
#define LINE_LEN	80


/*****************************************/
/* Configuration Defaults                */
/* (These will be overridden by a        */
/* configuration file.)                  */
/*****************************************/
#define _FONT_MAP		"/opt/fenform/etc/fonts/Fontmap.FF"
#define _CFG_FILE		"/opt/fenform/etc/fenform.cfg"
#define _PAPER_SIZE_FILE	"/opt/fenform/etc/stationery.sizes"
#define _FORMS			"/opt/fenform/etc/forms"

#define _STDFONT		"Courier"
#define _STDBOLD		"Courier-Bold"
#define _STDDBLSTRIKE		"Courier-Bold"
#define _STDITALIC		"Courier-Oblique"
#define _STDBOLDITALIC		"Courier-BoldOblique"
#define _STDDBLSTRIKEITALIC	"Courier-BoldOblique"
#define _NLQFONT		"Times-Roman"
#define _NLQBOLD		"Times-Bold"
#define _NLQDBLSTRIKE		"Times-Bold"
#define _NLQITALIC		"Times-Italic"
#define _NLQBOLDITALIC		"Times-BoldItalic"
#define _NLQDBLSTRIKEITALIC	"Times-BoldItalic"

#define _COLOUR_RED		0xFF0000
#define _COLOUR_GREEN		0x00AA00
#define _COLOUR_BLUE		0x0000FF
#define _COLOUR_YELLOW		0xFFFF00
#define _COLOUR_VIOLET		0xFF00FF
#define _COLOUR_ORANGE		0xFF5500
#define _UNDERLINE_OFFSET	8
#define _OVERSCORE_OFFSET	1.5
#define _SUB_SUPER_SIZE		1.7
#define _SUBSCRIPT_OFFSET	9
#define _SUPERSCRIPT_OFFSET	3

#define SHADOW_DEPTH		0.85
#define VTAB_CHANNELS		8
#define MAX_V_TABS		16
#define MAX_H_TABS		32
#define BASE_LINEWIDTH		0.5



/*****************************************/
/* Font settings flags                   */
/*****************************************/

#define FF_ITALICS_FLAG		'\x01'
#define FF_BOLD_FLAG		'\x02'
#define FF_DOUBLESTRIKE_FLAG	'\x04'
#define FF_NLQ_FLAG		'\x08'
#define FF_UNDERLINE_FLAG	'\x10'
#define FF_OVERSCORE_FLAG	'\x20'
#define FF_REVERSE_IMAGE_FLAG	'\x40'
#define FF_SHADOW_FLAG		'\x80'


/*****************************************/
/* Output File Formats                   */
/*****************************************/

typedef enum
{
  PS,
  PDF
} file_format;


/*****************************************/
/* Fenform configuration parameters      */
/*****************************************/

typedef struct _FF_Config
{
char *font_map;
char *forms_dir;
char *paper_size_file;
char *paper_size;
char paper_orientation;
float paper_length;
float paper_width;
char *std_font;
int std_font_id;
char *bold_font;
int bold_font_id;
char *dblstrike_font;
int dblstrike_font_id;
char *italic_font;
int italic_font_id;
char *bold_italic_font;
int bold_italic_font_id;
char *dblstrike_italic_font;
int dblstrike_italic_font_id;
char *nlq_font;
int nlq_font_id;
char *bold_nlq_font;
int bold_nlq_font_id;
char *dblstrike_nlq_font;
int dblstrike_nlq_font_id;
char *nlq_italic_font;
int nlq_italic_font_id;
char *bold_nlq_italic_font;
int bold_nlq_italic_font_id;
char *dblstrike_nlq_italic_font;
int dblstrike_nlq_italic_font_id;
float line_width;
unsigned int auto_lf;
unsigned int full_colour;
unsigned int allow_override;
} FF_Config;


typedef struct _FF_Form
{
char *form_name;
char *image;
char orientation;
float length;
float width;
float line_space;
float base_char_width;
float curr_char_width;
float l_margin;
float r_margin;
float htabs[ MAX_H_TABS ];
float vtabs[ VTAB_CHANNELS ] [ MAX_V_TABS ];
} FF_Form;


typedef struct _FF_barcode
{
unsigned int type;
unsigned int flags;
unsigned int height;
unsigned int width;
} FF_Barcode;


typedef struct _FF_Handle
{
int run_mode;
char *user_name;
char *curr_form;
char *curr_font;
int curr_font_id;
char *date_string;
struct passwd *pswd;
FILE *ifile;
file_format ifile_fmt;
FILE *ofile;
file_format ofile_fmt;
PSDoc *output_ps;
char *config_file;
FF_Config cfg;
FF_Form frm;
FF_Barcode bc_parm;
char *line_of_text;
int verbose;
float red;
float green;
float blue;
unsigned int font_set;
unsigned int page;
float cur_line;
float start_col;
float cur_col;
unsigned int h_tab;
unsigned int curr_vtab_channel;
unsigned int v_tab;
unsigned int font_flags;
float italics_start;
float italics_end;
float bold_start;
float bold_end;
float dblstrike_start;
float dblstrike_end;
float nlq_start;
float nlq_end;
float ul_start;
float ul_end;
float os_start;
float os_end;
float ri_start;
float ri_end;
float shadow_start;
float shadow_end;
unsigned int sub_superscript;
unsigned int text_mode;
unsigned int multi_size;
unsigned int ms_one_line;
unsigned int LF_reverse;
float prev_char_width;
float line_offset;
unsigned int new_page;
} FF_Handle;


typedef struct _FF_HeaderData {
 char *file_id;
 int header_size;
 int major_version;
 int minor_version;
 char *user_name;
 char *form_name;
 char *creation_date;
 char *creation_pgm;
 char *copyright_notice;
 int form_length;
 int form_width;
 int left_margin;
 int top_margin;
 int lpi;
 int cpi;
} FF_HeaderData;



#ifndef uchar
#define uchar unsigned char
#endif



/*****************************************/
/*                                       */
/* Prototypes of functions in            */
/* source file fenform.c                 */
/*                                       */
/*****************************************/

void FENFORM_VersionInformation( void );
void FENFORM_ShowConfiguration( FF_Handle* );
void FENFORM_Initialize( FF_Handle* );
void FENFORM_PrintSuppress( FF_Handle* );
void FENFORM_DefaultForm( FF_Handle* );
int  FENFORM_StartPage( FF_Handle* );
int  FENFORM_ReadParameters( FF_Handle*, int*, int, int );
void FENFORM_PrintText( FF_Handle* );
void FENFORM_PrintShadow( FF_Handle* );
void FENFORM_PrintReverseImage( FF_Handle* );
void FENFORM_SetFont( FF_Handle* );
void FENFORM_SetColour( FF_Handle* );
void FENFORM_HeightModulatedBarcode( FF_Handle*, char );
void FENFORM_SetBarcode( FF_Handle* );
void FENFORM_PrintBarcode( FF_Handle* );
int  FENFORM_ESC_error( int );
int  FENFORM_FS_error( int );
void FENFORM_PrintUnderline( FF_Handle* );
void FENFORM_PrintOverscore( FF_Handle* );
void FENFORM_NewPage( FF_Handle* );
void FENFORM_Backspace( FF_Handle* );
void FENFORM_LineFeed( FF_Handle*, unsigned int );
void FENFORM_Absolute_H_Tab( FF_Handle*, int* );
void FENFORM_HorizontalTab( FF_Handle* );
void FENFORM_VerticalTab( FF_Handle* );
void FENFORM_SetItalics( FF_Handle*, int );
void FENFORM_SetBoldFont( FF_Handle*, int );
void FENFORM_SetDoubleStrikeFont( FF_Handle*, int );
void FENFORM_SetNLQFont( FF_Handle*, int );
void FENFORM_SetCharacterWidth( FF_Handle*, float );
void FENFORM_MultiSize( FF_Handle*, int );
void FENFORM_SetSub_SuperScript( FF_Handle*, int );
void FENFORM_CancelSub_SuperScript( FF_Handle* );
void FENFORM_SetUnderline( FF_Handle*, int );
void FENFORM_SetOverscore( FF_Handle*, int );
void FENFORM_SetShadow( FF_Handle*, int );
void FENFORM_SetColourValue( FF_Handle*, int );
void FENFORM_SetPrintMode( FF_Handle*, int );
void FENFORM_ProcessControlCode( FF_Handle*, int );
void FENFORM_ProcessESC( FF_Handle*, int );
void FENFORM_ProcessFS( FF_Handle*, int );
int  FENFORM_ProcessInput( FF_Handle* );
int  FENFORM_StartDocument( FF_Handle* );
void FENFORM_EndDocument( FF_Handle* );


/*****************************************/
/*                                       */
/* Prototypes of functions in            */
/* source file fenform_ps.c              */
/*                                       */
/*****************************************/

int  FENFORM_PS_StartDocument( FF_Handle* );
void FENFORM_PS_EndDocument( FF_Handle* );
int  FENFORM_PS_ReadFormHeader( FF_Handle*, int );
int  FENFORM_PS_LoadForm( FF_Handle* );
char *FENFORM_PS_FindFontFile( FF_Handle*, char* );
int FENFORM_PS_LoadFonts( FF_Handle* );
void FENFORM_PS_StartPage( FF_Handle* );
void FENFORM_PS_PrintText( FF_Handle* );
void FENFORM_PS_SetFont( FF_Handle* );
void FENFORM_PS_PrintShadow( FF_Handle* );
void FENFORM_PS_PrintReverseImage( FF_Handle* );
void FENFORM_PS_NewPage( FF_Handle* );


/*****************************************/
/*                                       */
/* Prototypes of functions in            */
/* source file fenform_cfg.c             */
/*                                       */
/*****************************************/

void FENFORM_CFG_RemoveNewline( char* );
int  FENFORM_CFG_ParseCSV( char*, char*[ ], int, char );
int  FENFORM_CFG_GetMediaSize( FF_Handle* );
char *FENFORM_CFG_ExtractParameter( char* );
int  FENFORM_CFG_ProcessParameters( FF_Handle*, char*, char* );
int  FENFORM_CFG_GetUserConfig( FF_Handle* );
int  FENFORM_CFG_GetConfig( FF_Handle* );


/*****************************************/
/*                                       */
/* Prototypes of functions in            */
/* source file fenform_bc.c              */
/*                                       */
/*****************************************/

float FENFORM_BC_PrintPostnetCharacter( FF_Handle*, char* );
float FENFORM_BC_Print_RM4SCC_Character( FF_Handle*, char* );

char* FENFORM_BC_EncodePostnet( FF_Handle*, char* );
char* FENFORM_BC_EncodePlanet( FF_Handle*, char* );
char* FENFORM_BC_EncodeRM4SCC( FF_Handle*, char* );

float FENFORM_BC_PrintRM4SCC( FF_Handle*, char* );
float FENFORM_BC_PrintPostnet( FF_Handle*, char* );
float FENFORM_BC_PrintPlanet( FF_Handle*, char* );
float FENFORM_BC_PrintPDF417( FF_Handle*, char* );

void  FENFORM_BC_InvalidBarcode( FF_Handle* );
void  FENFORM_BC_InvalidBarcode_PS( FF_Handle* );


#endif  /* If Not __FENFORM_H */


/*********************************************************************************/
/*                                                                               */
/*                         End of Header File - fenform.h                        */
/*                                                                               */
/*********************************************************************************/

