#include "main.h"
#include <qapp.h>
#include "config.h"

QString key_str[]={
		"# HP Deskjet configuration file",
		"# Produced by HP Deskjet tool",
		"#",
		"QUALITY=",
		"RESOLUTION=",
		"COLORMODE=",
		"ORIENTATION=",
		"PAPERSIZE=",
		"PAPERTYPE=",
		"MANUALFEED=",
		"COMPRESSION=",
		"DRYTIME=",
		"HPMODEL=",
		"MARGINFILE="	};

uint paramNum=13;


DeskjetTool::DeskjetTool( QWidget *parent, const char *name )
    : QTabDialog( parent, name )
{ 
   setCaption( "HP Deskjet utility" );
   setCancelButton();
//   setDefaultButton();
   resize(450,455);
   
   qdlg= new QualityDialog(this,"quality_tab");
   pdlg= new PaperDialog(this,"paper_tab");
   tdlg= new TuningDialog(this,"tuning_tab");
   odlg= new OtherDialog(this,"other_tab");
   adlg= new AboutDialog(this,"about_tab");

   addTab( qdlg, "&Quality" );
   addTab( pdlg, "&Paper" );
   addTab( tdlg, "&Tuning" );
   addTab( odlg, "&Other" );
   addTab( adlg, "&About" );
   connect( this, SIGNAL(applyButtonPressed()), SLOT(writeConfig()) );
   connect( this, SIGNAL(defaultButtonPressed()),  SLOT(setDefaultConfig()) ); 
   connect( this, SIGNAL(cancelButtonPressed()), qApp, SLOT(quit()) ); 
   readConfig();
   show();
}

void DeskjetTool::readConfig()
{ 
  QFile f( CNF_FILE );
  if ( f.open(IO_ReadOnly)==TRUE ) {
       QTextStream fromfile(&f);
       QString str;

       str=fromfile.readLine();
       str=fromfile.readLine(); 
       str=fromfile.readLine();

       uint j=3; uint k=0; QString confStr[paramNum];
       while ( j<=paramNum ) {  
               str=fromfile.readLine();
               for ( uint i=key_str[j++].length(); i<str.length(); i++ )  
                     confStr[k]+=str[i];
               k++;
       }
       f.close();
       qdlg->setQuality(confStr[0]);
       qdlg->setResolution(confStr[1]);
       qdlg->setColorMode(confStr[2]);
       pdlg->setOrientation(confStr[3]);
       pdlg->setPaperSize(confStr[4]);
       pdlg->setPaperType(confStr[5]);
       pdlg->setFeed(confStr[6]);
       tdlg->setCompression(confStr[7]);
       tdlg->setDryTime(confStr[8]);
       odlg->setModel(confStr[9]);
       odlg->setMarginFile(confStr[10]);
 }
 else setDefaultConfig();
}


void DeskjetTool::writeConfig()
{
  QFile f( CNF_FILE );
  f.open(IO_WriteOnly);
  QTextStream toFile(&f);
  toFile << key_str[0]+"\n";  
  toFile << key_str[1]+"\n";
  toFile << key_str[2]+"\n";

  QString q=key_str[3]+qdlg->getQuality()+"\n"; 
  toFile << q;
  q=key_str[4]+qdlg->getResolution()+"\n";
  toFile << q;
  q=key_str[5]+qdlg->getColorMode()+"\n";
  toFile << q;

  QString p=key_str[6]+pdlg->getOrientation()+"\n"; 
  toFile << p;
  p=key_str[7]+pdlg->getPaperSize()+"\n";
  toFile << p;
  p=key_str[8]+pdlg->getPaperType()+"\n";
  toFile << p;
  p=key_str[9]+pdlg->getFeed()+"\n";
  toFile << p;

  QString t=key_str[10]+tdlg->getCompression()+"\n";
  toFile << t;
  t=key_str[11]+tdlg->getDryTime()+"\n";
  toFile << t;
  QString o=key_str[12]+odlg->getModel()+"\n";
  toFile << o;
  o=key_str[13]+odlg->getMarginFile()+"\n";
  toFile << o;
  
  f.close();
  qApp->quit();
}


void DeskjetTool::setDefaultConfig()
{
 qdlg->setQuality("normal");
 qdlg->setResolution("600x600");
 qdlg->setColorMode("mono");
 pdlg->setOrientation("");
 pdlg->setPaperSize("a4");
 pdlg->setPaperType("plain");
 pdlg->setFeed("false");
 tdlg->setCompression("9");
 tdlg->setDryTime("-1");
 odlg->setModel("unspec");
}




int main( int argc, char **argv )
{   
    QApplication a( argc, argv );
    DeskjetTool dj(0, "top-level" );   
    a.setMainWidget( &dj );
    dj.show();
    return a.exec();
}

