#include <qlayout.h>
#include <qbttngrp.h>
#include <qframe.h>
#include <qgrpbox.h>
#include <qradiobt.h>
#include <qlabel.h>
#include <qslider.h>
#include <qlcdnum.h>
#include <qstrlist.h>

class TuningDialog : public QWidget { 
Q_OBJECT

public:
    TuningDialog( QWidget *parent=0, const char *name=0 );
    void setCompression( QString comp );
    void setDryTime( QString dtime );
    void setGamma( QString gamma );
    QString getCompression();
    QString getDryTime();
private slots:
    void updateGamma();
    void compChanged(int comp); 
    void dtimeChanged(int dtime); 
private:
    QStrList *compression;
    QButtonGroup *bg; 
    QRadioButton  *rb[5];
    QLCDNumber *gammaLCD; 
    QSlider *gammaSlider;
    QLCDNumber *dryLCD; 
    QSlider *drySlider;
    int current_comp;
    int current_dtime;
};


