/****************************************************************
** Copyright (C) 1998 Peter Cebokli
**
** This file is distributed under the GNU general public license
** version 2.
** See the file COPYING included in the distribution for the usage
** and distribution terms.
**
** This software comes with no warranty at all except that if it
** breaks, or if it breaks something else, you get to keep all
** the pieces.
**
****************************************************************/

#include "TuningDialog.h"

TuningDialog::TuningDialog( QWidget *parent, const char *name )
    : QWidget( parent, name )
{ 
    compression=new QStrList();
    compression->append("0"); 
    compression->append("1"); 
    compression->append("2"); 
    compression->append("3"); 
    compression->append("9"); 

    QFrame* frame;
    frame = new QFrame( this, "frame" );
    frame->move( 10, 10 );
    frame->resize(parent->width()-36,parent->height()-90);
    frame->setFrameStyle( 49 );

    QVBoxLayout *topLayout = new QVBoxLayout( frame, 15 );
    QGridLayout *grid = new QGridLayout( 3, 3 );
    topLayout->addLayout( grid, 10 );

// COMPRESSION button group
    bg = new QButtonGroup( frame, "compression" );
    bg->setTitle( "Compression" );
    grid->addMultiCellWidget( bg, 0, 0,0,2 );
    QHBoxLayout *hbox = new QHBoxLayout( bg, 20 );

    for (int i=0; i<=4; i++) {
         rb[i] = new QRadioButton( bg );
         rb[i]->setText( compression->at(i) );
         hbox->addWidget(rb[i]);
         rb[i]->setMinimumSize( rb[i]->sizeHint());
    }
    connect( bg, SIGNAL(pressed(int)), this, SLOT(compChanged(int)) );

// DRYING 
    QGroupBox *gb = new QGroupBox( frame, "drying" );
    gb->setTitle( "Drying time" );
    grid->addMultiCellWidget( gb, 1, 1,0,1 );
    QVBoxLayout *vbox = new QVBoxLayout( gb, 20 );

    dryLCD = new QLCDNumber( gb, "dryLCD" );
    dryLCD->display(-1);
    vbox->addWidget( dryLCD );
    drySlider = new QSlider( -1, 1200, 1, -1, QSlider::Horizontal,
			       gb, "dry_slider" );
    drySlider->setTickmarks( QSlider::Below );
    drySlider->setTickInterval( 100 );
    drySlider->setFixedHeight( drySlider->sizeHint().height() );
    dryLCD->setFixedHeight( drySlider->sizeHint().height()*1.5 );   
    vbox->addWidget( drySlider );
    connect( drySlider, SIGNAL(valueChanged(int)),
    	     dryLCD,    SLOT(display(int)) );
    connect( drySlider, SIGNAL(valueChanged(int)), 
             this,      SLOT(dtimeChanged(int)));

// GAMMA
    gb = new QGroupBox( frame, "gamma" );
    gb->setTitle( "Gamma correction (not yet)" );
    grid->addMultiCellWidget( gb, 2, 2,0,1 );
    vbox = new QVBoxLayout( gb, 20 );

    gammaLCD = new QLCDNumber( gb, "gammaLCD" );
    vbox->addWidget( gammaLCD );
    gammaSlider = new QSlider( QSlider::Horizontal,gb, "gamma_slider" );
    gammaSlider->setTickmarks( QSlider::Below );
    gammaSlider->setTickInterval( 1 );
    gammaSlider->setFixedHeight( gammaSlider->sizeHint().height() );
    gammaSlider->setRange( -1, 10 );
    gammaLCD->setFixedHeight( gammaSlider->sizeHint().height()*1.5 );   

    vbox->addWidget( gammaSlider );
    connect( gammaSlider, SIGNAL( valueChanged( int ) ), SLOT( updateGamma()));

    grid->setRowStretch(0,1);
    grid->setRowStretch(1,2);  
    grid->setRowStretch(2,2);
    topLayout->activate();

}

void TuningDialog::setCompression( QString compr )
{
  int index;
  if ( (index=compression->find(compr.data()))==-1 )  {
       warning("Unrecognized compression parameter");
       current_comp=0;
  }
  else { rb[index]->setChecked(TRUE);
           current_comp=index;
         }
}

void TuningDialog::setDryTime( QString dtime )
{
  if ( (dtime.toInt()<-1) || (dtime.toInt()>1200) )  {
        warning("Unrecognized drying time parameter");
        current_dtime=-1;
  }
  else { drySlider->setValue(dtime.toInt());
           current_dtime=dtime.toInt();
         }
}


void TuningDialog::setGamma( QString gamma )
{
  double g=1.0*gamma.toDouble()/10;
  QString tmp;

  if ( (g>=-1) && (g<=1) ) {
       tmp.sprintf( "%1.1f", g );
       if ( g >= 0 ) tmp.insert( 0, " " );
       gammaLCD->display(tmp);
       gammaSlider->setValue( gamma.toInt() );
  }
  else { gammaLCD->display("-0.1");
         gammaSlider->setValue( -1 );
       }
}


void TuningDialog::updateGamma()
{
  QString tmp;
  double gammaVal = 1.0*gammaSlider->value()/10;

  tmp.sprintf( "%1.1f", gammaVal  );
    if ( gammaVal >= 0 ) tmp.insert( 0, " " );
  gammaLCD->display(tmp);

   
}


QString TuningDialog::getCompression()
{
 return(compression->take(current_comp));
}


QString TuningDialog::getDryTime()
{ QString s;
  s.setNum(current_dtime);
 return(s);
}


void TuningDialog::compChanged(int comp)
{
current_comp=comp;
}


void TuningDialog::dtimeChanged(int dtime)
{
current_dtime=dtime;
}

