#include <qlayout.h>
#include <qbttngrp.h>
#include <qcombo.h>
#include <qframe.h>
#include <qgrpbox.h>
#include <qradiobt.h>
#include <qlabel.h>
#include <qpixmap.h> 
#include <qstrlist.h>

class QualityDialog : public QWidget { 
Q_OBJECT

public:
    QualityDialog( QWidget *parent=0, const char *name=0 );
    void setQuality( QString quality );
    void setResolution( QString resolution );
    void setColorMode( QString cmode );
    QString getQuality();
    QString getResolution();
    QString getColorMode();
private slots:
     void qualityChanged(int res); 
     void resolutionChanged(int quality);
     void cmodeChanged(int cm);
private:
     QStrList *resolution;
     QStrList *color_mode;
     QStrList *print_quality;
     QButtonGroup *qualityBG;
     QRadioButton  *q_rb[4];
     int current_q;
     QButtonGroup *resolutionBG; 
     QRadioButton  *res_rb[3];
     int current_res;
     QButtonGroup *cmodeBG;
     QRadioButton  *cm_rb[3];
     int current_cm;
};
