/****************************************************************
** Copyright (C) 1998 Peter Cebokli
**
** This file is distributed under the GNU general public license
** version 2.
** See the file COPYING included in the distribution for the usage
** and distribution terms.
**
** This software comes with no warranty at all except that if it
** breaks, or if it breaks something else, you get to keep all
** the pieces.
**
****************************************************************/

#include "QualityDialog.h"
#include "config.h"

QualityDialog::QualityDialog( QWidget *parent, const char *name )
    : QWidget( parent, name )
{   
    resolution=new QStrList();
    resolution->append("600x600"); 
    resolution->append("600x300");
    resolution->append("300x300");   
    resolution->append("100x100"); 
    resolution->append("75x75"); 

    color_mode=new QStrList();
    color_mode->append("mono");
    color_mode->append("CMY");
    color_mode->append("CMY+K");
    color_mode->append("CMYK");

    print_quality=new QStrList();
    print_quality->append("draft");
    print_quality->append("normal");
    print_quality->append("best");

    QFrame* frame;
    frame = new QFrame( this, "frame" );
    frame->move( 10, 10 );
    frame->resize( parent->width()-36,parent->height()-90 );
    frame->setFrameStyle( 49 );
    QVBoxLayout *topLayout = new QVBoxLayout( frame, 15 );
    QGridLayout *grid = new QGridLayout( 3, 5 );
    topLayout->addLayout( grid, 10 );

// PRINT QUALITY button group
    qualityBG = new QButtonGroup( frame, "print_quality" );
    qualityBG->setTitle( "Print quality" );
    grid->addMultiCellWidget( qualityBG, 0, 0,0,3);

// place bitmaps
    QHBoxLayout *hbox = new QHBoxLayout( qualityBG, 25 );
    QVBoxLayout *vbox = new QVBoxLayout();
    hbox->addLayout( vbox );

    QLabel *picLabel = new QLabel( qualityBG, "piclabel" );
    QPixmap *pix=new QPixmap( DRAFT_BMP );
    picLabel->setPixmap( *pix );  
    picLabel->setFixedHeight( pix->height() );
    picLabel->setFixedWidth(  pix->width()  );
    picLabel->setFrameStyle( QFrame::WinPanel | QFrame::Raised );
    picLabel->setAlignment( AlignCenter );
    vbox->addWidget( picLabel );     
    q_rb[0]  = new QRadioButton( qualityBG );
    q_rb[0]->setText( print_quality->at(0) );
    hbox->addSpacing(15);
    vbox->addWidget( q_rb[0], 120 );
    q_rb[0]->setMinimumSize( q_rb[0]->sizeHint() );

    vbox = new QVBoxLayout();
    hbox->addLayout( vbox );
    picLabel = new QLabel( qualityBG, "piclabel" );
    pix=new QPixmap( NORMAL_BMP );
    picLabel->setPixmap( *pix );
    picLabel->setFixedHeight( pix->height() );
    picLabel->setFixedWidth(  pix->width() );
    picLabel->setFrameStyle( QFrame::WinPanel | QFrame::Raised );
    picLabel->setAlignment( AlignCenter );
    vbox->addWidget( picLabel );
    q_rb[1]  = new QRadioButton( qualityBG );
    q_rb[1]->setText( print_quality->at(1) );
    hbox->addSpacing( 15 );
    vbox->addWidget( q_rb[1] );
    q_rb[1]->setMinimumSize( q_rb[1]->sizeHint() );

    vbox = new QVBoxLayout();
    hbox->addLayout( vbox );
    picLabel = new QLabel( qualityBG, "piclabel" );
    pix=new QPixmap( BEST_BMP );
    picLabel->setPixmap( *pix );
    picLabel->setFixedHeight( pix->height() );
    picLabel->setFixedWidth(  pix->width() );
    picLabel->setFrameStyle( QFrame::WinPanel | QFrame::Raised );
    picLabel->setAlignment( AlignCenter );
    vbox->addWidget( picLabel );
    q_rb[2] = new QRadioButton( qualityBG );
    q_rb[2]->setText( print_quality->at(2) );
    vbox->addWidget( q_rb[2] );
    q_rb[2]->setMinimumSize( q_rb[2]->sizeHint() );

    connect( qualityBG, SIGNAL(pressed(int)), this, SLOT(qualityChanged(int)));
    hbox->activate();

// RESOLUTION button group

    resolutionBG = new QButtonGroup( frame, "Resolution" );
    resolutionBG->setTitle( "Resolution" );

    grid->addMultiCellWidget( resolutionBG, 1, 1, 0,1 );
    vbox = new QVBoxLayout( resolutionBG, 10 );
    vbox->addSpacing( resolutionBG->fontMetrics().height() );
    for ( int i=0; i<=4; i++ ) {   
          res_rb[i] = new QRadioButton( resolutionBG );
          res_rb[i]->setText( resolution->at(i) );
          vbox->addWidget( res_rb[i] );
          res_rb[i]->setMinimumSize( res_rb[i]->sizeHint() );
      } 
    connect( resolutionBG, SIGNAL(pressed(int)), 
    	     this,         SLOT(resolutionChanged(int)));    
    vbox->activate();

 // COLOR MODE button group

    cmodeBG = new QButtonGroup( frame, "cmode_group" );
    cmodeBG->setTitle( "Color mode" );

    grid->addMultiCellWidget( cmodeBG, 1, 1, 2,4 );
    vbox = new QVBoxLayout( cmodeBG, 10 );
    vbox->addSpacing( cmodeBG->fontMetrics().height() );
    for ( int i=0; i<=3; i++ ) {   
          cm_rb[i] = new QRadioButton( cmodeBG );
          cm_rb[i]->setText( color_mode->at(i) );
          vbox->addWidget( cm_rb[i] );
          cm_rb[i]->setMinimumSize( cm_rb[i] ->sizeHint() );
    } 
    vbox->activate();

    connect( cmodeBG, SIGNAL(pressed(int)), this, SLOT(cmodeChanged(int)));    
    topLayout->activate();
}


void QualityDialog::setQuality( QString q )
{ int index;
  if ( (index=print_quality->find( q.data() ))==-1 )  {
       warning("Unrecognized quality parameter");
       current_q=-1;
  }
  else {  q_rb[index]->setChecked(TRUE);
            current_q=index;
         } 
}

void QualityDialog::setResolution( QString r )
{ int index;
  if ( (index=resolution->find( r.data() ))==-1 )  {
       warning("Unrecognized resolution parameter");
       current_res=-1;
  }
  else { res_rb[index]->setChecked(TRUE);
           current_res=index;
         }
}

void QualityDialog::setColorMode( QString cmode )
{ int index;
  if ( (index=color_mode->find( cmode.data() ))==-1 )  {
        warning("Unrecognized color mode parameter");
        current_cm=-1;
  }
  else { cm_rb[index]->setChecked(TRUE);
           current_cm=index;
         }
}


QString QualityDialog::getQuality()
{
 return(print_quality->take(current_q));
}

QString QualityDialog::getResolution()
{
return(resolution->take(current_res));
}

QString QualityDialog::getColorMode()
{
return(color_mode->take(current_cm));
}

void QualityDialog::resolutionChanged(int res)
{
current_res=res;
}

void QualityDialog::qualityChanged(int quality)
{
current_q=quality;
}

void QualityDialog::cmodeChanged(int cm)
{
current_cm=cm;
}

