/****************************************************************
** Copyright (C) 1998 Peter Cebokli
**
** This file is distributed under the GNU general public license
** version 2.
** See the file COPYING included in the distribution for the usage
** and distribution terms.
**
** This software comes with no warranty at all except that if it
** breaks, or if it breaks something else, you get to keep all
** the pieces.
**
****************************************************************/

#include "PaperDialog.h"
#include "config.h"

PaperDialog::PaperDialog( QWidget *parent, const char *name )
    : QWidget( parent, name )
{ 
    orientation=new QStrList();
    orientation->append(""); 
    orientation->append("landscap.ps"); 
    paper_size=new QStrList();
    paper_size->append("a4"); 
    paper_size->append("letter"); 
    paper_size->append("legal"); 
    paper_size->append("halfletter"); 
    paper_size->append("ledger"); 
    paper_size->append("note"); 
    paper_size->append("a5"); 
    paper_size->append("b4"); 
    paper_size->append("b5"); 
    paper_size->append("archA"); 
    paper_size->append("archB"); 
    paper_size->append("flsa"); 
    paper_size->append("flse"); 

    paper_type=new QStrList();
    paper_type->append("plain"); 
    paper_type->append("bond"); 
    paper_type->append("Premium"); 
    paper_type->append("glossy"); 
    paper_type->append("transparency"); 
    paper_type->append("photo"); 

    QFrame* frame;
    frame = new QFrame( this, "frame" );
    frame->move( 10, 10 );
    frame->resize(parent->width()-36,parent->height()-90);
    frame->setFrameStyle( 49 );

    QVBoxLayout *topLayout = new QVBoxLayout( frame, 15 );
    QGridLayout *grid = new QGridLayout( 4, 3 );
    topLayout->addLayout( grid, 10 );

// ORIENTATION button group
    orient_bg = new QButtonGroup( frame, "orientation" );
    orient_bg->setTitle( "Orientation" );
    grid->addMultiCellWidget( orient_bg, 0, 0,0,1);
    QHBoxLayout *hbox = new QHBoxLayout( orient_bg, 20);
    QVBoxLayout *vbox = new QVBoxLayout();
    hbox->addLayout(vbox,10);

    QLabel *picLabel = new QLabel( orient_bg, "piclabel" );
    QPixmap *port_pic=new QPixmap( PORTRAIT_BMP );
    picLabel->setPixmap( *port_pic );
    picLabel->setFixedHeight( port_pic->height() );
    picLabel->setFixedWidth( port_pic->width() );
    picLabel->setAlignment( AlignCenter );
    vbox->addWidget( picLabel,AlignBottom );
    orient_port = new QRadioButton( orient_bg );
    orient_port->setText( "Portrait" );
    vbox->addWidget( orient_port );
    orient_port->setMinimumSize( orient_port->sizeHint());

    vbox = new QVBoxLayout();
    hbox->addLayout(vbox,10);

    picLabel = new QLabel( orient_bg, "piclabel" );
    QPixmap *land_pic=new QPixmap( LANDSCAPE_BMP );
    picLabel->setPixmap( *land_pic );
    picLabel->setFixedHeight( port_pic->height());
    picLabel->setFixedWidth(  land_pic->width() );
    picLabel->setAlignment( AlignCenter );
    vbox->addWidget( picLabel);
    orient_land = new QRadioButton( orient_bg );
    orient_land->setText( "Landscape" );
    vbox->addWidget( orient_land );
    orient_land->setMinimumSize( orient_land->sizeHint() );

// PAPER OPTIONS 
    QGroupBox *gb = new QGroupBox( frame, "paper_options" );
    gb->setTitle( "Paper options" );
    grid->addMultiCellWidget( gb, 1, 1,0,2);
    vbox = new QVBoxLayout(gb, 15);
    hbox = new QHBoxLayout();
    vbox->addLayout(hbox);

    QLabel *sizeLabel = new QLabel( "Paper size:",gb, "sizelabel" );
    sizeLabel->setFixedWidth( sizeLabel->sizeHint().width() );
    hbox->addWidget( sizeLabel);
    paperSize = new QComboBox( TRUE, gb, "papesize" );
    for (uint i=0; i<=(paper_size->count()-1); i++)    
          paperSize->insertItem( paper_size->at(i) );
    paperSize->setFixedHeight( paperSize->sizeHint().height() );
    paperSize->setFixedWidth( 150 );
    hbox->addWidget( paperSize );

    QHBoxLayout    *hbox1 = new QHBoxLayout();
    vbox->addLayout(hbox1);
    QLabel *typeLabel = new QLabel( "Paper type:",gb, "typelabel" );
    typeLabel->setFixedWidth( typeLabel->sizeHint().width() );
    hbox1->addWidget( typeLabel );
    paperType = new QComboBox( TRUE, gb, "papetype" );
    for (uint i=0; i<=(paper_type->count()-1); i++)  
          paperType->insertItem(paper_type->at(i));
    paperType->setFixedHeight( paperType->sizeHint().height() );
    paperType->setFixedWidth( 170 );
    hbox1->addWidget( paperType );

// MANUAL FEED 
    feedBox = new QCheckBox( frame );
    feedBox->setText( "Manual feed" );
    feedBox->setFixedHeight( feedBox->sizeHint().height() );
    grid->addMultiCellWidget( feedBox, 2, 2,0,1 );

    grid->setRowStretch(2,0);
    grid->setRowStretch(3,0);  
    grid->setRowStretch(0,1);
    grid->setRowStretch(1,1);
    topLayout->activate();
}

void PaperDialog::setOrientation( QString orient )
{
  if ( orient=="landscap.ps" )    
     orient_land->setChecked(TRUE);
  else orient_port->setChecked(TRUE);
}

void PaperDialog::setPaperSize( QString size )
{ int index;
  if ( (index=paper_size->find( size.data() ))==-1 )  
  warning("Unrecognized paper size parameter");
  else paperSize->setCurrentItem(index);
}

void PaperDialog::setPaperType( QString type )
{ int index;
  if ( (index=paper_type->find( type.data() ))==-1 )  
  warning("Unrecognized paper type parameter");
  else paperType->setCurrentItem(index);
}

void PaperDialog::setFeed( QString feed )
{
  if ( strcmp( feed, "true") == 0 )
     feedBox->setChecked(TRUE);
  else feedBox->setChecked(FALSE);
}

QString PaperDialog::getOrientation()
{
 if (orient_port->isChecked()==TRUE) 
     return(orientation->take(0));
 else return(orientation->take(1));
}

QString PaperDialog::getPaperSize( )
{
  return(paperSize->currentText());
}

QString PaperDialog::getPaperType()
{
 return(paperType->currentText());
}

QString PaperDialog::getFeed()
{
 if (feedBox->isChecked()==TRUE) return("true");
 else return("false");

}
