/****************************************************************
** Copyright (C) 1998 Peter Cebokli
**
** This file is distributed under the GNU general public license
** version 2.
** See the file COPYING included in the distribution for the usage
** and distribution terms.
**
** This software comes with no warranty at all except that if it
** breaks, or if it breaks something else, you get to keep all
** the pieces.
**
****************************************************************/

#include "OtherDialog.h"

OtherDialog::OtherDialog( QWidget *parent, const char *name )
    : QWidget( parent, name )
{ 
    printer_model=new QStrList();
    printer_model->append("unspec"); 
    printer_model->append("500"); 
    printer_model->append("500C"); 
    printer_model->append("510"); 
    printer_model->append("520"); 
    printer_model->append("540"); 
    printer_model->append("550C"); 
    printer_model->append("560C"); 
    printer_model->append("850C"); 
    printer_model->append("855C"); 

    QFrame* frame;
    frame = new QFrame( this, "frame" );
    frame->move( 10, 10 );
    frame->resize( parent->width()-36, parent->height()-90 );
    frame->setFrameStyle( 49 );

    QVBoxLayout *topLayout = new QVBoxLayout( frame, 15 );
    QGridLayout *grid = new QGridLayout( 4, 4 );
    topLayout->addLayout( grid, 10 );

// PRINTER MODEL

    QGroupBox *gb = new QGroupBox( frame, "model" );
    grid->addMultiCellWidget( gb, 0, 0,0,3 );
    QHBoxLayout *hbox = new QHBoxLayout( gb, 20 );

    QLabel *modelLabel = new QLabel( "Printer model:", gb,"sizelabel" );
    modelLabel->setFixedWidth(  modelLabel->sizeHint().width() ); 
    modelLabel->setFixedHeight( modelLabel->sizeHint().height() );    
    hbox->addWidget( modelLabel,AlignBottom );

    printerModel = new QComboBox( TRUE, gb, "papesize" );
    for ( uint i=0; i<=(printer_model->count()-1); i++ )    
          printerModel->insertItem( printer_model->at(i) );
    printerModel->setFixedHeight( printerModel->sizeHint().height() );
    printerModel->setFixedWidth( 150 );
    hbox->addWidget( printerModel );

// MARGIN FILE

    gb = new QGroupBox( frame, "model" );
    grid->addMultiCellWidget( gb, 1, 1,0,3 );
    QVBoxLayout *vbox = new QVBoxLayout( gb, 20 );
    hbox = new QHBoxLayout();
    vbox->addLayout( hbox,10 );
    
    QLabel *marginLabel = new QLabel( "Margin file:", gb, "marginfile" );
    marginLabel->setFixedWidth( marginLabel->sizeHint().width() );
    hbox->addWidget( marginLabel );

    marginFile = new QLineEdit( gb, "margin_file" );
    marginFile->setFixedHeight( printerModel->sizeHint().height() );
    hbox->addWidget( marginFile );

// PROGRAM PATH

    topLayout->activate();

}

void OtherDialog::setModel( QString model )
{
  if ( int index=printer_model->find( model.data() )==-1 )  
  warning( "Unrecognized printer model" );
  else printerModel->setCurrentItem( index );
}

QString OtherDialog::getModel()
{
 return( printerModel->currentText() );
}

void OtherDialog::setMarginFile( QString mfile )
{ 
  marginFile->setText( mfile );
}

QString OtherDialog::getMarginFile()
{
 return( marginFile->text() );
}

