/***************************************************************************
                          cover.c  -  description
                             -------------------
    begin                : Sun Aug 6 2000
    copyright            : (C) 2000 by Dietmar Schnabel
    email                : dietmar.schnabel@aon.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*

   COVER-MAKER BY MAXI-SOFT

   Dieses Programm beschriftet Musik-Kassetten. Dazu geben sie bitte
   die Titel und berschriften in den Computer ein, geben ein leeres
   Blatt in den Drucker (EPSON-KOMPATIBEL) und whlen PRINT aus.

   Es knnen maximal 15 * 2 Titel eingegeben werden (jeweils 35 Zeichen)
*/

#include<stdio.h>
#include<string.h>
#include<tn.h>

#include<lib1.h>
#include<help.h>
#include<lese.h>

#define FALSE 0
#define TRUE 1

/* Statische Variablenvereinbarungen */

static char XC[20] = {11,11,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,11,11,11};
static char YC[20] = {1,2,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,20,21,22};
static char Ende[2] = {40,80};

int main(int argc, char *argv[])

{
  char Help[35],Help2[35],Name[255],Namestart;
  char Titel[20][2][35];
  char Sw,Pos,edit=FALSE;
  int Fehler,ch, Code;
  int i,j,Ze,w,direkt;
  FILE *fp;

  if (argc == 2) strcpy(Name,argv[1]);
  else
  {
    printf("Wrong number of Arguments\n");
    printf("Syntax: covermaker 'filename'\n\n\n");
    printf("Press ENTER to continue");
    getchar();
    printf("\n");

    exit(0);
  }

  j=0;
  if (exists(Name))
  {
    fp=fopen(Name,"r"); Fehler=0;
    for (; (j<20 && Fehler!=EOF); ++j)
    {
      Fehler=fgetline(Titel[j][0],40-XC[j],fp);
      Fehler=fgetline(Titel[j][1],40-XC[j],fp);
    }
    fclose(fp);
  }
  else
  {
    fp=fopen(Name,"w");
    if (fp==NULL)
    {
      fclose(fp);
      remove(Name);
      printf("Kassettenbezeichnung fehlerhaft! (Pfad nicht moeglich\n");
      exit(0);
    }
    fclose(fp);
    remove(Name);
  }
  if (j<20)
  {
    for (j=0; j<20; ++j)
    {
      Titel[j][0][0]=0;
      Titel[j][1][0]=0;
    }
  }

  /* Bildschirmmode Reset */
  initcons();
  bgcolor(Black);
  clrscr();

  strcpy(Help,"COVERMAKER - BY MAXI-SOFT (R)");
  poswrite(7,51,25,Help);
  Ze=0;
  Drucke("HEAD 1 A:",Titel[Ze][0],"HEAD 1 B:",Titel[Ze][1],YC[Ze],XC[Ze]);
  ++Ze;
  Drucke("HEAD 2 A:",Titel[Ze][0],"HEAD 2 B:",Titel[Ze][1],YC[Ze],XC[Ze]);
  ++Ze;

  for (j=1; j<=15; ++j)
  {
    sprintf(Help,"%2d A:",j); sprintf(Help2,"%2d B:",j);
    Drucke(Help,Titel[Ze][0],Help2,Titel[Ze][1],YC[Ze],XC[Ze]);
    ++Ze;
  }

  Drucke("DATE   A:",Titel[Ze][0],"DATE   B:",Titel[Ze][1],YC[Ze],XC[Ze]);
  ++Ze;
  Drucke("MODE   A:",Titel[Ze][0],"MODE   B:",Titel[Ze][1],YC[Ze],XC[Ze]);
  ++Ze;
  Drucke("NR-SYS A:",Titel[Ze][0],"NR-SYS B:",Titel[Ze][1],YC[Ze],XC[Ze]);

  update();

  w=1; Code=86;
  while (Code != '0')
  {
    cursorsize(14,14);
    ch=32; direkt=FALSE;

    while (ch != 13 || direkt)
    {
    /* schreibe Kommandozeile */

      poswrite(14,1,24," E");     /* EDIT */
      poswrite(7,3,24,"DIT ");

      poswrite(14,10,24," P");    /* PRINT */
      poswrite(7,12,24,"RINT ");

      poswrite(14,20,24," S");    /* SAVE */
      poswrite(7,22,24,"AVE ");

      poswrite(14,29,24," Q");    /* QUIT */
      poswrite(7,31,24,"UIT ");

      if (w==1)
      {
        Code='E';
        bgcolor(White);
        poswrite(Black,1,24," EDIT ");
        bgcolor(Black);
      }
      else if (w==2)
      {
        Code='P';
        bgcolor(White);
        poswrite(Black,10,24," PRINT ");
        bgcolor(Black);
      }
      else if (w==3)
      {
        Code='S';
        bgcolor(White);
        poswrite(Black,20,24," SAVE ");
        bgcolor(Black);
      }
      else if (w==4)
      {
        Code='0';
        bgcolor(White);
        poswrite(Black,29,24," QUIT ");
        bgcolor(Black);
      }

      if (!direkt)
      {
        ch=readkey();
	if (ch == KEY_LEFT || ch == KEY_RIGHT)
        {
          if (ch==KEY_LEFT)  if (w>1) --w; else w=4;
          if (ch==KEY_RIGHT) if (w<4) ++w; else w=1;
        }
        else if (ch!=KEY_ENTER)
        {
          direkt=TRUE;
          switch(ch)
          {
            case 'E':
            case 'e':
              w=1;
              ch=KEY_ENTER;
              break;
            case 'P':
            case 'p':
              w=2;
              ch=KEY_ENTER;
              break;
            case 'S':
            case 's':
              w=3;
              ch=KEY_ENTER;
              break;
            case 'Q':
            case 'q':
              w=4;
              ch=KEY_ENTER;
              break;
            default:
              direkt=FALSE;
              ch=32;
          }
        }
      }
      else direkt=FALSE;
    }

    if (Code=='E')
    {
      insertcursor(FALSE); Sw=0;
      edit=TRUE;
      j=0; i=0; Pos=1; Code=KEY_ENTER;
      while (j<21)
      {
        Code=lese_Zeile(Titel[j][i],XC[j]+i*40,Ende[i],
        		&Pos,YC[j],YC[j],&Sw,2,14);
        switch(Code)
        {
          case  KEY_BACKSPACE:                /* Backspace */
          case 115:		   /* CTRL Cursor - left */
            if (!(i==0 && j==0))
            {
              if (i==0 && j>0) {--j; i=1;} else i=0;
              Pos=strlen(Titel[j][i])+1;
            }
            break;

          case KEY_ENTER:                 /* Return */
            if (j<19)
            {
              ++j;
              Pos=1;
            }
            break;

          case KEY_HOME:           /* Home - Taste */
            Pos=1;
            break;

          case KEY_PGUP:          /* Pg Up - Taste */
            i=0;
            Pos=1;
            break;

          case KEY_PGDOWN:          /* Pg Down - Taste */
            i=1;
            Pos=1;
            break;

          case 116:                /* CTRL Cursor - right */
          case KEY_RIGHT:                 /* Cursor - right */
            if (i)
            {
              if (j<19)
              {
                ++j;
                i=0;
                Pos=1;
              }
            }
            else {i=1; Pos=1;}
            break;

          case KEY_LEFT:	  /* Cursor - left */
            if (!(i==0 && j==0))
            {
              if (i) i=0;
              else if (j>0)
              {
                --j;
                i=1;
              }
              Pos=Ende[i]-(XC[j]+i*40)+1;
            }
            break;

          case KEY_UP:		   /* Cursor - up */
            if (j>0) --j;
            break;

	  case KEY_DOWN:           /* Cursor - down */
            if (j<19) ++j;
            break;

          case KEY_ESC: j=21;           /* ESC - Ende */
        }
      }
      textmode(0);
    }
    else if (Code=='P')
    {
      gotoxy(1,1);
      popscr();
      Print_Cover(Titel,Name);
      pushscr();
    }
    else if (Code == 'S')
    {
      gotoxy(1,1);
      popscr();
      speichern(Name,Titel);
      pushscr();
    }
    update();
  }
  if (edit)
  {
    strcpy(Help,"SAVE (Y/N)");
    poswrite(14,1,25,Help);
    update();
    do
    {
      ch=readkey();
      if (ch==KEY_ESC && kbhit()) edit=readkey();
    }
    while(ch!='Y' && ch!='y' && ch!='N' && ch!='n');
    Help[0]=ch;
    strcut(Help,1);
    poswrite(14,12,25,Help);
    update();
    if (ch=='Y' || ch=='y')
    {
      gotoxy(1,1);
      popscr();
      speichern(Name,Titel);
      pushscr();
    }
    strcpy(Help,"             ");
    poswrite(14,1,25,Help);
    update();
  }
  insertcursor(FALSE);
  clrscr();
  gotoxy(1,24);

  donecons();

  return 0;
}
