#include <forms.h>
#include <stdio.h>
#include "../PriMa.xpm"
#include "../version.h"

#ifdef LANG_DE
#include "PriMa.input-forms_de.h"
#endif

#ifdef LANG_EN
#include "PriMa.input-forms_en.h"
#endif

FD_mainwin *fd_mainwin;

char *Prompt = NULL, *Default = NULL, *Title = NULL; 

void button_cb(FL_OBJECT *obj, long arg)
{
  switch (arg) {
  case 0:  
    printf("%s", fl_get_input(fd_mainwin->input));
    fl_hide_form(fd_mainwin->mainwin);
    exit(0);
    break;
  case 1:
    fl_hide_form(fd_mainwin->mainwin);
    exit(1);
    break;
  case 2:
    fl_set_input(fd_mainwin->input, Default);
    break;
  case 3:
    fl_set_input(fd_mainwin->input, "");
    break;
  }
} 


int main(argc, argv)
    int argc;
    char *argv[];
{
  FL_OBJECT *obj;

  if (argc < 2) {
    fprintf(stderr, "Usage: %s PROMPT [DEFAULT] [TITLE]\n", argv[0]);
    exit(2);
  }
  Prompt = malloc(strlen(argv[1])+1);
  strcpy(Prompt, argv[1]);
  
  if (argc >= 3) {
    Default = malloc(strlen(argv[2])+1);
    strcpy(Default, argv[2]);
  }
  if (argc >= 4) {
    Title = malloc(strlen(argv[3])+1);
    strcpy(Title, argv[3]);
  }
  fl_initialize(&argc, argv, "PriMa Input", 0, 0);
  
  fl_set_border_width(2);
  
  fd_mainwin = create_form_mainwin();
  fl_set_pixmap_data(fd_mainwin->pixmap, PriMa_xpm);
  fl_set_object_label(fd_mainwin->input, Prompt);
  fl_set_input(fd_mainwin->input, Default);
    
  fl_show_form
    (fd_mainwin->mainwin, FL_PLACE_HOTSPOT, FL_FULLBORDER,
     Title != NULL ? Title : LONG_VERSION);
  fl_set_app_mainform(fd_mainwin->mainwin);
  
  do 
    obj = fl_do_forms(); 
  while (1 == 1);
  
  return 110;
}
