/******************************************************************
  Program: PriMa
  File:    options.c
  Author:  Jrg Rdler
******************************************************************/

#include "main.h"

#define DOTLINE_MAX 1000

struct printerdat PrinterDat[MAX_PRINTER];
int Printer;
int Paper;
int Pages;
int ReverseOrder;
int BookOrder;
int Nup;
int StartPage;
int EndPage;
int Signature;

int NewPrinter;
int NewPaper;
int NewPages;
int NewReverseOrder;
int NewBookOrder;
int NewNup;
int NewStartPage;
int NewEndPage;
int NewSignature;

int MaxPrinterNum;

int PrinterLoaded = 0;
char UserPrinterFile[PATH_MAX+1], GlobalPrinterFile[PATH_MAX+1];

extern FD_mainwin *fd_mainwin;
extern int Converted, Transformed;
extern int DefaultPrinter;

int update_options()
{
  NewPrinter = fl_get_choice(fd_mainwin->printer);
  if (NewPrinter != Printer) {
    Printer = NewPrinter;
    Converted = 0;
    Transformed = 0;
  }
  NewPaper = fl_get_choice(fd_mainwin->paper);
  if (NewPaper != Paper) {
    Paper = NewPaper;
    Transformed = 0;
  }
  NewStartPage = atoi(fl_get_input(fd_mainwin->startpage));
  if (NewStartPage != StartPage) {
    StartPage = NewStartPage;
    Transformed = 0;
  }
  NewEndPage = atoi(fl_get_input(fd_mainwin->endpage));
  if (NewEndPage != EndPage) {
    EndPage = NewEndPage;
    Transformed = 0;
  }
  NewSignature = atoi(fl_get_input(fd_mainwin->signature));
  if (NewSignature != Signature) {
    Signature = NewSignature;
    Transformed = 0;
  }
  if (NewPages != Pages) {
    Pages = NewPages;
    Transformed = 0;
  }
  NewReverseOrder = fl_get_button(fd_mainwin->reverse_order);
  if (NewReverseOrder != ReverseOrder) {
    ReverseOrder = NewReverseOrder;
    Transformed = 0;
  }
  NewBookOrder = fl_get_button(fd_mainwin->book_order);
  if (NewBookOrder != BookOrder) {
    BookOrder = NewBookOrder;
    Transformed = 0;
  }
  if (NewNup != Nup) {
    Nup = NewNup;
    Transformed = 0;
  }
  return(0);
}


int load_printer(int force_global)
{
  FILE *dotfile;
  char tmpstr[DOTLINE_MAX+1];
  int i;

  if ((access(UserPrinterFile, R_OK) == 0) && (force_global != 1)) {
    /* ok, using user file */
    dotfile = fopen(UserPrinterFile, "r");
  }
  else if (access(GlobalPrinterFile, R_OK) == 0) {
    /* ok, using global file */
    dotfile = fopen(GlobalPrinterFile, "r");
  }
  else {
    /* ERROR: No user and no global file!!! */
    return(1);
  }
  i = 0;
  while ((fgets(tmpstr, DOTLINE_MAX, dotfile) != NULL) && 
	 (i <= MAX_PRINTER)) {
    if (strchr(tmpstr, '#') != tmpstr) {
      i++;
      sscanf(tmpstr, "%[^\t] \t %[^\t] \t %[^\n]", PrinterDat[i].printer_name, 
	     PrinterDat[i].convert_command, PrinterDat[i].print_command); 
    }
  }
  MaxPrinterNum = i;
  fclose(dotfile);

  if (PrinterLoaded == 0) {
    /* set menu items */
    for(i = 1; i <= MaxPrinterNum; i++)
      fl_addto_choice(fd_mainwin->printer, PrinterDat[i].printer_name);
  }
  else {
    /* change menu items */
    for(i = 1; i <= MaxPrinterNum; i++)
      fl_replace_choice(fd_mainwin->printer, i, PrinterDat[i].printer_name);
  }
  fl_set_choice(fd_mainwin->printer, DefaultPrinter);

  PrinterLoaded = 1;
  return(0);
}


int save_printer(int global)
{
  FILE *printerfile;
  char *filename;
  char tmpstr[500];
  int i;
  
  if (global == 1) {
    filename = GlobalPrinterFile;
  }
  else {
    filename = UserPrinterFile;
  }
  printerfile = fopen(filename, "w");
  if (printerfile == NULL) {
    fl_show_alert("", MSG_SAVE_ERROR, "", 1);
    return(1);
  }
  for (i = 1; i <= MAX_PRINTER; i++) {
    if (strlen(PrinterDat[i].printer_name) != 0) {
      fprintf(printerfile, "%s\t%s\t%s\n", PrinterDat[i].printer_name,
	      PrinterDat[i].convert_command, PrinterDat[i].print_command);
    }
    }
  fclose(printerfile);
  return(0);
}
