/******************************************************************
  Program: PriMa
  File:    opt_win.c
  Author:  Jrg Rdler
******************************************************************/

#include "main.h"

#include "PriMa.xpm"

extern struct printerdat PrinterDat[MAX_PRINTER];
extern int UseGlobal;

extern FD_mainwin *fd_mainwin;
FD_optwin *fd_optwin;

int OptPrinter;


void setup_optwin()
{
  fd_optwin = create_form_optwin();
  fl_set_pixmap_data(fd_optwin->pixmap, PriMa_xpm);
  fl_set_form_hotobject(fd_optwin->optwin, fd_optwin->opt_printer_number);
  fl_set_counter_bounds(fd_optwin->opt_printer_number, (double)1, 
			(double)MAX_PRINTER);
  fl_set_counter_step(fd_optwin->opt_printer_number, (double)1, (double)1);
  fl_set_counter_precision(fd_optwin->opt_printer_number, 0);
  fl_set_counter_value(fd_optwin->opt_printer_number, 1);
  fl_set_input(fd_optwin->opt_printer_name, PrinterDat[1].printer_name);
  fl_set_input(fd_optwin->opt_converter, PrinterDat[1].convert_command);
  fl_set_input(fd_optwin->opt_printer, PrinterDat[1].print_command);
}


void opt_actbutton_cb(FL_OBJECT *obj, long arg)
{
  int i;

  if (obj == fd_optwin->opt_savebutton) {
    /* get current changes */
    strcpy(PrinterDat[OptPrinter].printer_name, 
	   fl_get_input(fd_optwin->opt_printer_name));
    strcpy(PrinterDat[OptPrinter].convert_command, 
	   fl_get_input(fd_optwin->opt_converter));
    strcpy(PrinterDat[OptPrinter].print_command, 
	   fl_get_input(fd_optwin->opt_printer));
    /* update choice widget */
    for (i = 1; i <= MAX_PRINTER; i++) {
      if (strlen(PrinterDat[i].printer_name) != 0) {
	fl_replace_choice(fd_mainwin->printer, i, PrinterDat[i].printer_name);
      }
    }
    save_printer(fl_get_button(fd_optwin->opt_globalbutton));
  }
  else if (obj == fd_optwin->opt_reloadbutton) {
    load_printer(fl_get_button(fd_optwin->opt_globalbutton));
    fl_set_input(fd_optwin->opt_printer_name, 
		 PrinterDat[OptPrinter].printer_name);
    fl_set_input(fd_optwin->opt_converter, 
		 PrinterDat[OptPrinter].convert_command);
    fl_set_input(fd_optwin->opt_printer, 
		 PrinterDat[OptPrinter].print_command);
  }
  else if (obj == fd_optwin->opt_quitbutton) {
    /* get current changes */
    strcpy(PrinterDat[OptPrinter].printer_name, 
	   fl_get_input(fd_optwin->opt_printer_name));
    strcpy(PrinterDat[OptPrinter].convert_command, 
	   fl_get_input(fd_optwin->opt_converter));
    strcpy(PrinterDat[OptPrinter].print_command, 
	   fl_get_input(fd_optwin->opt_printer));
    /* update choice widget */
    for (i = 1; i <= MAX_PRINTER; i++) {
      if (strlen(PrinterDat[i].printer_name) != 0) {
	fl_replace_choice(fd_mainwin->printer, i, PrinterDat[i].printer_name);
      }
    }
    /* close options form */
    fl_hide_form(fd_optwin->optwin);
  }
}


void opt_printer_number_cb(FL_OBJECT *obj, long arg)
{
  int foo;
  /* get changed values */
  strcpy(PrinterDat[OptPrinter].printer_name, 
	 fl_get_input(fd_optwin->opt_printer_name));
  strcpy(PrinterDat[OptPrinter].convert_command, 
	 fl_get_input(fd_optwin->opt_converter));
  strcpy(PrinterDat[OptPrinter].print_command, 
	 fl_get_input(fd_optwin->opt_printer));

  /* set values for new printer */
  foo = (int)fl_get_counter_value(fd_optwin->opt_printer_number);
  fl_set_input(fd_optwin->opt_printer_name, PrinterDat[foo].printer_name);
  fl_set_input(fd_optwin->opt_converter, PrinterDat[foo].convert_command);
  fl_set_input(fd_optwin->opt_printer, PrinterDat[foo].print_command);
  OptPrinter = foo;
}
