/******************************************************************
  Program: PriMa
  File:    main.h
  Author:  Jrg Rdler
******************************************************************/

#include <forms.h>
#if (FL_REVISION < 86)
#error "This program requires XForms version 0.86 or newer"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <X11/Xlib.h>
#include <X11/cursorfont.h>
#include "version.h"
#include "language.h"

#ifdef LANG_DE
#include "forms_de.h"
#endif

#ifdef LANG_EN
#include "forms_en.h"
#endif

#ifdef TOOLTIPS
#include <tooltips.h>
#include "tt.h"
#endif

#ifndef GLOBAL_PRINTERFILE
#define GLOBAL_PRINTERFILE "/home/jora/.prima_printer"
#endif

#ifndef USER_PRINTERFILE
#define USER_PRINTERFILE ".prima_printer"
#endif

#ifndef PREVIEW_COMMAND
#define PREVIEW_COMMAND "ghostview %s &"
#endif

#define MAX_PRINTER 10
#define DEF_PRINTER 1

#define PAPERLIST " DIN A3 | DIN A4 | DIN A5 | DIN B5 | Letter | Legal | Tabloid | Statement | Executive | Folio | Quarto | 10x14" 
#define DEF_PAPER 2

#define WAITCURSOR XC_watch

struct printerdat
{
  char printer_name[100];
  char convert_command[200];
  char print_command[200];
};

extern int make_filenames();
extern int update_statusline();
extern void quit_program(int error);
extern int cleanup_files();
extern int load_printer(int force_global);
extern int save_printer(int global);
extern int update_options();
extern int print_doit();
extern int preview_doit();
extern void setup_optwin();

#ifdef DEBUG
extern void print_options();
#endif

#ifdef CHANGE_CURSOR
extern void set_waitcursor();
extern void set_okcursor();
#endif

#ifdef TOOLTIPS
extern void tt_maketips();
#endif
