/******************************************************************
  Program: PriMa
  File:    main.c
  Author:  Jrg Rdler
******************************************************************/

#include "main.h"

#include "PriMa.xpm"

extern int NewPages;
extern int NewNup;
extern int NewReverseOrder;
extern int NewBookOrder;

extern char *InFileName;

extern int Converted, Transformed;

FD_mainwin *fd_mainwin;
extern FD_optwin *fd_optwin;

int StdIn = 0;
int AskForFile = 0;

int DefaultPrinter, DefaultPaper;

#ifdef TOOLTIPS
int UseTooltips = 1;
#endif

extern char UserPrinterFile[PATH_MAX], GlobalPrinterFile[PATH_MAX];

void actbutton_cb(FL_OBJECT *obj, long arg) 
{
  char *foo;
  
  if (obj == fd_mainwin->printbutton) 
    {
      print_doit();
    }
  else if (obj == fd_mainwin->previewbutton) 
    {
      preview_doit();
    }
  else if (obj == fd_mainwin->quitbutton) 
    {
      if (fl_show_question(QST_REALLY_QUIT, 1) == 1)
	quit_program(0);
    }
  else if (obj == fd_mainwin->filebutton) 
    {
      if (((foo = fl_show_fselector(MSG_FSELECTOR, 0, "*", 0)) != NULL) 
	&& (access(foo, R_OK) == 0)) {
	  cleanup_files();
	  strcpy(InFileName, foo);
	  StdIn = 0;
	  Converted = 0;
	  Transformed = 0;
	  make_filenames();
	  update_statusline();
	}
    }
  else if (obj == fd_mainwin->optionsbutton) 
    {
      update_options();
      fl_show_form
	(fd_optwin->optwin, FL_PLACE_HOTSPOT, FL_TRANSIENT,"PriMa Options");
    }
  else if (obj == fd_mainwin->infobutton) 
    {
      fl_show_messages(MSG_INFOWIN);
    }
}


void pages_cb(FL_OBJECT *obj, long arg) 
{
  NewPages = (int) arg;
}  


void book_cb(FL_OBJECT *obj, long arg)
{
  if (fl_get_button(fd_mainwin->book_order) == 1) {
    fl_activate_object(fd_mainwin->signature);
  }
  else {
    fl_deactivate_object(fd_mainwin->signature);
  }
}


void nup_cb(FL_OBJECT *obj, long arg)
{
  NewNup = (int) arg;
}


void quit_program(int error)
{
  fl_hide_form(fd_mainwin->mainwin);
  cleanup_files();
  exit(error);
}


int main(argc, argv)
    int argc;
    char *argv[];
{
  FL_OBJECT *obj;
  char *foo;
  char c;

  /* initialize forms, get forms specific options */
  fl_initialize(&argc, argv, "PriMa", 0, 0);

  /* set default filenames for printer configuration files */
  sprintf(UserPrinterFile, "%s/%s", getenv("HOME"), USER_PRINTERFILE);
  sprintf(GlobalPrinterFile, "%s", GLOBAL_PRINTERFILE);

  /* set default printer and paper for menu */
  DefaultPrinter = DEF_PRINTER;
  DefaultPaper = DEF_PAPER;

  /* get application specific options */
  while ((c = getopt(argc, argv, "tP:p:c:u:")) != -1) {
    switch (c)
      {
	/* flags: t */
      case 't':
	/* disable tooltips */
#ifdef TOOLTIPS
	UseTooltips = 0;
#endif
	break;
	/* options with argument: P, p, g, u */
      case 'P':
	/* use printer number arg */
	DefaultPrinter = atoi(optarg);
	break;
      case 'p':
	/* use paper number arg */
	DefaultPaper = atoi(optarg);
	break;
      case 'c':
	/* use global config file arg */
	strcpy(GlobalPrinterFile, optarg);
	break;
      case 'u':
	/* use user config file arg */
	strcpy(UserPrinterFile, optarg);
	break;
      case '?':
	/* print usage information on stdout */
	printf("Usage: %s [options] [argument]\n", argv[0]);
	printf("Options:\n");
#ifdef TOOLTIPS
	printf("\t -t - disable tooltips (small hint windows)\n");
#endif
	printf("\t -P <num> - set printer number <num> as default printer\n");
	printf("\t -p <num> - set papersize number <num> as default paper\n");
	printf("\t -c <file> - use <file> as global config file\n");
	printf("\t -u <file> - use <file> as userspecific config file\n");
	printf("Argument: file to process, if not specified the program\n");
	printf("will read stdin or ask for a filename\n\n");
	return(1);
      default:
	abort();
      }
  }

  /* get argument - filename to process */
  if ((argc >= 2) && (optind < argc)) {
    InFileName = malloc(PATH_MAX);
    strcpy(InFileName, argv[optind]);
  }
  else {
    /* check for STDIN or filename prompting */
    if (isatty(0)) 
      AskForFile = 1;
    else {
      StdIn = 1;
      InFileName = malloc(PATH_MAX);
      strcpy(InFileName, "stdin");
    }
  }
  
  /* change some default options */
  fl_set_goodies_font(FL_BOLD_STYLE, FL_NORMAL_SIZE);
  fl_set_resource("flAlert.dismiss.label", BTN_DISMISS);
  fl_set_resource("flQuestion.yes.label", BTN_YES);
  fl_set_resource("flQuestion.no.label", BTN_NO);
  fl_set_resource("*.ok.label", BTN_OK);
  fl_set_border_width(2);

  /* make main window */
  fd_mainwin = create_form_mainwin();
  
  /* add lists */
  fl_addto_choice(fd_mainwin->paper, PAPERLIST);
  fl_set_choice(fd_mainwin->paper, DefaultPaper);
  load_printer(0);

  /* set defaults */
  NewNup = 1;
  fl_set_button(fd_mainwin->one_up, NewNup);
  NewPages = 1;
  fl_set_button(fd_mainwin->all_pages, NewPages);
  NewReverseOrder = 0;
  fl_set_button(fd_mainwin->reverse_order, NewReverseOrder);
  NewBookOrder = 0;
  fl_set_button(fd_mainwin->book_order, NewBookOrder);
  fl_deactivate_object(fd_mainwin->signature);
  fl_set_input(fd_mainwin->signature, "4");
  fl_set_input(fd_mainwin->startpage, "0");
  fl_set_input(fd_mainwin->endpage, "0");
  fl_set_pixmap_data(fd_mainwin->pixmap, PriMa_xpm);
  fl_set_form_hotobject(fd_mainwin->mainwin, fd_mainwin->printbutton);

  /* showtime! */
  fl_show_form
    (fd_mainwin->mainwin, FL_PLACE_HOTSPOT, FL_FULLBORDER, 
    "Print Manager " VERSION);
  fl_set_app_mainform(fd_mainwin->mainwin);

  /* making options window */
  setup_optwin();

  /* initialize tooltips if defined and not disabled */
#ifdef TOOLTIPS
  if (UseTooltips == 1) {
    tooltips_initialize();
    tt_maketips();
  }
#endif

  /* get a filename, if not in arg or stdin */
  if (AskForFile == 1) {
    InFileName = malloc(PATH_MAX);
    if (((foo = fl_show_fselector(MSG_FSELECTOR, 0, "*", 0)) == NULL) 
	|| (access(foo, R_OK) != 0)) {
      quit_program(1);
    }
    else
      strcpy(InFileName, foo);
  }
  /* prepare all needed filenames */
  make_filenames();
  update_statusline();
  
  /* ... and start the main loop */
  do 
    obj = fl_do_forms(); 
  while (1 == 1);
  
  /* should never reach this */
  return(110);
}
