/******************************************************************
  Program: PriMa
  File:    language.h
  Author:  Jrg Rdler
******************************************************************/
#ifndef LANGUAGE_H
#define LANGUAGE_H
#include "version.h"

/* ENGLISH */

#ifdef LANG_EN
#define LANGUAGE_SELECTED
#define MSG_TMPDIR_ERROR "Error occured while creating temporary files!"
#define MSG_CONVERTER_ERROR "Error occured while converting file!"
#define MSG_TRANSFORM_ERROR "Error occured while transforming file!"
#define MSG_PRINT_ERROR "Error occured while printing file!"
#define MSG_PREVIEW_ERROR "Error occured while starting previewer!"
#define MSG_FNKT_NOT_AVAIL "Requested function is not available in this release!"
#define MSG_SAVE_ERROR "Error occured while saving file!"
#define MSG_INFOWIN LONG_VERSION "\n\
Copyright(c) 1996, 1997 by Joerg Raedler\n\
This program is free software; you can redistribute it and/or\n\
modify it under the terms of the GNU General Public License\n\
as published by the Free Software Foundation; either version 2\n\
of the License, or (at your option) any later version."
 
#define QST_PRINT_QUIT "Print job spooled, quit PriMa?"
#define QST_REALLY_QUIT "Really quit PriMa?"

#define BTN_OK "Ok"
#define BTN_YES "Yes"
#define BTN_NO "No"
#define BTN_DISMISS "Dismiss" 
#define BTN_QUIT "Quit"
#define BTN_BACK "Back"

#define MSG_STATUSLINE "Filename: %s"
#define MSG_FSELECTOR "Choose a new filename"
#endif 

/* GERMAN */

#ifdef LANG_DE
#define LANGUAGE_SELECTED 
#define MSG_TMPDIR_ERROR "Fehler beim Erstellen der temporren Dateien!"
#define MSG_CONVERTER_ERROR "Fehler beim Konvertieren!"
#define MSG_TRANSFORM_ERROR "Fehler beim Bearbeiten der Datei!"
#define MSG_PRINT_ERROR "Fehler beim Drucken!"
#define MSG_PREVIEW_ERROR "Fehler beim Starten des Previewers!"

#define MSG_FNKT_NOT_AVAIL "Diese Funktion ist noch nicht verfgbar!"
#define MSG_SAVE_ERROR "Fehler beim Sichern der Daten!"

#define MSG_INFOWIN LONG_VERSION "\n\
Copyright(c) 1996, 1997 by Joerg Raedler\n\
This program is free software; you can redistribute it and/or\n\
modify it under the terms of the GNU General Public License\n\
as published by the Free Software Foundation; either version 2\n\
of the License, or (at your option) any later version."

#define QST_PRINT_QUIT "Druckauftrag abgeschickt, PriMa beenden?"
#define QST_REALLY_QUIT "PriMa wirklich beenden?"

#define BTN_OK "Ok"
#define BTN_YES "Ja"
#define BTN_NO "Nein"
#define BTN_DISMISS "Schlieen" 
#define BTN_QUIT "Beenden"
#define BTN_BACK "Zurck"

#define MSG_STATUSLINE "Datei: %s"
#define MSG_FSELECTOR "Whle eine neue Datei"
#endif

#ifndef LANGUAGE_SELECTED
#error "ERROR: You MUST define a language in Makefile!"
#endif

#endif
