/******************************************************************
  Program: PriMa
  File:    diverses.c
  Author:  Jrg Rdler
******************************************************************/

#include "main.h"

extern int StdIn, AskForFile;
extern FD_mainwin *fd_mainwin;

char *InFileName, *PSInFileName, *PSOutFileName, *PSOutFileFName, 
  *TmpDirName, *WorkDirName;

int make_filenames()
{
  char *foo;

  TmpDirName = malloc(L_tmpnam);
  tmpnam(TmpDirName);
  if (mkdir(TmpDirName, 0755) != 0) {
    fl_show_alert("", MSG_TMPDIR_ERROR, "", 1);
    return(1);
  }
  WorkDirName = getcwd(NULL, 0);
  if ((foo = strrchr(InFileName, '/')) == NULL)
    foo = InFileName;
  else
    foo++;
  PSOutFileFName = malloc(NAME_MAX);
  PSOutFileName = malloc(PATH_MAX);
  PSInFileName = malloc(PATH_MAX);
  strcpy(PSOutFileFName, foo);
  sprintf(PSOutFileName, "%s/%s", TmpDirName, PSOutFileFName);
  sprintf(PSInFileName, "%s/%s.temp", TmpDirName, PSOutFileFName);
  return(0);
}


int cleanup_files()
{
  if (StdIn == 1)
    remove(InFileName);
  remove(PSInFileName);
  remove(PSOutFileName);
  rmdir(TmpDirName);

  return(0);
}

extern int update_statusline()
{
  char line[PATH_MAX];

  sprintf(line, MSG_STATUSLINE, InFileName); 
  fl_set_object_label(fd_mainwin->statusline, line);
  return(0);
}


void set_waitcursor()
{
  fl_set_cursor(FL_ObjWin(fd_mainwin->main_frame), WAITCURSOR);
  XFlush(fl_get_display());
}

void set_okcursor()
{
  fl_reset_cursor(FL_ObjWin(fd_mainwin->main_frame));
  XFlush(fl_get_display());
}
