/******************************************************************
  Program: PriMa
  File:    actions.c
  Author:  Jrg Rdler
******************************************************************/

#include "main.h"

#define MAX_CMDLINE 1000

extern int Printer;
extern int Paper;
extern int Pages;
extern int ReverseOrder;
extern int BookOrder;
extern int Nup;
extern int StartPage;
extern int EndPage;
extern int Signature;
extern struct printerdat PrinterDat[MAX_PRINTER];
extern int StdIn;
extern char *InFileName, *PSInFileName, *PSOutFileName, *PSOutFileFName, 
  *TmpDirName, *WorkDirName;
char *PaperList[] = {"std", "a3", "a4", "a5", "b5",
		       "letter", "legal", "tabloid", "statement", "executive",
		       "folio", "quarto", "10x14"}; 
int Converted = 0;
int Transformed = 0;
int StdIn_Saved = 0;

int convert_to_ps();
int transform_ps();


int print_doit()
{
  char command[MAX_CMDLINE+1], command_tmp[MAX_CMDLINE+1];
  char *foo, *bar;
  int error;
  
  update_options();
  if (Converted != 1) {
    error = convert_to_ps();
    if (error != 0)
      return(error);
  }
  if (Transformed != 1) {
    error = transform_ps();
    if (error != 0)
      return(error);
  }
  set_waitcursor();
  strncpy(command, PrinterDat[Printer].print_command, MAX_CMDLINE); 
  strcpy(command_tmp, command);
  foo = strstr(command, "%PSFILE"); 
  bar = strstr(command_tmp, "%PSFILE");
  strcpy(foo, PSOutFileFName);
  strcat(foo, (bar + 7));

  chdir(TmpDirName);
  error = fl_exe_command(command, 1);
  chdir(WorkDirName);
  set_okcursor();
  if (error != 0) {
    fl_show_alert("", MSG_PRINT_ERROR, "", 1);
    fl_addto_command_log("\nPrevious error was produced by:\n");
    fl_addto_command_log(command);
    fl_addto_command_log("\nexecuted in:\n");
    fl_addto_command_log(TmpDirName);
    fl_show_command_log(FL_TRANSIENT);
  }
  else {
    if (fl_show_question(QST_PRINT_QUIT, 1) == 1)
      quit_program(0);
  }
  return(error);
}


int preview_doit()
{
  int error;
  char command[MAX_CMDLINE+1];

  update_options();
  if (Converted != 1) {
    error = convert_to_ps();
    if (error != 0)
      return(error);
  }
  if (Transformed != 1) {
    error = transform_ps();
    if (error != 0)
      return(error);
  }
  
  set_waitcursor();
  sprintf(command, PREVIEW_COMMAND, PSOutFileName);
  error = fl_exe_command(command, 1);
  set_okcursor();
  if (error != 0) {
    fl_show_alert("", MSG_PREVIEW_ERROR, "", 1);
    fl_addto_command_log("\nPrevious error was produced by:\n");
    fl_addto_command_log(command);
    fl_show_command_log(FL_TRANSIENT);
  }
  return(error);
}


int convert_to_ps()
{
  char command[MAX_CMDLINE+1], command_tmp[MAX_CMDLINE+1];
  char *foo, *bar;
  int error;
  FILE *tmpfile;
  int buf;


  set_waitcursor();
  if ((StdIn == 1) && (StdIn_Saved == 0)) {
    tmpnam(InFileName);
    tmpfile = fopen(InFileName, "w");
    while ((buf = getchar()) != EOF) 
      putc(buf, tmpfile);
    fclose(tmpfile);
    StdIn_Saved = 1;
  }
  
  strncpy(command, PrinterDat[Printer].convert_command, MAX_CMDLINE); 
  strcpy(command_tmp, command);
  foo = strstr(command, "%INFILE"); 
  bar = strstr(command_tmp, "%INFILE");
  strcpy(foo, InFileName);
  strcat(foo, (bar + 7));
  
  strcpy(command_tmp, command);
  foo = strstr(command, "%PSFILE"); 
  bar = strstr(command_tmp, "%PSFILE");
  strcpy(foo, PSInFileName);
  strcat(foo, (bar + 7));

  error = fl_exe_command(command, 1);
  set_okcursor();
  if (error != 0) {
    fl_show_alert("", MSG_CONVERTER_ERROR, "", 1);
    fl_addto_command_log("\nPrevious error was produced by:\n");
    fl_addto_command_log(command);
    fl_show_command_log(FL_TRANSIENT);
  }
  else
    Converted = 1;
  return(error);
}


int transform_ps()
{
  char command[MAX_CMDLINE+1];
  char foo[100];
  int error;

  set_waitcursor();
  /* set selected papersize */
  sprintf(command, "psresize -p%s < %s ", PaperList[Paper], PSInFileName); 
  
  /* any need to use psselect now? */ 
  if ((Pages != 1) || (StartPage != 0) || (EndPage != 0)) {
    strcat(command, "| psselect ");
    if (Pages == 2)
      strcat(command, "-e ");
    if (Pages == 3)
      strcat(command, "-o ");
    if ((StartPage != 0) || (EndPage != 0)) {
      sprintf(foo, "-p%d-%d ", ((StartPage != 0) ? StartPage : EndPage), 
	      ((EndPage != 0) ? EndPage : StartPage));
      strcat(command, foo);
    }
  }
  /* use psnup */ 
  if (Nup != 1) {
    sprintf(foo, "| psnup -p%s -%1dup ", PaperList[Paper], Nup);
    strcat(command, foo);
  }
  /* use psbook */
  if (BookOrder == 1) {
    sprintf(foo, "| psbook -s%d ", Signature);
    strcat(command, foo);
  }
  /* reverse order */
  if (ReverseOrder == 1) {
    strcat(command, "| psselect -r");
  }
  strcat(command, "> ");
  strcat(command, PSOutFileName);

  error = fl_exe_command(command, 1);
  set_okcursor();

  if (error != 0) {
    fl_show_alert("", MSG_TRANSFORM_ERROR, "", 1);
    fl_addto_command_log("\nPrevious error was produced by:\n");
    fl_addto_command_log(command);
    fl_show_command_log(FL_TRANSIENT);
  }
  else {
    Transformed = 1;
  }
  return(error);
}
