/*
 *	xbatstat  the Linux battery status checker for X.
 *						       version 0.5.2
 *						        Jan. 2, 1997
 *      (c) Daisuke SUZUKI <daisuke@jaist.ac.jp/daisuke@linux.or.jp>
 *
 *    thanks to minor-change for thinkpad560 by Y.Senta at Dec. 1996
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <forms.h>
#include <apm.h>
#include "xbatstat.h"


int main(int argc, char *argv[])
{
  int  x = 593, y = 431;
   
  switch (apm_exists()) {
    case 1: fprintf( stderr, "No APM support in kernel\n" );  exit( 1 );
    case 2: fprintf( stderr, "Old APM support in kernel\n" ); exit( 2 );
  }

  if (argc == 3){
    x=atoi(argv[1]);
    y=atoi(argv[2]);
  }else if (argc != 1)
    usage();

  fl_initialize(&argc, argv, "xbatstat", 0, 0);
  create_form(x,y);

  fl_set_idle_callback( read_cb, 0 );

  fl_do_forms();
  
  return 0;
}

int read_cb( XEvent *ev, void *d )
{
      apm_info   i;
      char buf[128], *p;
      int life;

      apm_read( &i );

      if (i.ac_line_status == 1){
	 p = "Online";
         fl_set_object_lcol(apm_status,FL_YELLOW);
      } else {
	 p = "Offline";
	 fl_set_object_lcol(apm_status,FL_BLACK);
           if (i.battery_time <= 0)
             p = "Offline";
           else {
             sprintf( buf, "%d%s",
		      i.battery_time, i.using_minutes ? "min" : "sec" );
             p=buf;
           }
      }
      fl_set_object_label(apm_status, p);
     
      if (i.battery_percentage >= 70){
         fl_set_object_color(apm_life,FL_COL1,FL_SLATEBLUE);
      } else if (i.battery_percentage >= 30){
         fl_set_object_color(apm_life,FL_COL1,FL_INACTIVE);
      } else if (i.battery_percentage >= 10){
         fl_set_object_color(apm_life,FL_COL1,FL_INDIANRED);
      } else {
         fl_set_object_color(apm_life,FL_COL1,FL_RED);
      }
      sprintf( buf, "%d%%", (int)i.battery_percentage );
      fl_set_object_label(apm_batt, buf);
      life = i.battery_percentage;
      fl_set_slider_value(apm_life, life);

   return 0;
}

void life_cb(FL_OBJECT *obj, long life)
{
   return;
}

void usage( void )
{
   fprintf( stderr,
            "usage: xbatstat [x position] [y position]\n" );
   exit( 1 );
}

void create_form(int x, int y)
{
  apm_form = fl_bgn_form(FL_NO_BOX, 43, 45);
  
  apm_status = fl_add_text(FL_NORMAL_TEXT,0,0,43,15,"Status");
    fl_set_object_boxtype(apm_status,FL_FRAME_BOX);
    fl_set_object_lsize(apm_status,FL_SMALL_SIZE);
    fl_set_object_lalign(apm_status,FL_ALIGN_CENTER);
    fl_set_object_lstyle(apm_status,FL_NORMAL_STYLE);
  
  apm_batt = fl_add_text(FL_NORMAL_TEXT,0,15,43,15,"Life");
    fl_set_object_boxtype(apm_batt,FL_FRAME_BOX);
    fl_set_object_lsize(apm_batt,FL_SMALL_SIZE);
    fl_set_object_lalign(apm_batt,FL_ALIGN_CENTER);
    fl_set_object_lstyle(apm_batt,FL_ITALIC_STYLE+FL_EMBOSSED_STYLE);
  
  apm_life = fl_add_slider(FL_HOR_FILL_SLIDER,0,30,43,15,"");
    fl_set_object_boxtype(apm_life,FL_FRAME_BOX);
    fl_set_object_lcol(apm_life,FL_BLACK);
    fl_set_object_lalign(apm_life,FL_ALIGN_RIGHT);
    fl_set_slider_bounds(apm_life, 0, 100);
    fl_set_object_callback(apm_life,life_cb,0);  

  fl_end_form();
  fl_set_form_position(apm_form, x, y);
  fl_show_form(apm_form, FL_PLACE_GEOMETRY, FL_TRANSIENT, "xbatstat");
}


