
/*
 * American Power Conversion Ethernet MasterSwitch
 *
 * Secure Outlet Manager
 *
 * Author:      Kit Knox <kit@connectnet.com>
 * Version:     1.00
 * Date:        3/1/1999
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 */

#include <stdio.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <fcntl.h>
#include <netdb.h>
#include <stdarg.h>
#include <unistd.h>
#include <string.h>

#include "cgic.h"

#define CONFFILE		"masterswitch.conf"

unsigned int
resolve (char *hostname)
{

  static struct in_addr i;
  struct hostent *h;
  i.s_addr = inet_addr (hostname);
  if (i.s_addr == -1)
    {

      h = gethostbyname (hostname);
      if (h == NULL)
	{

	  fprintf (stderr, "can't find %s\n.", hostname);
	  exit (0);
	}

      bcopy (h->h_addr, (char *) &i.s_addr, h->h_length);
    }

  return i.s_addr;
}

char *
base64 (char *bin, int len)
{
  char *buf = (char *) malloc ((len + 2) / 3 * 4 + 1);
  int i = 0, j = 0;

  char BASE64_END = '=';
  char base64_table[64] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
  "abcdefghijklmnopqrstuvwxyz"
  "0123456789+/";

  while (j < len - 2)
    {
      buf[i++] = base64_table[bin[j] >> 2];
      buf[i++] = base64_table[((bin[j] & 3) << 4) | (bin[j + 1] >> 4)];
      buf[i++] = base64_table[((bin[j + 1] & 15) << 2) | (bin[j + 2] >> 6)];
      buf[i++] = base64_table[bin[j + 2] & 63];
      j += 3;
    }

  switch (len - j)
    {
    case 1:
      buf[i++] = base64_table[bin[j] >> 2];
      buf[i++] = base64_table[(bin[j] & 3) << 4];
      buf[i++] = BASE64_END;
      buf[i++] = BASE64_END;
      break;
    case 2:
      buf[i++] = base64_table[bin[j] >> 2];
      buf[i++] = base64_table[((bin[j] & 3) << 4)
			      | (bin[j + 1] >> 4)];
      buf[i++] = base64_table[(bin[j + 1] & 15) << 2];
      buf[i++] = BASE64_END;
      break;
    case 0:
      break;
    }
  buf[i] = '\0';
  return buf;
}

void
socket_out (int sock, const char *format,...)
{
  char buf[1024];
  va_list ap;
  va_start (ap, format);
  vsnprintf (buf, 1024, format, ap);
  write (sock, buf, strlen (buf));
  va_end (ap);
}

int
sendcommand (char *host, int port, char *command, char *user, char *password)
{
  struct sockaddr_in sin;
  int sock;
  char buf[1024];

  sin.sin_family = AF_INET;
  sin.sin_port = htons (80);
  sin.sin_addr.s_addr = resolve (host);
  sock = socket (AF_INET, SOCK_STREAM, 0);
  if (-1 == connect (sock, (struct sockaddr *) &sin, sizeof (sin)))
    {
      fprintf (stderr, "Fatal Error: Unable to connect to APC MasterSwitch\n");
      exit (0);
    }
  socket_out (sock, "POST /Forms/outlcfg1?%d HTTP/1.0\r\n", port);
  socket_out (sock, "Referer: http://207.110.41.248/outlcfg?1\r\n");
  socket_out (sock, "Connection: Keep-Alive\r\n");
  socket_out (sock, "User-Agent: Secure Outlet Manager\r\n");
  socket_out (sock, "Host: %s\r\n", host);
  snprintf (buf, 1024, "%s:%s", user, password);
  socket_out (sock, "Authorization: Basic %s\r\n", base64 (buf, strlen (buf)));
  socket_out (sock, "Content-type: application/x-www-form-urlencodecoded\r\n");
  snprintf (buf, 1024, "control=%s&Submit=Apply", command);
  socket_out (sock, "Content-length: %d\r\n", strlen (buf));
  socket_out (sock, "\r\n%s\r\n", buf);
  read (sock, buf, 1024);
  if (strstr (buf, "HTTP/1.0 302 Moved Temporarily") == NULL)
    {
      cgiHeaderContentType ("text/html");
      fprintf (cgiOut, "Fatal Error:<br><pre>\n%s", buf);
      exit (0);
    }
  close (sock);
}

int 
pwcheck (void)
{
  FILE *f;
  char buf[1024];
  char user[8], password[8], control[8];
  char *cuser, *cpassword, *outlet;
  char *shost, *susername, *spassword;

  cgiFormStringNoNewlines ("user", user, 8);
  cgiFormStringNoNewlines ("password", password, 8);
  cgiFormStringNoNewlines ("control", control, 8);
  f = fopen (CONFFILE, "r");
  while (!feof (f))
    {
      fgets (buf, 1024, f);
      buf[strlen (buf) - 1] = 0;
      cuser = (char *) strtok (buf, ":");
      cpassword = (char *) strtok (NULL, ":");
      outlet = (char *) strtok (NULL, ":");
      shost = (char *) strtok (NULL, ":");
      susername = (char *) strtok (NULL, ":");
      spassword = (char *) strtok (NULL, ":");
      if (spassword != NULL)
	{
	  if (!strcmp (user, cuser) && !strcmp (password, cpassword))
	    {
	      sendcommand (shost, 1, control, susername, spassword);
	      fprintf (cgiOut, "Location: success.html\n\n");
	      return (0);
	    }
	}
    }
  fclose (f);
  fprintf (cgiOut, "Location: badlogin.html\n\n");
}

int
cgiMain ()
{
  pwcheck ();
}
