'\" t
.TH xdir 1  "23 October 1995"
.na
.SH NAME
\fILLNL XDIR\fR - A graphical network-oriented file manager
.RE

.SH SYNOPSIS
xdir [options] [directory path]
.RE

.SH DESCRIPTION
\fILLNL XDIR\fR provides a graphical user interface for file transfer and for direct manipulation of local and remote directories on UNIX (and a number of non-UNIX) platforms.  \fILLNL XDIR\fR offers the ability to view directory information in four different formats, ranging from long lists to tree structures.  \fILLNL XDIR\fR is based on UNIX, the C programming language, OSF/Motif and FTP; hence, \fILLNL XDIR\fR is highly portable.

With \fILLNL XDIR\fR, you can manage virtually all of your files in a network.  Specifically, \fILLNL XDIR\fR can be used to browse directory structures, transfer files and directories, view local and remote files, delete files and directories, rename files and directories, and search directories on one or more hosts for entries matching a specified pattern.

\fILLNL XDIR\fR simultaneously displays any number of directories of any number of (local or remote) hosts, with each directory being displayed in its own window.  Several existing products are able to manage files on a single system, but \fILLNL XDIR\fR extends this capability to manage files on an entire network.

\fILLNL XDIR\fR does not have a "main" window, as such, but instead consists of a number of windows, each of which displays the contents of a local or remote host's directory.  Each of these "directory windows" has a complete set of controls for setting modes and invoking operations.  Several other windows are provided for setting general preferences and displaying diagnostic information.

\fILLNL XDIR\fR offers elaborate directory-browsing functionality.  Each directory can be viewed in several different formats, ranging from long lists to tree structures.  A number of mechanisms are provided to traverse directory structures, including: (1) double-clicking a directory name/icon to enter that directory, (2) a "go to parent directory" button, (3) a "go to home directory" button, and (4) a sophisticated history mechanism for easily reentering previously visited directories.

\fILLNL XDIR\fR provides powerful file transfer capability using drag-and-drop.  It is just as easy to copy a file between two remote systems as it is to copy a file from the local host to itself.  Files and directories may be transferred either singly or in groups with just a few movements of the mouse.

One of \fILLNL XDIR\fR's most powerful features is its ability to search directory structures for entry names matching a specified pattern.  You are able to specify the range and depth of such searches.  The search can be restricted to a single subdirectory or can extend across machine boundaries.

With \fILLNL XDIR\fR, you are able to view local or remote files, using either the built-in viewer or any combination of external viewers of your choice (e.g., \fIemacs\fR or \fIxv\fR).

\fILLNL XDIR\fR's history mechanism makes it simple to establish a connection with a remote host.  This and other features make it especially painless to connect to an anonymous FTP site.

A number of directory-manipulation features are provided for operating on selected entries.  There are several ways to select a group of directory entries to operate on, including direct toggling of entries, sweeping out a rectangular area, and wildcard selection.  Once entries are selected, you are able to rename entries, delete entries (including entire subdirectories), or move entries between directories within the same host.  You are also able to create directories, both on local and remote hosts.

\fILLNL XDIR\fR utilizes a history mechanism for automatically saving (1) wildcard expressions used in selecting directory entries, (2) previously visited directories, (3) host/user name pairs used in connecting to remote hosts, and (4) low-level "quoted" commands sent to the host's FTP server.  The purpose of this mechanism is to reduce the amount of typing and mouse movement required.  For example, when you wish to apply a wildcard expression to select directory entries to operate on, a list of recently referenced wildcard expressions for that host will be presented; you can then double-click on an existing wildcard expression to apply it.  The histories are automatically preserved across \fILLNL XDIR\fR sessions.

\fILLNL XDIR\fR presents a graphical user interface for easily tailoring the program's behavior.  You are able to specify such things as whether you would like the delete operation to first pop up a verification dialog listing the entries to be deleted.

Finally, an extensive on-line help facility, much of which is contextual, is provided.  However, experience has shown that the user interface is so intuitive that the user rarely needs to access the help package.
.RE
.SH OPTIONS
\fILLNL XDIR\fR accepts all of the standard X Toolkit command line options, as well as the following option:

-color
.RS
Force \fILLNL XDIR\fR to use a nice color scheme, even if the application defaults file, \fIXDir\fR, is not found.
.RE
.RE
.SH GETTING STARTED
When \fILLNL XDIR\fR is started, a window appears that displays the contents of a directory on the local host.  This window is called a "directory window."  You can have any number of directory windows for any number of hosts.

Use the \fIConnect\fR menu to connect to a remote host.  Select \fIConnect to Anonymous\fR to connect to an anonymous FTP site.  Choose \fIConnect to Remote\fR to connect to other remote hosts.  A directory window will be created for the specified host.

You can use a host's directory window to create another directory window for that host,  First make sure that tunneling mode is off for that directory window (using the tunnel icon in the toolbar).  Then, simply change to another undisplayed directory by using any of the following techniques: (1) double-click an entry name or icon that represents a directory, (2) press the "go to parent directory" button (the up-arrow button in the toolbar), (3) press the "go to home directory" button (the house button in the toolbar), or (4) select an item in the \fIGoto\fR menu.  If tunneling mode happens to be on, the current directory window is used to display the specified directory.

\fILLNL XDIR\fR has several mechanisms to aid you in managing a proliferation of directory windows: (1) directory windows may be individually iconified (using the window manager), (2) all iconified \fILLNL XDIR\fR windows can be redisplayed by selecting \fIDeiconify All\fR in the \fIFile\fR menu, (3) any request to display a directory that is iconified or buried under other windows causes its directory window to be brought to the front, and (4) the \fIWins\fR menu can be used to identify existing directory windows and bring them to the front.

Change between different formats for displaying information within a directory window by toggling the layout buttons in the directory window's toolbar.

Many operations require that entries in a directory window first be selected.  Select/deselect entries by (1) single-clicking on an entry (which toggles its selection state), (2) holding the left mouse button down and dragging to sweep out a selection rectangle (which individually toggles each entry's selection state), (3) selecting any of the items in the directory window's \fISelect\fR menu, or (4) typing a sequence of characters into a directory window to select the first entry that most closely matches the characters.

Copy (i.e., transfer) selected entries by using the left mouse button to drag the entries.  The drop site of the drag can be (1) the background of another directory window, (2) a directory entry in any directory window (including the source directory window).  Directories, as well as files, can be transferred.  \fILLNL XDIR\fR does not permit transfers from a remote host to itself.  The desired file transfer mode can be specified by using the option menu in the toolbar of any directory window.

Move selected entries by using the left mouse button to drag the entries, and holding down the control key when the mouse button is released over the drop site.  (A move differs from a transfer in that (1) the source entries are destroyed, and (2) a move is usually implemented by manipulating file system pointers rather than by actually copying bits.)  The drop site of the drag may be (1) the background of another directory window, (2) a directory entry in any directory window (including the source directory window).  \fILLNL XDIR\fR only allows moves from a host to itself.

View selected files by selecting \fIView Selected Entries\fR in the directory window's \fIOps\fR menu.  Also, you may double-click on an entry that \fILLNL XDIR\fR knows not to be a directory.  Configure the viewer by selecting item \fIViewer Preferences\fR in the \fIPrefs\fR menu.  Be sure to first set the file transfer mode by using the option menu in the toolbar of any directory window.

Delete selected entries by pressing the trash can button in the toolbar.  Directories, as well as files, may be deleted.

Search for an entry that matches a specified wildcard expression by selecting \fISearch\fR in the \fIOps\fR menu.  You are able to specify the range and depth of the search.  After a match has been found, you can continue the search by selecting \fISearch Again\fR in the \fIOps\fR menu.

Some other operations on selected entries may be invoked by selecting appropriate items in the directory window's \fIOps\fR menu.

Abort in-progress operations by pressing the animated stop button in the upper-right corner of the affected directory window (this button is normally labeled "LLNL XDIR").  \fILLNL XDIR\fR will attempt to return control to you at the earliest possible moment.

Configure \fILLNL XDIR\fR by selecting the \fIGeneral Preferences\fR item in the \fIPrefs\fR menu.
.RE

.SH DIRECTORY WINDOW TOOLBAR
Each directory window has a toolbar that can be used to set modes and to invoke operations.  From left to right, the toolbar controls are:

Transfer Mode  (Option menu)
.RS
The option menu at the left allows you to choose the file transfer mode (\fIASCII\fR or \fIBinary\fR).  This mode is global in scope; hence, changing the value in one directory window will automatically change the value in all directory windows.
.RE

Layout Mode  (Group of four buttons)
.RS
The layout mode controls how the directory entries are displayed.  The first button selects "Tabular Layout," in which only the entry names are displayed.  The second button selects "Iconic Layout," in which an icon and name is displayed for each entry.  In Iconic Layout, five different icons are used to identify the entry type: directory, executable file, generic file, socket, and link.  The third button selects "Tree Layout," which is similar to Iconic Layout except that each entry that is a directory also has a small triangle-shaped button, which can be used to expand and collapse the subdirectory.  The last button selects "Full Info Layout," which displays as much information about each directory entry as possible (the amount of information available is limited by the host's FTP server).
.RE

Tunneling Mode  (Button with picture of tunnel)
.RS
If "tunneling mode" is off, entering a directory that is not already displayed will cause a new window to be created to display that directory.  If tunneling mode is on, an existing directory window (the one from the which the command was invoked) will be used to display a directory that does not already have it own window.
.RE

Dot Files Mode  (Button with dot in dog-eared page)
.RS
If "dot files mode" is on, then entry names that begin with a dot (i.e., period) will be displayed.
.RE

Cache Mode  (Button with "C")
.RS
If "cache mode" is on, then directory lists from remote hosts will be saved and used to quickly display revisited directories.
.RE

Refresh Directory  (Button with starburst shape)
.RS
Redisplay this window's directory.
.RE

Go To Parent  (Up arrow button)
.RS
Display this window's parent directory.

Also, pressing the right mouse button pops up a menu that contains the paths for each ancestor of this window.  Select a path to display that directory.
.RE

Go To Home   (House button)
.RS
Display the home directory of this directory window's host.
.RE

Delete  (Trash can button)
.RS
Delete selected directory entries.
.RE

Make Directory  (Button containing folder labeled "New")
.RS
Create a directory.
.RE

Close  (Skull and cross bones button)
.RS
Get rid of this directory window.
.RE
.RE

.SH DIRECTORY WINDOW COMMANDS
\fILLNL XDIR\fR contains a large number of commands that can be invoked from the directory windows.  Most commands are invoked (1) from the menus, (2) from the toolbars, and (3) by dragging and dropping directory entries.  Here is a list of the commands:

About \fILLNL XDIR\fR (in \fIFile\fR menu)
.RS
Give version information.
.RE

Close (in \fIFile\fR menu and toolbar)
.RS
Remove (not iconify) this directory window.  If this directory window is the last for its host, the host is disconnected.
.RE

Connect to Anonymous (in \fIConnect\fR menu)
.RS
Easily connect to an anonymous FTP site.  A dialog pops up to prompt for the remote host, user name and password.  The user name is initialized to "anonymous". The password is initialized to the value of the general preference \fIAnonymous Ftp Password\fR (which you will probably want to set to your email address).  If the general preference \fIAnonymous Ftp Password\fR is blank, \fILLNL XDIR\fR will attempt to create a password of the form "user@host".
An optional, space-delimited port number may follow the host name.  Previously used host/user name pairs are saved across sessions, and those with user names "anonymous" or "ftp" are displayed in the scrolled list \fIRecently Referenced Hosts\fR.  Double-clicking on a host/user name pair initiates a connection.  Single-clicking on a host/user name pair places those values into the host name and user name fields, where they can be edited.  Click on the \fIConnect\fR button to initiate a connection.  (If already connected, a directory window for that host is simply brought to the front.)  (See general preferences \fIAnonymous Ftp Password\fR, \fIHistory Sort Order\fR, \fIMax Host Name History\fR, and \fIMax User Name History\fR.)
.RE

Connect to Local (in \fIConnect\fR menu)
.RS
Connect to the local host (i.e., the host upon which \fILLNL XDIR\fR is executing).  If already connected, an existing directory window for the local host is brought to the front.
.RE

Connect to Remote (in \fIConnect\fR menu)
.RS
Connect to a remote host (use \fIConnect to Anonymous\fR to more easily connect to an anonymous FTP site).  A dialog pops up to prompt for the remote host and user names. The user name is initialized to the value of the environment variable \fIUSER\fR.  An optional, space-delimited port number may follow the host name.  Previously used host/user name pairs are saved across sessions, and those with user names other than "anonymous" and "ftp" are displayed in the scrolled list \fIRecently Referenced Hosts\fR.  Double-clicking on a host/user name pair initiates a connection.  Single-clicking on a host/user name pair places those values into the host name and user name fields, where they can be edited.  Click on the \fIConnect\fR button to initiate a connection.  (If already connected, a directory window for the host is simply popped to the top.)  (See general preferences \fIHistory Sort Order\fR, \fIMax Host Name History\fR, and \fIMax User Name History\fR.)
.RE

Contextual Help (in \fIHelp\fR menu)
.RS
Enter contextual-help mode.  The mouse cursor changes to a pointing hand.  Click on any graphical element in the directory window that you wish to know more about.
.RE

Copy (drag-and-drop operation)
.RS
Copy (i.e., transfer) the selected files according to the mode (ASCII or Binary) specified in the toolbar's file transfer mode option menu.
Copy selected items by using the left mouse button to drag the items.  The drop site of the drag can be (1) the background of another directory window, (2) a directory entry in any directory window (including the source directory window).  Directories, as well as files, can be transferred (but the general preference \fICopy Mode\fR must be set to \fIRecursive\fR).
\fILLNL XDIR\fR does not permit transfers from a remote host to itself.  The desired file transfer mode can be specified via the option menu in the toolbar of any directory window.
Set general preference \fICopy Mode\fR to \fIRecursive\fR to allow copying of directories.  Set general preference \fIOverwrite Dir On Copy\fR to specify whether or not it is okay to overwrite an existing directory.  A dialog pops up to enable the user to monitor the progress of the transfers.  This dialog contains a button for aborting the transfers.  (See general preferences \fIBeep When Ops Done\fR, \fICopy Mode\fR, \fIInitial Transfer Mode\fR, \fIInquire On Copy\fR, and \fIOverwrite Dir On Copy\fR.)
.RE

Delete Selected Entries (in \fIOps\fR menu and toolbar)
.RS
Delete the selected entries.  Set general preference \fIDelete Mode\fR to \fIRecursive\fR to allow deletion of nonempty directories.  A dialog pops up to enable the user to monitor the progress of the deletions.  This dialog contains a button for aborting the deletions.  (See general preferences \fIBeep When Ops Done\fR, \fIDelete Mode\fR and \fIInquire On Delete\fR.)
.RE

Deselect All Entries (in \fISelect\fR menu)
.RS
Deselect all the entries in this directory window.
.RE

Deiconify All (in \fIFile\fR menu)
.RS
Deiconify all top-level windows in the application.
.RE

Diagnostics (in \fIWins\fR menu)
.RS
Display the diagnostics window.
.RE

Disconnect (in \fIConnect\fR menu)
.RS
Terminate the connection to this directory window's host.  All directory windows associated with this host are closed.
.RE

Edit History (in \fIFile\fR menu)
.RS
Display the Edit History dialog.  See section \fIEdit History\fR for details.
.RE

Getting Started (in \fIHelp\fR menu)
.RS
Learn how to get started using \fILLNL XDIR\fR.
.RE

General Preferences (in \fIPrefs\fR menu)
.RS
Display the General Preferences window.  See section \fIGeneral Preferences\fR for details.
.RE

Go to Ancestor ((in \fIGoto\fR menu and toolbar)
.RS
Display an ancestor of this directory window.
.RE

Go to Directory (in \fIGoto\fR menu)
.RS
Display a directory.  A dialog pops up to prompt for the directory path.  The directory may be specified with a full or relative path.  Previously referenced directories are saved and displayed in a scrollable list.  Double-click on a path in the list to display that directory.  Single click on a path in the list to place that entry into text field \fIDirectory\fR, where it can be edited.  Click on the \fIOK\fR button to change to the directory displayed in the text field.  (See general preferences \fIHistory Sort Order\fR, \fIMax Dir Name History\fR, and \fIMax Host Name History\fR.)
.RE

Go to Home Directory (in \fIGoto\fR menu and toolbar)
.RS
Display the home directory of this directory window's host.
.RE

Go to Parent Directory (in \fIGoto\fR menu and toolbar)
.RS
Display the parent directory of this directory window.
.RE

Iconify All (in \fIFile\fR menu)
.RS
Iconify all top-level windows in the application.
.RE

Launch (submenu in \fIOps\fR menu and popup menu in entries area)
.RS
Launch application as a child process.  Select a command name in the \fILaunch\fR submenu to fork and exec the associated command.  See section \fILauncher Preferences\fR for details on constructing commands.)
When a command is launched, placeholders are replaced by their values as follows: "%u" is replaced by the user name, "%h" is replaced by the host name, "%s" is replaced by the name of a selected entry, and "%l" is replaced by the blank-delimited names of all selected entries.  If "%s" is used, then the command is launched once for each selected entry, each time "%s" being replaced by the full path of the next selected entry name.
.RE

Launcher Preferences (in \fIPrefs\fR menu)
.RS
Display the Launcher Preferences window.  See section \fILauncher Preferences\fR for details.
.RE

LLNL XDIR Overview (in \fIHelp\fR menu)
.RS
Give a high-level description of \fILLNL XDIR\fR.
.RE

Make Directory (in \fIOps\fR menu and toolbar)
.RS
Pop up a dialog to prompt for the name of a directory to create in the displayed directory.
.RE

Move (drag-and-drop operation)
.RS
Move selected entries from one directory to another on the same host.
Move selected items by using the left mouse button to drag the items, and holding down the control key when the mouse button is released over the drop site.  (A move differs from a transfer in that (1) the source entries are destroyed, and (2) a move is usually implemented by manipulating file system pointers rather than by actually copying bits.)
The drop site of the drag can be (1) the background of another directory window, and (2) a directory entry in any directory window (including the source directory window).  \fILLNL XDIR\fR only allows moves from a host to itself.
A dialog pops up to enable the user to monitor the progress of the moves.  This dialog contains a button for aborting the move operations.  (See general preferences \fIBeep When Ops Done\fR, and \fIInquire on Move\fR.)
.RE

Quit (in \fIFile\fR menu)
.RS
Terminate the application.
.RE

Refresh Directory (in \fIOps\fR menu)
.RS
Redisplay this window's directory.
.RE

Rename Selected Entries (in \fIOps\fR menu)
.RS
Pop up a dialog to individually rename selected entries.
.RE

Save Preferences (in \fIPrefs\fR menu)
.RS
Save the current settings of the general, viewer, and launcher preferences.
.RE

Search (in \fIOps\fR menu)
.RS
Pop up a dialog to initiate a search of directory windows for entry names that match a specified pattern.  The pattern to be matched can contain the usual wildcard characters ('*', '?', '[', and ']').  The toggle item \fIMatch Case\fR controls whether case (upper or lower) should be considered when looking for a match.  The \fIMaximum Search Depth\fR slider is used to specify the maximum number of directory levels the search command will explore when looking for an entry that matches the specified pattern.  Choose one of the toggle items, \fISearch this directory\fR, \fISearch all displayed directories of this host\fR, or \fISearch all displayed directories of all hosts\fR, to specify which directory windows (and their descendants) are to be searched.

When the \fIOK\fR button is pressed, a dialog appears to monitor the progress of the search.  This dialog contains a button that can be used to abort the search.

If a match is found in a directory that is already displayed, the entry is selected, scrolled into view, and its directory window is brought to the front.  If a match is found in a directory that is not already displayed, there are two cases: If the search was initiated from a directory window with tunneling mode on, the entry's directory is displayed in that directory window; otherwise a new window is created to display the entry's directory.

Use \fISearch Again\fR to continue the search once an entry has been found.  (See general preferences \fIBeep When Ops Done\fR, \fIInitial Max Search Depth\fR, \fIInitial Search Case Match\fR, and \fIInitial Search Range\fR).
.RE

Search Again (in \fIOps\fR menu)
.RS
Search for the next entry that satisfies the search criteria specified by the last search command.  (See general preference \fIBeep When Ops Done\fR).
.RE

Select All Entries (in \fISelect\fR menu)
.RS
Select all the entries in this window.
.RE

Send Quoted Command (in \fIOps\fR menu)
.RS
Pop up a dialog to prompt for a "raw" command to send to the FTP server of the remote host.  Previously issued commands are saved and displayed in a scrolled list.  Double-clicking on a command in the list issues that command.  To have a command act on selected entries, use the quote placeholder ("%s") to represent a selected item.  For example, type "stage 1 %s" to send a STAGE command to the the remote host for each selected entry.  (See general preference \fIBeep When Ops Done\fR and \fIMax Quoted Cmd History\fR.)
.RE

Use Wildcard (in \fISelect\fR menu)
.RS
Pop up a dialog to prompt for a wildcard expression to use in selecting entries in this directory window.  Previously referenced wildcard expressions are saved and displayed in a scrolled list.  Double-clicking on an item in the list applies that wildcard expression.  Single-clicking on an item in the list places the expression in a text field where it may be edited.  Choose the toggle item \fIReplace Selection\fR to cause the currently selected entries to be cleared before applying the wildcard.  Choose the toggle item \fIAdd to Selection\fR to cause the entries selected by the wildcard to be added to the current selection.  (See general preference \fIInitial Wildcard Mode\fR and \fIMax Wildcard History\fR).
.RE

Using Help (in \fIHelp\fR menu)
.RS
Describe the online help package.
.RE

View Selected Files (in \fIOps\fR menu)
.RS
Display the selected files.  The viewer preferences dialog (accessible via the \fIPrefs\fR menu) can be used to control whether files will be displayed using the built-in viewer or using an external viewer of the user's choice (e.g., \fIemacs\fR or \fIxv\fR).  The selection of the viewer is configurable, based on the file extension (e.g., ".gif" or ".jpg").

The file is transferred according to the mode (ASCII or Binary) specified in the toolbar of the directory window.  A dialog pops up to enable the user to monitor the progress of the transfer.  This dialog contains a button for aborting the transfer.

The destination of the transfer is a temporary directory created in the directory defined as \fIP_tmpdir\fR in the include file "/usr/include/stdio.h".  If the environment variable \fITMPDIR\fR is defined, it is used as the directory.  The temporary directory, and the files it contains, are automatically deleted when the user dismisses the viewer or terminates \fILLNL XDIR\fR.

If the file is recognized as being compressed, it is expanded before viewing.  \fILLNL XDIR\fR excutes the following decompressors based on the file extension: \fIgunzip\fR for ".z" and ".gz"; \fIuncompress\fR for ".Z"; \fIatob\fR for "atob"; and \fIuudecode\fR for ".uu".  \fILLNL XDIR\fR searches for the decompressor application in the standard way using the \fIPATH\fR environment variable.
.RE

Viewer Preferences (in \fIPrefs\fR menus)
.RS
Display the viewer preferences window.  See section \fIViewer Preferences\fR for details.
.RE
.RE

.SH GENERAL PREFERENCES
Selecting item \fIGeneral Preferences\fR in a directory window's \fIPrefs\fR menu pops up a dialog that allows you to configure \fILLNL XDIR\fR according to your tastes.  Use the option menu at the top of the window to display a subset of the configuration parameters, whos values may then be changed by either toggling, sliding, or typing.  Click the \fIApply\fR button to cause the new values to take effect.  The \fIOK\fR button has the same effect as \fIApply\fR, but the dialog is also closed.  The \fICancel\fR button undoes changes made since \fIOK\fR or \fIApply\fR were last pressed.  The preferences can be preserved across \fILLNL XDIR\fR sessions in a text file named ".xdirrc" in your home directory.

Anonymous Ftp Password
.RS
The value to initialize the \fIPassword\fR field of the Connect to Anonymous dialog to.  This is normally your email address.  If the value is blank, \fILLNL XDIR\fR attempts to construct a password of the form "user@host".  The Connect to Anonymous dialog is accessible via each directory window's \fIConnect\fR menu.
.RE

Beep When Ops Done
.RS
Specifes whether to beep when each set of deletion, move, quoted command, search, and file transfer operations completes.
.RE

Copy Mode
.RS
Specifies whether to allow recursive file transfers.
.RE

Delete Mode
.RS
Specifies whether to allow recursive delete operations.
.RE

History Sort Order
.RS
Specifies how to sort history items (such as names of previously visited directories) when they are displayed in dialogs and menus.  If \fIAlphanumeric\fR, then sort by the ASCII-collating sequence.  If \fIBy Last Use\fR, then the most recently used items are placed at the top of the list.
.RE

Initial Cache Mode
.RS
Specifies cache mode for the first created directory window.  Cache mode controls whether directory lists from remote hosts will be saved and used to quickly display revisited directories.  Each subsequently created directory window inherits its cache mode from its parent directory window.
.RE

Initial Diagnostics
.RS
The default level of diagnostics information to be written to the diagnostics window.  Choose \fIQuiet\fR for error messages, only.  Choose \fINormal\fR for error messages and success messages.  Choose \fIVerbose\fR for error messages, success messages, and replies received from the FTP servers.  Choose \fIDebug\fR for error messages, success messages, commands sent to the FTP servers, replies received from the FTP servers, and other assorted diagnostics.
.RE

Initial Directory Layout
.RS
The layout used by the first created directory window.  Each subsequently created directory window inherits its directory layout mode from its parent directory window.
.RE

Initial Dot Files Mode
.RS
Specifies whether the first created directory window will display dot files.  Each subsequently created directory window inherits its dot files mode from its parent directory window.
.RE

Initial Max Search Depth
.RS
The default maximum number of directory levels the search command will explore when looking for an entry that matches the specified pattern.
.RE

Initial Max Viewer Width
.RS
The maximum initial width in characters that the built-in viewer takes on.  The first part of the file to be viewed is examined to determine an appropriate width to initialize the viewer to.  The initial width will not exceed the value of this preference.
.RE

Initial Search Direction
.RS
The default value that specifies the direction to search the built-in file viewer for a text string using the "Find" operation.
.RE

Initial Search Case Match
.RS
The default value that specifies whether search or find commands should consider case when looking for an entry that matches the specified pattern.
.RE

Initial Search Range
.RS
The default value used as the search range in the Search dialog.  Choose \fIThis Dir\fR to make \fISearch this directory\fR the default.  Choose \fIThis Host\fR to make \fISearch all displayed directories of this host\fR the default.  Choose \fIAll Hosts\fR to make \fISearch all displayed directories of all hosts\fR the default.
.RE

Initial Transfer Mode
.RS
The default file transfer mode (\fIASCII\fR or \fIBinary\fR).
.RE

Initial Tunneling Mode
.RS
Specifies tunneling mode for the first created directory window.  Tunneling mode controls whether or not a new directory window is created to display a directory.  Each subsequently created directory window inherits its tunneling mode from its parent directory window.
.RE

Initial Wildcard Mode
.RS
The default mode of the Use Wildcard dialog.  Choose \fIReplace\fR to make \fIReplace Selection\fR the default.  Choose \fIAdd\fR to make \fIAdd to Selection\fR the default.
.RE

Inquire On Copy
.RS
Specifies whether to pop up a dialog that asks the user to confirm that the indicated file transfers should take place.
.RE

Inquire On Delete
.RS
Specifies whether to pop up a dialog that asks the user to confirm that the indicated delete operations should take place.
.RE

Inquire On Move
.RS
Specifies whether to pop up a dialog that asks the user to confirm that the indicated moves should take place.
.RE

Inquire On Quoted Cmd
.RS
Specifies whether to pop up a dialog that asks the user to confirm that the indicated commands should be sent.
.RE

Max Dir Cache Len (KB)
.RS
Specifies the maximum size (in kilobytes) of the directory cache.
.RE

Max Dir Name History
.RS
The maximum number of previously referenced directory paths saved per host.  These path names are preserved across \fILLNL XDIR\fR sessions.
.RE

Max Ftp Retries
.RS
Specifies the maximum number of retries \fILLNL XDIR\fR will attempt if it receives a response from an FTP server that indicates the desired operation failed because of some temporary condition on the remote host.
.RE

Max Host Name History
.RS
The maximum number of hosts to save history items for.  The history information is preserved across \fILLNL XDIR\fR sessions.
.RE

Max Quoted Cmd History
.RS
The number of quoted commands to save.  These commands are preserved across \fILLNL XDIR\fR sessions.
.RE

Max Time For Ftp Reply
.RS
Specifies the maximum time in seconds that \fILLNL XDIR\fR will wait for a response from an FTP server before concluding that the connection has been broken.
.RE

Max User Name History
.RS
The number of user names to save for remote hosts). These user names are preserved across \fILLNL XDIR\fR sessions.
.RE

Max Wildcard History
.RS
The number of wildcard expressions to save.  These wildcard expressions preserved across \fILLNL XDIR\fR sessions.
.RE

Overwrite Dir On Copy
.RS
Specifies whether it is okay to overwrite an existing directory when recursively copying another directory by the same name.  If a sink directory is overwritten then none of its subdirectories will be deleted, but new files and subdirectories might be added to it, and some existing files might be replaced.
.RE

Preserve Vms Ver Nums
.RS
Specifies whether to preserve VMS file version numbers when transferring files from a VMS system.  This is only an issue for those VMS FTP servers that provide version numbers (at least one server does not).
.RE

Print Password In Debug
.RS
Specifies whether to print passwords in the diagnostics window when the level of diagnostics messages is set to \fIDebug\fR.
.RE

Stop Button Blinking
.RS
Specifies whether the STOP button (shown during potentially lengthy operations) should blink or not.
.RE

Store Unique
.RS
Specifies whether existing sink files are to be renamed before file transfer occurs.  If \fIYes\fR then the existing sink file is typically renamed by appending a "." (period) followed by an integer between 1 and 99.
.RE

Type To Select Delay
.RS
The number of milliseconds to wait before \fILLNL XDIR\fR determines that you are finished typing characters into a directory window to select the first entry that best matches the characters.
.RE

Use Last Dir At Login
.RS
Specifies whether to automatically enter the most recently referenced directory after connecting to a host.  If this option is requested, but is not possible to perform (e.g., because the directory no longer exists), your home directory will be entered.
.RE
.RE

.SH VIEWER PREFERENCES
Selecting item \fIViewer Preferences\fR in a directory window's \fIPrefs\fR menu pops up a dialog that allows the user to control which file will be displayed with which viewer, based on the file extension.

A file to be viewed is first transferred to a temporary directory and then, if necessary, is decompressed.  The file extension (e.g., ".gif") is then examined to determine which viewer the file is to be displayed in.  There are two types of viewers: the viewer built into \fILLNL XDIR\fR (which is suitable for displaying text files) and external viewers (e.g., \fIemacs\fR for text and \fIxv\fR for graphics).

Single-click on an entry in the \fIExtensions\fR list to place that extension and its associated command line into the \fIExtension\fR and \fIViewer Command Line\fR text fields, respectively.

An extension is a file suffix that begins with a period (".").  A special entry in the extensions list, "OTHERS," represents all files that do not have their extension listed (including files with no extensions).

The pattern "%s" in a command line is a placeholder for the name of the file to be viewed.  A blank command line indicates that the built-in viewer is to be used.  To add a new extension to the list, fill in the \fIExtension\fR and \fIViewer Command Line\fR text fields and press the \fIAdd\fR button.  If the text in \fIExtension\fR does not begin with a period, one will be added.  If the extension is already in the list, it will be replaced.

To replace the command line associated with an extension, (1) single-click on the list item to select it, (2) edit the command line, and (3) press the \fIReplace\fR button.

To delete an extension from the list, single-click on the list item to select it and then press the \fIDelete\fR button.  The "OTHERS" entry cannot be deleted (but its command line can be replaced).

Click the \fIApply\fR button to cause the new changes to take effect.  The \fIOK\fR button has the same effect as \fIApply\fR, but the dialog is also closed.  The \fICancel\fR button undoes the changes made since \fIOK\fR or \fIApply\fR were last pressed.

The viewer preferences can be preserved across \fILLNL XDIR\fR sessions in a text file named ".xdirrc" in the user's home directory (select \fISave Preferences\fR in a directory window's \fIPrefs\fR menu).

.SH LAUNCHER PREFERENCES
Selecting item \fILauncher Preferences\fR in a directory window's \fIPrefs\fR menu pops up a dialog that allows the user to specify commands that can be invoked using the \fILaunch\fR submenu of the \fIOps\fR menu.  The idea is to be able to fork and exec child processes with execute lines based on information about selected entries.

Single-click on an entry in the \fICommand Names\fR list to place that command name and its associated command line into the \fICommand Name\fR and \fICommand Line\fR text fields, respectively.

The following placeholders can be specified in a command line: "%u" for the user name, "%h" for the host name, "%s" for the name of a selected entry, and "%l" for the blank-delimited names of all selected entries.  To add a new command to the list, fill in the \fICommand Name\fR and \fICommand Line\fR text fields and press the \fIAdd\fR button.  If the command name is already in the list, it will be replaced.

To replace the command line associated with a command name, (1) single-click on the list item to select it, (2) edit the command line, and (3) press the \fIReplace\fR button.

To delete a command from the list, single-click on the list item to select it and then press the \fIDelete\fR button.

Click the \fIApply\fR button to cause the new changes to take effect.  The \fIOK\fR button has the same effect as \fIApply\fR, but the dialog is also closed.  The \fICancel\fR button undoes the changes made since \fIOK\fR or \fIApply\fR were last pressed.

The launcher preferences can be preserved across \fILLNL XDIR\fR sessions in a text file named ".xdirrc" in the user's home directory (select \fISave Preferences\fR in a directory window's \fIPrefs\fR menu).

The names of the commands will be placed in the \fILaunch\fR submenu of the \fIOps\fR menu.  (See command \fILaunch\fR in section \fIDirectory Window Commands\fR for details on how commands are actually launched.)
.RE

.SH EDIT HISTORY
Selecting item \fIEdit History\fR in a directory window's \fIFile\fR menu pops up a dialog that allows the user to remove unwanted history information.  (\fILLNL XDIR\fR automatically saves certain information, such as the paths of previously visited directories, for future use.)

Four categories of history information are saved for each host: (1) paths of previously visited directories, (2) wildcard expressions used in selecting directory entries, (3) user names used in connecting to the host, and (4) low-level "quoted" commands sent to the host's FTP server.

An entire host's history information may be removed by selecting an entry in the \fIHosts\fR list and then clicking the \fIDelete Host\fR button.

A single item may be removed by using the three lists to specify host, category and item, and then clicking the \fIDelete Item\fR button.

Click the \fIOK\fR button to cause the changes to take effect (and remove the dialog).  Click the \fICancel\fR button to undo the changes (and remove the dialog).

.RE

.SH LIMITATIONS
Here are some things to watch out for:

\fILLNL XDIR\fR might not work with some old X servers.  For example, some older OpenWindows servers might dump core.  MacX fans should use nothing older than version 1.1.7b.

Old, buggy versions of Motif can cause weirdness.

\fILLNL XDIR\fR might not work correctly with some non-Unix FTP servers.  (If you can give us temporary access to such a server, we might be able to fix the problem.)

Out-of-spec FTP servers can cause untold grief.  (Most Unix-based servers work correctly.)

Third-party file transfers will not work unless at least one of the remote FTP servers supports the PASV (passive) command.
.RE

.SH FILES
.nf
$HOME/.xdirhistory   history file
$HOME/.xdirrc        preferences
XDir                 application defaults file

.SH AVAILABILITY
Source code for \fILLNL XDIR\fR is tarred and compressed, and is available as follows:
.nf

    ftp://coral.ocf.llnl.gov/pub/ia/llnlxdir/latest_xdir.tar.Z

    http://www.llnl.gov/ia/xdir.html
.RE
.RE

.SH SUPPORT
Because our resources are limited, we will not be able to give individual assistance in building and using \fILLNL XDIR\fR.  However, your comments, suggestions and bug reports are valuable in helping us determine how to best direct our efforts.  Our email address is
.nf

                           llnlxdir@llnl.gov

.RE

.SH COPYRIGHT
(c) 1995.  The Regents of the University of California.  All rights reserved.

This work was produced at the University of California, Lawrence Livermore National Laboratory (UC LLNL) under contract no.  W-7405-ENG-48 (Contract 48) between the U.S. Department of Energy (DOE) and The Regents of the University of California (University) for the operation of UC LLNL.  Copyright is reserved to the University for purposes of controlled dissemination, commercialization through formal licensing, or other disposition under terms of Contract 48; DOE policies, regulations and orders; and U.S. statutes.  The rights of the Federal Government are reserved under Contract 48 subject to the restrictions agreed upon by the DOE and University.

                           DISCLAIMER

This software was prepared as an account of work sponsored by an agency of the United States Government.  Neither the United States Government nor the University of California nor any of their employees, makes any warranty, express or implied, or assumes any liability or responsibility for the accuracy, completeness, or usefulness of any information, apparatus, product, or process disclosed, or represents that its specific commercial products, process, or service by trade name, trademark, manufacturer, or otherwise, does not necessarily constitute or imply its endorsement, recommendation, or favoring by the United States Government or the University of California. The views and opinions of the authors expressed herein do not necessarily state or reflect those of the United States Government or the University of California, and shall not be used for advertising or product endorsement purposes.

Permission to use, copy, modify and distribute this software and its documentation for any non-commercial purpose, without fee, is hereby granted, provided that the above copyright notice and this permission notice appear in all copies of the software and supporting documentation, and that all UC LLNL identification in the user interface remain unchanged.  The title to copyright LLNL XDIR shall at all times remain with The Regents of the University of California and users agree to preserve same. Users seeking the right to make derivative works with LLNL XDIR for commercial purposes may obtain a license from the Lawrence Livermore National Laboratory's Technology Transfer Office, P.O. Box 808, L-795, Livermore, CA 94550.


.SH SEE ALSO
ftpd(8C)
.RE

.SH AUTHOR
.nf
     Neale G. Smith, Lawrence Livermore National Laboratory
.RE

