


xftp(1)                  USER COMMANDS                    xftp(1)



NAME
     LLNL XFTP - an X-based interface to FTP


SYNOPSIS
     xftp [standard X options]


DESCRIPTION
     _L_L_N_L _X_F_T_P is a graphical user interface to FTP (File
     Transfer Protocol).  _L_L_N_L _X_F_T_P does not execute the _f_t_p pro-
     gram; instead, it directly communicates with remote FTP
     servers.  _L_L_N_L _X_F_T_P is an X client and follows the OSF/Motif
     look-and-feel.  _L_L_N_L _X_F_T_P enables users to transfer files
     and perform various directory manipulation commands, both
     remotely and locally.  Two especially notable features are
     the ability to (1) perform "third-party" file transfers, and
     (2) transfer or delete entire directory substructures.

     _L_L_N_L _X_F_T_P'_s main window is divided into five main sections:
     (1) the main menu bar at the top of the window,  (2) the
     diagnostics log at the bottom, (3) the file transfer con-
     trols in the center, and (4 and 5) the "left" and "right"
     host sections to either side of the file transfer controls.

     _L_L_N_L _X_F_T_P can be connected to zero, one, or two hosts.  The
     hosts may be any combination of local and remote hosts (the
     local host is the client host upon which _L_L_N_L _X_F_T_P is run-
     ning).  In this document, a connected host is referred to as
     either the "left" or "right" host, depending on whether it
     is displayed in the left or right host section, respec-
     tively.

     Each host section consists of four major graphical elements:
     (1) a label which displays the host's name; (2) a menu bar
     whose menus contain many commands that operate on the host;
     (3) a "directory" menu; and (4) a scrollable "directory
     list."

     Each host's _C_o_n_n_e_c_t menu contains commands for
     connecting/disconnecting local and remote hosts.

     Each host's _D_i_r menu contains various commands for creating
     new directories, and for changing and displaying the current
     directory.

     Each host's _S_e_l_e_c_t menu contains commands for
     selecting/deselecting entries in the current directory (the
     selections appear in the scrollable list of directory
     entries).

     Each host's _O_p_s menu contains several commands that operate



                    Last change: 12 May 1994                    1






xftp(1)                  USER COMMANDS                    xftp(1)



     on selected directory entries.

     Each host's directory menu contains each link of the path of
     the current directory (the last link is displayed).  By
     selecting a link in the path, the current directory is
     correspondingly changed.  (Hence, this is a mechanism to
     traverse up the host's directory structure.)

     Each host's directory list contains the entries of the
     current directory.  One way to select/deselect a directory
     entry is to click on it.  If an entry is double-clicked, an
     attempt is made to change the current directory to that
     entry.  (Hence, this is a way to traverse down the host's
     directory structure.)

     The file transfer controls in the middle of the main window
     allow the user to initiate file transfers on selected
     entries.  The transfers can go from left to right or from
     right to left.  Angle brackets in the _C_o_p_y and _R_c_o_p_y buttons
     indicate the direction of the transfer (e.g., ">>Copy>>"
     indicates that a left-to-right transfer would take place).
     The _V_i_e_w button causes the selected file to be displayed.

     The scrollable diagnostics log window at the bottom of the
     main window displays error and status information.  The user
     can control the level of verbosity of messages written to
     this window via the user preference _D_i_a_g_n_o_s_t_i_c_s.  The con-
     tents of this window can be saved to a file by selecting the
     _S_a_v_e _L_o_g item in the _L_o_g menu.  The diagnostics window can
     be cleared by selecting the _C_l_e_a_r _L_o_g item in the _L_o_g menu.

     There is a flag to the left of the diagnostics log window
     that indicates whether an operation completes successfully
     or not.  If an operation fails then (1) a beep is emitted,
     (2) the flag changes from green to red (white to black on
     monochrome displays), (3) the "OK" in the flag changes to
     "E", and (4) an error message is written to the diagnostic
     log window. The next operation will clear the error flag.

     _L_L_N_L _X_F_T_P automatically caches (1) wildcard expressions, (2)
     paths of current directories, (3) host names and user names
     used in connecting to remote hosts, and (4) quoted commands.
     The purpose of each cache is to reduce the amount of typing
     required.  For example, when the user wishes to apply a
     wildcard expression to select directory entries, a list of
     recently referenced wildcard expressions for that host will
     be presented to the user; the user can then double-click on
     an existing wildcard expression to apply it.  The cache is
     automatically preserved across _L_L_N_L _X_F_T_P sessions in a file
     named ".xftpcache" in the users home directory.





                    Last change: 12 May 1994                    2






xftp(1)                  USER COMMANDS                    xftp(1)



GETTING STARTED
     Use the _C_o_n_n_e_c_t menus to connect the two sides to the
     desired combination of local and/or remote hosts.  (Depend-
     ing on how the user preferences are set, when _L_L_N_L _X_F_T_P
     comes up some combination of the left and right sides might
     already be connected to the local host.)

     Once connected, traverse through a host's directory struc-
     ture by (1) using the directory name menu (the menu just
     above the directory list), (2) double-clicking on entries in
     the directory list, (3) selecting an item in the _G_o _t_o _P_r_e_-
     _v_i_o_u_s _D_i_r_e_c_t_o_r_y submenu in the host's _D_i_r menu, or (4)
     selecting the _C_h_a_n_g_e _D_i_r_e_c_t_o_r_y item in the host's _D_i_r menu.

     Obtain different types of views into a host's current direc-
     tory by selecting the _D_i_s_p_l_a_y _D_i_r_e_c_t_o_r_y (_L_o_n_g) or _D_i_s_p_l_a_y
     _D_i_r_e_c_t_o_r_y (_T_a_b_l_e) items in the host's _D_i_r menu.

     Select/deselect directory entries to operate on by (1)
     single-clicking on entries in the main directory list, (2)
     single-clicking on entries in the tabular directory list,
     (3) dragging the mouse with the left button held down over
     entries in the tabular directory list, or (4) by selecting
     any of the items in the host's _S_e_l_e_c_t menu.

     Transfer selected items by clicking on the _C_o_p_y or _R_c_o_p_y
     (recursive copy) buttons.  Be sure to first set the file
     transfer mode by toggling the appropriate button (_A_S_C_I_I or
     _B_i_n_a_r_y) in the main window.

     View a selected file by clicking on the _V_i_e_w button.  Con-
     figure the viewer by selecting item _V_i_e_w_e_r _P_r_e_f_e_r_e_n_c_e_s in
     the _O_p_t_i_o_n_s menu.  Be sure to first set the file transfer
     mode by toggling the appropriate button (_A_S_C_I_I or _B_i_n_a_r_y) in
     the main window.

     Perform other types of operations on selected items by
     selecting any one of the items in the host's _O_p_s menu.

     Configure _L_L_N_L _X_F_T_P by selecting the _P_r_e_f_e_r_e_n_c_e_s item in the
     _O_p_t_i_o_n_s menu.

COMMANDS
     _L_L_N_L _X_F_T_P contains a large number of commands.  The commands
     are found in (1) the main menus, (2) the host menus, and (3)
     in the _X_f_e_r _O_p_s controls.  Here is a list of the commands:

     About LLNL XFTP (in _F_i_l_e menu)
          Gives version information.

     Change Directory (in _D_i_r menus)
          Change the current directory.  A dialog pops up to



                    Last change: 12 May 1994                    3






xftp(1)                  USER COMMANDS                    xftp(1)



          prompt for the directory to change to.  The directory
          may be specified with a full or relative path.  Previ-
          ously referenced directories are cached and displayed
          in a scrollable list.  Double-click on a path in the
          list to change to that directory.  Single click on a
          path in the list to place that entry into the text
          field labeled "Directory:", where it can be edited.
          Click on the _O_K button to change to the directory
          displayed in the text field.  (See user preferences _A_d_d
          _t_o _C_a_c_h_e, _D_i_a_g_n_o_s_t_i_c_s, _D_i_r_e_c_t_o_r_y _C_a_c_h_e _S_i_z_e, _H_o_s_t _C_a_c_h_e
          _S_i_z_e, and _S_o_r_t _C_a_c_h_e_s.)

     Clear Log (in _L_o_g menu)
          Clear the diagnostics log window.

     Connect to Anonymous (in _C_o_n_n_e_c_t menus)
          Easily connect to an anonymous FTP site.  If currently
          connected, the connection is first closed.  A dialog
          pops up to prompt for the remote host, user name and
          password.  The user name is initialized to "anonymous".
          The password is initialized to the value of the user
          preference _A_n_o_n_y_m_o_u_s _F_t_p _P_a_s_s_w_o_r_d (which you will prob-
          ably want to set to your email address).  An optional
          port number may follow the host name (using a space as
          the delimiter).  Previously used host/user name pairs
          are cached, and those with user names "anonymous" or
          "ftp" are displayed in a scolled list labeled "Recently
          Referenced Hosts:".  Double-clicking on a host/user
          name pair initiates a connection.  Single-clicking on a
          host/user name pair places those values in to the host
          name and user name fields, where they can be edited.
          Click on the _C_o_n_n_e_c_t button to initiate a connection.
          (See user preferences _A_d_d _T_o _C_a_c_h_e, _A_n_o_n_y_m_o_u_s _F_t_p _P_a_s_s_-
          _w_o_r_d, _D_i_a_g_n_o_s_t_i_c_s, _H_o_s_t _C_a_c_h_e _S_i_z_e, _U_s_e_r _C_a_c_h_e _S_i_z_e,
          and _S_o_r_t _C_a_c_h_e_s.)

     Connect to Local (in _C_o_n_n_e_c_t menus)
          Connect to the local (client) host.  If currently con-
          nected, the connection is first closed.  (See user
          preferences _L_e_f_t _A_u_t_o _L_o_c_a_l _L_o_g_i_n and _R_i_g_h_t _A_u_t_o _L_o_c_a_l
          _L_o_g_i_n.)

     Connect to Remote (in _C_o_n_n_e_c_t menus)
          Connect to a remote host (use _C_o_n_n_e_c_t _t_o _A_n_o_n_y_m_o_u_s to
          more easily connect to an anonymous FTP site).  If
          currently connected, the connection is first closed.  A
          dialog pops up to prompt for the remote host and user
          names. The user name is initialized to the value of the
          environment variable _U_S_E_R.  An optional port number may
          follow the host name (using a space as the delimiter).
          Previously used host/user name pairs are cached and
          those with user names other than "anonymous" and "ftp"



                    Last change: 12 May 1994                    4






xftp(1)                  USER COMMANDS                    xftp(1)



          displayed in a scolled list labeled "Recently Refer-
          enced Hosts:".  Double-clicking on a host/user name
          pair initiates a connection.  Single-clicking on a
          host/user name pair places those values into the host
          name and user name fields, where they can be edited.
          Click on the _C_o_n_n_e_c_t button to initiate a connection.
          (See user preferences _A_d_d _T_o _C_a_c_h_e, _D_i_a_g_n_o_s_t_i_c_s, _H_o_s_t
          _C_a_c_h_e _S_i_z_e, _U_s_e_r _C_a_c_h_e _S_i_z_e, and _S_o_r_t _C_a_c_h_e_s.)

     Contextual Help (in _H_e_l_p menu)
          Enter contextual-help mode.  The mouse cursor changes
          to a pointing hand.  Move the hand and click on any
          graphical element in the main window that you wish to
          know more about.

     Copy (in _X_f_e_r _O_p_s controls)
          Transfers the selected files according to the mode
          (_A_S_C_I_I or _B_i_n_a_r_y) specified in _X_f_e_r _M_o_d_e.  A dialog
          pops up to enable the user to monitor the progress of
          the transfers.  The dialog contains a button for abort-
          ing the transfers.  (See user preferences _B_e_e_p _W_h_e_n _O_p_s
          _D_o_n_e, _D_i_a_g_n_o_s_t_i_c_s, _I_n_i_t_i_a_l _T_r_a_n_s_f_e_r _M_o_d_e, and _I_n_q_u_i_r_e
          _O_n _C_o_p_y.)

     Delete Selected Entry(s) (in _O_p_s menus)
          Deletes the selected entries.  A dialog pops up to
          enable the user to monitor the progress of the dele-
          tions.  The dialog contains a button for aborting the
          deletions.  (See user preferences _B_e_e_p _W_h_e_n _O_p_s _D_o_n_e,
          _D_i_a_g_n_o_s_t_i_c_s, and _I_n_q_u_i_r_e _O_n _D_e_l_e_t_e.)

     Deselect All Entries (in _S_e_l_e_c_t menus)
          Deselect all the entries in the host's current direc-
          tory.

     Disconnect (in _C_o_n_n_e_c_t menus)
          Close the currently connected host.  (See user prefer-
          ence _D_i_a_g_n_o_s_t_i_c_s.)

     Display Directory (Long) (in _D_i_r menus)
          Pops up a dialog that displays the contents of the
          current directory in a scrollable list.  If supported
          by the host (and this is almost always the case), addi-
          tional information about each directory entry is
          displayed, such as file length and access restrictions.
          This display is automatically updated as the current
          directory changes.  This directory display does not
          support selecting entries or displaying the current
          selection.  _W_a_r_n_i_n_g: Using this feature can increase
          network traffic, put an additional load on the remote
          host, and slow down interactivity.   (See user prefer-
          ence _D_i_a_g_n_o_s_t_i_c_s and _S_o_r_t _L_o_n_g _L_i_s_t_s _B_y _D_a_t_e.)



                    Last change: 12 May 1994                    5






xftp(1)                  USER COMMANDS                    xftp(1)



     Display Directory Path (in _D_i_r menus)
          Pops up a dialog that displays the current directory
          for that host.  It will be automatically updated as the
          current directory changes.  (See user preference _D_i_a_g_-
          _n_o_s_t_i_c_s.)

     Display Directory (Table) (in _D_i_r menus)
          Pops up a dialog that displays the contents of the
          current directory in tabular form.  This dialog may be
          used to view and modify the directory's selected
          entries.  Entries may be selected/deselected either by
          clicking or by moving the cursor over the entries with
          the mouse button down.  Moving the mouse too quickly
          can cause some of the entries to be skipped.  If an
          entry is double-clicked, an attempt is made to change
          the current directory to that entry.  This display is
          automatically updated as the current directory changes.
          (See user preference _D_i_a_g_n_o_s_t_i_c_s.)

     Getting Started (in _H_e_l_p menu)
          Describes how to get started using _L_L_N_L _X_F_T_P.

     Go to Previous Directory (in _D_i_r menus)
          Displays a pullright menu that allows the user to
          easily change the current directory to a previously
          referenced directory.  (See user preferences _A_d_d _t_o
          _C_a_c_h_e, _D_i_a_g_n_o_s_t_i_c_s, _D_i_r_e_c_t_o_r_y _C_a_c_h_e _S_i_z_e, _H_o_s_t _C_a_c_h_e
          _S_i_z_e, and _S_o_r_t _C_a_c_h_e_s.)

     LLNL XFTP Overview (in _H_e_l_p menu)
          Gives a high-level description of _L_L_N_L _X_F_T_P.

     Make Directory (in _D_i_r menus)
          Pops up a dialog to prompt for the name of a directory
          to make in the current directory.  The user preference
          _E_n_t_e_r _D_i_r _U_p_o_n _C_r_e_a_t_i_o_n controls whether the the newly
          created directory is automatically entered upon crea-
          tion.  (See user preferences _D_i_a_g_n_o_s_t_i_c_s and _E_n_t_e_r _D_i_r
          _U_p_o_n _C_r_e_a_t_i_o_n.)

     Move Selected Entry(s) (in _O_p_s menus)
          Move selected entries from the current directory to
          another directory on the same host.  This is similar to
          the UNIX _m_v command, but without rename capability.
          (See user preferences _B_e_e_p _W_h_e_n _O_p_s _D_o_n_e, and _D_i_a_g_n_o_s_-
          _t_i_c_s.)

     Preferences (in _O_p_t_i_o_n_s menu)
          Display the user preferences dialog.  See _U_S_E_R _P_R_E_F_E_R_-
          _E_N_C_E_S section for a description of user preferences.

     Quit (in _F_i_l_e menu)



                    Last change: 12 May 1994                    6






xftp(1)                  USER COMMANDS                    xftp(1)



          Terminate _L_L_N_L _X_F_T_P.

     Rcopy (in _X_f_e_r _O_p_s controls)
          Recursively transfers the selected entries according to
          the mode (_A_S_C_I_I or _B_i_n_a_r_y) specified in _X_f_e_r _M_o_d_e.  If
          a selected entry is a directory, an attempt is made to
          transfer its entire directory subtree.  A dialog pops
          up to enable the user to monitor the progress of the
          transfers.  The dialog contains a button for aborting
          the transfers.  (See user preferences _B_e_e_p _W_h_e_n _O_p_s
          _D_o_n_e, _D_i_a_g_n_o_s_t_i_c_s, _I_n_i_t_i_a_l _X_f_e_r _M_o_d_e, and _I_n_q_u_i_r_e _O_n
          _C_o_p_y.)

     Recursively Delete Selected Entry(s) (in _O_p_s menus)
          Recursively deletes the selected entries.  A dialog
          pops up to enable the user to monitor the progress of
          the deletions.  The dialog contains a button for abort-
          ing the deletions.  _W_a_r_n_i_n_g: Exercise extreme caution
          when using this command because it deletes entire
          directory subtrees.  To minimize the chance of an unin-
          tentional deletion, this menu item is greyed out unless
          the user preference _R_e_c_u_r_s_i_v_e _D_e_l_e_t_e _E_n_a_b_l_e_d is
          enabled.  (See user preferences _B_e_e_p _W_h_e_n _O_p_s _D_o_n_e,
          _D_i_a_g_n_o_s_t_i_c_s, _I_n_q_u_i_r_e _O_n _D_e_l_e_t_e, and _R_e_c_u_r_s_i_v_e _D_e_l_e_t_e
          _E_n_a_b_l_e_d.)

     Rename Selected Entry(s) (in _O_p_s menus)
          Pop up a dialog to individually rename selected
          entries.  This is similar to the UNIX _m_v command except
          that the renamed entries cannot be moved to another
          directory.  (See user preference _D_i_a_g_n_o_s_t_i_c_s.)

     Save Log (in _L_o_g menu)
          Write the contents of the diagnostics window to a
          user-specified file.  The existing contents of the
          diagnostics window are not removed.

     Save Preferences (in _O_p_t_i_o_n_s menu)
          Save the current settings of the user and viewer
          preferences.

     Select All Entries (in _S_e_l_e_c_t menus)
          Select all the entries in the host's current directory.

     Send Quoted Command (in _O_p_s menus)
          Pops up a dialog to prompt for a "raw" command to send
          to the FTP server of the remote host.  Previously
          issued commands are cached and displayed in a scrolled
          list.  Double-clicking on a command in the list issues
          that command.  To have a command act on items selected
          in the host's directory list, use the quote placeholder
          (which by default is "<>") to represent a selected



                    Last change: 12 May 1994                    7






xftp(1)                  USER COMMANDS                    xftp(1)



          item.  For example, type "stage 1 <>" to send a STAGE
          command to the the remote host for each selected item.
          The quote placeholder can changed via the user prefer-
          ences.  (See user preferences _B_e_e_p _W_h_e_n _O_p_s _D_o_n_e, _D_i_a_g_-
          _n_o_s_t_i_c_s, and _Q_u_o_t_e _P_l_a_c_e_h_o_l_d_e_r.)

     Use Wildcard (in _S_e_l_e_c_t menus)
          Pops up a dialog to prompt for a wildcard expression to
          use in selecting entries in the host's current direc-
          tory list.  Previously referenced wildcard expressions
          are cached and displayed in a scrolled list.  Double-
          clicking on an item in the list applies that wildcard
          expression.  Single-clicking on an item in the list
          places the expression in a text field where it may be
          edited.  Choose the toggle item _R_e_p_l_a_c_e _F_i_l_e_n_a_m_e _S_e_l_e_c_-
          _t_i_o_n to cause the currently selected entries to be
          cleared before applying the wildcard.  Choose the tog-
          gle item _A_d_d _t_o _F_i_l_e_n_a_m_e _S_e_l_e_c_t_i_o_n to cause the entries
          selected by the wildcard to be added to the current
          selection.  (See user preference _I_n_i_t_i_a_l _W_i_l_d_c_a_r_d
          _M_o_d_e).

     Using Help (in _H_e_l_p menu)
          Gives a description of the online help package.

     View (in _X_f_e_r _O_p_s controls)
          Displays the selected file.  The _V_i_e_w_e_r _P_r_e_f_e_r_e_n_c_e_s
          dialog (accessible via the _O_p_t_i_o_n_s menu) can be used to
          control whether the file will be displayed using the
          built-in viewer or using an external viewer of the
          user's choice (e.g., _e_m_a_c_s or _x_v).  The selection of
          the viewer is configurable, based on the file extension
          (e.g., ".gif" or ".jpg").  There is no limit on the
          number or types of viewers that can be simultaneously
          displayed.

          The file is transferred according to the mode (_A_S_C_I_I or
          _B_i_n_a_r_y) specified in _X_f_e_r _M_o_d_e.  A dialog pops up to
          enable the user to monitor the progress of the
          transfer.  The dialog contains a button for aborting
          the transfer.

          The destination of the transfer is a temporary direc-
          tory created in the directory defined as _P__t_m_p_d_i_r in
          the include file stdio.h.  If the environment variable
          _T_M_P_D_I_R is defined, it is used as the directory.  The
          temporary directory, and the files it contains, are
          automatically deleted when the user dismisses the
          viewer or terminates _L_L_N_L _X_F_T_P.

          If the file is recognized as being compressed, it is
          expanded before viewing.  _L_L_N_L _X_F_T_P excutes the



                    Last change: 12 May 1994                    8






xftp(1)                  USER COMMANDS                    xftp(1)



          following decompressors based on the file extension:
          _g_u_n_z_i_p for ".z" and ".gz"; _u_n_c_o_m_p_r_e_s_s for ".Z"; _a_t_o_b
          for "atob"; and _u_u_d_e_c_o_d_e for ".uu".  _L_L_N_L _X_F_T_P searches
          for the decompressor application in the standard way
          using the _P_A_T_H environment variable.

     Viewer Preferences (in _O_p_t_i_o_n_s menu)
          Display the viewer preferences dialog.  See _V_I_E_W_E_R
          _P_R_E_F_E_R_E_N_C_E_S section for a description of viewer prefer-
          ences.

USER PREFERENCES
     Selecting item _P_r_e_f_e_r_e_n_c_e_s in the _O_p_t_i_o_n_s menu pops up a
     dialog that allows the user to configure _L_L_N_L _X_F_T_P according
     to his/her preferences.  The user is presented with a number
     of configuration parameters, which are set by either tog-
     gling, sliding, or typing.  Click the _A_p_p_l_y button to cause
     the new values to take effect.  The _O_K button has the same
     effect as _A_p_p_l_y, but the dialog is also closed.  The _C_a_n_c_e_l
     button undoes changes made since _O_K or _A_p_p_l_y were last
     pressed.  The preferences can be preserved across _L_L_N_L _X_F_T_P
     sessions in a text file named ".xftprc" in the user's home
     directory.  The user may alter the order the preferences are
     presented in the dialog by (1) terminating _L_L_N_L _X_F_T_P, (2)
     using a text editor to change the order of lines in
     ".xftprc" and (3) restarting _L_L_N_L _X_F_T_P.

     Add To Cache
          Specifies whether newly referenced items should be
          added to the directory, quoted command, wildcard, and
          host/user caches.  It is usually desirable to choose
          _Y_e_s.  Choose _N_o if referencing a series of seldom-
          referenced items that would clear the cache of your
          favorite entries.

     Anonymous Ftp Password
          The value to initialize the "Password" field of the
          _C_o_n_n_e_c_t _t_o _A_n_o_n_y_m_o_u_s dialog to.  This is normally your
          email address.  The _C_o_n_n_e_c_t _t_o _A_n_o_n_y_m_o_u_s dialog is
          accessible via each host's _C_o_n_n_e_c_t menu.

     Beep When Ops Done
          Specifes whether to beep when each set of deletion,
          move, quoted command, and file transfer operations com-
          pletes.

     Diagnostics
          Specifies the level of diagnostics information to be
          written to the diagnostics log window.  Choose _Q_u_i_e_t
          for error messages, only.  Choose _N_o_r_m_a_l for error mes-
          sages and success messages.  Choose _V_e_r_b_o_s_e for error
          messages, success messages, and replies received from



                    Last change: 12 May 1994                    9






xftp(1)                  USER COMMANDS                    xftp(1)



          the FTP servers.  Choose _D_e_b_u_g for error messages, suc-
          cess messages, commands sent to the FTP servers,
          replies received from the FTP servers, and other
          assorted diagnostics.

     Directory Cache Size
          The maximum number of previously referenced directory
          paths cached per host.  The cache is preserved across
          _L_L_N_L _X_F_T_P sessions.

     Enhance Colors
          Speficies whether to "pretty up" some of the graphical
          elements (such as scrolled lists and text fields) by
          changing the normal background colors.  This preference
          has no effect on monochrome displays.  Choose _Y_e_s to
          enhance the appearance, or _N_o for the usual Motif look.

     Enter Dir Upon Creation
          Specifies whether to automatically enter a newly
          created directory.

     Host Cache Size
          The maximum number of hosts to cache items for.  The
          cache is preserved across _L_L_N_L _X_F_T_P sessions.

     Initial Logfile Name
          The default file name to be presented to the user in
          the "Save Log" dialog.

     Initial Transfer Mode
          The default file transfer mode (_A_S_C_I_I or _B_i_n_a_r_y).

     Initial Wildcard Mode
          The default mode of the "Use Wildcard" dialog.  Choose
          _R_e_p_l_a_c_e to make "Replace Filename Selection" the
          default.  Choose _A_d_d to make "Add to Filename Selec-
          tion" the default.

     Inquire On Copy
          Specifies whether to pop up a dialog that asks the user
          to confirm that the indicated transfers should take
          place.

     Inquire On Delete
          Specifies whether to pop up a dialog that asks the user
          to confirm that the indicated deletions should take
          place.

     Inquire On Move
          Specifies whether to pop up a dialog that asks the user
          to confirm that the indicated moves should take place.




                    Last change: 12 May 1994                   10






xftp(1)                  USER COMMANDS                    xftp(1)



     Inquire On Quote
          Specifies whether to pop up a dialog that asks the user
          to confirm that the indicated commands should be sent.

     Left Auto Local Login
          Specifies whether to automatically connect the left
          side to the local (client) host upon starting _L_L_N_L
          _X_F_T_P.

     Max Ftp Retries
          Specifies the maximum number of retries _L_L_N_L _X_F_T_P will
          attempt if it receives a response from an FTP server
          that indicates the desired operation failed because of
          some temporary condition on the remote host.

     Max Time For Ftp Reply
          Specifies the maximum time in seconds that _L_L_N_L _X_F_T_P
          will wait for a response from an FTP server before con-
          cluding that the connection has been broken.

     Preserve Vms Ver Nums
          Specifies whether to preserve VMS file version numbers
          when transferring files from a VMS system.  This is
          only an issue for those VMS FTP servers that provide
          numbers (not all do).

     Print Password In Debug
          Specifies whether to print passwords in the log window
          when the user preference _D_i_a_g_n_o_s_t_i_c_s is set to _D_e_b_u_g.

     Quote Cache Size
          The number of quoted commands to cache.  The cache is
          preserved across _L_L_N_L _X_F_T_P sessions.

     Quote Placeholder
          This is used as a placeholder in a quoted command to
          represent items selected in the directory list.  For
          example, the quoted command "stage 1 <>" will send a
          STAGE command to the remote host for each selected
          item.  The default value is "<>", but the placeholder
          can be set to any nonnull printable string.

     Recursive Delete Enabled
          Specifies whether to enable the _R_e_c_u_r_s_i_v_e_l_y _D_e_l_e_t_e
          _S_e_l_e_c_t_e_d _E_n_t_r_y(_s) item in the _O_p_s menus.  Choose _N_o to
          help prevent accidental recursive deletions.

     Right Auto Local Login
          Specifies whether to automatically connect the right
          side to the local (client) host upon starting _L_L_N_L
          _X_F_T_P.




                    Last change: 12 May 1994                   11






xftp(1)                  USER COMMANDS                    xftp(1)



     Sort Caches
          Specifies whether to sort (by ASCII-collating sequence)
          cached items when they are displayed in dialogs.  If
          _Y_e_s, then sort.  If _N_o, then the most recently refer-
          enced items are placed at the top of the list.

     Sort Longs Lists By Date
          Specifies whether to attempt to sort the "long" direc-
          tory lists by time modified (with most recent listed
          first) instead of by name.  The _Y_e_s option is con-
          sidered unsafe because some FTP servers to not support
          this option and may give unpredictable results.  (Most
          UNIX hosts support this option.)

     Store Unique
          Specifies whether existing sink files are to be renamed
          before file transfer occurs.  If _Y_e_s then the existing
          sink file is typically renamed by appending a "."
          (period) followed by an integer between 1 and 99.

     Symbols On Dir Entries
          Specifies whether to append single characters to direc-
          tory entries in order to distinguish their types.  If
          _Y_e_s(_U_n_s_a_f_e) is chosen, "/" is appended to directories,
          "*" is appended to executables, "@" is appended to sym-
          bolic links, and "=" is appended to AF_UNIX address
          family sockets.  The "Yes" option is considered to be
          unsafe because some FTP servers do not support this
          feature and may give unpredictable results.  (Most UNIX
          hosts support this option.)  Furthermore, if you are
          referencing a directory or directory entry whose name
          ends with one of the special characters, you will need
          to select _N_o(_S_a_f_e).  When in doubt, select _N_o(_S_a_f_e).
          One further note: use of this feature can dramatically
          degrade interactivity.

     Use Last Dir At Login
          Specifies whether to automatically enter the most
          recently referenced directory after connecting to a
          host.  If this option is requested, but is not possible
          to perform (e.g., because the directory no longer
          exists), an error message will be generated, and your
          home directory will be entered.  _N_o_t_e: This mechanism
          attempts to enter the last directory referenced on the
          host, regardless of whether it is another user's direc-
          tory.

     User Cache Size
          The number of user names to cache (for remote hosts).
          The cache is preserved across _L_L_N_L _X_F_T_P sessions.

     Wildcard Cache Size



                    Last change: 12 May 1994                   12






xftp(1)                  USER COMMANDS                    xftp(1)



          The number of wildcard expressions to cache.  The cache
          is preserved across _L_L_N_L _X_F_T_P sessions.

VIEWER PREFERENCES
     Selecting item _V_i_e_w_e_r _P_r_e_f_e_r_e_n_c_e_s in the _O_p_t_i_o_n_s menu pops
     up a dialog that allows the user to control which file will
     be displayed with which viewer, based on the file extension.

     A file to be viewed is first transferred to a temporary
     directory and then, if necessary, is decompressed.  The file
     extension (e.g., ".gif") is then examined to determine which
     viewer the file is to be displayed in.  There are two types
     of viewers: the viewer built into _L_L_N_L _X_F_T_P (which is suit-
     able for displaying text files) and external viewers (e.g.,
     _e_m_a_c_s for text and _x_v for graphics).

     Single-click on an entry in the _E_x_t_e_n_s_i_o_n_s list to place
     that extension and its associated command line into the
     _E_x_t_e_n_s_i_o_n and _V_i_e_w_e_r _C_o_m_m_a_n_d _L_i_n_e text fields, respectively.

     An extension is a file suffix that begins with a period
     (".").  A special entry in the extensions list, "OTHERS"
     represents all files that do not have their extension listed
     (including files with no extensions).

     The pattern "<>" in a command line is a placeholder for the
     name of the file to be viewed.  A blank command line indi-
     cates that the built-in viewer is to be used.  To add a new
     extension to the list, fill in the _E_x_t_e_n_s_i_o_n and _V_i_e_w_e_r _C_o_m_-
     _m_a_n_d _L_i_n_e text fields and press the _A_d_d button.  If the text
     in _E_x_t_e_n_s_i_o_n does not begin with a period, one will be
     added.  If the extension is already in the list, it will be
     replaced.

     To replace the command line associated with an extension,
     (1) single-click on the list item to select it, (2) edit the
     command line, and (3) press the _R_e_p_l_a_c_e button.

     To delete an extension from the list, single-click on the
     list item to select it and then press the _D_e_l_e_t_e button.
     The "OTHERS" entry cannot be deleted (but it's command line
     can be replaced).

     Click the _A_p_p_l_y button to cause the new changes to take
     effect.  The _O_K button has the same effect as _A_p_p_l_y, but the
     dialog is also closed.  The _C_a_n_c_e_l button undoes the changes
     made since _O_K or _A_p_p_l_y were last pressed.

     The viewer preferences can be preserved across _L_L_N_L _X_F_T_P
     sessions in a text file named ".xftpview" in the user's home
     directory (select _S_a_v_e _P_r_e_f_e_r_e_n_c_e_s in the main window's
     _O_p_t_i_o_n_s menu).



                    Last change: 12 May 1994                   13






xftp(1)                  USER COMMANDS                    xftp(1)



WIDGET HIERARCHY
     Most of _L_L_N_L _X_F_T_P's widget heirarchy is listed here so that
     the knowledgeable user can use the X resource mechanism to
     customize _L_L_N_L _X_F_T_P.  Widget names are followed by their
     class names in parentheses.  A question mark is displayed if
     the widget's name is not known.  _L_L_N_L _X_F_T_P's classname is
     _X_F_t_p.


     _M_a_i_n _W_i_n_d_o_w

          main  (XmMainWindow)
              mainMenuBar (XmRowColumn)
                  File (XmCascadeButton)
                  ? (XmMenuShell)
                      pulldown (XmRowColumn)
                  Edit (XmCascadeButton)
                  ? (XmMenuShell)
                      pulldown (XmRowColumn)
                  Options (XmCascadeButton)
                  ? (XmMenuShell)
                      pulldown (XmRowColumn)
                  Help (XmCascadeButton)
                  ? (XmMenuShell)
                      pulldown (XmRowColumn)
              pane  (XmPanedWindow)
                  topForm  (XmForm)
                      leftHost  (XmForm)
                          hostName  (XmLabel)
                          hostMenuBar  (XmRowColumn)
                              Connect  (XmCascadeButton)
                              ?  (XmMenuShell)
                                  pulldown  (XmRowColumn)
                              Dir  (XmCascadeButton)
                              ?  (XmMenuShell)
                                  pulldown  (XmRowColumn)
                              Select  (XmCascadeButton)
                              ?  (XmMenuShell)
                                  pulldown  (XmRowColumn)
                              Ops  (XmCascadeButton)
                              ?  (XmMenuShell)
                                  pulldown  (XmRowColumn)
                          dirNameForm  (XmForm)
                              dirName  (XmRowColumn)
                                  ?  (XmCascadeButtonGadget)
                              ?  (XmMenuShell)
                                  dirNameMenu  (XmRowColumn)
                                      ?  (XmPushButtonGadget)
                                                 . . .
                                      ?  (XmPushButtonGadget)
                          dirListSW  (XmScrolledWindow)
                              dirList  (XmList)



                    Last change: 12 May 1994                   14






xftp(1)                  USER COMMANDS                    xftp(1)



                      rightHost  (XmForm)
                          hostName  (XmLabel)
                          hostMenuBar  (XmRowColumn)
                              Connect  (XmCascadeButton)
                                  ?  (XmMenuShell)
                                      pulldown  (XmRowColumn)
                                  Dir  (XmCascadeButton)
                                  ?  (XmMenuShell)
                                      pulldown  (XmRowColumn)
                                  Select  (XmCascadeButton)
                                  ?  (XmMenuShell)
                                      pulldown  (XmRowColumn)
                                  Ops  (XmCascadeButton)
                                  ?  (XmMenuShell)
                                      pulldown  (XmRowColumn)
                              dirNameForm  (XmForm)
                                  dirName  (XmRowColumn)
                                      ?  (XmCascadeButtonGadget)
                                  ?  (XmMenuShell)
                                      dirNameMenu  (XmRowColumn)
                                          ?  (XmPushButtonGadget)
                                                  . . .
                                          ?  (XmPushButtonGadget)
                              dirListSW  (XmScrolledWindow)
                                  dirList  (XmList)
                          centerControls  (XmForm)
                              xferModeFrame  (XmFrame)
                                  xferMode  (XmRowColumn)
                                      ascii  (XmToggleButtonGadget)
                              xferModeLabel  (XmLabel)
                              xferOpsFrame  (XmFrame)
                                  xferOps  (XmRowColumn)
                                      copyButton  (XmPushButton)
                                      rCopyButton  (XmPushButton)
                                      viewButton  (XmPushButton)
                              xferOpsLabel  (XmLabel)
                              logo  (XmLabelGadget)
                      bottomForm  (XmForm)
                          resultFlagFrame  (XmFrame)
                              resultFlag  (XmLabel)
                          logSW  (XmScrolledWindow)
                              log  (XmText)

     _A_b_o_r_t _i_n _P_r_o_g_r_e_s_s _D_i_a_l_o_g
          abort_popup  (XmDialogShell)
              abort  (XmForm)
                  abortMessage  (XmLabel)

     _A_b_o_u_t _X_F_T_P _D_i_a_l_o_g
          about_popup  (XmDialogShell)
              about  (XmSelectionBox)
                  form  (XmForm)



                    Last change: 12 May 1994                   15






xftp(1)                  USER COMMANDS                    xftp(1)



                      frame  (XmFrame)
                          startup  (XmLabel)

     _A_c_c_o_u_n_t _D_i_a_l_o_g
          account_popup  (XmDialogShell)
              account  (XmSelectionBox)

     _C_h_a_n_g_e _D_i_r_e_c_t_o_r_y _D_i_a_l_o_g
          changeDir_popup  (XmDialogShell)
              changeDir  (XmSelectionBox)

     _C_o_n_n_e_c_t _t_o _A_n_o_n_y_m_o_u_s _D_i_a_l_o_g
          aConnect_popup  (XmDialogShell)
              aConnect  (XmSelectionBox)
                  form  (XmForm)
                      hostListLabel  (XmLabel)
                      hostListSW  (XmScrolledWindow)
                          hostList  (XmList)
                      hostNameLabel  (XmLabel)
                      hostName  (XmTextField)
                      userNameLabel  (XmLabel)
                      userName  (XmTextField)
                      passwordLabel  (XmLabel)
                      password  (XmTextField)

     _D_e_s_t_i_n_a_t_i_o_n _D_i_r_e_c_t_o_r_y _D_i_a_l_o_g
          destdir_popup  (XmDialogShell)
              destdir  (XmSelectionBox)
                  form  (XmForm)
                      instruction  (XmLabel)
                      dirNameForm  (XmForm)
                          dirName  (XmRowColumn)
                              ?  (XmCascaseButtonGadget)
                          ? (XmMenuShell)
                              dirNameMenu  (XmRowColumn)
                                  ?  (XmPushButtonGadget)
                                            . . .
                                  ?  (XmPushButtonGadget)
                      dirListSw  (XmScrolledWindow)
                          dirList  (XmList)

     _F_i_l_e _T_r_a_n_s_f_e_r _M_o_n_i_t_o_r _D_i_a_l_o_g
          monitor_popup  (XmDialogShell)
              monitor  (XmSelectionBox)
                  controlArea  (XmForm)
                      nameLabel  (XmLabel)
                      name  (XmLabel)
                      lengthLabel  (XmLabel)
                      length  (XmLabel)
                      bytesMovedLabel  (XmLabel)
                      bytesMove  (XmLabel)
                      scale  (XmScale)



                    Last change: 12 May 1994                   16






xftp(1)                  USER COMMANDS                    xftp(1)



     _H_e_l_p _D_i_a_l_o_g
          help_popup  (XmDialogShell)
              help  (XmForm)
                  pane  (XmPanedWindow)
                      controlArea  (XmForm)
                          topic  (XmLabel)
                          textSW   (XmScrolledWindow)
                              text  (XmText)

     _I_n_f_o_r_m_a_t_i_o_n _D_i_a_l_o_g
          information_popup  (XmDialogShell)
              information  (XmMessageBox)

     _L_e_f_t _D_i_r_e_c_t_o_r_y _P_a_t_h _D_i_a_l_o_g
          leftDirPath_popup  (XmDialogShell)
              leftDirPath  (XmSelectionBox)

     _L_e_f_t _L_o_n_g _D_i_r_e_c_t_o_r_y _L_i_s_t _D_i_a_l_o_g
          leftDirLong_popup  (XmDialogShell)
              leftDirLong  (XmForm)
                  dirListSW  (XmScrolledWindow)
                      dirList  (XmText)
                  separator  (XmSeparator)
                  closeButton  (XmPushButton)
                  helpButton  (XmPushButton)

     _L_e_f_t _T_a_b_u_l_a_r _D_i_r_e_c_t_o_r_y _L_i_s_t _D_i_a_l_o_g
          leftDirTable_popup  (XmDialogShell)
              leftDirTable  (XmForm)
                  scrolledWindow  (XmScrolledWindow)
                      drawingArea  (XmDrawingArea)
                  separator  (XmSeparator)
                  closeButton  (XmPushButton)
                  helpButton  (XmPushButton)

     _M_a_k_e _D_i_a_l_o_g
          makeDir_popup  (XmDialogShell)
              makeDir  (XmSelectionBox)

     _M_o_n_i_t_o_r _D_i_a_l_o_g
          mpMonitor_popup  (XmDialogShell)
              mpMonitor  (XmSelectionBox)
                  form  (XmForm)
                      pathLabel  (XmLabel)
                      path  (XmLabel)

     _P_a_s_s_w_o_r_d _D_i_a_l_o_g
          password_popup  (XmDialogShell)
              password  (XmSelectionBox)

     _P_r_e_f_e_r_e_n_c_e_s _D_i_a_l_o_g
          prefs_popup  (XmDialogShell)



                    Last change: 12 May 1994                   17






xftp(1)                  USER COMMANDS                    xftp(1)



              prefs  (XmForm)
                  actionArea  (XmForm)
                      okButton  (XmPushButton)
                  separator  (XmSeparator)
                  scrolledWindow  (XmScrolledWindow)
                      rowColumn  (XmRowColumn)
                          frame  (XmFrame)
                              form  (XmForm)
                                  label  (XmLabel)
                                  --------------------------------------
                                  textField  (XmTextField)
                                  --------------------------------------
                                  radioBoxFrame  (XmFrame)
                                      radioBox  (XmRowColumn)
                                          ?  (XmToggleButtonGadget)
                                                     . . .
                                          ?  (XmToggleButtonGadget)
                                  --------------------------------------
                                  scale  (XmScale)
                                  --------------------------------------

     _Q_u_e_s_t_i_o_n _D_i_a_l_o_g
          question_popup (XmDialogShell)
              question  (XmMessageBox)

     _Q_u_o_t_e _D_i_a_l_o_g
          quote_popup  (XmDialogShell)
              quote  (XmSelectionBox)
                  form  (XmForm)
                      listLabel  (XmLabel)
                      listSW  (XmScrolledWindow)
                          list  (XmList)
                      textLabel  (XmLabel)
                      text  (XmTextField)
                      warningLabel  (XmLabel)
                      warningFrame  (XmFrame)
                          warning  (XmRowColumn)
                          warningMsg1  (XmLabel)
                          warningMsg2  (XmLabel)
                          warningMsg3  (XmLabel)

     _R_e_m_o_t_e _C_o_n_n_e_c_t _D_i_a_l_o_g
          rConnect_popup  (XmDialogShell)
              rConnect  (XmSelectionBox)
                  form  (XmForm)
                      hostListLabel  (XmLabel)
                      hostListSW  (XmScrolledWindow)
                          hostList  (XmList)
                      hostNameLabel  (XmLabel)
                      hostName  (XmTextField)
                      userNameLabel  (XmLabel)
                      userName  (XmTextField)



                    Last change: 12 May 1994                   18






xftp(1)                  USER COMMANDS                    xftp(1)



     _R_e_n_a_m_e _D_i_a_l_o_g
          rename_popup  (XmDialogShell)
              rename  (XmSelectionBox)
                  form  (XmForm)
                      oldNameLabel  (XmLabel)
                      oldName  (XmLabel)
                      newNameLabel  (XmLabel)
                      newName  (XmTextField)

     _R_i_g_h_t _D_i_r_e_c_t_o_r_y _P_a_t_h _D_i_a_l_o_g
          rightDirPath_popup  (XmDialogShell)
              rightDirPath  (XmSelectionBox)

     _R_i_g_h_t _L_o_n_g _D_i_r_e_c_t_o_r_y _L_i_s_t _D_i_a_l_o_g
          rightDirLong_popup  (XmDialogShell)
              rightDirLong  (XmForm)
                  dirListSW  (XmScrolledWindow)
                      dirList  (XmText)
                  separator  (XmPushButton)
                  closeButton  (XmPushButton)
                  helpButton  (XmPushButton)

     _R_i_g_h_t _T_a_b_u_l_a_r _D_i_r_e_c_t_o_r_y _L_i_s_t _D_i_a_l_o_g
          rightDirTable_popup  (XmDialogShell)
              rightDirTable  (XmForm)
                  scrolledWindow  (XmScrolledWindow)
                      drawingArea  (XmDrawingArea)
                  separator  (XmSeparator)
                  closeButton  (XmPushButton)
                  helpButton  (XmPushButton)

     _S_a_v_e _D_i_a_g_n_o_s_t_i_c_s _L_o_g _D_i_a_l_o_g
          saveLog_popup  (XmDialogShell)
              saveLog  (XmSelectionBox)

     _V_e_r_i_f_y _D_i_a_l_o_g
          verify_popup  (XmDialogShell)
              verify  (XmSelectionBox)
                  form  (XmForm)
                      label  (XmLabel)
                      listSW  (XmScrolledWindow)
                          list  (XmList)

     _V_i_e_w _F_i_l_e _D_i_a_l_o_g
          view_popup  (XmDialogShell)
              view  (XmForm)
                  saveButton  (XmPushButton)
                  closeButton  (XmPushButton)
                  helpButton  (XmPushButton)
                  separator  (XmSeparator)
                  textSW  (XmScrolledWindow)
                      text  (XmText)



                    Last change: 12 May 1994                   19






xftp(1)                  USER COMMANDS                    xftp(1)



     _V_i_e_w_e_r _P_r_e_f_e_r_e_n_c_e_s _D_i_a_l_o_g
          viewPrefs_popup  (XmDialogShell)
              viewPrefs  (XmSelectionBox)
                  form  (XmForm)
                      listLabel  (XmLabel)
                      listSW  (XmScrolledWindow)
                          list  (XmList)
                      extensionLabel  (XmLabel)
                      extension  (XmTextField)
                      commandLineLabel  (XmLabel)
                      commandLine  (XmTextField)
                      editFrame  (XmFrame)
                          editForm  (XmForm)
                              addButton  (XmPushButton)
                              replaceButton  (XmPushButton)
                              deleteButton  (XmPushButton)
                      messageFrame  (XmFrame)
                          messageRowcolumn  (XmRowColumn)
                              message1  (XmLabel)
                              message2  (XmLabel)

     _W_i_l_d_c_a_r_d _D_i_a_l_o_g
          wildcard_popup  (XmDialogShell)
              wildcard  (XmSelectionBox)
                  form  (XmForm)
                      listLabel  (XmLabel)
                      listSW  (XmScrolledWindow)
                          list  (XmList)
                      textLabel  (XmLabel)
                      text  (XmTextField)
                      radioBoxFrame  (XmFrame)
                          radioBox  (XmRowColumn)
                              replaceToggle  (XmToggleButtonGadget)
                              addToggle  (XmToggleButtonGadget)

LIMITATIONS
     Here are some things to watch out for:

     _L_L_N_L _X_F_T_P might not work with some old X servers.  For exam-
     ple, some older OpenWindows servers might dump core.  MacX
     fans should use nothing older than version 1.1.7b.

     Old, buggy versions of Motif can cause weirdness.

     _L_L_N_L _X_F_T_P might not work correctly with some non-Unix FTP
     servers.  (If you can give us temporary access to such a
     server, we might be able to fix the problem.)

     Out-of-spec FTP servers can cause untold grief.  (Most
     Unix-based servers work correctly.)

     Third-party file transfers will not work unless at least one



                    Last change: 12 May 1994                   20






xftp(1)                  USER COMMANDS                    xftp(1)



     of the remote FTP servers supports the PASV (passive) com-
     mand.

FILES
     $HOME/.xftpcache   cache file
     $HOME/.xftprc      user preferences
     $HOME/.xftpview    viewer preferences
     XFtp.color         application defaults file for color displays
     XFtp.mono          application defaults file for monochrome displays

AVAILABILITY
     The sources for _L_L_N_L _X_F_T_P are tarred and compressed, and are
     available via anonymous ftp:

                        IP Address:  phoenix.ocf.llnl.gov
                         Directory:  /llnlxftp

SUPPORT
     Because our resources are limited, we will not be able to
     give individual assistance in building and using _L_L_N_L _X_F_T_P.
     However, your comments, suggestions and bug reports are
     valuable in helping us determine how to best direct our
     efforts.  Our email address is

                                llnlxftp@llnl.gov


COPYRIGHT
     (c) 1993-1994.  The Regents of the University of California.
     All rights reserved.

     This work was produced at the University of California,
     Lawrence Livermore National Laboratory (UC LLNL) under con-
     tract no.  W-7405-ENG-48 (Contract 48) between the U.S.
     Department of Energy (DOE) and The Regents of the University
     of California (University) for the operation of UC LLNL.
     Copyright is reserved to the University for purposes of con-
     trolled dissemination, commercialization through formal
     licensing, or other disposition under terms of Contract 48;
     DOE policies, regulations and orders; and U.S. statutes.
     The rights of the Federal Government are reserved under Con-
     tract 48 subject to the restrictions agreed upon by the DOE
     and University.

                                DISCLAIMER

     This software was prepared as an account of work sponsored
     by an agency of the United States Government.  Neither the
     United States Government nor the University of California
     nor any of their employees, makes any warranty, express or
     implied, or assumes any liability or responsibility for the
     accuracy, completeness, or usefulness of any information,



                    Last change: 12 May 1994                   21






xftp(1)                  USER COMMANDS                    xftp(1)



     apparatus, product, or process disclosed, or represents that
     its specific commercial products, process, or service by
     trade name, trademark, manufacturer, or otherwise, does not
     necessarily constitute or imply its endorsement, recommenda-
     tion, or favoring by the United States Government or the
     University of California. The views and opinions of the
     authors expressed herein do not necessarily state or reflect
     those of the United States Government or the University of
     California, and shall not be used for advertising or product
     endorsement purposes.

     Permission to use, copy, modify and distribute this software
     and its documentation for any non-commercial purpose,
     without fee, is hereby granted, provided that the above
     copyright notice and this permission notice appear in all
     copies of the software and supporting documentation, and
     that all UC LLNL identification in the user interface remain
     unchanged.  The title to copyright LLNL XFTP shall at all
     times remain with The Regents of the University of Califor-
     nia and users agree to preserve same. Users seeking the
     right to make derivative works with LLNL XFTP for commercial
     purposes may obtain a license from the Lawrence Livermore
     National Laboratory's Technology Transfer Office, P.O. Box
     808, L-795, Livermore, CA 94550.


SEE ALSO
     ftpd(8C)

AUTHOR
          Neale G. Smith, Lawrence Livermore National Laboratory
























                    Last change: 12 May 1994                   22



