/* TODO:
 * c) computing timeouts automatically
 * d) only lookup up addresses once for sure
 * e) use better memory sharing
 * f) use more portable and generic socket interfaces
 * g) make the entire thing more portable (autoconf??)
 * h) LOTS AND LOTS OF CLEANUP!
 * i) the various markers of "network unreachable", "ttl!= ..." need testing
 *    and incorporation where they don't work
 * j) The "errata" section, while fairly straightforward, needs to be
 *    tested.  The Internet just isn't as unreliable as it used to be
 *    so I'm having trouble testing it.  (explaination of it is easy:
 *    capital letter for unresolved addresses, lower case letter for when
 *    it gets resolved, it corresponds to the packet that is in that position,
 *    any packet with a blank for DNS is the same as =)
 * k) Integrate all the spiffy features of other traceroutes in like
 *    looking up AS #s, path MTU discovery, etc.
 * l) etc. etc. etc.
 * m) IPv6 doesn't work.  Make it work.  See g) and h) too.
 * n) need to make address system work better.  Should be able to
 *    toggle addresses/names, and also flip through a list of alternative
 *    paths.  Keys to retrieve & flip to ASN/MTU would be helpful.
 *    Think about a way to do all of this.  The parallel architecture
 *    via the select call makes this all really powerful.
 *    I think I should start with that -- the ASN lookup or something like
 *    that.
 * o) consider tripple layered system (i.e. select: will have a collect info
 *    abstraction and a plot on screen abstraction; perhaps plotting on screen
 *    is just an update pass every time select returns and commands are
 *    or something, but that's not a good way -- ideally, updates to screen
 *    could be done via other mechanisms).  Data could even be saved to a file.
 *    Now we're getting somewhere.  Where is MULTICS?
 * p) it needs some way of deciding to finish.  I don't consider this a high
 *    priority (this is a very human-oriented type of tool, who can ^C it.)
 * q) The continuousness part needs more definition (like, is it supposed
 *    to restart with new state in the beginning?  Is it supposed to wait
 *    for packets associated with the screen to expire first (not a bad idea)?)
 *    I want to make it expire packets before reissuing queries -- perhaps
 *    send the query upon death.  There's an idea.
 * r) need to add feature to kill packets after they've obtained all datum.
 *    perhaps that's what I'll do to death expire times.  Yes, that's
 *    what I'll do.  Or two deaths.

 * WRITE:

  above
 *
 * On my system, this compiles with:
 * gcc -O2 -g -pipe -o traceroute2 traceroute2.c /usr/lib/libresolv.so.4 /lib/libncurses.so && sudo cp ~/src/traceroute2 ~/bin && sudo chmod 6555 ~/bin/traceroute2
 * My system is Linux 2.0.21+netdev (IPv6 patches), gcc 2.7.2.1, libc5.4.2,
 * libresolv.so 4.9.5T4B, etc.
 * copyrights removed since this is so unique they don't matter any more.
 * you're free to put them back if you feel like doing it.
 * u@q.net 1996-Sep-26 v4 ftp://ftp.q.net/linux/traceroute-ulmo.c.gz
 * u@q.net 1998-Feb-1 v5 ftp://ftp.q.net/tu.tar.bz2
 *         My system is now GLIBC without IPv6 with Linux 2.0.33 kernel
 *         and this version probably is less portable but works.
 *         Please someone portabilize it.
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/wait.h>
#ifndef GLIBC
#include <linux/sched.h>
#include <linux/unistd.h>
#endif GLIBC
#include <unistd.h>
#include <signal.h>
#include <netdb.h>
#include <sys/time.h>
#include <curses.h>

#include <sys/param.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <sys/ioctl.h>

#ifdef __linux__
#include <endian.h>
#endif

#ifndef GLIBC
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>

#ifdef __linux__
#include <bsd/netinet/ip_icmp.h>
#include <linux/in6.h>
#include <linux/ipv6.h>
#include <linux/icmpv6.h>
#else
#include <netinet/ip_icmp.h>
#endif

#include <netinet/udp.h>

#include <arpa/inet.h>
#endif GLIBC

#include <netdb.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#ifdef GLIBC
#include "defines.h"
#endif GLIBC

#define	MAXPACKET	65535	/* max ip packet size */
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN	64
#endif

#if 0
#ifndef FD_SET
#define NFDBITS         (8*sizeof(fd_set))
#define FD_SETSIZE      NFDBITS
#define FD_SET(n, p)    ((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define FD_CLR(n, p)    ((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define FD_ISSET(n, p)  ((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)      bzero((char *)(p), sizeof(*(p)))
#endif
#endif

#define	Fprintf (void)fprintf
#define Sprintf (void)sprintf
#define Printf (void)printf

#ifdef INTERNAL_LOOKUPNAME
#ifdef __linux__
# define USE_LINUX_CLONE 1
#else
# define USE_FORK 1
#endif
#if USE_LINUX_CLONE
#if 1
 _syscall2(pid_t,clone,void*,sp,unsigned long,flags);
 pid_t clone(void *,unsigned long);
#define CClone(x,y) clone(x,y)
#else
extern int clone __P ((int (*__fn) (void *__arg), void *__child_stack,
                       int __flags, void *__arg));
#define CClone(x,y) clone(NULL,x,y,NULL)
#endif
# define Clone(x,y) CClone(x,y)
#elif USE_FORK
# define Clone(x,y) fork()
#endif
#endif INTERNAL_LOOKUPNAME


extern char **environ;
extern int errno, h_errno;

#define FAMILY AF_INET		/* choose AF_INET or AF_INET6 */ /*%% needs fixing */
#if (FAMILY == AF_INET6)
# define PROTSOCKADDR struct sockaddr_in6
# define PROTADDR struct in6_addr
# define PROTSAMBRADDR sin6_addr
# define PROTSAMBRFAM sin6_family
# define PROTSAMBRPORT sin6_port
# define IPHDR struct ipv6hdr
# define ICMPHDR struct icmpv6hdr
#else
# define PROTSOCKADDR struct sockaddr_in
# define PROTADDR struct in_addr
# define PROTSAMBRADDR sin_addr
# define PROTSAMBRFAM sin_family
# define PROTSAMBRPORT sin_port
# define IPHDR struct ip
# define ICMPHDR struct icmp
#endif
static int family=FAMILY;

/*
 * format of a (udp) probe packet.
 */
#if (FAMILY == AF_INET)
struct opacket {
	struct ip ip;
	struct udphdr udp;
# if 0
	u_char seq;		/* sequence number of this packet */
# else
	unsigned long ident;
	unsigned long seq;
	unsigned long probe;
# endif
	u_char ttl;		/* ttl packet left with */
	struct timespec ts;	/* time packet left */
};
#else
struct pkt_format {
	unsigned long ident;
	unsigned long seq;
	struct timespec ts;
};
#endif

struct pkt {
 u_char ttl;
 unsigned long probe, seq;
 struct timespec t1, sent_ts;

 unsigned char waitflags;
 int fda[2];
 char *hn;
 int pkt_h_errno;
 pid_t child;
 unsigned char erratanum;
 struct timespec death;
 struct pkt *prevpkt,*nextpkt,*nextdeath;
};

static u_char	packet[512];		/* last inbound (icmp) packet */
static struct opacket	*outpacket;	/* last output (udp) packet */

static int s;				/* receive (icmp) socket file descriptor */
static int sndsock;			/* send (udp) socket file descriptor */
/*static struct timezone tz;*/		/* leftover */
static int reset_timer=1;		/* reset timer to catch hanging traceroute */
static int got_there_f;
static int unreachable;
/*static unsigned long debugcounter=0,debugpacketinstance=0;*/
static int y,x,erratax,erratay;	/* terminal size and errata location */
static int erratayspace;
static unsigned char erratanum='@';

static PROTSOCKADDR whereto;	/* Who to try to reach */

static char *source = 0;
static char *hostname;
static unsigned char sfbuf[0x100]; /* overkill but safer */

static unsigned long seq=0,probe=0,nprobes=0;
static u_char ttl=1,initttl=1,max_ttl,cascade=1,cascadeamt=4;
static pid_t ident;
static u_short port = (0x8000+666);	/* start udp dest port # for probe packets */

/* mostly just booleans (sort of): */
static int options;			/* socket options */
static int verbose;
static int nflag;			/* print addresses numerically */
static u_char zopt=0,both=0,continuous=0,ttlfirst=1,max_ttl_reset=0,backwards=0;

#if (FAMILY == AF_INET6)
static char *sendbuff;
static int datalen = sizeof(struct pkt_format);
#else
static int datalen;
#endif
static PROTADDR *alist,*alistp;
static unsigned char *alistf,*alistpf;	/* flag of whether alist entry is valid */

static struct pkt *nextdeath=NULL,*lastdeath=NULL;
/* refresh is screen update, probe is next sending */
static struct timespec next_refresh,next_probe,
 expire_interval={60,0},
 refresh_interval={0,50*1000*1000},
 probe_interval={0,40*1000*1000};
/* X to Y  */
#define	TS2V(X,Y)	(((Y).tv_sec=(X).tv_sec), \
			((Y).tv_usec=(X).tv_nsec/1000))
#define TV2S(X,Y)	(((Y).tv_sec=(X).tv_sec), \
			((Y).tv_nsec=(X).tv_usec*1000))
/* result in X */
#define TSADD(X,Y)	(((((X).tv_nsec+=(Y).tv_nsec)>=1000000000)? \
			(++((X).tv_sec),(((X).tv_nsec)-=1000000000)):0), \
			((X).tv_sec+=(Y).tv_sec))
#define TSSUB(X,Y)	(((((X).tv_nsec-=(Y).tv_nsec)<0)? \
			(--((X).tv_sec),(((X).tv_nsec)+=1000000000)):0), \
			((X).tv_sec-=(Y).tv_sec))
#define TSCPY(X,Y)	(((X).tv_sec=(Y).tv_sec),((X).tv_nsec=(Y).tv_nsec))
/* >0 for X>Y, <0 for X<Y, 0 for equal */
#define TSCMP(X,Y)	(((X).tv_sec>(Y).tv_sec)?1: \
			(((X).tv_sec<(Y).tv_sec)?-1: \
			(((X).tv_nsec>(Y).tv_nsec)?1: \
			(((X).tv_nsec<(Y).tv_nsec)?-1:0))))
#define tsisset(X)	((X).tv_sec||(X).tv_nsec)

#define MY_WAIT_HN  (0x1)
#define MY_WAIT_PKT (0x2)

static int probespacing=8;
#define suggested_nprobes ((x-R_COL)/(probespacing+2))

#define HEAD_ROW (0)	/* title of the page: where we're tracerouting to */
#define HEAD_COL (0)
#define RESERR_COL (15)
#define NAME_COL (ADDR_COL+((RESERR_COL+1)*(!!both)))	/* PTR records */
#define ADDR_COL (0)
#define ERR_COL ((x>40)?(x-30):(x/2))	/* errors */
#define STAT_ROW (1)	/* current status */
#define STAT_COL (0)
#define R_ROW_F(hop) (hop+STAT_ROW-initttl+1)	/* result row */
#define R_ROW	R_ROW_F(ttl)
#define	R_ROW_PKT R_ROW_F(pkt->ttl)
#define R_COL (28+NAME_COL)	/* results column */
#define	R_COL_F(x)	(R_COL+(x*probespacing))
#define	R_COL_PKT R_COL_F(pkt->probe)	/* packet response results */

#define blip_p(X)	mvaddstr(R_ROW_PKT,(x-nprobes)+pkt->probe-1,X);
#define blip_n(X)	mvaddstr(R_ROW_PKT,(x-nprobes*2)+pkt->probe-1,X);

static int	packet_ok __P((u_char *, int, PROTSOCKADDR *, struct pkt *));
static void	send_probe __P((struct pkt**));
static double	deltaT __P((struct timespec *, struct timespec *));
static void	print __P((unsigned char *, int, PROTSOCKADDR *,struct pkt *));
static void	usage __P((void));
static int	waitpkt __P((struct pkt **, int, PROTSOCKADDR *));
static int	lookup_name __P((struct pkt *, void* , size_t , int));
extern int	lookup_name_ext __P((struct pkt *, void* , size_t , int));
static void	rmpkt __P((struct pkt *,struct pkt**));
static struct	pkt *newpkt __P((struct pkt **));
static int	chkprobe __P((struct pkt **));
static struct timespec	*gettime __P((struct timespec *));
static struct timespec *atots __P((struct timespec *,unsigned char*));
#define validts(X) (((X)->tv_sec>=0)&&((X)->tv_nsec>=0)&&((X)->tv_nsec<1000000000))
static void	got_there __P((struct pkt*));
static void	did_not_get_there __P((struct pkt*));
static void	reset_max_ttl __P((struct pkt*));
static int	keepgoing __P((void));

static struct timespec *atots (struct timespec *ts,unsigned char*s) {
 unsigned char *p;
 signed long significance;

 ts->tv_sec=ts->tv_nsec=0;
 for(p=s;isdigit(*p);++p){
  (ts->tv_sec)*=10; (ts->tv_sec)+=(long)(*p-(unsigned char)'0');
 }
 if(*(p++)==(unsigned char)'.')
  for(significance=1000000000;isdigit(*p)&&(significance>1);++p)
   (ts->tv_nsec)+=((significance/=10)*(long)(*p-(unsigned char)'0'));
 return ts;
}

static struct timespec *gettime(struct timespec *ts) {
 struct timeval tv;

 gettimeofday(&tv,NULL);
 TV2S(tv,*ts);
 return ts;
}

#ifdef DEBUG
static FILE *debugfp; /*d*/
static unsigned char debugbuf[4]; /*d*/
#endif DEBUG

void main(int argc, char **argv) {
 struct pkt *treeroot=NULL;
 struct timespec ts;

	char pa[64];
	extern char *optarg;
	extern int optind;
	struct hostent *hp;
	struct protoent *pe;
	PROTSOCKADDR from, *to;
	int ch, on, tos;

#ifdef DEBUG
 debugfp=fopen("/tmp/debug","w");
#endif DEBUG

 initscr();cbreak();noecho();getmaxyx(stdscr,y,x);
 nonl();intrflush(stdscr,FALSE);keypad(stdscr,TRUE);
 max_ttl=y-STAT_ROW-1;
 erratayspace=((int)((float)y/(float)4.5));
 gettime(&ts); TSCPY(next_refresh,ts); TSCPY(next_probe,ts);

 got_there_f=unreachable=0;

	on = 1;
	tos = 0;
	to = (PROTSOCKADDR *)&whereto;
	while ((ch = getopt(argc, argv, "Bce:f:bdm:np:q:rs:t:w:u:vY:Ty:i:z")) != EOF)
		switch(ch) {
		case 'f':
			refresh();endwin();
			Fprintf(stderr,
				"traceroute: switching families not yet supported, currently set at %s.\n",
				FAMILY==AF_INET6?"AF_INET6":"AF_INET");
			exit(1);
			if(!(strncasecmp(optarg,"inet6",strlen("inet6"))))
			 {family=AF_INET6;break;}
			if(!(strncasecmp(optarg,"inet4",strlen("inet4"))))
			 {family=AF_INET;break;}
			if(!(strncasecmp(optarg,"inet",strlen("inet"))))
			 {family=AF_INET;break;}
			refresh();endwin();
			Fprintf(stderr,
				"traceroute: family must be inet4 or inet6.\n");
			exit(1);
			break;
		case 'B':
			++backwards;
			break;
		case 'b':
			++both;
			break;
		case 'c':
			++continuous;
			break;
		case 'e':
			atots(&expire_interval,optarg);
			if(!validts(&expire_interval)) {
				refresh();endwin();
				Fprintf(stderr,
					"traceroute: -e is timespec in floating format (a.b).\n");
				exit(1);
			}
			break;
		case 'd':
			options |= SO_DEBUG;
			break;
		case 'i':
			initttl = atoi(optarg);
			if (initttl < 1) {
				refresh();endwin();
				Fprintf(stderr,
					"traceroute: initial ttl must be >=1.\n");
				exit(1);
			}
			break;
		case 'm':
			max_ttl = atoi(optarg);
			if (max_ttl <= 1) {
				refresh();endwin();
				Fprintf(stderr,
					"traceroute: max ttl must be >1.\n");
				exit(1);
			}
			break;
		case 'n':
			nflag++;
			break;
		case 'p':
			port = atoi(optarg);
			if (port < 1) {
				refresh();endwin();
				Fprintf(stderr,
				    "traceroute: port must be >0.\n");
				exit(1);
			}
			break;
		case 'q':
			nprobes = atoi(optarg);
			if (nprobes < 1) {
				refresh();endwin();
				Fprintf(stderr,
				    "traceroute: nprobes must be >0.\n");
				exit(1);
			}
			break;
		case 'r':
			options |= SO_DONTROUTE;
			break;
		case 's':
			/*
			 * set the ip source address of the outbound
			 * probe (e.g., on a multi-homed host).
			 */
			source = optarg;
			break;
		case 'T':
			ttlfirst=0;
			break;
		case 't':
			tos = atoi(optarg);
			if (tos < 0 || tos > 255) {
				refresh();endwin();
				Fprintf(stderr,
				    "traceroute: tos must be 0 to 255.\n");
				exit(1);
			}
			break;
		case 'u':
			atots(&refresh_interval,optarg);
			if(!validts(&refresh_interval)) {
				refresh();endwin();
				Fprintf(stderr,
					"traceroute: -u is timespec in floating format (a.b).\n");
				exit(1);
			}
			break;
		case 'v':
			verbose++;
			break;
		case 'w':
			atots(&probe_interval,optarg);
			if(!validts(&probe_interval)) {
				refresh();endwin();
				Fprintf(stderr,
					"traceroute: -w is timespec in floating format (a.b).\n");
				exit(1);
			}
			break;
		case 'y':
			erratayspace=atoi(optarg);
			if(erratayspace>y) {
				refresh();endwin();
				Fprintf(stderr,
				    "traceroute: erratayspace must be under y (%d).\n",y);
				exit(1);
			}
			break;
		case 'Y':
			probespacing=atoi(optarg);
			if(probespacing<2) {
				refresh();endwin();
				Fprintf(stderr,
				    "traceroute: probespacing should be higher.\n");
				exit(1);
			}
			break;
		case 'z':
			zopt++;
			break;
		default:
			usage();
		}
	argc -= optind;
	argv += optind;

	if (argc < 1)
		usage();

 if(nprobes) {
  if (nprobes>suggested_nprobes) {
   mvprintw(STAT_ROW,ERR_COL,"nprobes suggested is %d (<%d) which is automatic",suggested_nprobes,nprobes);
  }
 } else nprobes=suggested_nprobes;
 erratax=0;erratay=y-erratayspace;
 sprintf(sfbuf,"%%%lud%%%lud",nprobes,nprobes);
 TSADD(next_refresh,refresh_interval);
 TSADD(next_probe,probe_interval);
 cascadeamt=max_ttl/4;
 ttl=initttl;
 {
  char buf[100]; /* 56 should be enough */
  int xpos;
  sprintf(buf,"probe %g, refresh %g, expire %g",
   (double)probe_interval.tv_sec+(double)probe_interval.tv_nsec/(double)1000000000.0,
   (double)refresh_interval.tv_sec+(double)refresh_interval.tv_nsec/(double)1000000000.0,
   (double)expire_interval.tv_sec+(double)expire_interval.tv_nsec/(double)1000000000.0
  );
  if((xpos=x-strlen(buf)-1)<0)xpos=0;
  mvaddnstr(y-1,xpos,buf,x-xpos-1);
 }

 if(!(alist=calloc(max_ttl*nprobes,sizeof(PROTADDR)))){refresh();endwin();perror("t:malloc");exit(20);}
 memset(alist,0,max_ttl*nprobes*sizeof(PROTADDR));
 if(!(alistp=calloc(max_ttl,sizeof(PROTADDR)))){refresh();endwin();perror("t:malloc");exit(20);}
 memset(alistp,0,max_ttl*sizeof(PROTADDR));
 if(!(alistf=calloc(max_ttl*nprobes,sizeof(unsigned char)))){refresh();endwin();perror("t:malloc");exit(20);}
 memset(alistf,0,max_ttl*nprobes*sizeof(unsigned char));
 if(!(alistpf=calloc(max_ttl,sizeof(unsigned char)))){refresh();endwin();perror("t:malloc");exit(20);}
 memset(alistpf,0,max_ttl*sizeof(unsigned char));

	(void) bzero((char *)&whereto, sizeof(PROTSOCKADDR));

	to->PROTSAMBRFAM = family;
#if (FAMILY == AF_INET6)
	to->PROTSAMBRPORT = htons(port);
#endif

	if (inet_pton(family, *argv, &to->PROTSAMBRADDR))
	{
		hostname = *argv;
	}
	else 
	{
		hp = gethostbyname2(*argv, family);
		if (hp) {
			to->PROTSAMBRFAM = hp->h_addrtype;
			memmove((caddr_t)&to->PROTSAMBRADDR, hp->h_addr,
				hp->h_length);
			hostname = (char *)hp->h_name;
		} else {
			refresh();endwin();
			(void)fprintf(stderr,
			    "traceroute: unknown host %s\n", *argv);
			exit(1);
		}
	}
	if (*++argv)
		datalen = atoi(*argv);

#if (FAMILY == AF_INET6)
	if (datalen < 0 || datalen >= MAXPACKET - sizeof(struct pkt_format)) {
		refresh();endwin();
		Fprintf(stderr,
		    "traceroute: packet size must be 0 <= s < %d.\n",
		    MAXPACKET - sizeof(struct pkt_format));
		exit(1);
	}
#else
	if (datalen < 0 || datalen >= MAXPACKET - sizeof(struct opacket)) {
		refresh();endwin();
		Fprintf(stderr,
		    "traceroute: packet size must be 0 <= s < %d.\n",
		    MAXPACKET - sizeof(struct opacket));
		exit(1);
	}
	datalen += sizeof(struct opacket);
#endif

	ident = getpid();

#if (FAMILY == AF_INET6)
	sendbuff = malloc(datalen);
	if (sendbuff == NULL) {
#else
	outpacket = (struct opacket *)malloc((unsigned)datalen);
	if (! outpacket) {
#endif
		refresh();endwin();
		perror("traceroute: malloc");
		exit(1);
	}

#if (FAMILY == AF_INET)
	(void) bzero((char *)outpacket, datalen);
	outpacket->ip.ip_dst = to->sin_addr;
	outpacket->ip.ip_tos = tos;
	outpacket->ip.ip_v = IPVERSION;
/*	outpacket->ip.ip_id = htons(port);*/

#endif

	if ((pe = getprotobyname(family==AF_INET6?"icmpv6":"icmp")) == NULL) {
		refresh();endwin();
		Fprintf(stderr, "icmp(v6?): unknown protocol\n");
		exit(10);
	}
	if ((s = socket(family, SOCK_RAW, pe->p_proto)) < 0) {
		refresh();endwin();
		perror("traceroute: icmp socket");
		exit(5);
	}
	if (options & SO_DEBUG)
		(void) setsockopt(s, SOL_SOCKET, SO_DEBUG,
				  (char *)&on, sizeof(on));
	if (options & SO_DONTROUTE)
		(void) setsockopt(s, SOL_SOCKET, SO_DONTROUTE,
				  (char *)&on, sizeof(on));

#if (FAMILY == AF_INET)
	if ((sndsock = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) < 0) {
		refresh();endwin();
		perror("traceroute: raw socket");
#else
	if ((sndsock = socket(family, SOCK_DGRAM, 0)) < 0) {
		refresh();endwin();
		perror("traceroute: UDP socket");
#endif
		exit(5);
	}
#ifdef SO_SNDBUF
	if (setsockopt(sndsock, SOL_SOCKET, SO_SNDBUF, (char *)&datalen,
		       sizeof(datalen)) < 0) {
		refresh();endwin();
		perror("traceroute: SO_SNDBUF");
		exit(6);
	}
#endif SO_SNDBUF
#if (FAMILY == AF_INET)
# ifdef IP_HDRINCL
	if (setsockopt(sndsock, IPPROTO_IP, IP_HDRINCL, (char *)&on,
		       sizeof(on)) < 0) {
		perror("traceroute: IP_HDRINCL");
		exit(6);
	}
# endif IP_HDRINCL
#endif

	if (options & SO_DEBUG)
		(void) setsockopt(sndsock, SOL_SOCKET, SO_DEBUG,
				  (char *)&on, sizeof(on));
	if (options & SO_DONTROUTE)
		(void) setsockopt(sndsock, SOL_SOCKET, SO_DONTROUTE,
				  (char *)&on, sizeof(on));

	if (source)
	{
		(void) bzero((char *)&from, sizeof(PROTSOCKADDR));
		from.PROTSAMBRFAM = family;
		if (inet_pton(family, source, &from.PROTSAMBRADDR))
		{
			refresh();endwin();
			Printf("traceroute: unknown addr %s\n", source);
			exit(1);
		}

#if (FAMILY == AF_INET)
		outpacket->ip.ip_src = from.sin_addr;
#endif
#if !defined(IP_HDRINCL) || (FAMILY == AF_INET6)
		if (bind(sndsock, (struct sockaddr *)&from, sizeof(from)) < 0)
		{
			refresh();endwin();
			perror ("traceroute: bind:");
			exit (1);
		}
#endif
	}

	mvprintw(HEAD_ROW,HEAD_COL,"traceroute %s [%s]", hostname,
		inet_ntop(family, &to->PROTSAMBRADDR, pa, 64));

	if (source) printw(" src %s", source);
	if (ttl!=1) printw(", initttl %d", ttl);
	printw(", %d bytes, %d probes, %d maxttl\n",datalen,nprobes,max_ttl);
	clrtoeol();
	mvaddnstr(HEAD_ROW,(x-nprobes*2)-1,
"DNS===============================================================",nprobes);
	mvaddnstr(HEAD_ROW,x-nprobes-1,
"PKTS++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",nprobes);

 while(waitpkt(&treeroot,s,&from));

 if(!zopt) {
  mvprintw(STAT_ROW,STAT_COL,"Press any key to finish"); refresh();
  ungetc(fgetc(stdin),stdin);
  mvprintw(STAT_ROW,STAT_COL,"                       ");
 }

 refresh();endwin();
 exit(0);
} /* main() */

static int keepgoing() {
 return (
  continuous ||
  ((ttlfirst) &&(probe<nprobes)) ||
  ((!ttlfirst)&&(ttl<=max_ttl))
 );
}

static int chkprobe(struct pkt **treeroot) {
 struct timespec ts;

 if(keepgoing()) {
  gettime(&ts);
  if(TSCMP(ts,next_probe)>=0) {
   send_probe(treeroot);
   while(TSCMP(ts,next_probe)>0)	/* only send one at a time since more
					   may ruin the results */
    TSADD(next_probe,probe_interval);
  }
  return 1;
 }
 return 0;
}

static struct pkt *newpkt(struct pkt **treeroot) {
 struct pkt *pkt;
 if(!(pkt=(struct pkt*)malloc(sizeof(struct pkt)))){exit(-2);}
 if(treeroot) {
  pkt->nextpkt=*treeroot;
  if(*treeroot) (*treeroot)->prevpkt=pkt;
  *treeroot=pkt;
 } else pkt->nextpkt=NULL;
 pkt->prevpkt=NULL;
 return pkt;
} /* newpkt() */

static void rmpkt(struct pkt *pkt,struct pkt**treeroot) {
 if(pkt->prevpkt) pkt->prevpkt->nextpkt=pkt->nextpkt;
 if(pkt->nextpkt) pkt->nextpkt->prevpkt=pkt->prevpkt;
 if(*treeroot==pkt) *treeroot=pkt->nextpkt;
 if(pkt->waitflags){
  if(pkt->waitflags&MY_WAIT_HN) blip_n("-");
  if(pkt->waitflags&MY_WAIT_PKT) blip_p("-");
 }
 free(pkt);
} /* rmpkt() */

#ifndef INTERNAL_LOOKUP_NAME
static int lookup_name(struct pkt *pkt, void* a, size_t size, int family) {
 blip_n("?");
 return lookup_name_ext(pkt, a, size, family);
}
#else
static int lookup_name(struct pkt *pkt, void* a, size_t size, int family) {
 pkt->waitflags|=MY_WAIT_HN;
 blip_n("?");
 if(pipe(pkt->fda)){perror("t:pipe()");exit(4);}
 if((pkt->child=Clone(0,SIGCLD|CLONE_FS))) {
  if(pkt->child==-1) {
   refresh();endwin();
   perror("t");
   return -1;
  } else
#ifdef DEBUG
#undef DEBUG2
#ifdef DEBUG2
  {time_t t;time(&t);fprintf(debugfp, "spawned hn lookup packet %08X %s", (unsigned int)pkt,ctime(&t));}
  sleep(1); /*d*/
  memset(debugbuf,'x',4);
  read(pkt->fda[0],debugbuf,4); /*d*/
  {time_t t;time(&t);fprintf(debugfp, "debug read on packet %08X pipe data: %s = \"test\"? %s", (unsigned int)pkt,debugbuf,ctime(&t));}
  memset(debugbuf,'y',4);
  sleep(5);
  read(pkt->fda[0],debugbuf,4); /*d*/
  {time_t t;time(&t);fprintf(debugfp, "debug read #2 on packet %08X pipe data: %s = \"test\"? %s", (unsigned int)pkt,debugbuf,ctime(&t));}
#endif
#endif DEBUG
  return 0;
 } else {
  struct hostent *h;
#ifdef DEBUG
#ifdef DEBUG2
  write(pkt->fda[1],"test",4); /*d*/
#endif
#endif DEBUG
  if((h=gethostbyaddr(a,size,family))) {
   write(pkt->fda[1],h->h_name,strlen(h->h_name)+1); /**/
  } else {
   unsigned char buf[0x100];
   *buf=1; /* Invalid character for hostname */
   sprintf(buf+1,"%d",h_errno);
   write(pkt->fda[1],buf,1+strlen(buf+1)+1); /**/
  }
  close(pkt->fda[1]);
  exit(0);
 }
} /* lookup_name() */
#endif

static void got_there (struct pkt*pkt) {
 ++got_there_f;
 reset_max_ttl(pkt);
}

static void did_not_get_there (struct pkt*pkt){
 ++unreachable;
 reset_max_ttl(pkt);
}

static void reset_max_ttl(struct pkt*pkt) {
 if(max_ttl>(pkt->ttl+1)) {
  max_ttl=pkt->ttl+1;
  mvprintw(y-1,STAT_COL,"maxttl reset to %u",(unsigned int)max_ttl);
  max_ttl_reset++;
  if(!erratax) { /* horrible heuristic to figure out if it's been used yet */
   if(erratay>R_ROW_F(max_ttl+2)) {
    erratay=R_ROW_F(max_ttl+2);
   }
  }
  if(erratay<R_ROW_F(max_ttl+1)) {	/* too small!! */
   erratay=R_ROW_F(max_ttl+2); erratax=0;
  }
/* else {
 wait(reset_grow_time_wait);++max_ttl;printw(max_ttl incremented again);
  
 }
*/
 }
}

/* Do one select. Returns true if anything is left.*/
static int waitpkt(struct pkt **treeroot, int sock, PROTSOCKADDR *from) {
 int cc=0,n=0,i,children=0,outstanding_pkts=0;
 static struct timeval waittv; static struct timespec waitts;
 int fromlen = sizeof (*from);
 struct timespec ts,t2;
 fd_set readfds, writefds, exceptfds;
 struct pkt *pkt;

 gettime(&ts);
 FD_ZERO(&readfds); FD_ZERO(&writefds); FD_ZERO(&exceptfds);
 if(nextdeath && *treeroot) {
  if(TSCMP(ts,nextdeath->death)>=0) {
   pkt=nextdeath;
   nextdeath=pkt->nextdeath;
   if tsisset(pkt->death) rmpkt(pkt,treeroot);
  }
 }
 if(*treeroot) {
  for(children=0,outstanding_pkts=0,n=0,pkt=*treeroot;pkt;pkt=pkt->nextpkt) {
   if(pkt->waitflags) {
    if(pkt->waitflags&MY_WAIT_HN) {
     ++children;
     FD_SET((pkt->fda[0]),&readfds);
     if(pkt->fda[0]>n)n=pkt->fda[0];
    }
    if(pkt->waitflags&MY_WAIT_PKT) {
     ++outstanding_pkts;
    }
   }
  }
  mvprintw(STAT_ROW,(x-nprobes*2)-1,sfbuf,children,outstanding_pkts);
  if(outstanding_pkts) {
   FD_SET(sock, &readfds);
   if(sock>n)n=sock;
  } else
   if(!(
    keepgoing()||children||outstanding_pkts
   )) return 0;
 }
 /*mvprintw(STAT_ROW,0,"%lu",++debugcounter);*/
 if(TSCMP(ts,next_refresh)>=0) {
  refresh();
  while(TSCMP(ts,next_refresh)>0) TSADD(next_refresh,refresh_interval);
 }
 TSCPY(waitts,next_refresh);
 if(chkprobe(treeroot))
  if(TSCMP(waitts,next_probe)>0)
   TSCPY(waitts,next_probe);
 if(nextdeath)
  if(tsisset(nextdeath->death)&&TSCMP(waitts,nextdeath->death)>0)
   TSCPY(waitts,nextdeath->death);
 if(TSCMP(waitts,ts)>0) TSSUB(waitts,ts);
 else waitts.tv_sec=waitts.tv_nsec=0;
 TS2V(waitts,waittv);
 if(-1==select(n+1,&readfds,&writefds,&exceptfds,&waittv)) {
  refresh();endwin();
  perror("traceroute:select()");
  exit(12);
 }
#ifdef DEBUG
 {time_t t;time(&t);fprintf(debugfp, "done with select %s", ctime(&t));}
#endif DEBUG
 if(FD_ISSET(sock,&readfds)) {
#ifdef DEBUG
  {time_t t;time(&t);fprintf(debugfp, "sock set %s", ctime(&t));}
#endif DEBUG
  cc=recvfrom(s, (char *)packet, sizeof(packet), 0, (struct sockaddr *)from, &fromlen);
  gettime(&t2);
 }
 for(pkt=*treeroot;pkt;pkt=pkt->nextpkt) {
  if(pkt->waitflags) {
   if(pkt->waitflags&MY_WAIT_PKT) {
    if(cc) {
     if ((i = packet_ok(packet, cc, from, pkt))) {
      pkt->waitflags^=MY_WAIT_PKT;
      blip_p("+");
      reset_timer = 1;
      print(packet, cc, from, pkt);
      mvprintw(R_ROW_PKT,R_COL_PKT,"%g", deltaT(&pkt->t1, &t2));
      switch(i - 1) {
#if (FAMILY == AF_INET6)
      case ICMPV6_PORT_UNREACH:
#else
      case ICMP_UNREACH_PORT:
       {
        struct ip *ip;
        ip = (struct ip *)packet;
        if (ip->ip_ttl <= 1)
         blip_p("!");
       }
#endif
       got_there(pkt);
       break;
#if (FAMILY == AF_INET6)
      case ICMPV6_NOROUTE:
#else
      case ICMP_UNREACH_NET:
#endif
       did_not_get_there(pkt);
       blip_p("N");
       break;
#if (FAMILY == AF_INET6)
      case ICMPV6_ADDR_UNREACH:
#else
      case ICMP_UNREACH_HOST:
#endif
       did_not_get_there(pkt);
       blip_p("H");
       break;
#if (FAMILY == AF_INET6)
      case ICMPV6_ADM_PROHIBITED:
#else
      case ICMP_UNREACH_SRCFAIL:
#endif
       did_not_get_there(pkt);
       blip_p("S");
       break;
#if (FAMILY == AF_INET)
      case ICMP_UNREACH_PROTOCOL:
       got_there(pkt);
       blip_p("P");
       break;
      case ICMP_UNREACH_NEEDFRAG:
       did_not_get_there(pkt);
       blip_p("F");
       break;
#endif
      }
     } else {
      reset_timer = 0;
     }
     /*if(got_there_f) return 0; *//* || unreachable >= nprobes-1)%% have to do count per hop*/
    }
   }
   if(pkt->waitflags&MY_WAIT_HN) {
#ifdef DEBUG
    {time_t t;time(&t);fprintf(debugfp, "testing packet %08X %s", (unsigned int)pkt,ctime(&t));}
#endif DEBUG
    if(FD_ISSET(pkt->fda[0],&readfds)) {
     int r;
#define MYBUFSIZ (0x100)
     static unsigned char buf[MYBUFSIZ];
#ifdef DEBUG
     {time_t t;time(&t);fprintf(debugfp, "packet %08X has read data, buf=%08X %s", (unsigned int)pkt, (unsigned int)buf,ctime(&t));}
#endif DEBUG
     switch(r=read(pkt->fda[0],buf,BUFSIZ)) {
      case 0:
       refresh();endwin();
       fprintf(stderr,"got EOF reading output from %d without buf!",pkt->child);
       exit(11);
      case -1:
       refresh();endwin();
       perror("t:read()");
       exit(12);
      default:
       close(pkt->fda[0]);
       pkt->waitflags^=MY_WAIT_HN;
       switch(*buf) {
        case 1:
         pkt->hn=NULL;
         pkt->pkt_h_errno=atoi(buf+1);
         mvprintw(R_ROW_PKT,RESERR_COL,"(res.err %d)",pkt->pkt_h_errno);
         blip_n(buf+(strlen(buf+1)));
         break;
        case 2:
        case 3:
         pkt->hn=NULL;
         pkt->pkt_h_errno=0;
         mvaddstr(R_ROW_PKT,ERR_COL,"!DEVELOPMENT DEBUG: other error having to do with development only");clrtoeol();
         blip_n("!");
         break;
        default:
         pkt->hn=(unsigned char*)malloc(sizeof(unsigned char)*r); /**/
         memcpy(pkt->hn,buf,r);
         FD_CLR(pkt->fda[0],&readfds); /* necessary?? */
         if(alistf[pkt->ttl*nprobes+pkt->probe]>1) {
          char tinybuf[2]="@";
          tinybuf[0]=tolower(pkt->erratanum);
          blip_n(tinybuf);
          mvprintw(erratay,erratax,"*%s:%s ",tinybuf,pkt->hn);
          erratax+=strlen(pkt->hn)+4; while(erratax>=x) (++y,erratax-=x);
         } else {
          mvaddnstr(R_ROW_PKT,NAME_COL,
"                                                                   ",(R_COL-NAME_COL)-1);
          mvaddnstr(R_ROW_PKT,NAME_COL,pkt->hn,(R_COL-NAME_COL)-1);
          blip_n("=");
         }
         break;
       }
       break;
     }
    }
   }
  }
 }
 return (keepgoing()||children||outstanding_pkts);
} /* waitpkt() */

static void send_probe(struct pkt ** treeroot)
{
#if (FAMILY == AF_INET6)
	struct pkt_format *netpkt = (struct pkt_format *) sendbuff;
#else
	struct opacket *op = outpacket;
	struct ip *ip = &op->ip;
	struct udphdr *up = &op->udp;
#endif

	int i;
	struct pkt *pkt;

	pkt=newpkt(treeroot);
 	pkt->ttl=ttl; pkt->probe=probe; pkt->seq=++seq; pkt->waitflags=0;
	pkt->erratanum=0;

	gettime(&pkt->t1);
	gettime(&pkt->death);
	TSADD(pkt->death,expire_interval);
	if(lastdeath) {
		lastdeath->nextdeath=pkt;
	}
	lastdeath=pkt; lastdeath->nextdeath=NULL;
	if(!nextdeath) nextdeath=pkt;

#if (FAMILY == AF_INET6)
	netpkt->ident = htonl(ident);
	netpkt->seq = htonl(pkt->seq);
	netpkt->probe = htonl(pkt->probe);
	gettime(&netpkt->ts);
	TSCPY(pkt->sent_ts,netpkt->ts);

	if(0>(i = setsockopt(sndsock, SOL_IPV6, IPV6_UNICAST_HOPS, &pkt->ttl, sizeof(int)))) {
		refresh();endwin();
		perror("traceroute:setsockopt #1");
		exit(1);
	}

	i = sendto(sndsock, sendbuff, datalen, 0,
		   (struct sockaddr *)&whereto, sizeof(PROTSOCKADDR));
#else
	ip->ip_off = 0;
	ip->ip_hl = sizeof(*ip) >> 2;
	ip->ip_p = IPPROTO_UDP;
	ip->ip_len = datalen;
	ip->ip_ttl = ttl;
	ip->ip_v = IPVERSION;
/*	ip->ip_id = htons(ident+seq);*/

	up->source = htons(ident);
/*	up->source = htons(port);*/
	up->dest = htons(port+seq);
/*	up->dest = htons(port);*/
	up->len = htons((u_short)(datalen - sizeof(struct ip)));
	up->check = 0;

	op->seq = htonl(pkt->seq);
	op->ttl = pkt->ttl;
	op->ident = htonl(ident);
	op->probe = htonl(probe);
	gettime(&op->ts);
	TSCPY(pkt->sent_ts,op->ts);

	i = sendto(sndsock, (char *)outpacket, datalen, 0, (struct sockaddr*)&whereto,
		   sizeof(struct sockaddr));
/*#define DEBUG_PKT 1*/
#ifdef DEBUG_PKT
	{
			int i; u_long *lp = (u_long *) op;
			move(6,0);
			for (i = 0; i < datalen ; i += sizeof(long))
				printw("%2x: x%8.8lx ", i, *lp++);
	}
#endif
#endif
	if (i<0) {
		char leetlebuf[2]="!";
		mvprintw(STAT_ROW,STAT_COL,"sendto: %s",strerror(errno));
		leetlebuf[0]='0'+errno%10; /* test this */
		blip_p(leetlebuf);
	} else {
		pkt->waitflags|=MY_WAIT_PKT;
		blip_p("?");
		if(ttlfirst) {
			if(probe==0) {
				label_loop:
#if 1
/* fix logic */
				if((ttl+=cascadeamt)>max_ttl) {
					if(++cascade<=cascadeamt) {
						ttl=initttl+cascade-1;
					}
					else {
						++probe;ttl=backwards?max_ttl:initttl;
					}
				}
#else
				if(--ttl<initttl) {
					++probe;ttl=initttl;
				}
#endif
				/* horrible gaping hole to avoid errata stomping */
				if(ttl==erratay) goto label_loop;
			} else {
				if(backwards)--ttl;else++ttl;
				if(backwards?(ttl<initttl):(ttl>max_ttl)) {
					++probe;ttl=backwards?max_ttl:initttl;
					if(continuous) {
						if (probe>nprobes) probe=0;
					}
				}
			}
		} else {
			if(++probe>=nprobes) {
				++ttl;probe=0;
				if(continuous) {
					if (ttl>max_ttl) ttl=1;
				}
			}
		}
	}

	if (i < 0 || i != datalen)  {
		mvprintw(STAT_ROW,ERR_COL,"traceroute: wrote %s %d chars, ret=%d", hostname, datalen, i);clrtoeol();
	}
}


static double deltaT(struct timespec *t1p, struct timespec *t2p)
{
	register double dt;

	dt = (double)(t2p->tv_sec - t1p->tv_sec) * 1000.0 +
	     (double)((double)(t2p->tv_nsec - t1p->tv_nsec) / (double)1000000.0);
	return (dt);
}


/*
 * Convert an ICMP "type" field to a printable string.
 */
static char * pr_type(unsigned char t)
{
#if (FAMILY == AF_INET6)
	static char *ttab1[] = {
		"Error",
		"Destination Unreachable",
		"Packet Too Big",
		"Time Exceeded in Transit",
		"Parameter Problem"
	};

	static char *ttab2[] = {
		"Echo Reply",
		"Echo Request",
		"Membership Query",
		"Membership Report",
		"Membership Reduction",
	};

	if (t < 5)
	{
		return (ttab1[t]);
	}

	if (t >= 128 && t <= 132)
	{
		return (ttab2[t]);
	}

	return("OUT-OF-RANGE");
#else
	static char *ttab[] = {
	"Echo Reply",	"ICMP 1",	"ICMP 2",	"Dest Unreachable",
	"Source Quench", "Redirect",	"ICMP 6",	"ICMP 7",
	"Echo",		"ICMP 9",	"ICMP 10",	"Time Exceeded",
	"Param Problem", "Timestamp",	"Timestamp Reply", "Info Request",
	"Info Reply"
	};

	if(t > 16)
		return("OUT-OF-RANGE");

	return(ttab[t]);
#endif
}


static int packet_ok(u_char *buf, int cc, PROTSOCKADDR *from, struct pkt *pkt)
{
	ICMPHDR *icp;
	u_char type, code;
	int hlen;
#if (FAMILY == AF_INET)
	struct ip *ip;
#define DEBUG_POK 1
#ifdef DEBUG_POK
	int ccsave;
	
	ccsave=cc;
#endif
	ip = (struct ip *) buf;
	hlen = ip->ip_hl << 2;
	if (cc < hlen + ICMP_MINLEN) {
		if (verbose)
			Printf("packet too short (%d bytes) from %s\n", cc,
				inet_ntoa(from->sin_addr));
		return (0);
	}
	cc -= hlen;
	icp = (struct icmp *)(buf + hlen);
#else
	icp = (ICMPHDR *) buf;
#endif

	type = icp->icmp_type;
	code = icp->icmp_code;

#if (FAMILY == AF_INET6)
	if((type == ICMPV6_TIME_EXCEEDED && code == ICMPV6_EXC_HOPLIMIT) || type == ICMPV6_DEST_UNREACH)
	{
		IPHDR *hip;
		struct udphdr *up;

		hip = (IPHDR *) (icp + 1);
		if (hip->nexthdr == IPPROTO_UDP)
		{
			struct pkt_format *netpkt;
			
			up = (struct udphdr *)(hip+1);
			netpkt = (struct pkt_format *) (up + 1);

			if (ntohl(netpkt->ident) == ident &&
			    ntohl(netpkt->seq) == pkt->seq)
			{
				TSCPY(pkt->t1,netpkt->tv);
				return (type == ICMPV6_TIME_EXCEEDED? -1 : code+1);
			}
		}
	}
	if (verbose) {
		IPHDR *hip;
		unsigned long *lp;
		char pa1[64];
		char pa2[64];
		int i;
		
		hip = (IPHDR *) (icp + 1);
		lp = (unsigned long *) (icp + 1);

		mvprintw(R_ROW_PKT,ERR_COL,"\n%d bytes from %s to %s", cc,
		       inet_ntop(family, &hip->saddr, pa1, 64),
		       inet_ntop(family, &hip->daddr, pa2, 64));
		
		printw(": icmp type %d (%s) code %d\n", type, pr_type(type),
		       icp->code);

		for (i = sizeof(IPHDR); i < cc ; i += sizeof(long))
			printw("%2d: %8.8lx ", i, *lp++);

		clrtoeol();
	}
#else
        if((type == ICMP_TIMXCEED && code == ICMP_TIMXCEED_INTRANS) || type == ICMP_UNREACH) {
		IPHDR *hip;
		struct udphdr *up;
/*		struct opacket *op;*//* unused variable (!)*/

		hip = &icp->icmp_ip;
		hlen = hip->ip_hl << 2;
		up = (struct udphdr *)((u_char *)hip + hlen);
#if 1
#ifdef DEBUG_PKT
		{
			int i; u_long *lp = (u_long *) ip;
			move(11,0);
			for (i = 0; i < ccsave ; i += sizeof(long))
				printw("%2x: %8.8lx ", i, *lp++);
			mvprintw(14,0,"up->source=%x ident=%x; up->dest=%x port+pkt->seq=%x   ",up->source,htons(ident),up->dest,htons(port+pkt->seq));refresh();sleep(1);
		}
#endif
		if (hlen + 12 <= cc && hip->ip_p == IPPROTO_UDP &&
		    up->source == htons(ident) &&
		    up->dest == htons(port+pkt->seq)) {
#else
		op=(struct opacket*) (up+1);
		/*mvprintw(9,0,"debug current ident %lu seq %lu  ",op->ident,op->seq);refresh();*/
#ifdef DEBUG_PKT
		{
			int i; u_long *lp = (u_long *) ip;
			move(11,0);
			for (i = 0; i < ccsave ; i += sizeof(long))
				printw("%2x: %8.8lx ", i, *lp++);
		}
#endif
		if (ntohl(op->ident) == ident &&
		    ntohl(op->seq) == pkt->seq) {
			TSCPY(pkt->t1,op->tv);
#endif
			return (type == ICMP_TIMXCEED? -1 : code+1);
		}
	}
	if (verbose) {
		int i;
		u_long *lp = (u_long *)&icp->icmp_ip;

		mvprintw(4,0,"%d bytes from %s to %s", cc,
			inet_ntoa(from->sin_addr), inet_ntoa(ip->ip_dst));
		printw(": icmp type %d (%s) code %d", type, pr_type(type),
		       icp->icmp_code);
		move(5,0);
		for (i = 4; i < cc ; i += sizeof(long))
			printw("%2d: x%8.8lx ", i, *lp++);
	}
#endif

	return(0);
}


static void print(unsigned char *buf, int cc, PROTSOCKADDR *from,struct pkt *pkt)
{
 char pa[R_COL], tinybuf[2]="@";
 int dolookup=0,plotaddrnorm=0;

 if(alistpf[pkt->ttl]) { /* there is a primary */
  if(memcmp(&alistp[pkt->ttl],&from->PROTSAMBRADDR,sizeof(PROTADDR))) {
   /* and we aren't equal ... we are errata -- look for companions */
   int i, do_errataprint=0;
   for(i=((pkt->ttl)*nprobes);i<(((pkt->ttl)+1)*nprobes);++i) {
    if((alistf[i])&&(!(memcmp(&from->PROTSAMBRADDR,&alist[i],sizeof(PROTADDR))))) {
     /* found companion */
     pkt->erratanum=alistf[i];
     goto print_continue;
    }
   }
   print_continue:
   if(!(pkt->erratanum)) { /* we haven't been printed before.  Do print. */
    pkt->erratanum=++erratanum;
    dolookup=1;
    do_errataprint=1;
   }
   alistf[((pkt->ttl)*nprobes)+(pkt->probe)]=pkt->erratanum;
   tinybuf[0]=pkt->erratanum; blip_n(tinybuf);
   if(do_errataprint) {
    inet_ntop(family, &from->PROTSAMBRADDR,pa,R_COL-1); /*%%*/
    pa[R_COL-1]='\0'; mvprintw(erratay,erratax,"*%s:%s ",tinybuf,pa);
    erratax+=strlen(pa)+4; while(erratax>=x) (++y,erratax-=x);
   }
  } else { /* we match primary; no plotting or lookups necessary */
   alistf[pkt->ttl*nprobes+pkt->probe]=1;
   blip_n("=");
  }
 } else { /* no primaries yet -- we're primary */
  alistpf[pkt->ttl]=1;
  memcpy(&alistp[pkt->ttl],&from->PROTSAMBRADDR,sizeof(PROTADDR));
  alistf[pkt->ttl*nprobes+pkt->probe]=1;
  plotaddrnorm=1;
  dolookup=1;
  blip_n("<");	/* gets overwritten by lookup */
 }
 memcpy(&alist[pkt->ttl*nprobes+pkt->probe],&from->PROTSAMBRADDR,sizeof(PROTADDR));
 if(dolookup&&(!nflag)) lookup_name(pkt, (void*)&from->PROTSAMBRADDR, sizeof(from->PROTSAMBRADDR), family); /**/
 if(plotaddrnorm) mvaddnstr(R_ROW_PKT,ADDR_COL,inet_ntop(family, &from->PROTSAMBRADDR,pa,R_COL-1),(NAME_COL?NAME_COL:R_COL)-1);
}

static void usage(void)
{
	refresh();endwin();
	fprintf(stderr,
"usage: traceroute [-BdcnrvzT] [-y errata_lines] [-Y probe_spacing]\n\t\
[-m max_ttl] [-i initial_ttl] [-q nqueries]\n\t\
[-e expire_interval] [-u refresh_interval] [-w send_interval]\n\t\
[-s src_addr] [-t tos] [-p port#] [-f family (doesn't work)]\n\t\
host [data size]\n\t\
-z is sometimes exit without a keypress (this doesn't work well yet)\n\t\
-n is don't do namelookups\n\t\
-v is verbose\n\t\
-d is debug\n\t\
-r is don't route\n\t\
-b is show both names and numbers\n\t\
-B is backwards\n\t\
-T is probes before ttl\n\t
-c is continuous (use -e & -E too)\n\
(note: timespecs are fractional values to nanoseconds)\n\
");
	exit(1);
}
