#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/wait.h>
#ifndef GLIBC
#include <linux/sched.h>
#include <linux/unistd.h>
#endif GLIBC
#include <unistd.h>
#include <signal.h>
#include <netdb.h>
#include <sys/time.h>
#include <curses.h>

#include <sys/param.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <sys/ioctl.h>

#ifdef __linux__
#include <endian.h>
#endif

#ifndef GLIBC
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>

#ifdef __linux__
#include <bsd/netinet/ip_icmp.h>
#include <linux/in6.h>
#include <linux/ipv6.h>
#include <linux/icmpv6.h>
#else
#include <netinet/ip_icmp.h>
#endif

#include <netinet/udp.h>

#include <arpa/inet.h>
#endif GLIBC

#include <netdb.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#ifdef GLIBC
#include "defines.h"
#endif GLIBC

#define	Fprintf (void)fprintf
#define Sprintf (void)sprintf
#define Printf (void)printf

#ifdef __linux__
# define USE_LINUX_CLONE 1
#else
# define USE_FORK 1
#endif
#if USE_LINUX_CLONE
#if 1
 _syscall2(pid_t,clone,void*,sp,unsigned long,flags);
 pid_t clone(void *,unsigned long);
#define CClone(x,y) clone(x,y)
#else
extern int clone __P ((int (*__fn) (void *__arg), void *__child_stack,
                       int __flags, void *__arg));
#define CClone(x,y) clone(NULL,x,y,NULL)
#endif
# define Clone(x,y) CClone(x,y)
#elif USE_FORK
# define Clone(x,y) fork()
#endif

extern int errno, h_errno;

struct pkt {
 u_char ttl;
 unsigned long probe, seq;
 struct timespec t1, sent_ts;

 unsigned char waitflags;
 int fda[2];
 char *hn;
 int pkt_h_errno;
 pid_t child;
 unsigned char erratanum;
 struct timespec death;
 struct pkt *prevpkt,*nextpkt,*nextdeath;
};

#define MY_WAIT_HN  (0x1)

int lookup_name_ext(struct pkt *pkt, void* a, size_t size, int family) {
 pkt->waitflags|=MY_WAIT_HN;
 if(pipe(pkt->fda)){perror("t:pipe()");exit(4);}
 if((pkt->child=Clone(0,SIGCLD|CLONE_FS))) {
  if(pkt->child==-1) {
   refresh();endwin();
   perror("t");
   return -1;
  } else
  return 0;
 } else {
  struct hostent *h;
  if((h=gethostbyaddr(a,size,family))) {
   write(pkt->fda[1],h->h_name,strlen(h->h_name)+1); /**/
  } else {
   unsigned char buf[0x100];
   *buf=1; /* Invalid character for hostname */
   sprintf(buf+1,"%d",h_errno);
   write(pkt->fda[1],buf,1+strlen(buf+1)+1); /**/
  }
  close(pkt->fda[1]);
  exit(0);
 }
} /* lookup_name() */
