/* IPVERSION: */
#define	IPVERSION	4               /* IP version number */ /* /usr/include/netinet/ip.h */
/* IPPROTO_RAW: */
#define   IPPROTO_RAW  255		/* Raw IP packets			*/ /* /usr/include/linux/in.h */
/* CLONE_FS: */
#define	CLONE_FS      0x00000200  /* Set if fs info shared between processes.*/ /* /usr/include/schedbits.h */
/* ICMP_UNREACH_PORT: */
#define	ICMP_UNREACH_PORT	        3	/* bad port */ /* /usr/include/netinet/ip_icmp.h */
/* ICMP_UNREACH_NET: */
#define	ICMP_UNREACH_NET	        0	/* bad net */ /* /usr/include/netinet/ip_icmp.h */
/* ICMP_UNREACH_HOST: */
#define	ICMP_UNREACH_HOST	        1	/* bad host */ /* /usr/include/netinet/ip_icmp.h */
/* ICMP_UNREACH_SRCFAIL: */
#define	ICMP_UNREACH_SRCFAIL	        5	/* src route failed */ /* /usr/include/netinet/ip_icmp.h */
/* ICMP_UNREACH_PROTOCOL: */
#define	ICMP_UNREACH_PROTOCOL	        2	/* bad protocol */ /* /usr/include/netinet/ip_icmp.h */
/* ICMP_UNREACH_NEEDFRAG: */
    /* ICMP_UNREACH_NEEDFRAG -- Path MTU Discovery (RFC1191) */ /* /usr/include/netinet/ip_icmp.h */
#define	ICMP_UNREACH_NEEDFRAG	        4	/* IP_DF caused drop */ /* /usr/include/netinet/ip_icmp.h */
/* IPPROTO_UDP: */
#define  IPPROTO_UDP  17		/* User Datagram Protocol		*/ /* /usr/include/linux/in.h */
/* IPVERSION: */
#define	IPVERSION	4               /* IP version number */ /* /usr/include/netinet/ip.h */
/* ICMP_MINLEN: */
#define	ICMP_MINLEN	8				/* abs minimum */ /* /usr/include/netinet/ip_icmp.h */
/* ICMP_TIMXCEED: */
#define	ICMP_TIMXCEED		11		/* time exceeded, code: */ /* /usr/include/netinet/ip_icmp.h */
/* ICMP_TIMXCEED_INTRANS: */
#define	ICMP_TIMXCEED_INTRANS	0		/* ttl==0 in transit */ /* /usr/include/netinet/ip_icmp.h */
/* ICMP_UNREACH: */
#define	ICMP_UNREACH		3		/* dest unreachable, codes: */ /* /usr/include/netinet/ip_icmp.h */
/* IPPROTO_UDP: */
#define  IPPROTO_UDP  17		/* User Datagram Protocol		*/ /* /usr/include/linux/in.h */

typedef unsigned int __u32;


/* Internet address. */
struct in_addr {
        __u32   s_addr;
};


#define __SOCK_SIZE__   16              /* sizeof(struct sockaddr)      */
struct sockaddr_in {
  short int             sin_family;     /* Address family               */
  unsigned short int    sin_port;       /* Port number                  */
  struct in_addr        sin_addr;       /* Internet address             */

  /* Pad to size of `struct sockaddr'. */
  unsigned char         __pad[__SOCK_SIZE__ - sizeof(short int) -
                        sizeof(unsigned short int) - sizeof(struct in_addr)];
};
#define sin_zero        __pad           /* for BSD UNIX comp. -FvK      */

/*
 * Structure of an internet header, naked of options.
 */
struct ip
  {
#if __BYTE_ORDER == __LITTLE_ENDIAN
    u_int8_t ip_hl:4;                   /* header length */
    u_int8_t ip_v:4;                    /* version */
#endif
#if __BYTE_ORDER == __BIG_ENDIAN
    u_int8_t ip_v:4;                    /* version */
    u_int8_t ip_hl:4;                   /* header length */
#endif
    u_int8_t ip_tos;                    /* type of service */
    u_short ip_len;                     /* total length */
    u_short ip_id;                      /* identification */
    u_short ip_off;                     /* fragment offset field */
#define IP_RF 0x8000                    /* reserved fragment flag */
#define IP_DF 0x4000                    /* dont fragment flag */
#define IP_MF 0x2000                    /* more fragments flag */
#define IP_OFFMASK 0x1fff               /* mask for fragmenting bits */
    u_int8_t ip_ttl;                    /* time to live */
    u_int8_t ip_p;                      /* protocol */
    u_short ip_sum;                     /* checksum */
    struct in_addr ip_src, ip_dst;      /* source and dest address */
  };
struct udphdr {
  u_int16_t     source;
  u_int16_t     dest;
  u_int16_t     len;
  u_int16_t     check;
};


struct icmp_ra_addr
{
  u_int32_t ira_addr;
  u_int32_t ira_preference;
};

struct icmp
{
  u_int8_t  icmp_type;  /* type of message, see below */
  u_int8_t  icmp_code;  /* type sub code */
  u_int16_t icmp_cksum; /* ones complement checksum of struct */
  union
  {
    u_char ih_pptr;             /* ICMP_PARAMPROB */
    struct in_addr ih_gwaddr;   /* gateway address */
    struct ih_idseq             /* echo datagram */
    {
      u_int16_t icd_id;
      u_int16_t icd_seq;
    } ih_idseq;
    u_int32_t ih_void;

    /* ICMP_UNREACH_NEEDFRAG -- Path MTU Discovery (RFC1191) */
    struct ih_pmtu
    {
      u_int16_t ipm_void;
      u_int16_t ipm_nextmtu;
    } ih_pmtu;

    struct ih_rtradv
    {
      u_int8_t irt_num_addrs;
      u_int8_t irt_wpa;
      u_int16_t irt_lifetime;
    } ih_rtradv;
  } icmp_hun;
#define icmp_pptr       icmp_hun.ih_pptr
#define icmp_gwaddr     icmp_hun.ih_gwaddr
#define icmp_id         icmp_hun.ih_idseq.icd_id
#define icmp_seq        icmp_hun.ih_idseq.icd_seq
#define icmp_void       icmp_hun.ih_void
#define icmp_pmvoid     icmp_hun.ih_pmtu.ipm_void
#define icmp_nextmtu    icmp_hun.ih_pmtu.ipm_nextmtu
#define icmp_num_addrs  icmp_hun.ih_rtradv.irt_num_addrs
#define icmp_wpa        icmp_hun.ih_rtradv.irt_wpa
#define icmp_lifetime   icmp_hun.ih_rtradv.irt_lifetime
  union
  {
    struct
    {
      u_int32_t its_otime;
      u_int32_t its_rtime;
      u_int32_t its_ttime;
    } id_ts;
    struct
    {
      struct ip idi_ip;
      /* options and then 64 bits of data */
    } id_ip;
    struct icmp_ra_addr id_radv;
    u_int32_t   id_mask;
    u_int8_t    id_data[1];
  } icmp_dun;
#define icmp_otime      icmp_dun.id_ts.its_otime
#define icmp_rtime      icmp_dun.id_ts.its_rtime
#define icmp_ttime      icmp_dun.id_ts.its_ttime
#define icmp_ip         icmp_dun.id_ip.idi_ip
#define icmp_radv       icmp_dun.id_radv
#define icmp_mask       icmp_dun.id_mask
#define icmp_data       icmp_dun.id_data
};

#define __NR_clone              120

#define _syscall2(type,name,type1,arg1,type2,arg2) \
type name(type1 arg1,type2 arg2) \
{ \
long __res; \
__asm__ volatile ("int $0x80" \
        : "=a" (__res) \
        : "0" (__NR_##name),"b" ((long)(arg1)),"c" ((long)(arg2))); \
if (__res >= 0) \
        return (type) __res; \
errno = -__res; \
return -1; \
}

extern int inet_pton __P ((int __af, __const char *__cp, void *__buf));
extern __const char *inet_ntop __P ((int __af, __const void *__cp,
                                    char *__buf, size_t __len));

#include <asm/byteorder.h>
extern char *inet_ntoa __P ((struct in_addr __in));
