/*
 *	V7/BSD HACKERS:  SEE NOTES UNDER mode(2) !!!
 *
 *   This file is #included so the main file can set parameters such as HOWMANY.
 *   See the main files (rz.c/sz.c) for compile instructions.
 */

STATIC char *Copyr = "Copyright 1993 Omen Technology Inc All Rights Reserved";

#ifdef V7
#include <sys/types.h>
#include <sys/stat.h>
#define STAT
#include <sgtty.h>
#define OS "V7/BSD"
#ifdef LLITOUT
STATIC long Locmode;		/* Saved "local mode" for 4.x BSD "new driver" */
STATIC long Locbit = LLITOUT;	/* Bit SUPPOSED to disable output translations */
#include <strings.h>
#endif
#endif

#ifdef USG
#include <sys/types.h>
#include <sys/stat.h>
#define STAT
#include <termio.h>
#define OS "SYS III/V"
#define MODE2OK
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#endif

#ifdef POSIX
#define USG
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#define STAT
#include <termios.h>
#define OS "POSIX"
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#ifndef READCHECK
#ifndef FIONREAD
#define SV
#endif
#endif
#endif


#ifdef T6K
#include <sys/ioctl.h>		/* JPRadley: for the Tandy 6000 */
#endif

#include <setjmp.h>

#if HOWMANY  > 255
Howmany must be 255 or less
#endif

 /*
 *  Some systems (Venix, Coherent, Regulus) may not support tty raw mode
 *  read(2) the same way as Unix. ONEREAD must be defined to force one
 *  character reads for these systems. Added 7-01-84 CAF
 */

#define sendline(c) net_putchar(c & 0377)
#define xsendline(c) net_putchar(c)

STATIC char linbuf[HOWMANY];
STATIC int Lleft=0;		/* number of characters in linbuf */
STATIC jmp_buf tohere;		/* For the interrupt on RX timeout */
#ifdef ONEREAD
/* Sorry, Regulus and some others don't work right in raw mode! */
STATIC int Readnum = 1;	/* Number of bytes to ask for in read() from modem */
#else
STATIC int Readnum = HOWMANY; /* Number of bytes to ask for in read() from modem */
#endif
STATIC int Verbose;


STATIC int Twostop;		/* Use two stop bits */

/*PMS*/
STATIC zmputs(char *s);

/*
 *  The following uses an external rdchk() routine if available,
 *  otherwise defines the function for BSD or fakes it for SYSV.
 */

#ifndef READCHECK
#ifdef FIONREAD
#define READCHECK
/*
 *  Return non 0 iff something to read 
 */
#define rdchk() net_rdchk()
#else		/* FIONREAD */
#endif
#endif

STATIC struct {
	unsigned baudr;
	int speedcode;
} speeds[] = {
	110,	B110,
#ifdef B150
	150,	B150,
#endif
	300,	B300,
	600,	B600,
	1200,	B1200,
	2400,	B2400,
	4800,	B4800,
	9600,	B9600,
#ifdef B19200
	19200,	B19200,
#endif
#ifdef EXTA
	19200,	EXTA,
#endif
#ifdef B38400
	38400,	B38400,
#endif
#ifdef EXTB
	38400,	EXTB,
#endif
	0,	0
};
STATIC unsigned
getspeed(code)
{
	register n;

	for (n=0; speeds[n].baudr; ++n)
		if (speeds[n].speedcode == code)
			return speeds[n].baudr;
	if (code > 49)
		return ((unsigned)code);
	return 1;	/* Assume fifo if ioctl failed */
}




#ifdef ICANON
#ifdef POSIX
STATIC struct termios oldtty, tty;
#else
STATIC struct termio oldtty, tty;
#endif
#else
STATIC struct sgttyb oldtty, tty;
STATIC struct tchars oldtch, tch;
#endif

STATIC sendbrk()
{
	sleep(1);
	net_sendbrk();
	sleep(1);
	net_sendbrk();
	net_flush();
}

/* Initialize tty device for serial file xfer */
STATIC inittty() { }

#define flushmoc() net_flush()

#define flushmo()  net_flush()

/*
 * This version of readline is reasoably well suited for
 * reading many characters.
 *
 * timeout is in tenths of seconds
 */
STATIC void alrm(c) 
{
 longjmp(tohere, -1);
}

STATIC readline(timeout)
int timeout;
{
	register n;
	static char *cdq;	/* pointer for removing chars from linbuf */

	if (--Lleft >= 0) {
		if (Verbose > 8) {   
			fprintf(stderr, "%02x ", *cdq&0377);
		} 
		return (*cdq++ & 0377);
	}
	n = timeout/10;
	if (n < 2)
		n = 2;
	if (Verbose > 5) 
               fprintf(stderr, "Calling read: alarm=%d  Readnum=%d ",
		  n, Readnum);
	if (setjmp(tohere)) {
		Lleft = 0;
		if (Verbose>1) 
			fprintf(stderr, "Readline:TIMEOUT\n");
		return TIMEOUT;
	}
	signal(SIGALRM, alrm); alarm(n);
	errno = 0;
	for(;;)
	 { Lleft=net_read(cdq=linbuf, Readnum);
	   if(Lleft!=0) break; 
	  }
	alarm(0);
	if (Verbose > 5) 
         { fprintf(stderr, "Read returned %d bytes errno=%d\n",
		  Lleft, errno);
	}
	if (Lleft < 1)
		return TIMEOUT;
	if (Verbose > 8) { 
		for (n = Lleft; --n >= 0; ) {
			fprintf(stderr, "%02x ", *cdq&0377);
		}
		fprintf(stderr, "\n");
	}
	--Lleft;
	return (*cdq++ & 0377);
}



/*
 * Purge the modem input queue of all characters
 */
STATIC purgeline()
{
	Lleft = 0;
	net_flush();
}


/* send cancel string to get the other end to shut up */
STATIC canit()
{
	static char canistr[] = {
	 24,24,24,24,24,24,24,24,24,24,8,8,8,8,8,8,8,8,8,8,0
	};

	zmputs(canistr);
	Lleft=0;	/* Do read next time ... */
}

/*
 * Send a string to the modem, processing for \336 (sleep 1 sec)
 *   and \335 (break signal)
 */
STATIC zmputs(s)
char *s;
{
	register c;

	while (*s) {
		switch (c = *s++) {
		case '\336':
			sleep(1); continue;
		case '\335':
			sendbrk(); continue;
		default:
			sendline(c);
		}
	}
	flushmo();
}


/* VARARGS1 */
STATIC vfile(f, a, b, c, d)
char *f;
long a, b, c, d;
{
	if (Verbose > 2) {
		fprintf(stderr, f, a, b, c, d);
		fprintf(stderr, "\n");
	}
}

STATIC init_rbsb()
{
   int i;
#ifdef LLITOUT
   Locmode = 0;
   Locbit = LLITOUT;
#endif
   Lleft = 0;
#ifdef ONEREAD
   Readnum = 1;	
#else
   Readnum = HOWMANY;	
#endif
   Verbose = 0;
   Twostop = 0;
 }
/* End of rbsb.c */
