
/*

    File: smtp/smtp.h
    
    Copyright (C) 1999 by Wolfgang Zekoll <wzk@quietsche-entchen.de>

    This source is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This source is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _SMTP_INCLUDED
#define	_SMTP_INCLUDED


#define	VERSION		"1.1.0"

#define	SENDMAIL	"/usr/sbin/sendmail"
#define	SMTP_TIMEOUT	300
#define	SMTP_ACCEPTTIME	600



extern char *program;
extern char progname[80];
extern int debug;


#define	WAITING		1
#define	MAIL_SEEN	2
#define	RCPT_SEEN	3
#define	DATA_SEEN	4
#define	SEND_QUIT	5
#define	NO_SENDMAIL	6



typedef struct _config {
    char	hostname[200];

    int		etrn;
    int		droppath;
    int		timeout;

    char	*senderlist;
    char	*rcptlist;

    char	server[200];
    char	**argv;

    char	clientdir[200];
    int		accepttime;
    } config_t;


typedef struct _smtp {
    config_t	*config;

    char	hostname[200];
    FILE	*sin, *sout;
    
    char	ipnum[100];
    char	client[300];

    int		helloseen;
    int		state;
    int		mailcount;


	/*
	 * Mail-spezifische Daten
	 */

    char	sender[300];
    int		nrcpt;

    char	jobid[80];
    char	msgid[200];
    long	size;
    } smtp_t;


extern int proxy_request(config_t *config);


#endif

