
/*

    File: smtp/main.c
    
    Copyright (C) 1999 by Wolfgang Zekoll <wzk@quietsche-entchen.de>

    This source is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This source is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/fcntl.h>
#include <sys/socket.h>
#include <signal.h>
#include <netdb.h>
#include <netinet/in.h>
#include <syslog.h>
#include <sys/time.h>

#include "smtp.h"
#include "ip-lib.h"
#include "lib.h"


char	*program =		"";
char	progname[80] =		"";

char	configfile[300] =	"";

int	debug =			0;
int	etrn =			0;


void missing_arg(int c, char *string)
{
	fprintf (stderr, "%s: missing arg: -%c, %s\n", program, c, string);
	exit (-1);
}

int main(int argc, char *argv[])
{
	int	c, i, k;
	char	*p, option[80];
	config_t config;
	

	if ((p = strrchr(argv[0], '/')) == NULL)
		program = argv[0];
	else {
		copy_string(progname, &p[1], sizeof(progname));
		program = progname;
		}

	memset(&config, 0, sizeof(config_t));
	config.timeout    = SMTP_TIMEOUT;
	config.accepttime = SMTP_ACCEPTTIME;
	openlog(program, LOG_PID, LOG_MAIL);

	k = 1;
	while (k < argc  &&  argv[k][0] == '-'  &&  argv[k][1] != 0) {
		copy_string(option, argv[k++], sizeof(option));
		for (i=1; (c = option[i]) != 0; i++) {
			if (c == 'd')
				debug = 1;
			else if (c == 'e')
				config.etrn = 1;
			else if (c == 'l') {
				if (k >= argc)
					missing_arg(c, "client log directory");

				copy_string(config.clientdir, argv[k++], sizeof(config.clientdir));
				}
			else if (c == 'q') {
				if (config.droppath == 0)
					config.droppath = 1;
				else
					config.droppath = 2;
				}
			else if (c == 'r') {
				if (k >= argc)
					missing_arg(c, "domain list");

				config.rcptlist = allocate(strlen(argv[k]) + 10);
				strcpy(config.rcptlist, argv[k++]);
				}
			else if (c == 's') {
				if (k >= argc)
					missing_arg(c, "domain list");

				config.senderlist = allocate(strlen(argv[k]) + 10);
				strcpy(config.senderlist, argv[k++]);
				}
			else if (c == 't') {
				if (k >= argc)
					missing_arg(c, "timeout");

				config.timeout = atoi(argv[k++]);
				if (config.timeout < 1)
					config.timeout = 60;
				}
			else {
				if (isatty(2))
					fprintf (stderr, "%s: unknown option: -%c\n", program, c);

				exit (-1);
				}
			}
		}


	if (k >= argc) {
		static char *sendmailargv[] = { SENDMAIL, "-bs", NULL };

		config.argv = sendmailargv;
		}
	else {
		if (*argv[k] == '/')
			config.argv = &argv[k];
		else {
			copy_string(config.server, argv[k++], sizeof(config.server));
			if (k < argc) {
				if (isatty(2))
					fprintf (stderr, "%s: unexpected extra arguments\n", program);

				exit (1);
				}
			}
		}


	proxy_request(&config);
	close(0);

	exit (0);
}


