
/*

    File: smtp/ip-lib.c
    Version 1.0
    
    Copyright (C) 1999 by Wolfgang Zekoll <wzk@quietsche-entchen.de>

    This source is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This source is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <signal.h>

#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>

#include "lib.h"
#include "ip-lib.h"


int	ip_lib_error =		0;

struct {
    int		code;
    char	msg[40];
    } _error[] = {
    0,	"unknown error",
    1,	"socket allocation error",
    2,	"nameserver lookup error",
    3,	"connection refused",
    4,	"fdopen() failed",
    5,	"setvbuf() failed",
    6,	"timeout reached",
    0,	""
    };
    
char *get_error(int code)
{
	int	i;

	for (i=0; _error[i].msg[0] != 0; i++) {
		if (_error[i].code == code)
			return (_error[i].msg);
		}

	return (_error[i].msg);
}

static void alarm_handler()
{
/*	fprintf (stderr, "TIMEOUT\n"); */
/*	exit (-2); */
	return;
}


FILE *ip_open(char *host, unsigned int port)
{
	int	socketd;
	struct sockaddr_in server;
	struct hostent *hostp, *gethostbyname();
	FILE	*fp;

	socketd = socket(AF_INET, SOCK_STREAM, 0);
	if (socketd < 0) {
		ip_lib_error = 1;
		return (NULL);
		}
  
	server.sin_family = AF_INET;
	hostp = gethostbyname(host);
	if (hostp == NULL) {
		ip_lib_error = 2;
		return (NULL);
		}
  
	memcpy(&server.sin_addr, hostp->h_addr, hostp->h_length);
	server.sin_port = htons(port);

	signal(SIGALRM, alarm_handler);
	alarm(10);
	if (connect(socketd, (struct sockaddr *) &server, sizeof(server)) < 0) {
		ip_lib_error = 3;
		if (errno == EINTR)
			ip_lib_error = 6;
			
		return (NULL);
		}

	alarm(0);
	signal(SIGALRM, SIG_DFL);
	
	if ((fp = fdopen(socketd, "w+")) == NULL) {
		ip_lib_error = 4;
		return (NULL);
		}

 	return (fp);
}	


unsigned int get_port(char *server, unsigned int def_port)
{
	unsigned int port;
	char	*p;

	if ((p = strchr(server, ':')) == NULL)
		return (def_port);

	*p++ = 0;
	port = atol(p);

	return (port);
}

int get_client_info(int pfd, char *ipnum, char *name)
{
	int	size;
	struct sockaddr_in saddr;
	struct in_addr *addr;
	struct hostent *hostp = NULL;

	*ipnum = 0;
	*name  = 0;

	size = sizeof(saddr);
	if (getpeername(pfd, (struct sockaddr *) &saddr, &size) < 0 ) {
		if (isatty(pfd) == 0) {
			strcpy(ipnum, "127.0.0.2");
			strcpy(name, "local.host");
			}

		strcpy(ipnum, "127.0.0.1");
		strcpy(name, "local.host");

		return (0);
		}		
		
	copy_string(ipnum, (char *) inet_ntoa(saddr.sin_addr), 80);
	addr = &saddr.sin_addr,
	hostp = gethostbyaddr((char *) addr,
			sizeof (saddr.sin_addr.s_addr), AF_INET);

	if (hostp == NULL)
		copy_string(name, ipnum, 200);
	else {
		copy_string(name, hostp->h_name, 200);
		strlwr(name);
		}

	return (0);
}

