#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/wait.h>
#include <stdio.h>

#define NDEBUG

int saveRealUid, saveEffUid, saveRealGid, saveEffGid, pid, killTimeOut;

void killIt()
{
  int termPid, status;
  
  sleep(killTimeOut);
  termPid = waitpid(pid, &status, WNOHANG);
  if (termPid < 0 || termPid == pid)
    exit(status);
  else
  {
    setreuid(saveEffUid, saveEffUid);
    setregid(saveEffGid, saveEffGid);
    kill(-pid, SIGKILL);
    setreuid(saveRealUid, saveEffUid);
    setregid(saveRealGid, saveEffGid);
#ifndef NDEBUG
    printf("delivering kill signal\n");
#endif
  }
}

void sigintHandler(int sig)
{
  signal(SIGINT, sigintHandler);
  setreuid(saveEffUid, saveEffUid);
  setregid(saveEffGid, saveEffGid);

  kill(-pid, SIGINT);
#ifndef NDEBUG
  printf("delivering int signal\n");
#endif
  setreuid(saveRealUid, saveEffUid);
  setregid(saveRealGid, saveEffGid);

  killIt();
}

void sigtermHandler(int sig)
{
  signal(SIGTERM, sigtermHandler);
  setreuid(saveEffUid, saveEffUid);
  setregid(saveEffGid, saveEffGid);

  kill(-pid, SIGTERM);
#ifndef NDEBUG
  printf("delivering term signal\n");
#endif
  setreuid(saveRealUid, saveEffUid);
  setregid(saveRealGid, saveEffGid);

  killIt();
}

void sigchildHandler(int sig)
{
  int termPid, status;
  signal(SIGCHLD, sigchildHandler);
  
#ifndef NDEBUG
  printf("chld signal\n");
#endif
  termPid = waitpid(pid, &status, WNOHANG);
  if (termPid < 0 || termPid == pid)
    exit(status);
}

int main(int argc, char *argv[])
{
  char fdBuf[100];
  char *pppdFd, *killTimeOutS;
  char *environ[] = {"LD_PRELOAD=/usr/X11R6/lib/xppp_syslog.so",
                     (char*)0, (char*)0};
  saveRealUid = getuid();
  saveEffUid = geteuid();
  saveRealGid = getgid();
  saveEffGid = getgid();
  
  /* build environment */
  pppdFd = getenv("PPPD_LOG_FD");
  if (pppdFd != (char*)0 && strlen(pppdFd) < 90)
  {
    sprintf(fdBuf, "PPPD_LOG_FD=%s", pppdFd);
    environ[1] = fdBuf;
  }

  /* get kill timeout */
  killTimeOutS = getenv("KILL_TIMEOUT");
  if (killTimeOutS == (char*)0)
    killTimeOut = 2;
  else
    if (sscanf(killTimeOutS, "%d", &killTimeOut) != 1)
      killTimeOut = 2;
    else if (killTimeOut < 1 || killTimeOut > 100)
      killTimeOut = 2;
  
  
  /* fork the process */
  switch (pid = fork())
  {
  case 0:                     /* child */
  {
    setreuid(saveEffUid, saveEffUid);
    setregid(saveEffGid, saveEffGid);
    setpgrp();
    execve("/usr/sbin/pppd", argv, environ);
    break;
  }
  case -1:                    /* error occurred */
    fprintf(stderr, "xppp_wrapper: could not fork\n");
    return 2;
  }

  /* parent */
  setreuid(saveRealUid, saveEffUid);
  setregid(saveRealGid, saveEffGid);
  signal(SIGINT, sigintHandler);
  signal(SIGTERM, sigtermHandler);
  signal(SIGCHLD, sigchildHandler);

  /* wait for signals */
  while (1) pause();
}
