#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

#define	LOG_EMERG	0	/* system is unusable */
#define	LOG_ALERT	1	/* action must be taken immediately */
#define	LOG_CRIT	2	/* critical conditions */
#define	LOG_ERR		3	/* error conditions */
#define	LOG_WARNING	4	/* warning conditions */
#define	LOG_NOTICE	5	/* normal but significant condition */
#define	LOG_INFO	6	/* informational */
#define	LOG_DEBUG	7	/* debug-level messages */

typedef char *char_p;

static FILE* logfile;
static char *progname;

void openlog( char *ident, int option, int  facility)
{
  int log_fd;

  char *s_log_fd;

  s_log_fd = getenv("PPPD_LOG_FD");
  
  if (s_log_fd != (char*)0 &&
      sscanf(s_log_fd, "%d", &log_fd) == 1 &&
      log_fd > 0)
    logfile = fdopen(log_fd, "w");
  else
    logfile = stderr;
  
  progname = strdup(ident);
}

static void put_escaped(char ch, FILE *f)
{
  if (ch < ' ')
  {
    fputc('^', logfile);
    fputc('@' + ch, logfile);
  }
  else
    fputc(ch, logfile);
}

void syslog( int priority, char *format, ...)
{
  va_list ap;
  char *fp, *pp;
  char *s;
  int i;
  char ch;

  switch (priority)
  {
  case LOG_ALERT:
    fprintf(logfile, "%s (alert): ", progname);
    break;
  case LOG_CRIT:
    fprintf(logfile, "%s (crit): ", progname);
    break;
  case LOG_DEBUG:
    fprintf(logfile, "%s (debug): ", progname);
    break;
  case LOG_EMERG:
    fprintf(logfile, "%s (emerg): ", progname);
    break;
  case LOG_ERR:
    fprintf(logfile, "%s (err): ", progname);
    break;
  case LOG_INFO:
    fprintf(logfile, "%s (info): ", progname);
    break;
  case LOG_NOTICE:
    fprintf(logfile, "%s (notice): ", progname);
    break;
  case LOG_WARNING:
    fprintf(logfile, "%s (warning): ", progname);
    break;
  }

  va_start(ap, format);
  fp = format;
  while (*fp)
  {
    if (*fp == '%')
    {
      fp++;
      switch (*fp)
      {
      case 'd':
        i = (int)va_arg(ap, int);
        fprintf(logfile, "%d", i);
        fp++;
        break;

      case 's':
        s = (char*)va_arg(ap, char_p);
        for (pp = s; *pp; pp++) put_escaped(*pp, logfile);
        fp++;
        break;

      case 'c':
        ch = va_arg(ap, char);
        fprintf(logfile, "%c", ch);
        fp++;
        break;

      case 'm':
        if (errno != -1)
          fprintf(logfile, "%s", sys_errlist[errno]);
        fp++;
        break;
        
      default:
        if (*fp)
          fprintf(logfile, "<%c>", *fp++);
        break;
      }
    }
    else
      put_escaped(*fp++, logfile);
  }

  fputc('\n', logfile);
  fflush(logfile);
  
  va_end(ap);
}

void closelog( void )
{
  /* do nothing */
}
