/* XPPP
 *
 * File:      xppp_config_dialog.h
 * Purpose:   Configuration Dialog
 * Author:    Peter Hofmann (970522)
 *
 */

#ifndef XPPP_CONFIG_DIALOG_H
#define XPPP_CONFIG_DIALOG_H

#define String XString
#include <wx.h>
#undef String

#include "xppp_config.h"

// *** XPPP Configuration dialog

class XpppConfigDialog : public wxDialogBox
{
public:
  // status vars
  ConfigData::iterator _currentIsp; // current ISP
  bool _changed;                // true if some parameter was changed
  
  // gui vars
  wxListBox *_ispListBox;
  wxText *_ispText;
  wxMultiText *_numberText;
  wxMultiText *_chatScript;
  wxMultiText *_pppdOptions;
  wxMultiText *_checkScript;
  wxText *_maxTries;
  wxText *_timeOut;
  
  // redisplay all isp data
  void redisplayAll();
  // redisplay current isp data
  void redisplay();
  
  XpppConfigDialog(wxFrame *parent);
  void OnSize(int, int);
  Bool OnClose(void);
};

#endif // XPPP_CONFIG_DIALOG_H
