/* XPPP
 *
 * File:      xppp_config_dialog.h
 * Purpose:   Configuration Dialog
 * Author:    Peter Hofmann (970522)
 *
 */

#include "xppp_config_dialog.h"
#include "xppp.h"

#include <ctype.h>

// callbacks

static void ispSelection(wxListBox& listBox, wxCommandEvent& event)
{
  if (event.IsSelection())
  {
    XpppConfigDialog *configDialog =
      ((XpppConfigDialog*)listBox.GetParent()->GetParent());
    configDialog->_currentIsp =
      (ConfigData::iterator)event.GetClientData();
    configDialog->redisplay();
  }
}

static void numberChanged(wxText& text, wxCommandEvent& event)
{
  XpppConfigDialog *dialog = (XpppConfigDialog*)text.GetParent()->GetParent();
  dialog->_currentIsp->_phoneNumbers = vector<String>();
  char buf[strlen(event.commandString) + 1];
  char *ip = event.commandString;
  char *op = buf;
  *op = 0;
  while (*ip)
    if (*ip == '\n')
    {
      ip++;
      *op = 0;
      if (strlen(buf) > 0)
      {
        dialog->_currentIsp->_phoneNumbers.push_back((String)buf);
        op = buf;
        *op = 0;
      }
    }
    else
      *op++ = *ip++;
  if (strlen(buf) > 0)
    dialog->_currentIsp->_phoneNumbers.push_back((String)buf);
  dialog->_changed = true;
}

static void ispChanged(wxText& text, wxCommandEvent& event)
{
  XpppConfigDialog *dialog = (XpppConfigDialog*)text.GetParent()->GetParent();
  dialog->_currentIsp->_name = event.commandString;
  dialog->_ispListBox->SetString(dialog->_currentIsp - configData.begin(),
                                 event.commandString);
  dialog->_changed = true;
}

static void chatChanged(wxText& text, wxCommandEvent& event)
{
  XpppConfigDialog *dialog = (XpppConfigDialog*)text.GetParent()->GetParent();
  dialog->_currentIsp->_chatScript = event.commandString;
  if (dialog->_currentIsp->_passwords.size() > 0)
    dialog->_currentIsp->_passwords = vector<String>();
  dialog->_changed = true;
}

static void pppdChanged(wxText& text, wxCommandEvent& event)
{
  XpppConfigDialog *dialog = (XpppConfigDialog*)text.GetParent()->GetParent();
  dialog->_currentIsp->_pppdOptions = event.commandString;
  dialog->_changed = true;
}

static void connectChanged(wxText& text, wxCommandEvent& event)
{
  XpppConfigDialog *dialog = (XpppConfigDialog*)text.GetParent()->GetParent();
  dialog->_currentIsp->_checkConnect = event.commandString;
  dialog->_changed = true;
}

static void maxTriesChanged(wxText& text, wxCommandEvent& event)
{
  XpppConfigDialog *dialog =(XpppConfigDialog*)text.GetParent()->GetParent();
  long insertPos = dialog->_maxTries->GetInsertionPoint();
  char buf[strlen(event.commandString) + 1];
  char *ip = event.commandString;
  char *op = buf;
  while (*ip)
    if (isdigit(*ip))
      *op++= *ip++;
    else
    {
      if (ip - event.commandString < insertPos) insertPos--;
      ip++;
    }
  *op = 0;
  dialog->_maxTries->SetValue(buf);
  dialog->_currentIsp->_maxTries = atoi(buf);
  dialog->_maxTries->SetInsertionPoint(insertPos);
  dialog->_changed = true;
}

static void timeoutChanged(wxText& text, wxCommandEvent& event)
{
  XpppConfigDialog *dialog =(XpppConfigDialog*)text.GetParent()->GetParent();
  long insertPos = dialog->_timeOut->GetInsertionPoint();
  char buf[strlen(event.commandString) + 1];
  char *ip = event.commandString;
  char *op = buf;
  while (*ip)
    if (isdigit(*ip))
      *op++= *ip++;
    else
    {
      if (ip - event.commandString < insertPos) insertPos--;
      ip++;
    }
  *op = 0;
  dialog->_timeOut->SetValue(buf);
  dialog->_currentIsp->_timeOut = atoi(buf);
  dialog->_timeOut->SetInsertionPoint(insertPos);
  dialog->_changed = true;
}

static void dismissButtonPressed(wxButton& button, wxCommandEvent&)
{
  ((XpppConfigDialog*)button.GetParent()->GetParent())->Show(False);
  configFinished();
}

static void newButtonPressed(wxButton& button, wxCommandEvent&)
{
  XpppConfigDialog *dialog =
    (XpppConfigDialog*)button.GetParent()->GetParent();
  Isp newIsp;
  newIsp._name = "<NEW>";
  newIsp._timeOut = DEFAULT_TIMEOUT;
  newIsp._maxTries = DEFAULT_MAXTRIES;
  configData.push_back(newIsp);
  dialog->_ispListBox->Append("<NEW>", (char*)(configData.end() - 1));
  dialog->_ispListBox->SetSelection(configData.end() - configData.begin() - 1);
  dialog->_currentIsp = configData.end() - 1;
  dialog->redisplay();
  dialog->_changed = true;
}

static void cloneButtonPressed(wxButton& button, wxCommandEvent&)
{
  XpppConfigDialog *dialog =
    (XpppConfigDialog*)button.GetParent()->GetParent();
  Isp newIsp;
  newIsp._name = "<NEW>";
  newIsp._timeOut = DEFAULT_TIMEOUT;
  newIsp._maxTries = DEFAULT_MAXTRIES;
  newIsp._chatScript = dialog->_currentIsp->_chatScript;
  newIsp._pppdOptions = dialog->_currentIsp->_pppdOptions;
  newIsp._checkConnect = dialog->_currentIsp->_checkConnect;
  newIsp._phoneNumbers = dialog->_currentIsp->_phoneNumbers;
  configData.push_back(newIsp);
  dialog->_ispListBox->Append("<NEW>", (char*)(configData.end() - 1));
  dialog->_ispListBox->SetSelection(configData.end() - configData.begin() - 1);
  dialog->_currentIsp = configData.end() - 1;
  dialog->redisplay();
  dialog->_changed = true;
}

static void deleteButtonPressed(wxButton& button, wxCommandEvent&)
{
  XpppConfigDialog *dialog =
    (XpppConfigDialog*)button.GetParent()->GetParent();
  if (dialog->_currentIsp != configData.end())
  {
    dialog->_changed = true;
    configData.erase(dialog->_currentIsp);
    dialog->_ispListBox->Delete(dialog->_currentIsp - configData.begin());
    if (dialog->_currentIsp == configData.end() &&
        dialog->_currentIsp != configData.begin())
      dialog->_currentIsp--;
    if (configData.end() == configData.begin())
    {
      dialog->_ispText->SetValue("");
      dialog->_ispText->SetEditable(FALSE);
      dialog->_numberText->SetValue("");
      dialog->_numberText->SetEditable(FALSE);
      dialog->_chatScript->SetValue("");
      dialog->_chatScript->SetEditable(FALSE);
      dialog->_pppdOptions->SetValue("");
      dialog->_pppdOptions->SetEditable(FALSE);
      dialog->_checkScript->SetValue("");
      dialog->_checkScript->SetEditable(FALSE);
      dialog->_maxTries->SetValue("");
      dialog->_maxTries->SetEditable(FALSE);
      dialog->_timeOut->SetValue("");
      dialog->_timeOut->SetEditable(FALSE);
    }
    else
      dialog->redisplay();
  }
}

// XppConfigDialog implementation

void XpppConfigDialog::redisplayAll()
{
  _ispListBox->Clear();
  // add ISPs
  for (ConfigData::iterator i = configData.begin(); i != configData.end(); i++)
  {
    _ispListBox->Append(removeConst(i->_name), (char*)i);
  }

  // add info for first ISP
  _currentIsp = configData.begin();
  redisplay();
}

void XpppConfigDialog::redisplay()
{
  if (_currentIsp != (ConfigData::iterator)0)
  {
    _ispText->SetValue(removeConst(_currentIsp->_name));
    _ispText->SetEditable(TRUE);
    String numberText;
    for (vector<String>::iterator i = _currentIsp->_phoneNumbers.begin();
         i != _currentIsp->_phoneNumbers.end(); i++)
      numberText += *i + "\n";
    _numberText->SetValue(removeConst(numberText));
    _numberText->SetEditable(TRUE);
    _chatScript->SetValue(removeConst(_currentIsp->_chatScript));
    _chatScript->SetEditable(TRUE);
    _pppdOptions->SetValue(removeConst(_currentIsp->_pppdOptions));
    _pppdOptions->SetEditable(TRUE);
    _checkScript->SetValue(removeConst(_currentIsp->_checkConnect));
    _checkScript->SetEditable(TRUE);
    _maxTries->SetValue(removeConst(itoa(_currentIsp->_maxTries)));
    _maxTries->SetEditable(TRUE);
    _timeOut->SetValue(removeConst(itoa(_currentIsp->_timeOut)));
    _timeOut->SetEditable(TRUE);
  }
}

const int FRAME_W = 640;
const int UPPER_PANEL_H = 360;
const int BUTTON_PANEL_H = 58;

XpppConfigDialog::XpppConfigDialog(wxFrame *parent) :
  wxDialogBox(parent, "XPPP Configuration", TRUE, -1, -1, -1, -1,
              wxRESIZE_BORDER | wxDEFAULT_DIALOG_STYLE),
  _changed(false)
{
  wxBeginBusyCursor();
  wxPanel *panel = new wxPanel(this, 0, 0, FRAME_W, UPPER_PANEL_H, wxBORDER,
                               "upperPanel");
  panel->SetLabelPosition(wxVERTICAL);

  // create isp listbox on the left
  _ispListBox =
    new wxListBox(panel, (wxFunction)ispSelection, "ISP:", wxSINGLE,
                  -1, -1, 200, -1, 0, (char**)0,
                  wxALWAYS_SB | wxLB_SINGLE, "ispListBox");
  wxLayoutConstraints *ic = new wxLayoutConstraints;
  ic->top.SameAs(panel, wxTop, 5);
  ic->left.SameAs(panel, wxLeft, 10);
  ic->width.PercentOf(panel, wxWidth, 22);
  ic->bottom.SameAs(panel, wxBottom, 10);
  _ispListBox->SetConstraints(ic);
    
  // create middle column
  _ispText = new wxText(panel, (wxFunction)ispChanged, "ISP Name:", "",
                       -1, -1, 150, -1, 0, "ispText");
  wxLayoutConstraints *isc = new wxLayoutConstraints;
  isc->top.SameAs(_ispListBox, wxTop);
  isc->left.SameAs(_ispListBox, wxRight, 12);
  isc->width.PercentOf(panel, wxWidth, 21);
  isc->height.AsIs();
  _ispText->SetConstraints(isc);

  _numberText =
    new wxMultiText(panel, (wxFunction)numberChanged, "Phone Numbers:", "",
                    -1, -1, 150, UPPER_PANEL_H - 10, 0, "numberText");
  wxLayoutConstraints *nc = new wxLayoutConstraints;
  nc->top.Below(_ispText, 5);
  nc->left.SameAs(_ispListBox, wxRight, 10);
  nc->width.PercentOf(panel, wxWidth, 23);
  nc->bottom.SameAs(panel, wxBottom, 10);
  _numberText->SetConstraints(nc);

  // create right column: chatScript, pppdOptions, checkScript,
  // maxtries/timeout
  _chatScript =
    new wxMultiText(panel, (wxFunction)chatChanged, "Chat Script:", "",
                    -1, -1, -1, -1, 0, "chatScript");
  wxLayoutConstraints *csc = new wxLayoutConstraints;
  csc->top.SameAs(_ispText, wxTop);
  csc->right.SameAs(panel, wxRight, 5);
  csc->left.SameAs(_ispText, wxRight, 11);
  csc->height.PercentOf(panel, wxHeight, 25);
  _chatScript->SetConstraints(csc);

  _pppdOptions =
    new wxMultiText(panel, (wxFunction)pppdChanged, "PPPD Options:", "",
                    -1, -1, -1, -1, 0, "pppdOptions");
  wxLayoutConstraints *psc = new wxLayoutConstraints;
  psc->top.Below(_chatScript, 5);
  psc->right.SameAs(panel, wxRight, 5);
  psc->left.SameAs(_chatScript, wxLeft);
  psc->height.PercentOf(panel, wxHeight, 25);
  _pppdOptions->SetConstraints(psc);
  
  _checkScript =
    new wxMultiText(panel, (wxFunction)connectChanged, "Connect Script:", "",
                    -1, -1, -1, -1, 0, "checkScript");
  wxLayoutConstraints *ksc = new wxLayoutConstraints;
  ksc->top.Below(_pppdOptions, 5);
  ksc->right.SameAs(panel, wxRight, 5);
  ksc->left.SameAs(_pppdOptions, wxLeft);
  ksc->height.PercentOf(panel, wxHeight, 25);
  _checkScript->SetConstraints(ksc);

  // maxTries and timeout
  _maxTries = new wxText(panel, (wxFunction)maxTriesChanged,
                         "Max Tries:", "", -1, -1, -1, -1, 0, "maxTries");
  wxLayoutConstraints *msc = new wxLayoutConstraints;
  msc->top.Below(_checkScript, 5);
  msc->left.SameAs(_checkScript, wxLeft);
  msc->width.PercentOf(_checkScript, wxWidth, 30);
  //  msc->bottom.SameAs(panel, wxBottom, 5);
  msc->height.AsIs();
  _maxTries->SetConstraints(msc);
  
  _timeOut = new wxText(panel, (wxFunction)timeoutChanged, "Timeout:", "",
                       -1, -1, -1, -1, 0, "timeout");
  wxLayoutConstraints *tsc = new wxLayoutConstraints;
  tsc->top.Below(_checkScript, 5);
  tsc->right.SameAs(_checkScript, wxRight, 8);
  tsc->width.PercentOf(_checkScript, wxWidth, 30);
  //  tsc->bottom.SameAs(panel, wxBottom, 5);
  tsc->height.AsIs();
  _timeOut->SetConstraints(tsc);

  // layout upper panel
  wxLayoutConstraints *c = new wxLayoutConstraints;
  c->top.SameAs(this, wxTop);
  //  c->height.Absolute(UPPER_PANEL_H);
  c->height.PercentOf(this, wxHeight, 84);
  c->left.SameAs(this, wxLeft);
  c->right.SameAs(this, wxRight);
  panel->SetConstraints(c);

  // create button panel
  wxPanel *buttonPanel =
    new wxPanel(this, 0, 0, FRAME_W, BUTTON_PANEL_H, 0, "buttonPanel");

  wxButton *dismissButton, *newButton, *cloneButton, *deleteButton;

  dismissButton =
    new wxButton(buttonPanel, (wxFunction)dismissButtonPressed, "Dismiss",
                 -1, -1, -1, -1, 0, "dismissButton");
  wxLayoutConstraints *b = new wxLayoutConstraints;
  b->centreY.SameAs(buttonPanel, wxCentreY);
  b->centreX.PercentOf(buttonPanel, wxWidth, 20);
  b->width.Absolute(75);
  b->height.Absolute(37);
  dismissButton->SetConstraints(b);
  
  newButton = new wxButton(buttonPanel, (wxFunction)newButtonPressed, "New",
                 -1, -1, -1, -1, 0, "newButton");
  b = new wxLayoutConstraints;
  b->centreY.SameAs(buttonPanel, wxCentreY);
  b->centreX.PercentOf(buttonPanel, wxWidth, 40);
  b->width.Absolute(75);
  b->height.Absolute(37);
  newButton->SetConstraints(b);

  cloneButton = new wxButton(buttonPanel,
                             (wxFunction)cloneButtonPressed, "Clone",
                 -1, -1, -1, -1, 0, "cloneButton");
  b = new wxLayoutConstraints;
  b->centreY.SameAs(buttonPanel, wxCentreY);
  b->centreX.PercentOf(buttonPanel, wxWidth, 60);
  b->width.Absolute(75);
  b->height.Absolute(37);
  cloneButton->SetConstraints(b);

  deleteButton = new wxButton(buttonPanel,
                              (wxFunction)deleteButtonPressed, "Delete",
                 -1, -1, -1, -1, 0, "deleteButton");
  b = new wxLayoutConstraints;
  b->centreY.SameAs(buttonPanel, wxCentreY);
  b->centreX.PercentOf(buttonPanel, wxWidth, 80);
  b->width.Absolute(75);
  b->height.Absolute(37);
  deleteButton->SetConstraints(b);
  dismissButton->SetDefault();

  // layout button panel
  wxLayoutConstraints *pc = new wxLayoutConstraints;
  pc->top.Below(panel);
  pc->left.SameAs(this, wxLeft);
  pc->right.SameAs(this, wxRight);
  pc->bottom.SameAs(this, wxBottom);
  //  pc->height.Absolute(BUTTON_PANEL_H);
  pc->height.PercentOf(this, wxHeight, 16);
  buttonPanel->SetConstraints(pc);

  redisplayAll();
  
  // do the layout
  Layout();
  Fit();

  wxEndBusyCursor();
}

void XpppConfigDialog::OnSize(int, int)
{
  Layout();
}

Bool XpppConfigDialog::OnClose(void)
{
  configFinished();
  Show(False);
  return FALSE;
}

