/* XPPP
 *
 * File:      xppp_config.h
 * Purpose:   Configuration
 * Author:    Peter Hofmann (970522)
 *
 */

#ifndef XPPP_CONFIG_H
#define XPPP_CONFIG_H

#define String XString
#include <wx.h>
#undef String

#include <String.h>
#include <stl.h>
#include <fstream.h>

#include "xppp_misc.h"

// *** defaults

const int DEFAULT_TIMEOUT = 60;
const int DEFAULT_MAXTRIES = 3;

// *** ISP structure

struct Isp
{
  // user-configurable items
  String _name, _chatScript, _pppdOptions, _checkConnect;
  int _maxTries;
  int _timeOut;
  vector<String> _phoneNumbers;
  vector<String> _passwords;
  // internal
  wxButton *_btn;
  int _tries;
  vector<String>::iterator _phoneIndex;
};

extern istream &operator>>(istream &is, Isp &isp);

// *** class that holds config data

class ConfigData : public vector<Isp>
{
  String _rcFile;
  int _lineNo;
  char _line[1000];
  String nextLine(ifstream &cf);
  
public:
  ConfigData();
  // set rc file name
  void setRcFile(String rcFile) {_rcFile = rcFile;}
  // reload configdata
  void reload();
  // save configData
  void save();
};

extern istream &operator>>(istream &is, ConfigData &configData);

// *** global config data

extern ConfigData configData;

#endif //XPPP_CONFIG_H
