/* XPPP
 *
 * File:      xppp.h
 * Purpose:   Main Program
 * Author:    Peter Hofmann (970522)
 *
 */

#ifndef XPPP_H
#define XPPP_H

#define String XString
#include <wx.h>
#undef String

#include "xppp_misc.h"
#include "String.h"
#include "xppp_config_dialog.h"
#include "xppp_pppd_output.h"

// constants

#define RESOURCE_PREFIX "xppp"

// Define a new application type
class MyApp: public wxApp
{
public:
  wxMenu *_configMenu;

  MyApp();
  wxFrame *OnInit(void);
};

// Define a new frame type
class MyFrame: public wxFrame
{
public:
  wxPanel *panel;
  XpppConfigDialog *_dialog;
  XpppPppdOutput *_pppdOutput;
  vector<wxButton*> _oldButtons;
  
  MyFrame(wxFrame *frame, char *title, int x, int y, int w, int h);
  void OnMenuCommand(int id);
  void addButtons();
  Bool OnClose(void);
  void OnSize(int, int);
  // return true if proceed to quit XPPP
  bool reallyQuit();
};

enum XPPPStatus {not_connected, connected, waiting_for_connection,
               waiting_for_disconnect};

// *** application resources structure

struct XpppResources
{
  String configFile;
  String buttonBackground, buttonForeground;
  String connectionOkColour, disconnectColour;
  String backgroundColour;
  String pppdCommand;
  String connectOptionStart;
  String connectOptionEnd;
  String pppdWrapper;
  bool storePasswords;
  int flashRate;
  int ispButtonHeight;
  int mainWindowWidth;
  int killTimeout;
  int checkInterval;
  int checkConnectTimeout;
};

extern XpppResources xpppResources;

// called by configuration dialog when finished

void configFinished();

#endif // XPPP_H
