/*
  Copyright (C) 1997-2002  Dimitrios P. Bouras

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   For author contact information, look in the README file.
*/

#include <stdio.h>
#include <stdlib.h>
#include <varargs.h>
#include <pwd.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <errno.h>
#include "common.h"
#include "version.h"
#include "pcode.h"
#include "logs.h"

#ifdef SUNOS41x
#include <memory.h>
extern int sys_nerr;
extern char *sys_errlist[];
extern int errno;
extern long strtol();
extern int fputs(), fscanf(), sscanf(), vfprintf(), fprintf(), fflush();
extern int fread(), fwrite(), fclose(), rename(), gethostname();
extern time_t time();
#endif

#ifdef SUNOS5x
#include <netdb.h>
extern int gethostname();
#endif

#ifdef RUNASEUID
int xisp_euidaccess();
#endif

#define MAXNUM_VERSIONS         16
#define FIRSTNBIN_VERSION        8
#define FIRSTGLOB_VERSION       10
#define FIRSTVISP_VERSION       12
#define OLD_MAXNUM_ISP           8
#define MAXNUM_ISP             256
#define OLD_OLD_MAXLEN_PHONE    16
#define OLD_MAXLEN_PHONE        32
#define OLD_MAXNUM_SLINES        8
#define OLD_MAXLEN_SLINE        32
#define OLD_MAXLEN_DEVICE       16
#define VERY_OLD_MAXLEN_ACCOUNT  8
#define VERY_OLD_MAXLEN_PASSWD   8
#define OLD_MAXLEN_ACCOUNT      32
#define OLD_MAXLEN_PASSWD       32
#define OLD_MAXLEN_UNR          32
#define OLD_MODEM_SPEED			0x20

typedef struct {
	char descr[MAXLEN_DESCR];
	char account[VERY_OLD_MAXLEN_ACCOUNT+1];
	char passwd[VERY_OLD_MAXLEN_PASSWD+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][OLD_OLD_MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[OLD_MAXNUM_SLINES][OLD_MAXLEN_SLINE+1];
} xisprc_t12;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	unsigned char autoRedial;
	char account[VERY_OLD_MAXLEN_ACCOUNT+1];
	char passwd[VERY_OLD_MAXLEN_PASSWD+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][OLD_OLD_MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[OLD_MAXNUM_SLINES][OLD_MAXLEN_SLINE+1];
} xisprc_t13;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	unsigned char autoRedial;
	char account[VERY_OLD_MAXLEN_ACCOUNT+1];
	char passwd[VERY_OLD_MAXLEN_PASSWD+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][OLD_OLD_MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[OLD_MAXNUM_SLINES][OLD_MAXLEN_SLINE+1];
	char modemInit[MAXLEN_MDMCMD+1];
	unsigned char modemOpts;
} xisprc_t14;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	unsigned char autoRedial;
	char account[VERY_OLD_MAXLEN_ACCOUNT+1];
	char passwd[VERY_OLD_MAXLEN_PASSWD+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][OLD_OLD_MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[OLD_MAXNUM_SLINES][OLD_MAXLEN_SLINE+1];
	char modemDevice[OLD_MAXLEN_DEVICE+1];
	unsigned char modemSpeed;
	char modemInit[MAXLEN_MDMCMD+1];
	unsigned char operOpts;
	unsigned char compLevel;
} xisprc_t16;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	unsigned char autoRedial;
	char account[OLD_MAXLEN_ACCOUNT+1];
	char passwd[OLD_MAXLEN_PASSWD+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][OLD_OLD_MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[OLD_MAXNUM_SLINES][OLD_MAXLEN_SLINE+1];
	char modemDevice[OLD_MAXLEN_DEVICE+1];
	unsigned char modemSpeed;
	char modemInit[MAXLEN_MDMCMD+1];
	unsigned char operOpts;
	unsigned char compLevel;
	char asyncmap[MAXDIG_ASYNCMAP+1];
	char escape[MAXLEN_ESCAPE+1];
	unsigned char localIP[4];
	unsigned char remoteIP[4];
	unsigned char netmask[4];
} xisprc_t17;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	unsigned char autoRedial;
	char account[OLD_MAXLEN_ACCOUNT+1];
	char passwd[OLD_MAXLEN_PASSWD+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][OLD_OLD_MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[OLD_MAXNUM_SLINES][OLD_MAXLEN_SLINE+1];
	char modemDevice[OLD_MAXLEN_DEVICE+1];
	unsigned char modemSpeed;
	char modemInit[MAXLEN_MDMCMD+1];
	unsigned char operOpts;
	unsigned char compLevel;
	char asyncmap[MAXDIG_ASYNCMAP+1];
	char escape[MAXLEN_ESCAPE+1];
	unsigned char localIP[4];
	unsigned char remoteIP[4];
	unsigned char netmask[4];
	unsigned int mtu;
	unsigned int mru;
} xisprc_t18;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	unsigned char autoRedial;
	char account[OLD_MAXLEN_ACCOUNT+1];
	char passwd[OLD_MAXLEN_PASSWD+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][OLD_OLD_MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[2*OLD_MAXNUM_SLINES][OLD_MAXLEN_SLINE+1];
	char modemDevice[OLD_MAXLEN_DEVICE+1];
	unsigned char modemSpeed;
	char modemInit[MAXLEN_MDMCMD+1];
	unsigned char operOpts;
	unsigned char compLevel;
	char asyncmap[MAXDIG_ASYNCMAP+1];
	char escape[MAXLEN_ESCAPE+1];
	unsigned char localIP[4];
	unsigned char remoteIP[4];
	unsigned char netmask[4];
	unsigned int mtu;
	unsigned int mru;
} xisprc_t19;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	char account[OLD_MAXLEN_ACCOUNT+1];
	char passwd[OLD_MAXLEN_PASSWD+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][OLD_MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[2*OLD_MAXNUM_SLINES][OLD_MAXLEN_SLINE+1];
	unsigned char numCBSlns;
	char CBsln[2*OLD_MAXNUM_SLINES][OLD_MAXLEN_SLINE+1];
	char modemDevice[OLD_MAXLEN_DEVICE+1];
	unsigned char modemSpeed;
	char modemInit[MAXLEN_MDMCMD+1];
	unsigned short operOpts;
	unsigned char compLevel;
	char asyncmap[MAXDIG_ASYNCMAP+1];
	char escape[MAXLEN_ESCAPE+1];
	unsigned char localIP[4];
	unsigned char remoteIP[4];
	unsigned char netmask[4];
	unsigned int mtu;
	unsigned int mru;
} xisprc_t20;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	char account[OLD_MAXLEN_ACCOUNT+1];
	char passwd[OLD_MAXLEN_PASSWD+1];
	char name[OLD_MAXLEN_UNR+1];
	char rname[OLD_MAXLEN_UNR+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char connectWait;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][OLD_MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[2*OLD_MAXNUM_SLINES][OLD_MAXLEN_SLINE+1];
	unsigned char CBDelay;
	unsigned char numCBSlns;
	char CBsln[2*OLD_MAXNUM_SLINES][OLD_MAXLEN_SLINE+1];
	char modemDevice[OLD_MAXLEN_DEVICE+1];
	unsigned char modemSpeed;
	char modemReset[MAXLEN_MDMCMD+1];
	char modemInit[MAXLEN_MDMCMD+1];
	unsigned short operOpts;
	unsigned char compLevel;
	char asyncmap[MAXDIG_ASYNCMAP+1];
	char escape[MAXLEN_ESCAPE+1];
	unsigned char localIP[4];
	unsigned char remoteIP[4];
	unsigned char netmask[4];
	unsigned char dns1[4];
	unsigned char dns2[4];
	unsigned int mtu;
	unsigned int mru;
} xisprc_t21;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	char account[OLD_MAXLEN_ACCOUNT+1];
	char passwd[OLD_MAXLEN_PASSWD+1];
	char name[OLD_MAXLEN_UNR+1];
	char rname[OLD_MAXLEN_UNR+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char connectWait;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][OLD_MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[2*OLD_MAXNUM_SLINES][OLD_MAXLEN_SLINE+1];
	unsigned char CBDelay;
	unsigned char numCBSlns;
	char CBsln[2*OLD_MAXNUM_SLINES][OLD_MAXLEN_SLINE+1];
	char modemDevice[OLD_MAXLEN_DEVICE+1];
	unsigned char modemSpeed;
	char modemReset[MAXLEN_MDMCMD+1];
	char modemInit[MAXLEN_MDMCMD+1];
	unsigned int operOpts;
	unsigned char compLevel;
	char asyncmap[MAXDIG_ASYNCMAP+1];
	char escape[MAXLEN_ESCAPE+1];
	unsigned char localIP[4];
	unsigned char remoteIP[4];
	unsigned char netmask[4];
	unsigned char dns1[4];
	unsigned char dns2[4];
	unsigned int mtu;
	unsigned int mru;
} xisprc_t22;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	char account[OLD_MAXLEN_ACCOUNT+1];
	char passwd[OLD_MAXLEN_PASSWD+1];
	char name[OLD_MAXLEN_UNR+1];
	char rname[OLD_MAXLEN_UNR+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char connectWait;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][OLD_MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[2*OLD_MAXNUM_SLINES][OLD_MAXLEN_SLINE+1];
	unsigned char CBDelay;
	unsigned char numCBSlns;
	char CBsln[2*OLD_MAXNUM_SLINES][OLD_MAXLEN_SLINE+1];
	char modemDevice[OLD_MAXLEN_DEVICE+1];
	unsigned char modemSpeed;
	char modemReset[MAXLEN_MDMCMD+1];
	char modemInit[MAXLEN_MDMCMD+1];
	unsigned int operOpts;
	char dialExtra[MAXLEN_DIALEXTRA+1];
	unsigned char compLevel;
	char asyncmap[MAXDIG_ASYNCMAP+1];
	char escape[MAXLEN_ESCAPE+1];
	unsigned char localIP[4];
	unsigned char remoteIP[4];
	unsigned char netmask[4];
	unsigned char dns1[4];
	unsigned char dns2[4];
	unsigned int mtu;
	unsigned int mru;
} xisprc_t23;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	char account[OLD_MAXLEN_ACCOUNT+1];
	char passwd[OLD_MAXLEN_PASSWD+1];
	char name[OLD_MAXLEN_UNR+1];
	char rname[OLD_MAXLEN_UNR+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char connectWait;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][OLD_MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[2*OLD_MAXNUM_SLINES][OLD_MAXLEN_SLINE+1];
	unsigned char CBDelay;
	unsigned char numCBSlns;
	char CBsln[2*OLD_MAXNUM_SLINES][OLD_MAXLEN_SLINE+1];
	unsigned char termW;
	unsigned char termH;
	char modemDevice[OLD_MAXLEN_DEVICE+1];
	unsigned char modemSpeed;
	char modemReset[MAXLEN_MDMCMD+1];
	char modemInit[MAXLEN_MDMCMD+1];
	unsigned int operOpts;
	char dialExtra[MAXLEN_DIALEXTRA+1];
	unsigned char compLevel;
	char asyncmap[MAXDIG_ASYNCMAP+1];
	char escape[MAXLEN_ESCAPE+1];
	unsigned char localIP[4];
	unsigned char remoteIP[4];
	unsigned char netmask[4];
	unsigned char dns1[4];
	unsigned char dns2[4];
	unsigned int mtu;
	unsigned int mru;
} xisprc_t24;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	char account[OLD_MAXLEN_ACCOUNT+1];
	char passwd[OLD_MAXLEN_PASSWD+1];
	char name[OLD_MAXLEN_UNR+1];
	char rname[OLD_MAXLEN_UNR+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char connectWait;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][OLD_MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[2*MAXNUM_SLINES][MAXLEN_SLINE+1];
	unsigned char CBDelay;
	unsigned char numCBSlns;
	char CBsln[2*MAXNUM_SLINES][MAXLEN_SLINE+1];
	unsigned char termW;
	unsigned char termH;
	char modemDevice[MAXLEN_DEVICE+1];
	unsigned char modemSpeed;
	char modemReset[MAXLEN_MDMCMD+1];
	char modemInit[MAXLEN_MDMCMD+1];
	char modemConnect[MAXLEN_MDMSTR+1];
	unsigned int operOpts;
	char dialExtra[MAXLEN_DIALEXTRA+1];
	unsigned char compLevel;
	char asyncmap[MAXDIG_ASYNCMAP+1];
	char escape[MAXLEN_ESCAPE+1];
	unsigned char localIP[4];
	unsigned char remoteIP[4];
	unsigned char netmask[4];
	unsigned char dns1[4];
	unsigned char dns2[4];
	unsigned int mtu;
	unsigned int mru;
} xisprc_t25;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	char account[MAXLEN_ACCOUNT+1];
	char passwd[MAXLEN_PASSWD+1];
	char name[MAXLEN_UNR+1];
	char rname[MAXLEN_UNR+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char connectWait;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[2*MAXNUM_SLINES][MAXLEN_SLINE+1];
	unsigned char CBDelay;
	unsigned char numCBSlns;
	char CBsln[2*MAXNUM_SLINES][MAXLEN_SLINE+1];
	unsigned char termW;
	unsigned char termH;
	unsigned char CBtermW;
	unsigned char CBtermH;
	char CBphone[MAXLEN_PHONE+1];
	char modemDevice[MAXLEN_DEVICE+1];
	unsigned char modemSpeed;
	char modemReset[MAXLEN_MDMCMD+1];
	char modemInit[MAXLEN_MDMCMD+1];
	char modemConnect[MAXLEN_MDMCMD+1];
	unsigned long operOpts;
	char dialExtra[MAXLEN_DIALEXTRA+1];
	unsigned char compLevel;
	char asyncmap[MAXDIG_ASYNCMAP+1];
	char escape[MAXLEN_ESCAPE+1];
	unsigned char localIP[4];
	unsigned char remoteIP[4];
	unsigned char netmask[4];
	unsigned char dns1[4];
	unsigned char dns2[4];
	unsigned int mtu;
	unsigned int mru;
} xisprc_t26;

typedef struct {
	char descr[MAXLEN_DESCR+1];
	char account[MAXLEN_ACCOUNT+1];
	char passwd[MAXLEN_PASSWD+1];
	char name[MAXLEN_UNR+1];
	char rname[MAXLEN_UNR+1];
	unsigned char maxAttempts;
	unsigned char sleepDelay;
	unsigned char connectWait;
	unsigned char LCPWait;
	unsigned char numPhones;
	char phone[MAXNUM_TELS][MAXLEN_PHONE+1];
	unsigned char numSlines;
	char sline[2*MAXNUM_SLINES][MAXLEN_SLINE+1];
	unsigned char CBDelay;
	unsigned char numCBSlns;
	char CBsln[2*MAXNUM_SLINES][MAXLEN_SLINE+1];
	unsigned char termW;
	unsigned char termH;
	unsigned char CBtermW;
	unsigned char CBtermH;
	char CBphone[MAXLEN_PHONE+1];
	char modemDevice[MAXLEN_DEVICE+1];
	unsigned int modemSpeed;
	char modemReset[MAXLEN_MDMCMD+1];
	char modemInit[MAXLEN_MDMCMD+1];
	char modemConnect[MAXLEN_MDMCMD+1];
	unsigned long operOpts;
	char dialExtra[MAXLEN_DIALEXTRA+1];
	unsigned char compLevel;
	char asyncmap[MAXDIG_ASYNCMAP+1];
	char escape[MAXLEN_ESCAPE+1];
	unsigned char localIP[4];
	unsigned char remoteIP[4];
	unsigned char netmask[4];
	unsigned char dns1[4];
	unsigned char dns2[4];
	unsigned int mtu;
	unsigned int mru;
	char domainname[MAXLEN_DNNAME+1];
	unsigned char ispPTT;
	unsigned char ispZone;
} xisprc_t27;

typedef union {
	xisprc_t12 opts12[OLD_MAXNUM_ISP];
	xisprc_t13 opts13[OLD_MAXNUM_ISP];
	xisprc_t14 opts14[OLD_MAXNUM_ISP];
	xisprc_t16 opts16[OLD_MAXNUM_ISP];
	xisprc_t17 opts17[OLD_MAXNUM_ISP];
	xisprc_t18 opts18[OLD_MAXNUM_ISP];
	xisprc_t19 opts19[OLD_MAXNUM_ISP];
	xisprc_t20 opts20[OLD_MAXNUM_ISP];
	xisprc_t21 opts21[OLD_MAXNUM_ISP];
	xisprc_t22 opts22[OLD_MAXNUM_ISP];
	xisprc_t23 opts23[OLD_MAXNUM_ISP];
	xisprc_t24 opts24[OLD_MAXNUM_ISP];
	xisprc_t25 opts25[MAXNUM_ISP];
	xisprc_t26 opts26[MAXNUM_ISP];
	xisprc_t27 opts27[MAXNUM_ISP];
} xisprc_ut;

xisprc_ut orc, nrc;

int rcsize[MAXNUM_VERSIONS] = {sizeof(xisprc_t12), sizeof(xisprc_t13),
							   sizeof(xisprc_t14), sizeof(xisprc_t14),
							   sizeof(xisprc_t16), sizeof(xisprc_t17),
							   sizeof(xisprc_t18), sizeof(xisprc_t19),
							   sizeof(xisprc_t20), sizeof(xisprc_t21),
							   sizeof(xisprc_t22), sizeof(xisprc_t23),
							   sizeof(xisprc_t24), sizeof(xisprc_t25),
							   sizeof(xisprc_t26), sizeof(xisprc_t27)};

typedef struct {
	unsigned char dfltISP;
} glob_t22;

typedef struct {
	unsigned char dfltISP;
	unsigned char dfltPTT;
	unsigned char dfltZone;
	unsigned int logOpts;
} glob_t23;

typedef struct {
	unsigned char numISPs;
	unsigned char dfltISP;
	unsigned char numPTTs;
	unsigned char dfltPTT;
	unsigned char dfltZone;
	unsigned int logOpts;
	char pppdPath[MAXLEN_PATH+1];
	char runPath[MAXLEN_PATH+1];
	char chatPath[MAXLEN_PATH+1];
	char utilsPath[MAXLEN_PATH+1];
	char pipePath[MAXLEN_PATH+1];
} glob_t24;

typedef struct {
	unsigned char numISPs;
	unsigned char dfltISP;
	unsigned char numPTTs;
	unsigned char dfltPTT;
	unsigned char dfltZone;
	unsigned short logOpts;
	char pppdPath[MAXLEN_PATH+1];
	char runPath[MAXLEN_PATH+1];
	char chatPath[MAXLEN_PATH+1];
	char utilsPath[MAXLEN_PATH+1];
	char pipePath[MAXLEN_PATH+1];
} glob_t26;

typedef struct {
	unsigned char numISPs;
	unsigned char dfltISP;
	unsigned char numPTTs;
	unsigned char costPTT;
	unsigned short logOpts;
	char pppdPath[MAXLEN_PATH+1];
	char runPath[MAXLEN_PATH+1];
	char lockPath[MAXLEN_PATH+1];
	char chatPath[MAXLEN_PATH+1];
	char utilsPath[MAXLEN_PATH+1];
	char pipePath[MAXLEN_PATH+1];
} glob_t27;

int PTTxlate26[MAXNUM_PTT] = { 0, 1, 2, 3, 4, 5, 6,11,12,13,15,16,17,
							  18,19,20,21,22,23,24,25,28,29, 7,26,27};

typedef union {
	glob_t22	glob22;
	glob_t23	glob23;
	glob_t24	glob24;
	glob_t26	glob26;
	glob_t27	glob27;
} glob_ut;

glob_ut ogl, ngl;

int globsize[MAXNUM_VERSIONS] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
								 sizeof(glob_t22), sizeof(glob_t23),
								 sizeof(glob_t24), sizeof(glob_t24),
								 sizeof(glob_t26), sizeof(glob_t27)};

char *rcname[MAXNUM_VERSIONS] = {"1.2","1.3","1.4","1.5",
								 "1.6","1.7","1.8","1.9",
								 "2.0","2.1","2.2","2.3",
								 "2.4","2.5","2.6",Version};

typedef struct ptt26_struct {
	char name[MAXLEN_PTTNAME+1];
	unsigned char num_zones;
	unsigned char current_zone;
	unsigned char num_categories;
	unsigned int attribs;
	unsigned char min_units;
	float min_cost;
	unsigned char charge_period;
	float cost_quantum;
	char currency[MAXLEN_CURRENCY+1];
	unsigned char decimals;
	float dflt_tariff[MAXNUM_ZONES];
	unsigned int min_cost_len[MAXNUM_ZONES];
	char zone_name[MAXNUM_ZONES][MAXLEN_ZNAME+1];
	discount_t discount[MAXNUM_ZONES];
	rule_t rule[MAXNUM_ZONES][MAXNUM_CATEGORY];
} ptt_t26;

char *orcfname, *nrcfname;
char *logdirname, *costfname, *costfnroot, *bkupfname;
char *pttfname;
ptt_t26 *ptt;

#define MSGLEN_ERR 128
void doErr(char *msg)
{
	char emsg[MSGLEN_ERR+1];

#ifdef HAVE_STRERROR
	sprintf(emsg, "xisprccv: %s: %s\n", msg, strerror(errno));
#else
	if (errno < sys_nerr)
		sprintf(emsg, "xisprccv: %s: %s\n", msg, sys_errlist[errno]);
	else
		sprintf(emsg, "xisprccv: %s: error #%d\n", msg, errno);
#endif
	fputs(emsg, stderr);
	exit(1);
}

void initXisprc13(int rec)
{
	int i;
	xisprc_t12 *p12 = &(orc.opts12[rec]);
	xisprc_t13 *p13 = &(nrc.opts13[rec]);

	strcpy(p13->descr, p12->descr);
	p13->autoRedial = 0;
	strcpy(p13->account, p12->account);
	strcpy(p13->passwd, p12->passwd);
	p13->maxAttempts = p12->maxAttempts;
	p13->sleepDelay = p12->sleepDelay;
	p13->numPhones = p12->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p13->phone[i], p12->phone[i]);
	p13->numSlines = p12->numSlines;
	for (i=0; i<OLD_MAXNUM_SLINES; i++)
		strcpy(p13->sline[i], p12->sline[i]);
}

void initXisprc14(int rec)
{
	int i;
	xisprc_t13 *p13 = &(orc.opts13[rec]);
	xisprc_t14 *p14 = &(nrc.opts14[rec]);

	strcpy(p14->descr, p13->descr);
	p14->autoRedial = p13->autoRedial;
	strcpy(p14->account, p13->account);
	strcpy(p14->passwd, p13->passwd);
	p14->maxAttempts = p13->maxAttempts;
	p14->sleepDelay = p13->sleepDelay;
	p14->numPhones = p13->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p14->phone[i], p13->phone[i]);
	p14->numSlines = p13->numSlines;
	for (i=0; i<OLD_MAXNUM_SLINES; i++)
		strcpy(p14->sline[i], p13->sline[i]);
	strcpy(p14->modemInit, MODEM_INIT);
	p14->modemOpts = MODEM_TONEDIAL;
}

void initXisprc15(int rec)
{
	nrc.opts14[rec] = orc.opts14[rec];
}

void initXisprc16(int rec)
{
	int i;
	xisprc_t14 *p14 = &(orc.opts14[rec]);
	xisprc_t16 *p16 = &(nrc.opts16[rec]);

	strcpy(p16->descr, p14->descr);
	p16->autoRedial = p14->autoRedial;
	strcpy(p16->account, p14->account);
	strcpy(p16->passwd, p14->passwd);
	p16->maxAttempts = p14->maxAttempts;
	p16->sleepDelay = p14->sleepDelay;
	p16->numPhones = p14->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p16->phone[i], p14->phone[i]);
	p16->numSlines = p14->numSlines;
	for (i=0; i<OLD_MAXNUM_SLINES; i++)
		strcpy(p16->sline[i], p14->sline[i]);
	strcpy(p16->modemDevice, MODEM_DEVICE);
	p16->modemSpeed = OLD_MODEM_SPEED;
	strcpy(p16->modemInit, p14->modemInit);
	p16->operOpts = p14->modemOpts | BSD_COMPRESS;
	p16->compLevel = COMP_LEVEL;
}

void initXisprc17(int rec)
{
	int i;
	xisprc_t16 *p16 = &(orc.opts16[rec]);
	xisprc_t17 *p17 = &(nrc.opts17[rec]);
	unsigned char ep[OLD_MAXLEN_PASSWD+1] = {0},
				  pp[OLD_MAXLEN_PASSWD+1] = {0};

	strcpy(p17->descr, p16->descr);
	p17->autoRedial = p16->autoRedial;
	strcpy(p17->account, p16->account);

	if (p16->passwd[0]) {
		pencode(ep, pp);
		memcpy(ep, p16->passwd, VERY_OLD_MAXLEN_PASSWD);
	}
	memcpy(p17->passwd, ep, OLD_MAXLEN_PASSWD);

	p17->maxAttempts = p16->maxAttempts;
	p17->sleepDelay = p16->sleepDelay;
	p17->numPhones = p16->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p17->phone[i], p16->phone[i]);
	p17->numSlines = p16->numSlines;
	for (i=0; i<OLD_MAXNUM_SLINES; i++)
		strcpy(p17->sline[i], p16->sline[i]);
	strcpy(p17->modemDevice, p16->modemDevice);
	p17->modemSpeed = p16->modemSpeed;
	strcpy(p17->modemInit, p16->modemInit);
	p17->operOpts = p16->operOpts |
				   (HW_FLOWCTRL|ACCEPT_LOCALIP|ACCEPT_REMOTEIP|DEFAULT_ROUTE);
	p17->compLevel = p16->compLevel;
	strcpy(p17->asyncmap, PPPD_SASYNCMAP);
	strcpy(p17->escape, PPPD_ESCAPE);
	memcpy(p17->localIP, LOCAL_IP, 4);
	memcpy(p17->remoteIP, REMOTE_IP, 4);
	memcpy(p17->netmask, NETMASK, 4);
}

void initXisprc18(int rec)
{
	int i;
	xisprc_t17 *p17 = &(orc.opts17[rec]);
	xisprc_t18 *p18 = &(nrc.opts18[rec]);

	strcpy(p18->descr, p17->descr);
	p18->autoRedial = p17->autoRedial;
	strcpy(p18->account, p17->account);
	memcpy(p18->passwd, p17->passwd, OLD_MAXLEN_PASSWD);
	p18->maxAttempts = p17->maxAttempts;
	p18->sleepDelay = p17->sleepDelay;
	p18->numPhones = p17->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p18->phone[i], p17->phone[i]);
	p18->numSlines = p17->numSlines;
	for (i=0; i<OLD_MAXNUM_SLINES; i++)
		strcpy(p18->sline[i], p17->sline[i]);
	strcpy(p18->modemDevice, p17->modemDevice);
	p18->modemSpeed = p17->modemSpeed;
	strcpy(p18->modemInit, p17->modemInit);
	p18->operOpts = p17->operOpts;
	p18->compLevel = p17->compLevel;
	strcpy(p18->asyncmap, PPPD_SASYNCMAP);
	strcpy(p18->escape, PPPD_ESCAPE);
	memcpy(p18->localIP, LOCAL_IP, 4);
	memcpy(p18->remoteIP, REMOTE_IP, 4);
	memcpy(p18->netmask, NETMASK, 4);
	p18->mtu = MTU;
	p18->mru = MRU;
}

void initXisprc19(int rec)
{
	int i;
	xisprc_t18 *p18 = &(orc.opts18[rec]);
	xisprc_t19 *p19 = &(nrc.opts19[rec]);
	char *p1, *p2, *pq;

	strcpy(p19->descr, p18->descr);
	p19->autoRedial = p18->autoRedial;
	strcpy(p19->account, p18->account);
	memcpy(p19->passwd, p18->passwd, OLD_MAXLEN_PASSWD);
	p19->maxAttempts = p18->maxAttempts;
	p19->sleepDelay = p18->sleepDelay;
	p19->numPhones = p18->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p19->phone[i], p18->phone[i]);
	p19->numSlines = p18->numSlines;
	for (i=0; i<p18->numSlines; i++) {
		p1 = p18->sline[i];
		p2 = strchr(p1, ' ');
		if (p2 < (pq = strchr(p1+1, '\'')))
			p2 = strchr(pq, ' ');
		*p2 = 0; ++p2;
		if (*p1 == '\'')
			++p1;
		if (*(p1+strlen(p1)-1) == '\'')
			*(p1+strlen(p1)-1) = 0;
		if (*p2 == '\'')
			++p2;
		if (*(p2+strlen(p2)-1) == '\'')
			*(p2+strlen(p2)-1) = 0;
		strcpy(p19->sline[i], p1);
		strcpy(p19->sline[OLD_MAXNUM_SLINES+i], p2);
	}
	strcpy(p19->modemDevice, p18->modemDevice);
	p19->modemSpeed = p18->modemSpeed;
	strcpy(p19->modemInit, p18->modemInit);
	p19->operOpts = p18->operOpts;
	p19->compLevel = p18->compLevel;
	strcpy(p19->asyncmap, p18->asyncmap);
	strcpy(p19->escape, p18->escape);
	memcpy(p19->localIP, p18->localIP, 4);
	memcpy(p19->remoteIP, p18->remoteIP, 4);
	memcpy(p19->netmask, p18->netmask, 4);
	p19->mtu = p18->mtu;
	p19->mru = p18->mru;
}

void initXisprc20(int rec)
{
	int i;
	xisprc_t19 *p19 = &(orc.opts19[rec]);
	xisprc_t20 *p20 = &(nrc.opts20[rec]);

	strcpy(p20->descr, p19->descr);
	strcpy(p20->account, p19->account);
	memcpy(p20->passwd, p19->passwd, OLD_MAXLEN_PASSWD);
	p20->maxAttempts = p19->maxAttempts;
	p20->sleepDelay = p19->sleepDelay;
	p20->numPhones = p19->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p20->phone[i], p19->phone[i]);
	p20->numSlines = p19->numSlines;
	for (i=0; i<(2*OLD_MAXNUM_SLINES); i++)
		strcpy(p20->sline[i], p19->sline[i]);
	strcpy(p20->modemDevice, p19->modemDevice);
	p20->modemSpeed = p19->modemSpeed;
	strcpy(p20->modemInit, p19->modemInit);
	p20->operOpts = p19->operOpts;
	if (p19->autoRedial)
		p20->operOpts |= AUTO_REDIAL;
	p20->compLevel = p19->compLevel;
	if ( (p20->operOpts & HW_FLOWCTRL) &&
		 ! strcmp(p19->asyncmap, PPPD_SASYNCMAP))
		strcpy(p20->asyncmap, PPPD_HASYNCMAP);
	else
		strcpy(p20->asyncmap, p19->asyncmap);
	strcpy(p20->escape, p19->escape);
	memcpy(p20->localIP, p19->localIP, 4);
	memcpy(p20->remoteIP, p19->remoteIP, 4);
	memcpy(p20->netmask, p19->netmask, 4);
	p20->mtu = p19->mtu;
	p20->mru = p19->mru;
}

void initXisprc21(int rec)
{
	int i;
	xisprc_t20 *p20 = &(orc.opts20[rec]);
	xisprc_t21 *p21 = &(nrc.opts21[rec]);

	strcpy(p21->descr, p20->descr);
	strcpy(p21->account, p20->account);
	memcpy(p21->passwd, p20->passwd, OLD_MAXLEN_PASSWD);
	p21->name[0] = 0;
	p21->rname[0] = 0;
	p21->maxAttempts = p20->maxAttempts;
	p21->sleepDelay = p20->sleepDelay;
	p21->connectWait = MAXSEC_CNWAIT;
	p21->numPhones = p20->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p21->phone[i], p20->phone[i]);
	p21->numSlines = p20->numSlines;
	for (i=0; i<(2*OLD_MAXNUM_SLINES); i++)
		strcpy(p21->sline[i], p20->sline[i]);
	p21->CBDelay = MAXSEC_CBDELAY;
	p21->numCBSlns = p20->numCBSlns;
	for (i=0; i<(2*OLD_MAXNUM_SLINES); i++)
		strcpy(p21->CBsln[i], p20->CBsln[i]);
	strcpy(p21->modemDevice, p20->modemDevice);
	p21->modemSpeed = p20->modemSpeed;
	strcpy(p21->modemReset, MODEM_RESET);
	strcpy(p21->modemInit, p20->modemInit);
	p21->operOpts = p20->operOpts;
	p21->compLevel = p20->compLevel;
	strcpy(p21->asyncmap, p20->asyncmap);
	strcpy(p21->escape, p20->escape);
	memcpy(p21->localIP, p20->localIP, 4);
	memcpy(p21->remoteIP, p20->remoteIP, 4);
	memcpy(p21->netmask, p20->netmask, 4);
	memcpy(p21->dns1, DNS, 4);
	memcpy(p21->dns2, DNS, 4);
	p21->mtu = p20->mtu;
	p21->mru = p20->mru;
}

void initXisprc22(int rec)
{
	int i;
	xisprc_t21 *p21 = &(orc.opts21[rec]);
	xisprc_t22 *p22 = &(nrc.opts22[rec]);

	strcpy(p22->descr, p21->descr);
	strcpy(p22->account, p21->account);
	memcpy(p22->passwd, p21->passwd, OLD_MAXLEN_PASSWD);
	strcpy(p22->name, p21->name);
	strcpy(p22->rname, p21->rname);
	p22->maxAttempts = p21->maxAttempts;
	p22->sleepDelay = p21->sleepDelay;
	p22->connectWait = p21->connectWait;
	p22->numPhones = p21->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p22->phone[i], p21->phone[i]);
	p22->numSlines = p21->numSlines;
	for (i=0; i<(2*OLD_MAXNUM_SLINES); i++)
		strcpy(p22->sline[i], p21->sline[i]);
	p22->CBDelay = p21->CBDelay;
	p22->numCBSlns = p21->numCBSlns;
	for (i=0; i<(2*OLD_MAXNUM_SLINES); i++)
		strcpy(p22->CBsln[i], p21->CBsln[i]);
	strcpy(p22->modemDevice, p21->modemDevice);
	p22->modemSpeed = p21->modemSpeed;
	strcpy(p22->modemReset, p21->modemReset);
	strcpy(p22->modemInit, p21->modemInit);
	p22->operOpts = p21->operOpts;
	p22->compLevel = p21->compLevel;
	strcpy(p22->asyncmap, p21->asyncmap);
	strcpy(p22->escape, p21->escape);
	memcpy(p22->localIP, p21->localIP, 4);
	memcpy(p22->remoteIP, p21->remoteIP, 4);
	memcpy(p22->netmask, p21->netmask, 4);
	memcpy(p22->dns1, p21->dns1, 4);
	memcpy(p22->dns2, p21->dns2, 4);
	p22->mtu = p21->mtu;
	p22->mru = p21->mru;
}

void initXisprc23(int rec)
{
	int i, todo;
	char *p, new[2] = "PU";
	xisprc_t22 *p22 = &(orc.opts22[rec]);
	xisprc_t23 *p23 = &(nrc.opts23[rec]);

	strcpy(p23->descr, p22->descr);
	strcpy(p23->account, p22->account);
	memcpy(p23->passwd, p22->passwd, OLD_MAXLEN_PASSWD);
	strcpy(p23->name, p22->name);
	strcpy(p23->rname, p22->rname);
	p23->maxAttempts = p22->maxAttempts;
	p23->sleepDelay = p22->sleepDelay;
	p23->connectWait = p22->connectWait;
	p23->numPhones = p22->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p23->phone[i], p22->phone[i]);
	p23->numSlines = p22->numSlines;
	for (i=0, todo=2; i<(2*OLD_MAXNUM_SLINES); i++) {
		strcpy(p23->sline[i], p22->sline[i]);
		if (todo && (p=strstr(p23->sline[i], "%s")) != NULL) {
			*(p+1) = new[todo-1];
			--todo;
		}
	}
	p23->CBDelay = p22->CBDelay;
	p23->numCBSlns = p22->numCBSlns;
	for (i=0, todo=2; i<(2*OLD_MAXNUM_SLINES); i++) {
		strcpy(p23->CBsln[i], p22->CBsln[i]);
		if (todo && (p=strstr(p23->CBsln[i], "%s")) != NULL) {
			*(p+1) = new[todo-1];
			--todo;
		}
	}
	strcpy(p23->modemDevice, p22->modemDevice);
	p23->modemSpeed = p22->modemSpeed;
	strcpy(p23->modemReset, p22->modemReset);
	strcpy(p23->modemInit, p22->modemInit);
	p23->operOpts = p22->operOpts;
	strcpy(p23->dialExtra, DIAL_EXTRA);
	p23->compLevel = p22->compLevel;
	strcpy(p23->asyncmap, p22->asyncmap);
	strcpy(p23->escape, p22->escape);
	memcpy(p23->localIP, p22->localIP, 4);
	memcpy(p23->remoteIP, p22->remoteIP, 4);
	memcpy(p23->netmask, p22->netmask, 4);
	memcpy(p23->dns1, p22->dns1, 4);
	memcpy(p23->dns2, p22->dns2, 4);
	p23->mtu = p22->mtu;
	p23->mru = p22->mru;
}

void initXisprc24(int rec)
{
	int i;
	xisprc_t23 *p23 = &(orc.opts23[rec]);
	xisprc_t24 *p24 = &(nrc.opts24[rec]);

	strcpy(p24->descr, p23->descr);
	strcpy(p24->account, p23->account);
	memcpy(p24->passwd, p23->passwd, OLD_MAXLEN_PASSWD);
	strcpy(p24->name, p23->name);
	strcpy(p24->rname, p23->rname);
	p24->maxAttempts = p23->maxAttempts;
	p24->sleepDelay = p23->sleepDelay;
	p24->connectWait = p23->connectWait;
	p24->numPhones = p23->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p24->phone[i], p23->phone[i]);
	p24->numSlines = p23->numSlines;
	for (i=0; i<(2*OLD_MAXNUM_SLINES); i++)
		strcpy(p24->sline[i], p23->sline[i]);
	p24->CBDelay = p23->CBDelay;
	p24->numCBSlns = p23->numCBSlns;
	for (i=0; i<(2*OLD_MAXNUM_SLINES); i++)
		strcpy(p24->CBsln[i], p23->CBsln[i]);
	p24->termW = TERMW;
	p24->termH = TERMH;
	strcpy(p24->modemDevice, p23->modemDevice);
	p24->modemSpeed = p23->modemSpeed;
	strcpy(p24->modemReset, p23->modemReset);
	strcpy(p24->modemInit, p23->modemInit);
	p24->operOpts = p23->operOpts;
	strcpy(p24->dialExtra, p23->dialExtra);
	p24->compLevel = p23->compLevel;
	strcpy(p24->asyncmap, p23->asyncmap);
	strcpy(p24->escape, p23->escape);
	memcpy(p24->localIP, p23->localIP, 4);
	memcpy(p24->remoteIP, p23->remoteIP, 4);
	memcpy(p24->netmask, p23->netmask, 4);
	memcpy(p24->dns1, p23->dns1, 4);
	memcpy(p24->dns2, p23->dns2, 4);
	p24->mtu = p23->mtu;
	p24->mru = p23->mru;
}

void initXisprc25(int rec)
{
	int i;
	xisprc_t24 *p24 = &(orc.opts24[rec]);
	xisprc_t25 *p25 = &(nrc.opts25[rec]);

	strcpy(p25->descr, p24->descr);
	strcpy(p25->account, p24->account);
	memcpy(p25->passwd, p24->passwd, OLD_MAXLEN_PASSWD);
	strcpy(p25->name, p24->name);
	strcpy(p25->rname, p24->rname);
	p25->maxAttempts = p24->maxAttempts;
	p25->sleepDelay = p24->sleepDelay;
	p25->connectWait = p24->connectWait;
	p25->numPhones = p24->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p25->phone[i], p24->phone[i]);
	p25->numSlines = p24->numSlines;
	for (i=0; i<OLD_MAXNUM_SLINES; i++) {
		strcpy(p25->sline[i], p24->sline[i]);
		strcpy(p25->sline[MAXNUM_SLINES+i], p24->sline[OLD_MAXNUM_SLINES+i]);
	}
	for (; i<MAXNUM_SLINES; i++)
		p25->sline[i][0] = p25->sline[MAXNUM_SLINES+i][0] = 0;
	p25->CBDelay = p24->CBDelay;
	p25->numCBSlns = p24->numCBSlns;
	for (i=0; i<OLD_MAXNUM_SLINES; i++) {
		strcpy(p25->CBsln[i], p24->CBsln[i]);
		strcpy(p25->CBsln[MAXNUM_SLINES+i], p24->CBsln[OLD_MAXNUM_SLINES+i]);
	}
	for (; i<MAXNUM_SLINES; i++)
		p25->CBsln[i][0] = p25->CBsln[MAXNUM_SLINES+i][0] = 0;
	p25->termW = TERMW;
	p25->termH = TERMH;
	strcpy(p25->modemDevice, p24->modemDevice);
	p25->modemSpeed = p24->modemSpeed;
	strcpy(p25->modemReset, p24->modemReset);
	strcpy(p25->modemInit, p24->modemInit);
	strcpy(p25->modemConnect, MODEM_CONNECT);
	p25->operOpts = p24->operOpts;
	strcpy(p25->dialExtra, p24->dialExtra);
	p25->compLevel = p24->compLevel;
	strcpy(p25->asyncmap, p24->asyncmap);
	strcpy(p25->escape, p24->escape);
	memcpy(p25->localIP, p24->localIP, 4);
	memcpy(p25->remoteIP, p24->remoteIP, 4);
	memcpy(p25->netmask, p24->netmask, 4);
	memcpy(p25->dns1, p24->dns1, 4);
	memcpy(p25->dns2, p24->dns2, 4);
	p25->mtu = p24->mtu;
	p25->mru = p24->mru;
}

void initXisprc26(int rec)
{
	int i;
	xisprc_t25 *p25 = &(orc.opts25[rec]);
	xisprc_t26 *p26 = &(nrc.opts26[rec]);
	unsigned char ep[MAXLEN_PASSWD+1] = {0},
				  pp[MAXLEN_PASSWD+1] = {0};

	strcpy(p26->descr, p25->descr);
	strcpy(p26->account, p25->account);

	if (p25->passwd[0]) {
		pencode(ep, pp);
		memcpy(ep, p25->passwd, OLD_MAXLEN_PASSWD);
	}
	memcpy(p26->passwd, ep, MAXLEN_PASSWD);

	strcpy(p26->name, p25->name);
	strcpy(p26->rname, p25->rname);
	p26->maxAttempts = p25->maxAttempts;
	p26->sleepDelay = p25->sleepDelay;
	p26->connectWait = p25->connectWait;
	p26->numPhones = p25->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p26->phone[i], p25->phone[i]);
	p26->numSlines = p25->numSlines;
	for (i=0; i<MAXNUM_SLINES; i++) {
		strcpy(p26->sline[i], p25->sline[i]);
		strcpy(p26->sline[MAXNUM_SLINES+i], p25->sline[MAXNUM_SLINES+i]);
	}
	p26->CBDelay = p25->CBDelay;
	p26->numCBSlns = p25->numCBSlns;
	for (i=0; i<MAXNUM_SLINES; i++) {
		strcpy(p26->CBsln[i], p25->CBsln[i]);
		strcpy(p26->CBsln[MAXNUM_SLINES+i], p25->CBsln[MAXNUM_SLINES+i]);
	}
	p26->termW = p25->termW;
	p26->termH = p25->termH;
	p26->CBtermW = TERMW;
	p26->CBtermH = TERMH;
	p26->CBphone[0] = 0;
	strcpy(p26->modemDevice, p25->modemDevice);
	p26->modemSpeed = p25->modemSpeed;
	strcpy(p26->modemReset, p25->modemReset);
	strcpy(p26->modemInit, p25->modemInit);
	strcpy(p26->modemConnect, p25->modemConnect);
	p26->operOpts = p25->operOpts;
	strcpy(p26->dialExtra, p25->dialExtra);
	p26->compLevel = p25->compLevel;
	strcpy(p26->asyncmap, p25->asyncmap);
	strcpy(p26->escape, p25->escape);
	memcpy(p26->localIP, p25->localIP, 4);
	memcpy(p26->remoteIP, p25->remoteIP, 4);
	memcpy(p26->netmask, p25->netmask, 4);
	memcpy(p26->dns1, p25->dns1, 4);
	memcpy(p26->dns2, p25->dns2, 4);
	p26->mtu = p25->mtu;
	p26->mru = p25->mru;
}

unsigned int speed_mask2uint(unsigned char mask)
{
	static unsigned int suint[8] =
							{1200,2400,4800,9600,19200,38400,57600,115200};
	static int smask[8] = {0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};
	int i;

	for (i=0; i<8; i++)
		if (mask & smask[i])
			return suint[i];
	return 0;
}

void initXisprc27(int rec)
{
	int i;
	xisprc_t26 *p26 = &(orc.opts26[rec]);
	xisprc_t27 *p27 = &(nrc.opts27[rec]);
	glob_t26 *g26 = &(ogl.glob26);

	strcpy(p27->descr, p26->descr);
	strcpy(p27->account, p26->account);
	memcpy(p27->passwd, p26->passwd, MAXLEN_PASSWD);
	strcpy(p27->name, p26->name);
	strcpy(p27->rname, p26->rname);
	p27->maxAttempts = p26->maxAttempts;
	p27->sleepDelay = p26->sleepDelay;
	p27->connectWait = p26->connectWait;
	p27->LCPWait = MAXSEC_LCPWAIT;
	p27->numPhones = p26->numPhones;
	for (i=0; i<MAXNUM_TELS; i++)
		strcpy(p27->phone[i], p26->phone[i]);
	p27->numSlines = p26->numSlines;
	for (i=0; i<MAXNUM_SLINES; i++) {
		strcpy(p27->sline[i], p26->sline[i]);
		strcpy(p27->sline[MAXNUM_SLINES+i], p26->sline[MAXNUM_SLINES+i]);
	}
	p27->CBDelay = p26->CBDelay;
	p27->numCBSlns = p26->numCBSlns;
	for (i=0; i<MAXNUM_SLINES; i++) {
		strcpy(p27->CBsln[i], p26->CBsln[i]);
		strcpy(p27->CBsln[MAXNUM_SLINES+i], p26->CBsln[MAXNUM_SLINES+i]);
	}
	p27->termW = p26->termW;
	p27->termH = p26->termH;
	p27->CBtermW = TERMW;
	p27->CBtermH = TERMH;
	p27->CBphone[0] = 0;
	strcpy(p27->modemDevice, p26->modemDevice);
	p27->modemSpeed = speed_mask2uint(p26->modemSpeed);
	strcpy(p27->modemReset, p26->modemReset);
	strcpy(p27->modemInit, p26->modemInit);
	strcpy(p27->modemConnect, p26->modemConnect);
	p27->operOpts = p26->operOpts;
	strcpy(p27->dialExtra, p26->dialExtra);
	p27->compLevel = p26->compLevel;
	strcpy(p27->asyncmap, p26->asyncmap);
	strcpy(p27->escape, p26->escape);
	memcpy(p27->localIP, p26->localIP, 4);
	memcpy(p27->remoteIP, p26->remoteIP, 4);
	memcpy(p27->netmask, p26->netmask, 4);
	memcpy(p27->dns1, p26->dns1, 4);
	memcpy(p27->dns2, p26->dns2, 4);
	p27->mtu = p26->mtu;
	p27->mru = p26->mru;
	memset(p27->domainname, 0, MAXLEN_DNNAME);
	p27->ispPTT = g26->dfltPTT;
	p27->ispZone = g26->dfltZone;
}

void initGlobal22(void)
{
	glob_t22 *g22 = &(ngl.glob22);

	g22->dfltISP = 1;
}

void initGlobal23(void)
{
	glob_t22 *g22 = &(ogl.glob22);
	glob_t23 *g23 = &(ngl.glob23);

	g23->dfltISP = g22->dfltISP;
	g23->dfltPTT = PTT_GR;
	g23->dfltZone = 0;
	g23->logOpts = LOG_NONE;
}

void initGlobal24(void)
{
	glob_t23 *g23 = &(ogl.glob23);
	glob_t24 *g24 = &(ngl.glob24);
	xisprc_t24 *p24;
	int i;

	g24->numISPs = 0;
	for (i=0; i<OLD_MAXNUM_ISP; i++) {
		p24 = &(nrc.opts24[i]);
		if (*(p24->descr)) g24->numISPs += 1;
		else break;
	}
	g24->dfltISP = g23->dfltISP;
	g24->numPTTs = MAXNUM_PTT;
	g24->dfltPTT = g23->dfltPTT;
	g24->dfltZone = g23->dfltZone;
	g24->logOpts = g23->logOpts;
	strcpy(g24->pppdPath, PPPD_PATH);
	strcpy(g24->runPath, RUN_PATH);
	strcpy(g24->chatPath, CHAT_PATH);
	strcpy(g24->utilsPath, UTILS_PATH);
	strcpy(g24->pipePath, PIPE_PATH);
}

void initGlobal25(void)
{
	ngl.glob24 = ogl.glob24;
}

void initGlobal26(void)
{
	glob_t24 *g24 = &(ogl.glob24);
	glob_t26 *g26 = &(ngl.glob26);

	g26->numISPs = g24->numISPs;
	g26->dfltISP = g24->dfltISP;
	g26->numPTTs = MAXNUM_PTT;
	g26->dfltPTT = PTTxlate26[g24->dfltPTT];
	g26->dfltZone = g24->dfltZone;
	g26->logOpts = (unsigned short) g24->logOpts;
	strcpy(g26->pppdPath, g24->pppdPath);
	strcpy(g26->runPath, g24->runPath);
	strcpy(g26->chatPath, g24->chatPath);
	strcpy(g26->utilsPath, g24->utilsPath);
	strcpy(g26->pipePath, g24->pipePath);
}

void initGlobal27(void)
{
	glob_t26 *g26 = &(ogl.glob26);
	glob_t27 *g27 = &(ngl.glob27);

	g27->numISPs = g26->numISPs;
	g27->dfltISP = g26->dfltISP;
	g27->numPTTs = MAXNUM_PTT;
	g27->costPTT = g26->dfltPTT;
	g27->logOpts = g26->logOpts | LOG_HINTS;
	strcpy(g27->pppdPath, g26->pppdPath);
	strcpy(g27->runPath, g26->runPath);
	strcpy(g27->lockPath, LOCK_PATH);
	strcpy(g27->chatPath, g26->chatPath);
	strcpy(g27->utilsPath, g26->utilsPath);
	strcpy(g27->pipePath, g26->pipePath);
}

void (* initrc[MAXNUM_VERSIONS])(int) = {initXisprc13, initXisprc14,
										 initXisprc15, initXisprc16,
										 initXisprc17, initXisprc18,
										 initXisprc19, initXisprc20,
										 initXisprc21, initXisprc22,
										 initXisprc23, initXisprc24,
										 initXisprc25, initXisprc26,
										 initXisprc27, NULL};

void (* initg[MAXNUM_VERSIONS])(void) = {NULL, NULL, NULL, NULL,
										 NULL, NULL, NULL, NULL,
										 NULL,         initGlobal22,
										 initGlobal23, initGlobal24,
										 initGlobal25, initGlobal26,
										 initGlobal27, NULL};

static unsigned char *passwd2ascii(unsigned char *pwd)
{
	static unsigned char apwd[2*MAXLEN_PASSWD+1];
	unsigned char up, lp, *p;
	int i;

	for (i=0, p=apwd; i<MAXLEN_PASSWD; i++, pwd++) {
		lp = *pwd & 0x03F;
		*p++ = lp + 33;
		up = (*pwd & 0x0FC) >> 2;
		*p++ = up + 161;
	}
	*p = 0;
	return apwd;
}

char *IP2str(unsigned char *ip)
{
	static char IPstr[16];

	sprintf(IPstr, "%u.%u.%u.%u",
			ip[0],ip[1],ip[2],ip[3]);
	return IPstr;
}

char *oldascii2passwd(unsigned char *buf)
{
	static unsigned char pwd[MAXLEN_PASSWD+1];
	unsigned char msh, lsh, *p;
	int i = 0;

	if (*buf) {
		for (p=pwd; i<MAXLEN_PASSWD; i++) {
			lsh = (*buf++ - 'A') & 0x0F;
			msh = (*buf++ - 'A') & 0x0F;
			pwd[i] = (msh << 4) | lsh;
		}
	}
	pwd[i] = 0;
	return pwd;
}

unsigned int str2speed(char *buf)
{
	static char sstr[8][8] = {"1200","2400","4800","9600",
							  "19200","38400","57600","115200"};
	static int snum[8] = {0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};
	int i;

	for (i=0; i<8; i++)
		if (strcmp(buf, sstr[i]) == 0)
			return snum[i];
	return 0;
}

unsigned char *str2IP(char *buf)
{
	static unsigned char ip[4];
	unsigned int iip[4];
	int i;

	i = sscanf(buf, "%3u.%3u.%3u.%3u", &iip[0],
			   &iip[1], &iip[2], &iip[3]);
	if (i < 4)
		return NULL;
	for (i=0; i<4; i++)
		ip[i] = iip[i];
	return ip;
}

void rcISP(FILE *fp, int nISP)
{
	int n;

	if (fscanf(fp, "-%3d- ", &n) < 1) {
		fprintf(stderr, "xisprccv: rcISP: error reading ISP number in %s\n",
				nrcfname);
		exit(1);
	}
	if (n != nISP) {
		fprintf(stderr, "xisprccv: rcISP: ISP sequence number wrong in %s\n",
				nrcfname);
		fprintf(stderr, "xisprccv: rcISP: expected %d, got %d\n", nISP, n);
		exit(1);
	}
}

void rcLineError(char *function, char *line)
{
	fprintf(stderr, "xisprccv: %s: error reading %s\n", function, nrcfname);
	fprintf(stderr, "xisprccv: %s: offending line: [%s]\n", function, line);
	exit(1);
}

#define MAXLEN_LINE 512
#define MAXLEN_PARAM 256

char *readParm21(FILE *fp, char *name, char type,
				 int llimit, int ulimit, void *data)
{
	static char line[MAXLEN_LINE];
	char sparam[MAXLEN_PARAM] = {0}, *p, *endp;
	int iparam, hex = 0, len;

	if (fgets(line, MAXLEN_LINE, fp) == NULL) {
		fprintf(stderr, "xisprccv: readParm21: %s: premature EOF\n", nrcfname);
		exit(1);
	}
	line[strlen(line)-1] = 0;
	if ((p=strchr(line,':')) == NULL)
		rcLineError("readParm21", line);
	if (strncmp(name, line, (int)(p-line))) {
		fprintf(stderr, "xisprccv: readParm21: expected [%s], got [%s]\n",
				name, line);
		exit(1);
	}
	for (++p; *p==' '; p++);
	strncpy(sparam, p, sizeof(sparam)-1);
	switch (type) {
		case 'S':
			len = strlen(sparam);
			if (ulimit<len || len<llimit)
				rcLineError("readParm21", line);
			strcpy((char *)data, sparam);
			break;

		case 'X':
			hex = 1;
		case 'B':
		case 'I':
			iparam = strtol(sparam, &endp, (hex)? 16:10);
			if ((!hex && (ulimit<iparam || iparam<llimit)) ||
				 endp == sparam || *endp )
				rcLineError("readParm21", line);
			if (type == 'B') *((unsigned char *)data) = iparam;
			else if (type == 'X') *((unsigned short *)data) = iparam;
			else if (type == 'I') *((unsigned int *)data) = iparam;
			break;

		default: break;
	}
	return(line);
}

char *readParm22(FILE *fp, char *name, char type,
				 int llimit, int ulimit, void *data)
{
	static char line[MAXLEN_LINE];
	char sparam[MAXLEN_PARAM] = {0}, *p, *endp;
	int iparam, hex = 0, len;

	if (fgets(line, MAXLEN_LINE, fp) == NULL) {
		fprintf(stderr, "xisprccv: readParm22: %s: premature EOF\n", nrcfname);
		exit(1);
	}
	line[strlen(line)-1] = 0;
	if ((p=strchr(line,':')) == NULL)
		rcLineError("readParm22", line);
	if (strncmp(name, line, (int)(p-line))) {
		fprintf(stderr, "xisprccv: readParm22: expected [%s], got [%s]\n",
				name, line);
		exit(1);
	}
	for (++p; *p==' '; p++);
	strncpy(sparam, p, sizeof(sparam)-1);
	switch (type) {
		case 'S':
			len = strlen(sparam);
			if (ulimit<len || len<llimit)
				rcLineError("readParm22", line);
			strcpy((char *)data, sparam);
			break;

		case 'X':
			hex = 1;
		case 'B':
		case 'I':
			iparam = strtol(sparam, &endp, (hex)? 16:10);
			if ((!hex && (ulimit<iparam || iparam<llimit)) ||
				 endp == sparam || *endp )
				rcLineError("readParm22", line);
			if (type == 'B') *((unsigned char *)data) = iparam;
			else *((unsigned int *)data) = iparam;
			break;

		default: break;
	}
	return(line);
}

char *readParm26(FILE *fp, char *name, char type,
				 int llimit, int ulimit, void *data)
{
	static char line[MAXLEN_LINE];
	char sparam[MAXLEN_PARAM] = {0}, *p, *endp;
	long iparam;
	int len, hex = 0;

	if (fgets(line, MAXLEN_LINE, fp) == NULL) {
		fprintf(stderr, "xisprccv: readParm26: %s: premature EOF\n", nrcfname);
		exit(1);
	}
	line[strlen(line)-1] = 0;
	if ((p=strchr(line,':')) == NULL)
		rcLineError("readParm26", line);
	if (strncmp(name, line, (int)(p-line))) {
		fprintf(stderr, "xisprccv: readParm26: expected [%s], got [%s]\n",
				name, line);
		exit(1);
	}
	for (++p; *p==' '; p++);
	strncpy(sparam, p, sizeof(sparam)-1);
	switch (type) {
		case 'S':
			len = strlen(sparam);
			if (ulimit<len || len<llimit)
				rcLineError("readParm26", line);
			strcpy((char *)data, sparam);
			break;

		case 'X':
		case 'L':
			hex = 1;
		case 'B':
		case 'I':
			iparam = strtol(sparam, &endp, (hex)? 16:10);
			if (hex) {
				if (type == 'X') *((unsigned short *)data) = iparam;
				else *((unsigned long *)data) = iparam;
			}
			else {
				if (ulimit<iparam || iparam<llimit || endp == sparam || *endp)
					rcLineError("readParm26", line);
				if (type == 'B') *((unsigned char *)data) = iparam;
				else *((unsigned int *)data) = iparam;
			}
			break;

		default: break;
	}
	return(line);
}

void inputAllXisprc20(xisprc_ut *up, FILE *rcfp, glob_ut *ug)
{
	int i, j, n;
	char buf[2*OLD_MAXLEN_PASSWD+1], pname[32] = {0}, *line;
	unsigned char *ipp;
	xisprc_t20 *p = &(up->opts20[0]);
	glob_t22 *g;

	g = &(ug->glob22);
	fgets(buf, 2*OLD_MAXLEN_PASSWD-1, rcfp);
	for (i=0; i<OLD_MAXNUM_ISP; i++, p++) {
		rcISP(rcfp, i);
		readParm21(rcfp, "DESCR", 'S', 0, MAXLEN_DESCR, p->descr);
		readParm21(rcfp, "ACCOUNT", 'S', 0, OLD_MAXLEN_ACCOUNT, p->account);
		if (! *(p->account))
			n = 0;
		else
			n = 2*OLD_MAXLEN_PASSWD;
		readParm21(rcfp, "PASSWD", 'S', n, n, buf);
		memcpy(p->passwd, oldascii2passwd((unsigned char *)buf), OLD_MAXLEN_PASSWD);
		readParm21(rcfp, "MAXATTEMPTS", 'B', 0, 255, &(p->maxAttempts));
		readParm21(rcfp, "SLEEPDELAY", 'B', 0, 255, &(p->sleepDelay));
		readParm21(rcfp, "NUMPHONES", 'B', 0, MAXNUM_TELS, &(p->numPhones));
		for (j=0; j<p->numPhones; j++) {
			sprintf(pname, " PHONE%d", j);
			readParm21(rcfp, pname, 'S', 1, MAXLEN_PHONE, p->phone[j]);
		}
		readParm21(rcfp, "NUMSLINES", 'B', 0, OLD_MAXNUM_SLINES, &(p->numSlines));
		for (j=0; j<p->numSlines; j++) {
			sprintf(pname, " SLINE%dE", j);
			readParm21(rcfp, pname, 'S', 1, OLD_MAXLEN_SLINE, p->sline[j]);
			sprintf(pname, " SLINE%dS", j);
			readParm21(rcfp, pname, 'S', 1, OLD_MAXLEN_SLINE,
					  p->sline[OLD_MAXNUM_SLINES+j]);
		}
		readParm21(rcfp, "NUMCBSLINES", 'B',0, OLD_MAXNUM_SLINES, &(p->numCBSlns));
		for (j=0; j<p->numCBSlns; j++) {
			sprintf(pname, " CBSLINE%dE", j);
			readParm21(rcfp, pname, 'S', 1, OLD_MAXLEN_SLINE, p->CBsln[j]);
			sprintf(pname, " CBSLINE%dS", j);
			readParm21(rcfp, pname, 'S', 1, OLD_MAXLEN_SLINE,
					  p->CBsln[OLD_MAXNUM_SLINES+j]);
		}
		readParm21(rcfp, "MODEMDEVICE", 'S', 1, OLD_MAXLEN_DEVICE, p->modemDevice);
		line = readParm21(rcfp, "MODEMSPEED", 'S', 4, 6, buf);
		if (! (n=str2speed(buf)))
			rcLineError("inputAllXisprc", line);
		p->modemSpeed = n;
		readParm21(rcfp, "MODEMINIT", 'S', 0, MAXLEN_MDMCMD, p->modemInit);
		readParm21(rcfp, "OPEROPTS", 'X', 0, 0, &(p->operOpts));
		readParm21(rcfp, "COMPLEVEL", 'B', 9, 15, &(p->compLevel));
		readParm21(rcfp, "ASYNCMAP", 'S', 2, MAXDIG_ASYNCMAP, p->asyncmap);
		readParm21(rcfp, "ESCAPE", 'S', 0, MAXLEN_ESCAPE, p->escape);
		line = readParm21(rcfp, "LOCALIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->localIP, ipp, 4);
		line = readParm21(rcfp, "REMOTEIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->remoteIP, ipp, 4);
		line = readParm21(rcfp, "NETMASK", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->netmask, ipp, 4);
		readParm21(rcfp, "MTU", 'I', 48, 1500, &(p->mtu));
		readParm21(rcfp, "MRU", 'I', 48, 1500, &(p->mru));
	}
}

void inputAllXisprc21(xisprc_ut *up, FILE *rcfp, glob_ut *ug)
{
	int i, j, n;
	char buf[2*OLD_MAXLEN_PASSWD+1], pname[32] = {0}, *line;
	unsigned char *ipp;
	xisprc_t21 *p = &(up->opts21[0]);
	glob_t22 *g;

	g = &(ug->glob22);
	fgets(buf, 2*OLD_MAXLEN_PASSWD-1, rcfp);
	for (i=0; i<OLD_MAXNUM_ISP; i++, p++) {
		rcISP(rcfp, i);
		readParm21(rcfp, "DESCR", 'S', 0, MAXLEN_DESCR, p->descr);
		readParm21(rcfp, "ACCOUNT", 'S', 0, OLD_MAXLEN_ACCOUNT, p->account);
		if (! *(p->account))
			n = 0;
		else
			n = 2*OLD_MAXLEN_PASSWD;
		readParm21(rcfp, "PASSWD", 'S', n, n, buf);
		memcpy(p->passwd, oldascii2passwd((unsigned char *)buf), OLD_MAXLEN_PASSWD);
		readParm21(rcfp, "NAME", 'S', 0, OLD_MAXLEN_UNR, p->name);
		readParm21(rcfp, "REMOTENAME", 'S', 0, OLD_MAXLEN_UNR, p->rname);
		readParm21(rcfp, "MAXATTEMPTS", 'B', 0, 255, &(p->maxAttempts));
		readParm21(rcfp, "SLEEPDELAY", 'B', 0, 255, &(p->sleepDelay));
		readParm21(rcfp, "CONNECTWAIT", 'B', 0, 255, &(p->connectWait));
		readParm21(rcfp, "NUMPHONES", 'B', 0, MAXNUM_TELS, &(p->numPhones));
		for (j=0; j<p->numPhones; j++) {
			sprintf(pname, " PHONE%d", j);
			readParm21(rcfp, pname, 'S', 0, MAXLEN_PHONE, p->phone[j]);
		}
		readParm21(rcfp, "NUMSLINES", 'B', 0, OLD_MAXNUM_SLINES, &(p->numSlines));
		for (j=0; j<p->numSlines; j++) {
			sprintf(pname, " SLINE%dE", j);
			readParm21(rcfp, pname, 'S', 0, OLD_MAXLEN_SLINE, p->sline[j]);
			sprintf(pname, " SLINE%dS", j);
			readParm21(rcfp, pname, 'S', 0, OLD_MAXLEN_SLINE,
					  p->sline[OLD_MAXNUM_SLINES+j]);
		}
		readParm21(rcfp, "CBDELAY", 'B', 0, 255, &(p->CBDelay));
		readParm21(rcfp, "NUMCBSLINES", 'B',0, OLD_MAXNUM_SLINES, &(p->numCBSlns));
		for (j=0; j<p->numCBSlns; j++) {
			sprintf(pname, " CBSLINE%dE", j);
			readParm21(rcfp, pname, 'S', 0, OLD_MAXLEN_SLINE, p->CBsln[j]);
			sprintf(pname, " CBSLINE%dS", j);
			readParm21(rcfp, pname, 'S', 0, OLD_MAXLEN_SLINE,
					  p->CBsln[OLD_MAXNUM_SLINES+j]);
		}
		readParm21(rcfp, "MODEMDEVICE", 'S', 0, OLD_MAXLEN_DEVICE, p->modemDevice);
		line = readParm21(rcfp, "MODEMSPEED", 'S', 4, 6, buf);
		if (! (n=str2speed(buf)))
			rcLineError("inputAllXisprc", line);
		p->modemSpeed = n;
		readParm21(rcfp, "MODEMRESET", 'S', 0, MAXLEN_MDMCMD, p->modemReset);
		readParm21(rcfp, "MODEMINIT", 'S', 0, MAXLEN_MDMCMD, p->modemInit);
		readParm21(rcfp, "OPEROPTS", 'X', 0, 0, &(p->operOpts));
		readParm21(rcfp, "COMPLEVEL", 'B', 9, 15, &(p->compLevel));
		readParm21(rcfp, "ASYNCMAP", 'S', 2, MAXDIG_ASYNCMAP, p->asyncmap);
		readParm21(rcfp, "ESCAPE", 'S', 0, MAXLEN_ESCAPE, p->escape);
		line = readParm21(rcfp, "LOCALIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->localIP, ipp, 4);
		line = readParm21(rcfp, "REMOTEIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->remoteIP, ipp, 4);
		line = readParm21(rcfp, "NETMASK", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->netmask, ipp, 4);
		line = readParm21(rcfp, "DNS1", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->dns1, ipp, 4);
		line = readParm21(rcfp, "DNS2", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->dns2, ipp, 4);
		readParm21(rcfp, "MTU", 'I', 48, 1500, &(p->mtu));
		readParm21(rcfp, "MRU", 'I', 48, 1500, &(p->mru));
	}
}

void inputAllXisprc22(xisprc_ut *up, FILE *rcfp, glob_ut *ug)
{
	int i, j, n;
	char buf[2*OLD_MAXLEN_PASSWD+1], pname[32] = {0}, *line;
	unsigned char *ipp;
	xisprc_t22 *p = &(up->opts22[0]);
	glob_t22 *g = &(ug->glob22);

	fgets(buf, 2*OLD_MAXLEN_PASSWD-1, rcfp);
	readParm22(rcfp, "DEFAULT_ISP", 'B', 0, OLD_MAXNUM_ISP, &(g->dfltISP));
	for (i=0; i<OLD_MAXNUM_ISP; i++, p++) {
		rcISP(rcfp, i);
		readParm22(rcfp, "DESCR", 'S', 0, MAXLEN_DESCR, p->descr);
		readParm22(rcfp, "ACCOUNT", 'S', 0, OLD_MAXLEN_ACCOUNT, p->account);
		if (! *(p->account))
			n = 0;
		else
			n = 2*OLD_MAXLEN_PASSWD;
		readParm22(rcfp, "PASSWD", 'S', n, n, buf);
		memcpy(p->passwd, oldascii2passwd((unsigned char *)buf), OLD_MAXLEN_PASSWD);
		readParm22(rcfp, "NAME", 'S', 0, OLD_MAXLEN_UNR, p->name);
		readParm22(rcfp, "REMOTENAME", 'S', 0, OLD_MAXLEN_UNR, p->rname);
		readParm22(rcfp, "MAXATTEMPTS", 'B', 0, 255, &(p->maxAttempts));
		readParm22(rcfp, "SLEEPDELAY", 'B', 0, 255, &(p->sleepDelay));
		readParm22(rcfp, "CONNECTWAIT", 'B', 0, 255, &(p->connectWait));
		readParm22(rcfp, "NUMPHONES", 'B', 0, MAXNUM_TELS, &(p->numPhones));
		for (j=0; j<p->numPhones; j++) {
			sprintf(pname, " PHONE%d", j);
			readParm22(rcfp, pname, 'S', 0, MAXLEN_PHONE, p->phone[j]);
		}
		readParm22(rcfp, "NUMSLINES", 'B', 0, OLD_MAXNUM_SLINES, &(p->numSlines));
		for (j=0; j<p->numSlines; j++) {
			sprintf(pname, " SLINE%dE", j);
			readParm22(rcfp, pname, 'S', 0, OLD_MAXLEN_SLINE, p->sline[j]);
			sprintf(pname, " SLINE%dS", j);
			readParm22(rcfp, pname, 'S', 0, OLD_MAXLEN_SLINE,
					  p->sline[OLD_MAXNUM_SLINES+j]);
		}
		readParm22(rcfp, "CBDELAY", 'B', 0, 255, &(p->CBDelay));
		readParm22(rcfp, "NUMCBSLINES", 'B',0, OLD_MAXNUM_SLINES, &(p->numCBSlns));
		for (j=0; j<p->numCBSlns; j++) {
			sprintf(pname, " CBSLINE%dE", j);
			readParm22(rcfp, pname, 'S', 0, OLD_MAXLEN_SLINE, p->CBsln[j]);
			sprintf(pname, " CBSLINE%dS", j);
			readParm22(rcfp, pname, 'S', 0, OLD_MAXLEN_SLINE,
					  p->CBsln[OLD_MAXNUM_SLINES+j]);
		}
		readParm22(rcfp, "MODEMDEVICE", 'S', 0, OLD_MAXLEN_DEVICE, p->modemDevice);
		line = readParm22(rcfp, "MODEMSPEED", 'S', 4, 6, buf);
		if (! (n=str2speed(buf)))
			rcLineError("inputAllXisprc", line);
		p->modemSpeed = n;
		readParm22(rcfp, "MODEMRESET", 'S', 0, MAXLEN_MDMCMD, p->modemReset);
		readParm22(rcfp, "MODEMINIT", 'S', 0, MAXLEN_MDMCMD, p->modemInit);
		readParm22(rcfp, "OPEROPTS", 'X', 0, 0, &(p->operOpts));
		readParm22(rcfp, "COMPLEVEL", 'B', 9, 15, &(p->compLevel));
		readParm22(rcfp, "ASYNCMAP", 'S', 2, MAXDIG_ASYNCMAP, p->asyncmap);
		readParm22(rcfp, "ESCAPE", 'S', 0, MAXLEN_ESCAPE, p->escape);
		line = readParm22(rcfp, "LOCALIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->localIP, ipp, 4);
		line = readParm22(rcfp, "REMOTEIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->remoteIP, ipp, 4);
		line = readParm22(rcfp, "NETMASK", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->netmask, ipp, 4);
		line = readParm22(rcfp, "DNS1", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->dns1, ipp, 4);
		line = readParm22(rcfp, "DNS2", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->dns2, ipp, 4);
		readParm22(rcfp, "MTU", 'I', 48, 1500, &(p->mtu));
		readParm22(rcfp, "MRU", 'I', 48, 1500, &(p->mru));
	}
}

void inputAllXisprc23(xisprc_ut *up, FILE *rcfp, glob_ut *ug)
{
	int i, j, n;
	char buf[2*OLD_MAXLEN_PASSWD+1], pname[32] = {0}, *line;
	unsigned char *ipp;
	xisprc_t23 *p = &(up->opts23[0]);
	glob_t23 *g = &(ug->glob23);

	fgets(buf, 2*OLD_MAXLEN_PASSWD-1, rcfp);
	readParm22(rcfp, "DEFAULTISP", 'B', 0, OLD_MAXNUM_ISP, &(g->dfltISP));
	readParm22(rcfp, "QTHPTT", 'B', 0, MAXNUM_PTT, &(g->dfltPTT));
	readParm22(rcfp, "QTHZONE", 'B', 0, MAXNUM_ZONES, &(g->dfltZone));
	readParm22(rcfp, "LOGOPTS", 'X', 0, 0, &(g->logOpts));
	for (i=0; i<OLD_MAXNUM_ISP; i++, p++) {
		rcISP(rcfp, i);
		readParm22(rcfp, "DESCR", 'S', 0, MAXLEN_DESCR, p->descr);
		readParm22(rcfp, "ACCOUNT", 'S', 0, OLD_MAXLEN_ACCOUNT, p->account);
		if (! *(p->account))
			n = 0;
		else
			n = 2*OLD_MAXLEN_PASSWD;
		readParm22(rcfp, "PASSWD", 'S', n, n, buf);
		memcpy(p->passwd, oldascii2passwd((unsigned char *)buf), OLD_MAXLEN_PASSWD);
		readParm22(rcfp, "NAME", 'S', 0, OLD_MAXLEN_UNR, p->name);
		readParm22(rcfp, "REMOTENAME", 'S', 0, OLD_MAXLEN_UNR, p->rname);
		readParm22(rcfp, "MAXATTEMPTS", 'B', 0, 255, &(p->maxAttempts));
		readParm22(rcfp, "SLEEPDELAY", 'B', 0, 255, &(p->sleepDelay));
		readParm22(rcfp, "CONNECTWAIT", 'B', 0, 255, &(p->connectWait));
		readParm22(rcfp, "NUMPHONES", 'B', 0, MAXNUM_TELS, &(p->numPhones));
		for (j=0; j<p->numPhones; j++) {
			sprintf(pname, " PHONE%d", j);
			readParm22(rcfp, pname, 'S', 0, MAXLEN_PHONE, p->phone[j]);
		}
		readParm22(rcfp, "NUMSLINES", 'B', 0, OLD_MAXNUM_SLINES,
				   &(p->numSlines));
		for (j=0; j<p->numSlines; j++) {
			sprintf(pname, " SLINE%dE", j);
			readParm22(rcfp, pname, 'S', 0, OLD_MAXLEN_SLINE, p->sline[j]);
			sprintf(pname, " SLINE%dS", j);
			readParm22(rcfp, pname, 'S', 0, OLD_MAXLEN_SLINE,
					  p->sline[OLD_MAXNUM_SLINES+j]);
		}
		readParm22(rcfp, "CBDELAY", 'B', 0, 255, &(p->CBDelay));
		readParm22(rcfp, "NUMCBSLINES", 'B',0, OLD_MAXNUM_SLINES,
				   &(p->numCBSlns));
		for (j=0; j<p->numCBSlns; j++) {
			sprintf(pname, " CBSLINE%dE", j);
			readParm22(rcfp, pname, 'S', 0, OLD_MAXLEN_SLINE, p->CBsln[j]);
			sprintf(pname, " CBSLINE%dS", j);
			readParm22(rcfp, pname, 'S', 0, OLD_MAXLEN_SLINE,
					  p->CBsln[OLD_MAXNUM_SLINES+j]);
		}
		readParm22(rcfp, "MODEMDEVICE", 'S', 0, OLD_MAXLEN_DEVICE, p->modemDevice);
		line = readParm22(rcfp, "MODEMSPEED", 'S', 4, 6, buf);
		if (! (n=str2speed(buf)))
			rcLineError("inputAllXisprc", line);
		p->modemSpeed = n;
		readParm22(rcfp, "MODEMRESET", 'S', 0, MAXLEN_MDMCMD, p->modemReset);
		readParm22(rcfp, "MODEMINIT", 'S', 0, MAXLEN_MDMCMD, p->modemInit);
		readParm22(rcfp, "OPEROPTS", 'X', 0, 0, &(p->operOpts));
		readParm22(rcfp, "DIALEXTRA", 'S', 0, MAXLEN_DIALEXTRA, p->dialExtra);
		readParm22(rcfp, "COMPLEVEL", 'B', 9, 15, &(p->compLevel));
		readParm22(rcfp, "ASYNCMAP", 'S', 2, MAXDIG_ASYNCMAP, p->asyncmap);
		readParm22(rcfp, "ESCAPE", 'S', 0, MAXLEN_ESCAPE, p->escape);
		line = readParm22(rcfp, "LOCALIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->localIP, ipp, 4);
		line = readParm22(rcfp, "REMOTEIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->remoteIP, ipp, 4);
		line = readParm22(rcfp, "NETMASK", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->netmask, ipp, 4);
		line = readParm22(rcfp, "DNS1", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->dns1, ipp, 4);
		line = readParm22(rcfp, "DNS2", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->dns2, ipp, 4);
		readParm22(rcfp, "MTU", 'I', 128, 2048, &(p->mtu));
		readParm22(rcfp, "MRU", 'I', 128, 2048, &(p->mru));
	}
}

void inputAllXisprc24(xisprc_ut *up, FILE *rcfp, glob_ut *ug)
{
	int i, j, n;
	char buf[2*OLD_MAXLEN_PASSWD+1], pname[32] = {0}, *line;
	unsigned char *ipp;
	xisprc_t24 *p = &(up->opts24[0]);
	glob_t24 *g = &(ug->glob24);

	fgets(buf, 2*OLD_MAXLEN_PASSWD-1, rcfp);
	readParm22(rcfp, "NUMISPS", 'B', 0, 255, &(g->numISPs));
	readParm22(rcfp, "DEFAULTISP", 'B', 0, 255, &(g->dfltISP));
	readParm22(rcfp, "NUMPTTS", 'B', 1, 255, &(g->numPTTs));
	readParm22(rcfp, "QTHPTT", 'B', 0, (g->numPTTs)-1, &(g->dfltPTT));
	readParm22(rcfp, "QTHZONE", 'B', 0, MAXNUM_ZONES-1, &(g->dfltZone));
	readParm22(rcfp, "LOGOPTS", 'X', 0, 0, &(g->logOpts));
	readParm22(rcfp, "PPPDPATH", 'S', 0, MAXLEN_PATH, g->pppdPath);
	readParm22(rcfp, "RUNPATH", 'S', 0, MAXLEN_PATH, g->runPath);
	readParm22(rcfp, "CHATPATH", 'S', 0, MAXLEN_PATH, g->chatPath);
	readParm22(rcfp, "UTILSPATH", 'S', 0, MAXLEN_PATH, g->utilsPath);
	readParm22(rcfp, "PIPEPATH", 'S', 0, MAXLEN_PATH, g->pipePath);
	for (i=0; i<g->numISPs; i++, p++) {
		memset(p, 0, sizeof(xisprc_t));
		rcISP(rcfp, i);
		readParm22(rcfp, "DESCR", 'S', 0, MAXLEN_DESCR, p->descr);
		readParm22(rcfp, "ACCOUNT", 'S', 0, OLD_MAXLEN_ACCOUNT, p->account);
		if (! *(p->account))
			n = 0;
		else
			n = 2*OLD_MAXLEN_PASSWD;
		readParm22(rcfp, "PASSWD", 'S', n, n, buf);
		memcpy(p->passwd, oldascii2passwd((unsigned char *)buf), OLD_MAXLEN_PASSWD);
		readParm22(rcfp, "NAME", 'S', 0, OLD_MAXLEN_UNR, p->name);
		readParm22(rcfp, "REMOTENAME", 'S', 0, OLD_MAXLEN_UNR, p->rname);
		readParm22(rcfp, "MAXATTEMPTS", 'B', 0, 255, &(p->maxAttempts));
		readParm22(rcfp, "SLEEPDELAY", 'B', 0, 255, &(p->sleepDelay));
		readParm22(rcfp, "CONNECTWAIT", 'B', 0, 255, &(p->connectWait));
		readParm22(rcfp, "NUMPHONES", 'B', 0, MAXNUM_TELS, &(p->numPhones));
		for (j=0; j<p->numPhones; j++) {
			sprintf(pname, " PHONE%d", j);
			readParm22(rcfp, pname, 'S', 0, MAXLEN_PHONE, p->phone[j]);
		}
		readParm22(rcfp, "NUMSLINES", 'B', 0, OLD_MAXNUM_SLINES,
				   &(p->numSlines));
		for (j=0; j<p->numSlines; j++) {
			sprintf(pname, " SLINE%dE", j);
			readParm22(rcfp, pname, 'S', 0, OLD_MAXLEN_SLINE, p->sline[j]);
			sprintf(pname, " SLINE%dS", j);
			readParm22(rcfp, pname, 'S', 0, OLD_MAXLEN_SLINE,
					   p->sline[OLD_MAXNUM_SLINES+j]);
		}
		readParm22(rcfp, "CBDELAY", 'B', 0, 255, &(p->CBDelay));
		readParm22(rcfp, "NUMCBSLINES", 'B', 0, OLD_MAXNUM_SLINES,
				   &(p->numCBSlns));
		for (j=0; j<p->numCBSlns; j++) {
			sprintf(pname, " CBSLINE%dE", j);
			readParm22(rcfp, pname, 'S', 0, OLD_MAXLEN_SLINE, p->CBsln[j]);
			sprintf(pname, " CBSLINE%dS", j);
			readParm22(rcfp, pname, 'S', 0, OLD_MAXLEN_SLINE,
					   p->CBsln[OLD_MAXNUM_SLINES+j]);
		}
		readParm22(rcfp, "TERMW", 'B', MINCHAR_TERMW, 255, &(p->termW));
		readParm22(rcfp, "TERMH", 'B', MINCHAR_TERMH, 255, &(p->termH));
		readParm22(rcfp, "MODEMDEVICE", 'S', 0, MAXLEN_DEVICE, p->modemDevice);
		line = readParm22(rcfp, "MODEMSPEED", 'S', 4, 6, buf);
		if (! (n=str2speed(buf)))
			rcLineError("inputAllXisprc", line);
		p->modemSpeed = n;
		readParm22(rcfp, "MODEMRESET", 'S', 0, MAXLEN_MDMCMD, p->modemReset);
		readParm22(rcfp, "MODEMINIT", 'S', 0, MAXLEN_MDMCMD, p->modemInit);
		readParm22(rcfp, "OPEROPTS", 'X', 0, 0, &(p->operOpts));
		readParm22(rcfp, "DIALEXTRA", 'S', 0, MAXLEN_DIALEXTRA, p->dialExtra);
		readParm22(rcfp, "COMPLEVEL", 'B', 9, 15, &(p->compLevel));
		readParm22(rcfp, "ASYNCMAP", 'S', 2, MAXDIG_ASYNCMAP, p->asyncmap);
		readParm22(rcfp, "ESCAPE", 'S', 0, MAXLEN_ESCAPE, p->escape);
		line = readParm22(rcfp, "LOCALIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->localIP, ipp, 4);
		line = readParm22(rcfp, "REMOTEIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->remoteIP, ipp, 4);
		line = readParm22(rcfp, "NETMASK", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->netmask, ipp, 4);
		line = readParm22(rcfp, "DNS1", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->dns1, ipp, 4);
		line = readParm22(rcfp, "DNS2", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->dns2, ipp, 4);
		readParm22(rcfp, "MTU", 'I', 128, 2048, &(p->mtu));
		readParm22(rcfp, "MRU", 'I', 128, 2048, &(p->mru));
	}
}

void inputAllXisprc25(xisprc_ut *up, FILE *rcfp, glob_ut *ug)
{
	int i, j, n;
	char buf[2*OLD_MAXLEN_PASSWD+1], pname[32] = {0}, *line;
	unsigned char *ipp;
	xisprc_t25 *p = &(up->opts25[0]);
	glob_t24 *g = &(ug->glob24);

	fgets(buf, 2*OLD_MAXLEN_PASSWD-1, rcfp);
	readParm22(rcfp, "NUMISPS", 'B', 0, 255, &(g->numISPs));
	readParm22(rcfp, "DEFAULTISP", 'B', 0, 255, &(g->dfltISP));
	readParm22(rcfp, "NUMPTTS", 'B', 1, 255, &(g->numPTTs));
	readParm22(rcfp, "QTHPTT", 'B', 0, (g->numPTTs)-1, &(g->dfltPTT));
	readParm22(rcfp, "QTHZONE", 'B', 0, MAXNUM_ZONES-1, &(g->dfltZone));
	readParm22(rcfp, "LOGOPTS", 'X', 0, 0, &(g->logOpts));
	readParm22(rcfp, "PPPDPATH", 'S', 0, MAXLEN_PATH, g->pppdPath);
	readParm22(rcfp, "RUNPATH", 'S', 0, MAXLEN_PATH, g->runPath);
	readParm22(rcfp, "CHATPATH", 'S', 0, MAXLEN_PATH, g->chatPath);
	readParm22(rcfp, "UTILSPATH", 'S', 0, MAXLEN_PATH, g->utilsPath);
	readParm22(rcfp, "PIPEPATH", 'S', 0, MAXLEN_PATH, g->pipePath);
	for (i=0; i<g->numISPs; i++, p++) {
		memset(p, 0, sizeof(xisprc_t));
		rcISP(rcfp, i);
		readParm22(rcfp, "DESCR", 'S', 0, MAXLEN_DESCR, p->descr);
		readParm22(rcfp, "ACCOUNT", 'S', 0, OLD_MAXLEN_ACCOUNT, p->account);
		if (! *(p->account))
			n = 0;
		else
			n = 2*OLD_MAXLEN_PASSWD;
		readParm22(rcfp, "PASSWD", 'S', n, n, buf);
		memcpy(p->passwd, oldascii2passwd((unsigned char *)buf), OLD_MAXLEN_PASSWD);
		readParm22(rcfp, "NAME", 'S', 0, OLD_MAXLEN_UNR, p->name);
		readParm22(rcfp, "REMOTENAME", 'S', 0, OLD_MAXLEN_UNR, p->rname);
		readParm22(rcfp, "MAXATTEMPTS", 'B', 0, 255, &(p->maxAttempts));
		readParm22(rcfp, "SLEEPDELAY", 'B', 0, 255, &(p->sleepDelay));
		readParm22(rcfp, "CONNECTWAIT", 'B', 0, 255, &(p->connectWait));
		readParm22(rcfp, "NUMPHONES", 'B', 0, MAXNUM_TELS, &(p->numPhones));
		for (j=0; j<p->numPhones; j++) {
			sprintf(pname, " PHONE%d", j);
			readParm22(rcfp, pname, 'S', 0, MAXLEN_PHONE, p->phone[j]);
		}
		readParm22(rcfp, "NUMSLINES", 'B', 0, MAXNUM_SLINES, &(p->numSlines));
		for (j=0; j<p->numSlines; j++) {
			sprintf(pname, " SLINE%dE", j);
			readParm22(rcfp, pname, 'S', 0, MAXLEN_SLINE, p->sline[j]);
			sprintf(pname, " SLINE%dS", j);
			readParm22(rcfp, pname, 'S', 0, MAXLEN_SLINE,
					  p->sline[MAXNUM_SLINES+j]);
		}
		readParm22(rcfp, "CBDELAY", 'B', 0, 255, &(p->CBDelay));
		readParm22(rcfp, "NUMCBSLINES", 'B', 0, MAXNUM_SLINES, &(p->numCBSlns));
		for (j=0; j<p->numCBSlns; j++) {
			sprintf(pname, " CBSLINE%dE", j);
			readParm22(rcfp, pname, 'S', 0, MAXLEN_SLINE, p->CBsln[j]);
			sprintf(pname, " CBSLINE%dS", j);
			readParm22(rcfp, pname, 'S', 0, MAXLEN_SLINE,
					  p->CBsln[MAXNUM_SLINES+j]);
		}
		readParm22(rcfp, "TERMW", 'B', MINCHAR_TERMW, 255, &(p->termW));
		readParm22(rcfp, "TERMH", 'B', MINCHAR_TERMH, 255, &(p->termH));
		readParm22(rcfp, "MODEMDEVICE", 'S', 0, MAXLEN_DEVICE, p->modemDevice);
		line = readParm22(rcfp, "MODEMSPEED", 'S', 4, 6, buf);
		if (! (n=str2speed(buf)))
			rcLineError("inputAllXisprc", line);
		p->modemSpeed = n;
		readParm22(rcfp, "MODEMRESET", 'S', 0, MAXLEN_MDMCMD, p->modemReset);
		readParm22(rcfp, "MODEMINIT", 'S', 0, MAXLEN_MDMCMD, p->modemInit);
		readParm22(rcfp, "MODEMCONNECT", 'S',0, MAXLEN_MDMSTR, p->modemConnect);
		readParm22(rcfp, "OPEROPTS", 'X', 0, 0, &(p->operOpts));
		readParm22(rcfp, "DIALEXTRA", 'S', 0, MAXLEN_DIALEXTRA, p->dialExtra);
		readParm22(rcfp, "COMPLEVEL", 'B', 9, 15, &(p->compLevel));
		readParm22(rcfp, "ASYNCMAP", 'S', 2, MAXDIG_ASYNCMAP, p->asyncmap);
		readParm22(rcfp, "ESCAPE", 'S', 0, MAXLEN_ESCAPE, p->escape);
		line = readParm22(rcfp, "LOCALIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->localIP, ipp, 4);
		line = readParm22(rcfp, "REMOTEIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->remoteIP, ipp, 4);
		line = readParm22(rcfp, "NETMASK", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->netmask, ipp, 4);
		line = readParm22(rcfp, "DNS1", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->dns1, ipp, 4);
		line = readParm22(rcfp, "DNS2", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->dns2, ipp, 4);
		readParm22(rcfp, "MTU", 'I', 128, 2048, &(p->mtu));
		readParm22(rcfp, "MRU", 'I', 128, 2048, &(p->mru));
	}
}

void inputAllXisprc26(xisprc_ut *up, FILE *rcfp, glob_ut *ug)
{
	int i, j, n;
	char buf[2*MAXLEN_PASSWD+1], pname[32] = {0}, *line;
	unsigned char *ipp;
	xisprc_t26 *p = &(up->opts26[0]);
	glob_t26 *g = &(ug->glob26);

	fgets(buf, 2*OLD_MAXLEN_PASSWD-1, rcfp);
	readParm26(rcfp, "NUMISPS", 'B', 0, 255, &(g->numISPs));
	readParm26(rcfp, "DEFAULTISP", 'B', 0, 255, &(g->dfltISP));
	readParm26(rcfp, "NUMPTTS", 'B', 1, 255, &(g->numPTTs));
	readParm26(rcfp, "QTHPTT", 'B', 0, (g->numPTTs)-1, &(g->dfltPTT));
	readParm26(rcfp, "QTHZONE", 'B', 0, MAXNUM_ZONES-1, &(g->dfltZone));
	readParm26(rcfp, "LOGOPTS", 'X', 0, 0, &(g->logOpts));
	readParm26(rcfp, "PPPDPATH", 'S', 0, MAXLEN_PATH, g->pppdPath);
	readParm26(rcfp, "RUNPATH", 'S', 0, MAXLEN_PATH, g->runPath);
	readParm26(rcfp, "CHATPATH", 'S', 0, MAXLEN_PATH, g->chatPath);
	readParm26(rcfp, "UTILSPATH", 'S', 0, MAXLEN_PATH, g->utilsPath);
	readParm26(rcfp, "PIPEPATH", 'S', 0, MAXLEN_PATH, g->pipePath);
	for (i=0; i<g->numISPs; i++, p++) {
		memset(p, 0, sizeof(xisprc_t));
		rcISP(rcfp, i);
		readParm26(rcfp, "DESCR", 'S', 0, MAXLEN_DESCR, p->descr);
		readParm26(rcfp, "ACCOUNT", 'S', 0, MAXLEN_ACCOUNT, p->account);
		if (! *(p->account))
			n = 0;
		else
			n = 2*MAXLEN_PASSWD;
		readParm26(rcfp, "PASSWD", 'S', n, n, buf);
		memcpy(p->passwd, oldascii2passwd((unsigned char *)buf), MAXLEN_PASSWD);
		readParm26(rcfp, "NAME", 'S', 0, MAXLEN_UNR, p->name);
		readParm26(rcfp, "REMOTENAME", 'S', 0, MAXLEN_UNR, p->rname);
		readParm26(rcfp, "MAXATTEMPTS", 'B', 0, 255, &(p->maxAttempts));
		readParm26(rcfp, "SLEEPDELAY", 'B', 0, 255, &(p->sleepDelay));
		readParm26(rcfp, "CONNECTWAIT", 'B', 0, 255, &(p->connectWait));
		readParm26(rcfp, "NUMPHONES", 'B', 0, MAXNUM_TELS, &(p->numPhones));
		for (j=0; j<p->numPhones; j++) {
			sprintf(pname, " PHONE%d", j);
			readParm26(rcfp, pname, 'S', 0, MAXLEN_PHONE, p->phone[j]);
		}
		readParm26(rcfp, "NUMSLINES", 'B', 0, MAXNUM_SLINES, &(p->numSlines));
		for (j=0; j<p->numSlines; j++) {
			sprintf(pname, " SLINE%dE", j);
			readParm26(rcfp, pname, 'S', 0, MAXLEN_SLINE, p->sline[j]);
			sprintf(pname, " SLINE%dS", j);
			readParm26(rcfp, pname, 'S', 0, MAXLEN_SLINE,
					  p->sline[MAXNUM_SLINES+j]);
		}
		readParm26(rcfp, "CBDELAY", 'B', 0, 255, &(p->CBDelay));
		readParm26(rcfp, "NUMCBSLINES", 'B', 0, MAXNUM_SLINES, &(p->numCBSlns));
		for (j=0; j<p->numCBSlns; j++) {
			sprintf(pname, " CBSLINE%dE", j);
			readParm26(rcfp, pname, 'S', 0, MAXLEN_SLINE, p->CBsln[j]);
			sprintf(pname, " CBSLINE%dS", j);
			readParm26(rcfp, pname, 'S', 0, MAXLEN_SLINE,
					  p->CBsln[MAXNUM_SLINES+j]);
		}
		readParm26(rcfp, "TERMW", 'B', MINCHAR_TERMW, 255, &(p->termW));
		readParm26(rcfp, "TERMH", 'B', MINCHAR_TERMH, 255, &(p->termH));
		readParm26(rcfp, "CBTERMW", 'B', MINCHAR_TERMW, 255, &(p->CBtermW));
		readParm26(rcfp, "CBTERMH", 'B', MINCHAR_TERMH, 255, &(p->CBtermH));
		readParm26(rcfp, "CBPHONE", 'S', 0, MAXLEN_PHONE, p->CBphone);
		readParm26(rcfp, "MODEMDEVICE", 'S', 0, MAXLEN_DEVICE, p->modemDevice);
		line = readParm26(rcfp, "MODEMSPEED", 'S', 4, 6, buf);
		if (! (n=str2speed(buf)))
			rcLineError("inputAllXisprc", line);
		p->modemSpeed = n;
		readParm26(rcfp, "MODEMRESET", 'S', 0, MAXLEN_MDMCMD, p->modemReset);
		readParm26(rcfp, "MODEMINIT", 'S', 0, MAXLEN_MDMCMD, p->modemInit);
		readParm26(rcfp, "MODEMCONNECT", 'S',0, MAXLEN_MDMSTR, p->modemConnect);
		readParm26(rcfp, "OPEROPTS", 'L', 0, 0, &(p->operOpts));
		readParm26(rcfp, "DIALEXTRA", 'S', 0, MAXLEN_DIALEXTRA, p->dialExtra);
		readParm26(rcfp, "COMPLEVEL", 'B', 8, 15, &(p->compLevel));
		readParm26(rcfp, "ASYNCMAP", 'S', 2, MAXDIG_ASYNCMAP, p->asyncmap);
		readParm26(rcfp, "ESCAPE", 'S', 0, MAXLEN_ESCAPE, p->escape);
		line = readParm26(rcfp, "LOCALIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->localIP, ipp, 4);
		line = readParm26(rcfp, "REMOTEIP", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->remoteIP, ipp, 4);
		line = readParm26(rcfp, "NETMASK", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->netmask, ipp, 4);
		line = readParm26(rcfp, "DNS1", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->dns1, ipp, 4);
		line = readParm26(rcfp, "DNS2", 'S', 7, MAXLEN_IP, buf);
		if ((ipp=str2IP(buf)) == NULL)
			rcLineError("inputAllXisprc", line);
		memcpy(p->dns2, ipp, 4);
		readParm26(rcfp, "MTU", 'I', 128, 2048, &(p->mtu));
		readParm26(rcfp, "MRU", 'I', 128, 2048, &(p->mru));
	}
}

void (* inputAllXisprc[MAXNUM_VERSIONS])(xisprc_ut*, FILE*, glob_ut*) =
	{NULL, NULL, NULL, NULL,
	 NULL, NULL, NULL, NULL,
	 inputAllXisprc20, inputAllXisprc21,
	 inputAllXisprc22, inputAllXisprc23,
	 inputAllXisprc24, inputAllXisprc25,
	 inputAllXisprc26, NULL};

int rcVersion()
{
	struct stat st;
	FILE *rcfp;
	char buf[64];
	int ov;

	stat(nrcfname, &st);
	for (ov=0; ov<FIRSTNBIN_VERSION; ov++)
		if (st.st_size == OLD_MAXNUM_ISP*rcsize[ov]) break;

	if (ov == FIRSTNBIN_VERSION) {
		rcfp = fopen(nrcfname, "r");
		if (rcfp == NULL) {
			sprintf(buf, "rcVersion: fopen(%s)", nrcfname);
			doErr(buf);
		}
		if (fscanf(rcfp, "xISP-%7[.0-9] ", buf) != 1) {
			fputs("xisprccv: rcVersion: error reading file version!\n",
				  stderr);
			exit(1);
		}
		for (ov=FIRSTNBIN_VERSION; ov<MAXNUM_VERSIONS; ov++)
			if (!strcmp(buf, rcname[ov])) break;
		if (ov == MAXNUM_VERSIONS) {
			fprintf(stderr, "xisprccv: rcVersion: %s: unknown version!\n",
					nrcfname);
			fprintf(stderr, "xisprccv: rcVersion: %s: not converted.\n",
					nrcfname);
			exit(1);
		}
		fclose(rcfp);
	}
	return ov;
}

void readXisprc(int ver)
{
	FILE *rcfp;
	int rw;
	char msg[64];

	rcfp = fopen(nrcfname, "r");
	if (rcfp == NULL) {
		sprintf(msg, "readXisprc: fopen(%s)", nrcfname);
		doErr(msg);
	}
	if (ver < FIRSTNBIN_VERSION) {
		rw = fread(&orc, rcsize[ver], OLD_MAXNUM_ISP, rcfp);
		if (rw != OLD_MAXNUM_ISP) {
			sprintf(msg, "readXisprc: fread(%s)", nrcfname);
			doErr(msg);
		}
	}
	else
		(*inputAllXisprc[ver])(&orc, rcfp, &ogl);
	fclose(rcfp);
}

int rcPrint(va_alist) va_dcl
{
	int bw;
	va_list ap;
	char *fmt;
	FILE *fp;

	va_start(ap);
	fp = va_arg(ap, FILE*);
	fmt = va_arg(ap, char*);
	bw = vfprintf(fp, fmt, ap);
	va_end(ap);
	if (bw <= 0)
		doErr("outputAllXisprc");
	return bw;
}

void outputAllXisprc(xisprc_ut *up, FILE *rcfp, glob_ut *ug)
{
	int i, n;
	xisprc_t27 *p = &(up->opts27[0]);
	glob_t27 *g = &(ug->glob27);
	char tmp[MAXLEN_PASSWD+1] = {0};

	rcPrint(rcfp, "xISP-%s\n", Version);
	rcPrint(rcfp, "NumISPs: %d\n", g->numISPs);
	rcPrint(rcfp, "DefaultISP: %d\n", g->dfltISP);
	rcPrint(rcfp, "NumPTTs: %d\n", g->numPTTs);
	rcPrint(rcfp, "CostPTT: %d\n", g->costPTT);
	rcPrint(rcfp, "LogOpts: %hX\n", g->logOpts);
	rcPrint(rcfp, "PppdPath: %s\n", g->pppdPath);
	rcPrint(rcfp, "RunPath: %s\n", g->runPath);
	rcPrint(rcfp, "LockPath: %s\n", g->lockPath);
	rcPrint(rcfp, "ChatPath: %s\n", g->chatPath);
	rcPrint(rcfp, "UtilsPath: %s\n", g->utilsPath);
	rcPrint(rcfp, "PipePath: %s\n", g->pipePath);
	for (i=0; i<g->numISPs; i++, p++) {
		rcPrint(rcfp, "[%d]\n", i);
		rcPrint(rcfp, "Description: %s\n", p->descr);
		rcPrint(rcfp, "Account: %s\n", p->account);
		if (*(p->account)) {
			pdecode(tmp, p->passwd);
			n = strlen(tmp);
			if (n % 8)
				n = 8*((n/8) + 1);
			memcpy(tmp, passwd2ascii(p->passwd), 2*n);
			rcPrint(rcfp, "Password: %s\n", tmp);
		}
		else
			rcPrint(rcfp, "Password: \n");
		rcPrint(rcfp, "Name: %s\n", p->name);
		rcPrint(rcfp, "RemoteName: %s\n", p->rname);
		rcPrint(rcfp, "MaxAttempts: %d\n", p->maxAttempts);
		rcPrint(rcfp, "SleepDelay: %d\n", p->sleepDelay);
		rcPrint(rcfp, "ConnectWait: %d\n", p->connectWait);
		rcPrint(rcfp, "LCPWait: %d\n", p->LCPWait);
		rcPrint(rcfp, "NumPhones: %d\n", p->numPhones);
		for (n=0; n<p->numPhones; n++)
			rcPrint(rcfp, " Phone[%d]: %s\n", n, p->phone[n]);
		rcPrint(rcfp, "NumSLines: %d\n", p->numSlines);
		for (n=0; n<p->numSlines; n++) {
			rcPrint(rcfp, " SLine[%d]E: %s\n", n, p->sline[n]);
			rcPrint(rcfp, " SLine[%d]S: %s\n", n, p->sline[MAXNUM_SLINES+n]);
		}
		rcPrint(rcfp, "CBDelay: %d\n", p->CBDelay);
		rcPrint(rcfp, "NumCBSLines: %d\n", p->numCBSlns);
		for (n=0; n<p->numCBSlns; n++) {
			rcPrint(rcfp, " CBSLine[%d]E: %s\n", n, p->CBsln[n]);
			rcPrint(rcfp, " CBSLine[%d]S: %s\n", n, p->CBsln[MAXNUM_SLINES+n]);
		}
		rcPrint(rcfp, "TermW: %d\n", p->termW);
		rcPrint(rcfp, "TermH: %d\n", p->termH);
		rcPrint(rcfp, "CBTermW: %d\n", p->CBtermW);
		rcPrint(rcfp, "CBTermH: %d\n", p->CBtermH);
		rcPrint(rcfp, "CBPhone: %s\n", p->CBphone);
		rcPrint(rcfp, "ModemDevice: %s\n", p->modemDevice);
		rcPrint(rcfp, "ModemSpeed: %u\n", p->modemSpeed);
		rcPrint(rcfp, "ModemReset: %s\n", p->modemReset);
		rcPrint(rcfp, "ModemInit: %s\n", p->modemInit);
		rcPrint(rcfp, "ModemConnect: %s\n", p->modemConnect);
		rcPrint(rcfp, "OperOpts: %lX\n", p->operOpts);
		rcPrint(rcfp, "DialExtra: %s\n", p->dialExtra);
		rcPrint(rcfp, "CompLevel: %d\n", p->compLevel);
		rcPrint(rcfp, "AsyncMap: %s\n", p->asyncmap);
		rcPrint(rcfp, "Escape: %s\n", p->escape);
		rcPrint(rcfp, "LocalIP: %s\n", IP2str(p->localIP));
		rcPrint(rcfp, "RemoteIP: %s\n", IP2str(p->remoteIP));
		rcPrint(rcfp, "NetMask: %s\n", IP2str(p->netmask));
		rcPrint(rcfp, "DNS1: %s\n", IP2str(p->dns1));
		rcPrint(rcfp, "DNS2: %s\n", IP2str(p->dns2));
		rcPrint(rcfp, "MTU: %u\n", p->mtu);
		rcPrint(rcfp, "MRU: %u\n", p->mru);
		rcPrint(rcfp, "DomainName: %s\n", p->domainname);
		rcPrint(rcfp, "ISPPTT: %d\n", p->ispPTT);
		rcPrint(rcfp, "ISPZone: %d\n", p->ispZone);
	}
}

void writeXisprc(int ver)
{
	FILE *rcfp;
	char msg[64];

	rcfp = fopen(nrcfname, "w");
	if (rcfp == NULL) {
		sprintf(msg, "writeXisprc: fopen(%s)", nrcfname);
		doErr(msg);
	}
	outputAllXisprc(&nrc, rcfp, &ngl);
	fclose(rcfp);
}

void outofMem(void)
{
	fprintf(stderr, "xisprccv: out of memory!\n");
	exit(1);
}

#define MAXLEN_VERSION 4

void initFnames(void)
{
#ifdef RUNASEUID
	struct passwd *user = getpwuid(geteuid());
#else
	struct passwd *user = getpwuid(getuid());
#endif
	int hdirlen = strlen(user->pw_dir), per_host = 0;
	char hostname[MAXHOSTNAMELEN+1];

	if (gethostname(hostname, MAXHOSTNAMELEN) == 0) {
		nrcfname =
			(char *)malloc(hdirlen+1+strlen(RCFNAME)+1+MAXHOSTNAMELEN+1);
		if (nrcfname != NULL) {
			strcpy(nrcfname, user->pw_dir); strcat(nrcfname, "/");
			strcat(nrcfname, RCFNAME); strcat(nrcfname, ".");
			strcat(nrcfname, hostname);
		}
		else outofMem();
#ifdef RUNASEUID
		if (xisp_euidaccess(nrcfname, R_OK) == 0) per_host = 1;
#else
		if (access(nrcfname, R_OK) == 0) per_host = 1;
#endif
		else free(nrcfname);
	}
	if (! per_host) {
		nrcfname = (char *)malloc(hdirlen+1+strlen(RCFNAME)+1);
		if (nrcfname != NULL) {
			strcpy(nrcfname, user->pw_dir); strcat(nrcfname, "/");
			strcat(nrcfname, RCFNAME);
		}
		else outofMem();
	}
	orcfname = (char *)malloc(strlen(nrcfname)+1+MAXLEN_VERSION);
	if (orcfname != NULL) {
		strcpy(orcfname, nrcfname);
		strcat(orcfname, "-");
	}
	else outofMem();
}

int yweek(void)
{
	time_t tsec = time(NULL);
	struct tm* ct = localtime(&tsec);
	int yday = ct->tm_yday, wday1, isdst = ct->tm_isdst, yweek = 1;

	tsec -= (yday*86400);
	if (isdst)
		tsec += 3600;
	ct = localtime(&tsec);
	wday1 = ct->tm_wday;
	if (--wday1 < 0)
		wday1 += 7;
	if (wday1 > 0)
		yday -= (7-wday1);
	if (yday < 0)
		yweek = 52;
	else {
		yweek = (1+yday)/7+
			(((1+yday)%7)?1:0);
		if (yweek > 52)
			yweek = 52;				
	}
	return yweek;
}

void conv_init(void)
{
	extern void outofMem();
#ifdef RUNASEUID
	struct passwd *user = getpwuid(geteuid());
#else
	struct passwd *user = getpwuid(getuid());
#endif
	int hdirlen = strlen(user->pw_dir);

	logdirname = (char *)malloc(hdirlen+1+strlen(LOGDIRNAME)+1);
	costfname = (char *)malloc(hdirlen+1+strlen(LOGDIRNAME)+1+
							   strlen(COSTFNROOT)+5+1);
	bkupfname = (char *)malloc(hdirlen+1+strlen(LOGDIRNAME)+1+
							   strlen(COSTFNROOT)+5+4+1);
	pttfname = (char *)malloc(hdirlen+1+strlen(LOGDIRNAME)+1+
							  strlen(PTTFNAME)+1);
	if (logdirname != NULL && costfname != NULL &&
		bkupfname != NULL && pttfname != NULL)
	{
		strcpy(logdirname, user->pw_dir); strcat(logdirname, "/");
		strcat(logdirname, LOGDIRNAME);
		strcpy(costfname, logdirname); strcat(costfname, "/");
		strcat(costfname, COSTFNROOT);
		strcpy(pttfname, logdirname); strcat(pttfname, "/");
		strcat(pttfname, PTTFNAME);
	}
	else
		outofMem();
	costfnroot = &costfname[strlen(costfname)];
}

static int safePrint(va_alist) va_dcl
{
	int bw;
	va_list ap;
	char *fmt;
	FILE *fp;

	va_start(ap);
	fp = va_arg(ap, FILE*);
	fmt = va_arg(ap, char*);
	bw = vfprintf(fp, fmt, ap);
	va_end(ap);
	if (bw <= 0)
		doErr("safePrint");
	fflush(fp);
	return bw;
}

static void inpCostError(char *function, char *line)
{
	fprintf(stderr, "xisprccv: %s: error reading %s\n", function, costfname);
	fprintf(stderr, "xisprccv: %s: offending line: [%s]\n", function, line);
	exit(2);
}

char *readLog26(FILE *fp, char *name, char type,
				int llimit, int ulimit, void *data)
{
	static char line[MAXLEN_LINE];
	char sparam[MAXLEN_PARAM] = {0}, *p, *endp;
	unsigned long lparam;

	if (fgets(line, MAXLEN_LINE, fp) == NULL) {
		fprintf(stderr, "xisprccv: readLog26: %s: premature EOF\n", costfname);
		exit(2);
	}
	line[strlen(line)-1] = 0;
	if ((p=strchr(line,':')) == NULL)
		inpCostError("readLog26", line);
	if (strncmp(name, line, (int)(p-line))) {
		fprintf(stderr, "xisprccv: readLog26: expected [%s], got [%s]\n",
				name, line);
		exit(2);
	}
	for (++p; *p==' '; p++);
	strncpy(sparam, p, sizeof(sparam)-1);
	switch (type) {

		case 'L':
			lparam = strtol(sparam, &endp, 10);
			if ((ulimit!=llimit && ulimit<lparam) || lparam<llimit ||
				endp == sparam || *endp )
				inpCostError("readParm26", line);
			*((unsigned long *)data) = lparam;
			break;

		default: break;
	}
	return(line);
}

void convStats(glob_t26 *global)
{
	int i, type = 0, tnf[3] = {52, 12, 6}, cur = 0;
	time_t tsec = time(NULL);
	struct tm* ct = localtime(&tsec);
	char monName[12][4] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun",
						   "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"},
		 addon[6] = {0}, til[3][2] = {"W", "", "B"};
	FILE *costfp;
	unsigned long totalTime, totalUnits;
	float totalCost;

	if (global->logOpts & LOG_WEEKLY) {
		type = 0;
		cur = yweek();
	}
	else if (global->logOpts & LOG_MONTHLY) {
		type = 1;
		cur = ct->tm_mon+1;
	}
	else if (global->logOpts & LOG_BIMONTHLY) {
		type = 2;
		cur = ((ct->tm_mon+1)/2)+(((ct->tm_mon+1)%2)?1:0);
	}
	for (i=0; i<tnf[type]; i++) {
		if (type == 1)
			sprintf(addon, ".%s", monName[cur-1]);
		else
			sprintf(addon, ".%s%d", til[type], cur);
		strcpy(costfnroot, addon);
		costfp = fopen(costfname, "r");
		if (costfp != NULL) {
			readLog26(costfp, "TOTALTIME", 'L', 0, 0, &totalTime);
			readLog26(costfp, "TOTALUNITS", 'L', 0, 0, &totalUnits);
			fclose(costfp);
			strcpy(bkupfname, costfname); strcat(bkupfname, ".bak");
			rename(costfname, bkupfname);
			costfp = fopen(costfname, "w");
			if (costfp != NULL) {
				if (ptt[global->dfltPTT].attribs & PTT_BY_UNIT)
					totalCost = totalUnits * ptt[global->dfltPTT].cost_quantum;
				else
					totalCost = totalUnits / 100.0;
				safePrint(costfp, "TotalTime: %lu\n", totalTime);
				safePrint(costfp, "TotalCost: %.2f\n", totalCost);
				fclose(costfp);
			}
			else
				doErr("convStats: fopen");
		}
		cur = cur % tnf[type] + 1;
	}
}

int get_Easter(struct tm *ct)
{
	signed int a,b,m,q,w,p,n,tt,mm;
	struct tm ptm;
	struct tm htm;
	time_t htt;
	
	n = ct->tm_year;
	a = n % 19;
	b = floor((7*a+1)/19);
	m = (11*a+4-b) % 29;
	q = floor(n/4);
	w = (n+q+31-m) % 7;
	p = 25-m-w;
	if (p>0) {
		tt=p;
		mm=4;
	}
 	else {
		tt=p+31;
 		mm=3;
	}

	htm.tm_year=ct->tm_year;
	htm.tm_mon=mm-1;
	htm.tm_mday=tt;
	htm.tm_hour=12;
	htm.tm_min=0;
	htm.tm_sec=0;
#ifdef SUNOS41x
	htt=timelocal(&htm);
#else
	htt=mktime(&htm);
#endif
	memcpy(&ptm, localtime(&htt), sizeof(struct tm));
	
	return(ptm.tm_yday);
}

static void ptt26Seq(FILE *fp, int nPTT)
{
	int n;

	if (fscanf(fp, "-%4d- ", &n) < 1) {
		fprintf(stderr, "xisprccv: pttSeq: error reading PTT number in %s\n",
				pttfname);
		exit(2);
	}
	if (n != nPTT) {
		fprintf(stderr, "xisprccv: pttSeq: PTT sequence number wrong in %s\n",
				pttfname);
		fprintf(stderr, "xisprccv: pttSeq: expected %d, got %d\n", nPTT, n);
		exit(2);
	}
}

static void pttLineError(char *function, char *line)
{
	fprintf(stderr, "xisprccv: %s: error reading %s\n", function, pttfname);
	fprintf(stderr, "xisprccv: %s: offending line: [%s]\n", function, line);
	exit(2);
}

static char *rdPtt26Parm(FILE *fp, char *name, char type,
						 int llimit, int ulimit, void *data)
{
	static char line[256];
	char sparam[128] = {0}, *p, *endp;
	int iparam, hex = 0, len;
	unsigned int uparam, th, tm, ts, dd, dm;
	float fparam;
	ruletime_t *rt;
	ruledate_t *rd;

	if (fgets(line, MAXLEN_LINE, fp) == NULL) {
		fprintf(stderr, "xISP: rdPtt26Parm: %s: premature EOF\n", pttfname);
		exit(2);
	}
	line[strlen(line)-1] = 0;
	if ((p=strchr(line,':')) == NULL)
		pttLineError("rdPtt26Parm", line);
	if (strncmp(name, line, (int)(p-line))) {
		fprintf(stderr, "xISP: rdPtt26Parm: expected [%s], got [%s]\n",
				name, line);
		exit(2);
	}
	for (++p; *p==' '; p++);
	strncpy(sparam, p, sizeof(sparam)-1);
	switch (type) {
		case 'S':
			len = strlen(sparam);
			if (ulimit<len || len<llimit)
				pttLineError("rdPtt26Parm", line);
			strcpy((char *)data, sparam);
			break;

		case 'H':
		case 'X':
			hex = 1;
		case 'B':
		case 'U':
			uparam = strtol(sparam, &endp, (hex)? 16:10);
			if ((!hex && (ulimit<uparam || uparam<llimit)) ||
				 endp == sparam || *endp )
				pttLineError("rdPtt26Parm", line);
			if (type == 'H' || type == 'B')
				*((unsigned char *)data) = uparam;
			else
				*((unsigned int *)data) = uparam;
			break;

		case 'I':
			iparam = strtol(sparam, &endp, 10);
			if (ulimit<iparam || iparam<llimit ||
				endp == sparam || *endp )
				pttLineError("rdPtt26Parm", line);
			*((int *)data) = iparam;
			break;

		case 'F':
			fparam = strtod(sparam, &endp);
			if (ulimit<fparam || fparam<llimit ||
				endp == sparam || *endp)
				pttLineError("rdPtt26Parm", line);
			*((float *)data) = fparam;
			break;

		case 'T':
			rt = data;
			if (sscanf(sparam, "%2u:%2u:%2u", &th, &tm, &ts) < 3 ||
				th > 24 || tm > 60 || ts > 60 ||
				(th > 23 && (tm != 0 || ts != 0)))
				pttLineError("rdPtt26Parm", line);
			rt->h = th; rt->m = tm; rt->s = ts;
			break;

		case 'D':
			rd = data;
			if (sscanf(sparam, "%2u/%2u", &dd, &dm) < 2 ||
				dm < 1 || dm > 12 || dd < 1 || dd > 31)
				pttLineError("rdPtt26Parm", line);
			rd->day = dd; rd->mon = dm - 1;
			break;

		default: break;
	}
	return(line);
}

static void inputOldPTTs(ptt_t26 *p, FILE *pttfp, glob_t26 *global)
{
	int i, z, c, testEaster;
	char *line, pname[32] = {0};
	time_t tt = time(NULL);
	struct tm *ct = localtime(&tt);

	for (i=0; i<global->numPTTs; i++) {
		ptt26Seq(pttfp, i);
		rdPtt26Parm(pttfp, "NAME", 'S', 0, MAXLEN_PTTNAME, p[i].name);
		rdPtt26Parm(pttfp, "NUMZONES", 'B', 0, MAXNUM_ZONES, &(p[i].num_zones));
		rdPtt26Parm(pttfp, "CURRENTZONE", 'B', 0, MAXNUM_ZONES-1,
				  &(p[i].current_zone));
		rdPtt26Parm(pttfp, "NUMCATEGORIES", 'B', 0, MAXNUM_CATEGORY,
				  &(p[i].num_categories));
		rdPtt26Parm(pttfp, "ATTRIBS", 'X', 0, 0, &(p[i].attribs));
		rdPtt26Parm(pttfp, "MINUNITS", 'B', 0, MAXVAL_MINUNITS,
				  &(p[i].min_units));
		rdPtt26Parm(pttfp, "MINCOST", 'F', 0, 100000, &(p[i].min_cost));
		rdPtt26Parm(pttfp, "CHARGEPERIOD", 'B', 1, 60, &(p[i].charge_period));
		rdPtt26Parm(pttfp, "COSTQUANTUM", 'F', 0, 10000,
				  &(p[i].cost_quantum));
		rdPtt26Parm(pttfp, "CURRENCY", 'S', 0, MAXLEN_CURRENCY, p[i].currency);
		rdPtt26Parm(pttfp, "DECIMALS", 'B', 0, MAXNUM_DECIMALS,
				  &(p[i].decimals));
		for (z=0; z<p[i].num_zones; z++) {
			sprintf(pname, "DFLTTARIFF%d", z);
			rdPtt26Parm(pttfp, pname, 'F', 0, 100000, &(p[i].dflt_tariff[z]));
			sprintf(pname, "MINCOSTLEN%d", z);
			rdPtt26Parm(pttfp, pname, 'U', 0, MAXSEC_MINCOSTLEN,
					  &(p[i].min_cost_len[z]));
			sprintf(pname, "ZONENAME%d", z);
			rdPtt26Parm(pttfp, pname, 'S', 0, MAXLEN_ZNAME, p[i].zone_name[z]);
			sprintf(pname, "DISCOUNTPERCENT%d", z);
			rdPtt26Parm(pttfp, pname, 'F', 0, 99.0, &(p[i].discount[z].percent));
			sprintf(pname, "DISCOUNTSTART%d", z);
			rdPtt26Parm(pttfp, pname, 'T', 0, 0, &(p[i].discount[z].start));
			sprintf(pname, "DISCOUNTEND%d", z);
			rdPtt26Parm(pttfp, pname, 'T', 0, 0, &(p[i].discount[z].end));
			for (c=0; c<p[i].num_categories; c++) {
				sprintf(pname, "RULETYPE%d_%d", z, c);
				rdPtt26Parm(pttfp, pname, 'H', 0, 0, &(p[i].rule[z][c].type));
				sprintf(pname, "RULEADATE%d_%d", z, c);
				rdPtt26Parm(pttfp, pname, 'D', 0, 0, &(p[i].rule[z][c].adate));
				sprintf(pname, "RULEEDATE%d_%d", z, c);
				rdPtt26Parm(pttfp, pname, 'D', 0, 0, &(p[i].rule[z][c].edate));
				sprintf(pname, "RULERDATE%d_%d", z, c);
				line = rdPtt26Parm(pttfp, pname, 'I', MINVAL_RELDATE,
								 MAXVAL_RELDATE, &(p[i].rule[z][c].rdate));
				testEaster = p[i].rule[z][c].rdate + get_Easter(ct);
				if (testEaster < 1 || testEaster > 365)
					pttLineError("inputAllXispPTTs", line);
				sprintf(pname, "RULESTART%d_%d", z, c);
				rdPtt26Parm(pttfp, pname, 'T', 0, 0, &(p[i].rule[z][c].start));
				sprintf(pname, "RULEEND%d_%d", z, c);
				rdPtt26Parm(pttfp, pname, 'T', 0, 0, &(p[i].rule[z][c].end));
				sprintf(pname, "RULETARIFF%d_%d", z, c);
				rdPtt26Parm(pttfp, pname, 'F', 0, 100000,
						  &(p[i].rule[z][c].tariff));
			}
		}
	}
}

static char *pttVersion(FILE *fp)
{
	static char version[8] = {0};

	if (fscanf(fp, "xISP-%7[.0-9] ", version) < 1) {
		fputs("xisprccv: pttVersion: error reading file version!\n", stderr);
		exit(2);
	}
	return version;
}

int readPTTs26(ptt_t26 **pttdataptr, glob_t26 *global)
{
	FILE *pttfp;
	extern void outofMem();

	pttfp = fopen(pttfname, "r");
	if (pttfp != NULL) {
		if (strcmp(pttVersion(pttfp), "2.6")) {
			fprintf(stderr, "xisprccv: unknown PTT database version!\n");
			fprintf(stderr, "xisprccv: %s: not converted.\n", pttfname);
			exit(2);
		}
		rdPtt26Parm(pttfp, "NUMPTTS", 'B', 1, 255, &(global->numPTTs));
		*pttdataptr = (ptt_t26 *)malloc((global->numPTTs)*sizeof(ptt_t26));
		if (*pttdataptr == NULL)
			outofMem();
		inputOldPTTs(*pttdataptr, pttfp, global);
		fclose(pttfp);
		return 1;
	}
	else
		return 0;
}

int main()
{
	int ov = 0, nv = MAXNUM_VERSIONS-1, i, j, nISPs = 0;
	char *rcsp = RCSid;

	rcsp = PatchLevel;
	umask(077);
	pcode_init();
	initFnames();

	ov = rcVersion();
	if (ov == nv) {
		fprintf(stderr, "xisprccv: %s: compatible with v%s.\n",
				nrcfname, rcname[ov]);
		fprintf(stderr, "xisprccv: %s: not converted.\n", nrcfname);
		return 0;
	}
	strcat(orcfname, rcname[ov]);

	readXisprc(ov);
	rename(nrcfname, orcfname);
	for (i=ov; i<nv; i++) {
		if (i < FIRSTVISP_VERSION)
			nISPs = OLD_MAXNUM_ISP;
		else
			nISPs = ogl.glob24.numISPs;
		memset(&nrc, 0, nISPs*rcsize[i+1]);
		for (j=0; j<nISPs; j++)
			(*initrc[i])(j);
		memcpy(&orc, &nrc, nISPs*rcsize[i+1]);
		if (i >= (FIRSTGLOB_VERSION-1))
			(*initg[i])();
		if (i < (nv-1))
			memcpy(&ogl, &ngl, globsize[i+1]);
	}
	writeXisprc(nv);
	fprintf(stderr, "xisprccv: %s: converted from v%s to v%s.\n",
			nrcfname, rcname[ov], rcname[nv]);

	if (! strcmp(rcname[ov], "2.6")) {
		conv_init();
		if (readPTTs26(&ptt, &ogl.glob26))
			convStats(&ogl.glob26);
	}

	return 0;
}

