.TH XISP 1 "X11 Utilities" "Linux"
.SH NAME
xisp \- an X11/XForms based, user-friendly interface to pppd/chat,
a simple ISP and phone company (PTT) database manager, and a dialup
costs and usage logging/statistics tool.
.SH SYNOPSIS
.TP 6
.B xisp\ \ [-bgcol\ #<6-digit\ hex\ color>] [-iconic] 
.B [-isp\ <ISP\-num>]\ [-autodial]\ [-debug]\ [-expert]
.B [-nohints]\ [-geometry\ [=][<W>{xX}<H>][{+-}<XO>{+-}<YO>]]
.B [-pidfp <PID file name prefix>] [XForms parameters]
.SH "DESCRIPTION"
.BR xisp 
implements a user-friendly interface to pppd/chat
and provides maximum feedback from the dial-in and login phases on a
browser screen, as well as a manual login terminal window. It also
provides greater versatility in interrupting a call in progress and in
general enhances the user's feeling of "what's going on", especially
if she/he is not all that well acquainted with the intricacies of
system log files. Furthermore, it incorporates a mechanism to log ISP
connections and calculate/store phone-call costs. It's also much nicer
to look at as compared to connection scripts writing output on the
terminal :) The main application, xisp, relies on a special dialer,
xispdial, which is spawned by pppd in order to perform the dialing,
and a "bare bones" terminal interface, xispterm.
.PP
The other facility provided by xisp is that of maintaining two small
data bases, one for Internet Service Providers (ISPs) and one for phone
companies (PTTs). The implementation supports a variable number of
records for both data bases. Each ISP entry, aside from user account name
and password, has space for 8 telephone numbers, two dialing parameters
determining number of dialing tries and inter-dialing delay, sixteen user
customizable script lines for the chat program, and a wealth of dialing
and pppd options to cover most communication needs. All ISP data base
information is saved in the xisp resource control file \fI.xisprc\fP in
the user's home directory. The phone company database supports all
(known) PTT attributes applicable while logging phone-call costs, and
saves its information in a separate file, in sub directory \fI.xisplogs\fP,
in the user's home directory.
.PP
For a brief presentation on the operation of xisp and in particular
on the parameters available from within its "Options" and "Logging"
menu options, invoke item "General" from within the "Help" menu. For
a general discussion on the workings of xisp, its dialer xispdial and
its helper terminal program xispterm, as well as their interaction with
pppd and chat, see the "ARCHITECTURE" section in file README of the
xisp distribution.
.SH OPTIONS
xisp accepts all of the standard XForms command line options along
with the additional options listed below:
.TP 8
.B \-bgcol #<6-digit hex color>
Enables changing the default background color for all program
windows, and also the background color used by xispdial. The desired color
is entered as a six-digit hexadecimal number, 2 digits for each one of the
three basic colors, red green and blue. Remember to escape the '#' character
from the shell (e.g. "xisp -bgcol '#495563'" or "xisp -bgcol \#495563").
.TP 8
.B \-iconic
.br
Instructs the window manager to start up xisp iconized.
.TP 8
.B \-isp <ISP-num>
.br
Selects the ISP entry specified by the number entered. Valid numbers
range from 1 to the maximum number of ISP's supported (currently equal
to 8).
.TP 8
.B \-autodial
.br
Immediately after startup, forces automatic dialing of the selected
ISP entry. If the ISP selected already has automatic dialing upon
startup enabled, then this option has no effect.
.TP 8
.B \-debug
.br
Switches on maximum PPP debugging, by increasing the pppd debug level
and setting the kernel debugging option to 7, i.e. full debugging. It
does that by instructing xisp to call pppd with the "debug kdebug 7"
options added to its command line. Read the pppd(8) manual page for
details on the types of debugging information written in the system
log files.
.TP 8
.B \-expert
.br
Turns off all program confirmation dialogues. By default, all such
dialogues are enabled. This option implies "-nohints".
.TP 8
.B \-nohints
.br
Turns off all popup hints. These contain valuable information for
novice users and are enabled by default.
.TP 8
.B \-geometry [=][<W>{xX}<H>][{+-}<XO>{+-}<YO>]
Instructs the window manager to adjust the size of the xisp window
and to place it at the location specified. W denotes width, H height,
XO x-offset and YO y-offset. The syntax for this geometry string is
the standard one used by all X11 applications.
.TP 8
.B \-pidfp <file name prefix>
.br
Specifies the file name prefix for pppd's PID file. This option is
currently needed only for the PPP package distributed from Sun
Microsystems for use with Solaris (derived from the ppp-2.4.0 release);
in such case invoke xisp as: "xisp -pidfp sppp".
.PP
The most commonly employed XForms command line options are also listed below
for the user's convenience:
.TP 8
.B \-name <appname>
Changes the application name. Useful for managing resources.
.TP 8
.B \-display <host:dpy>
Specifies the display server. The default value is that contained
in the $DISPLAY environment variable.
.TP 8
.B \-private
Forces xisp to use a private colormap.
.TP 8
.B \-shared
.br
Forces xisp to use a shared colormap.
.TP 8
.B \-stdcmap
Forces xisp to use the standard colormap.
.SH SIGNALS
The following signals have the specified effect when sent
to the xisp process using the kill(1) command:
.TP
.I SIGINT, SIGTERM
The xisp process is terminated and the PPP link is disconnected.
.TP
.I SIGUSR1
If xisp is in the disconnected state, sending it this signal is
equivalent to pressing the "Connect" button. If xisp is either
dialing or in the connected state, this signal has no effect.
.TP
.I SIGUSR2
If xisp is dialing, sending it this signal is equivalent to pressing
the "Interrupt" button, and if xisp is in the connected state, it is
equivalent to pressing "Disconnect". If xisp is in the disconnected
state, this signal has no effect.
.PP
The xisp process id number is saved in file
.I "$HOME/.xisprc"
(see section
.I FILES
below).
.SH FILES
.TP
.I "@ETCPPP@/options.xisp"
Special options file for pppd daemon version 2.2.x. It is not installed
by default as of version 1.8 of xisp. It can be used to pass pppd any
extra options not supported via xisp's GUI forms. This works with pppd
version 2.2.x \fIonly\fP.
.TP
.I "/etc/ppp/peers/xisp_dialer"
pppd 2.3.x peer information file used to set the path to xispdial, xisp's
dedicated dialer application. Used by all \fI/etc/ppp/peers/xisp_<device>\fP
peer files.
.TP
.I "/etc/ppp/peers/xisp_<device>"
pppd 2.3.x peer information file used for specifying the "noauth" option
needed by most (if not all) ISPs, together with the serial device for which
"noauth" holds. This is because setting "noauth" turns the modem device
file specification into a privileged option. All such peer files contain a
"call xisp_dialer" option, which reads in \fI/etc/ppp/peers/xisp_dialer\fP
for setting the path to xispdial, xisp's dedicated dialer application.
.TP
.I "@USRLIBPPP@/xispdial"
The special dialer program invoked by pppd 
as instructed by xisp. Employs chat(8) to converse with the modem
and if manual login is selected, launches xispterm enabling the
user to login manually.
.TP
.I "@USRLIBPPP@/xispterm"
A "bare bones" terminal emulation program invoked by xispdial
as a manual login terminal window.
.TP
.I "@USRLOCAL@/xisprccv"
Utility program for converting .xisprc files of all older versions to
the latest format. Understands database formats of version 1.2 and later.
.TP
.I "@USRLOCAL@/xispid"
Utility program for retrieving the real group id of the calling process.
Adapted from the GNU id(1) utility for use with xisp. Used in ip-up and
ip-down to screen users with permission to start pppd. For an example of
its use read the sample ip-up and ip-down files included in the xisp
distribution.
.TP
.I "$HOME/.xisprc"
.TP
.I "$HOME/.xisprc.<hostname>"
Resource control file where xisp saves all its database information.
Plaintext passwords entered via xisp, are encrypted before being stored
in this file. If \fI.xisprc.<hostname>\fP exists, it overrides the
generic \fI.xisprc\fP file.
.TP
.I "$HOME/.xispscript"
Temporary file created by xisp and used by xispdial during the connection
phase. This file contains the plaintext password if automatic login via the
login script is selected, but is created u+rw,go-rw (mode 600) and remains
on the filesystem only for that limited amount of time required for
connection.
.TP
.I "$HOME/.xisppap"
Temporary file created by xisp and used by pppd, when PAP login is selected.
It contains the plaintext user account name and password, and is passed to
pppd via the +ua command line option. It is created u+rw,go-rw (mode 600)
and remains on the filesystem only for the short amount of time required for
pppd to parse its command line and spawn a copy of itself in the background.
Chances are that unless you have a very heavily loaded system, you'll never
be able to see this file in your home directory by using ls(1).
.TP
.I "$HOME/.xisplogs"
Directory under the user's home directory where the two log files and the
phone company (PTT) ASCII data base updated by xisp are kept. It is created
the first time xisp is run.
.TP
.I "$HOME/.xisplogs/xispcost.(period-suffix)"
.TP
.I "$HOME/.xisplogs/xisplog.(period-suffix)"
The two log files kept by xisp when logging is enabled. The first one keeps
track of the total on-line time (in seconds) and the total number of units
charged (or total cost if the phone company selected charges by minute rather
than in units). The second one contains entries for all ISP connections in
the logging period selected (one for when the connection was set up and one
for when it was torn down). The "period suffix" depends on the logging period
selected. For "Weekly" logging it is ".W<week-number-in-year>", for "Monthly"
it is simply the abbreviated month as returned by date(1), and for "Bimonthly"
it is ".B<number-of-month-pair-in-year>". As an example, for date
"Fri Sep 26 17:59:39 EET DST 1997", the corresponding suffixes are ".W39",
".Sep" and ".B5", respectively.
.TP
.I "$HOME/.xisplogs/xispPTTs"
The ASCII data base file where xisp saves all the phone company (PTT)
information.
.TP
.I "$HOME/.xisp-up, $HOME/.xisp-down"
If either one of these scripts is present in the user's home directory,
it is executed when the PPP link is setup or torn down respectively.
The script output can appear in the xisp browser window. Sample .xisp-up
and .xisp-down scripts are included in the xisp distribution.
.TP
.I "/tmp/.xisppipe.<username>"
The named pipe node through which xispdial conveys messages to xisp. It
is created u+rw,go-rw (mode 600) and is not deleted when the user exits
xisp. The same node is also used for reading output from the ip-up, ip-down
scripts (called by pppd) and .xisp-up, .xisp-down scripts (called by xisp),
when a link is set up or torn down.
.TP
.I "$HOME/.xisppid"
This file contains the process id of the currently running xisp instance.
It can be used by scripts which control xisp via its signal handling
capabilities (details in the
.I SIGNALS
section above). Note that if for some reason (e.g. full filesystem) xisp
fails to create this file in the user's home directory, it will carry on
without giving any indication of this problem.
.SH "NOTES"
When specifying the background color remember either to escape or
to quote the leading '#'.
.SH "SEE ALSO"
pppd(8), chat(8).
.SH AUTHOR
The xisp package is authored and maintained by Dimitrios P. Bouras
<dbouras@hol.gr>. For more detailed contact information please read
the README file distributed with xisp.
.SH ACKNOWLEDGEMENTS
Thanks are due to the following individuals:
.TP 6
T.C. Zhao and Mark Overmars
.br
For creating the exceptional Forms
Library GUI. It's ease of use helped concentrating more on the
program parts doing the work rather those dealing with the
appearance of the user interface. Excellent work guys!
.TP 6
Luca Maranzano <liuk@kirk.linux.it>
.br
For putting together a packaged xisp for use with the Debian
Linux distribution.
.TP 6
I.Ioannou <roryt@hol.gr>
.br
For providing an alternative FTP site for the xisp distribution,
for his very helpful feedback and suggestions on improving xisp,
and for extensive beta testing.
.TP 6
Peter T. Breuer <ptb@it.uc3m.es>
.br
For his help in extensively testing xisp on a *very* loaded
system and his contribution to the alternative pppd-PID
search code.
.TP 6
Raphael Wegmann <wegmann@ophelia.tuwien.ac.at>
.br
For providing the animated XPM icons and code that runs the
animation, for contributing code for the ip-up/ip-down support,
and all his great ideas on improving the functionality of xisp.
.TP 6
Doron Shikmoni <P85025@VM.BIU.AC.IL>
.br
For suggesting and then spending quite a bit of time testing
the call-back feature, as well as his ideas on improving the
scripting capabilities of xisp.
.TP 6
Ximenes Zalteca <ximenes@netset.com>
.br
For supporting the RPM source and binary packaging of xisp up
to and including version 2.3p7, for use with the Red Hat Linux
distribution (Ximenes has since stopped maintaining RPM releases
of xisp, so please refrain from contacting him on this subject).
.TP 6
Dave Holland <dave@zenda.demon.co.uk>
.br
for his extensive beta
testing of the I/O-driven call-back code, and his contribution
of perl code for parsing the ipparam string.
.TP 6
Tillmann Steinbrecher <tst@gmx.de>
.br
for letting me use the code
he developed for the pppcosts program, as well as the phone
company information included therein.
.TP 6
Fabrice Bellet <Fabrice.Bellet@creatis.insa-lyon.fr>
.br
for his extensive
modifications of the cost calculation code to cover the case
of non-linear minimum charge times (in per-minute PTT charging
schemes), as well as his invaluable help (feedback and patches)
while beta-testing the PTT editor and its associated cost
calculation engine.
.TP 6
Johnny C. Lam <lamj@stat.cmu.edu>
.br
for porting xisp to NetBSD and
contributing his patches to the official distribution.
.TP 6
Takeshi Morishima <tm@planex-usa.com>
.br
for porting xisp to FreeBSD
and contributing his patches to the official distribution.
.TP 6
Peter Denison <peterd@pnd-pc.demon.co.uk>
.br
for maintaining the RPM source and binary distributions
for the Red Hat Linux distribution.
.TP 6
Andrew Bettison <andrewb@zip.com.au>
.br
for contributing bscanf.c as well as the code for passing
xispdial's parameters via the process environment as
opposed to using an environment file.
.TP 6
For their helpful feedback, suggestions and contributions:
.br
Luca Maranzano <liuk@linux.it>
.br
Bogdan Bucicovschi <bogdanb@math.ohio-state.edu>
.br
Rich Lampe <rlampe@gate.cybernex.net>
.br
Peter T. Breuer <ptb@it.uc3m.es>
.br
Jon Davis <jon@mast.QueensU.CA>
.br
Steve Masticola <masticol@scr.siemens.com>
.br
I.Ioannou <roryt@hol.gr>
.br
Stuart Luppescu <s-luppescu@uchicago.edu>
.br
Amos Shapira <amos@dsi.co.il>
.br
Dan Morrison <danm@primenet.com>
.br
Raphael Wegmann <wegmann@ophelia.tuwien.ac.at>
.br
Jacob Spoelstra <jacob@padda.usc.edu
.br
Richard Marchelletta <rbm@ma.ultranet.com>
.br
Javier Ros <jros@upna.es>
.br
Stig <stig@hackvan.com>
.br
Daniel Whicker <heimdall@mail.utexas.edu>
.br
Charles Herman <cherman@acm.org>
.br
Doron Shikmoni <P85025@VM.BIU.AC.IL>
.br
Tom Hutchison <tomhutch@oregontrail.net>
.br
Nik. I. Mouratidis <praeto@math.auth.gr>
.br
Dave Hoo <dhoo@flash.net>
.br
Stephan Hegel <ea273@fen.baynet.de>
.br
Geoffrey Leach <geoffrey@iname.com>
.br
Ximenes Zalteca <ximenes@netset.com>
.br
Dave Holland <dave@zenda.demon.co.uk>
.br
Henning Schmiedehausen <henning@forge.franken.de>
.br
Jim Searle <jims@broadcom.com>
.br
Kimball Anderson <crutch@aci.net>
.br
John Alonzo Breen <jabberwock82@worldnet.att.net>
.br
Martin Bialasinski <martinb@debian.org>
.br
Oleg Mercader <merol@aliga.cesca.es>
.br
Col Mackrory <mackrory@acay.com.au>
.br
Paul Colclough <squiz@squiz.clara.net>
.br
Andrea Carpani <ancarpan@studenti.to.it>
.br
Hans-Dieter Stich <hdstich@connectu.ulm.circular.de>
.br
Rene Fertig <rene.fertig@wupperonline.de>
.br
Matt Ettus <mne@cmu.edu>
.br
Navindra Umanee <navindra@cs.mcgill.ca>
.br
Ivo Naninck <inaninck@solair1.inter.NL.net>
.br
Reverend Jeremy Scott Dean <seregmcw@usa.net>
.br
Oliver Schulze <oliver@pla.net.py>
.br
Gasper Fele <gasper.fele@guest.arnes.si>
.br
Miguel Cruz <mnc@diana.law.yale.edu>
.br
TonyK Lindstrom <tonyk@pulpuri.pp.fi>
.br
Toni Bilic <tbilic@efos.hr>
.br
Tom Herzog <tom_herzog@MENTORG.COM>
.br
Victor Karpovich <victor@cport.com>
.br
Fabrice Bellet <Fabrice.Bellet@imag.fr>
.br
Mark J. Hewitt <mjh@elsabio.demon.co.uk>
.br
John Merritt <merritt@raindrop1.gsfc.nasa.gov>
.br
Lew Ewl <hilroy@capescott.net>
.br
Tessa Lau <tlau@cs.washington.edu>
.br
Andy Rabagliati <andyr@wizzy.com>
.br
Peter Denison <peterd@pnd-pc.demon.co.uk>
.br
Jean-Francois Laforest <catworld@geocities.com>
.br
Olav Woelfelschneider <wosch@rbg.informatik.th\-darmstadt.de>
.br
Alexander Baxevanis <noiz@usa.net>
.br
Erlend Simonsen <erlesimo@online.no>
.br
Alberto Caporro <a.caporro@pratesi.it>
.br
Jim Shallman <jim_shallman@mentorg.com>
.br
Orestis Glavas <glavas@hol.gr>
.br
Gisbert Berger <101.206067@GermanyNet.de>
.br
Kostas Zagoris <kzagor@rodopi.cc.duth.gr>
.br
John Totten <john@totten.com>
.br
Mike Bennett <mbennett@ns1.cfcc.cc.fl.us>
.br
Peter L. Jones <pljones@earthling.net>
.br
Robert A. Yetman <bobyetman@worldnet.att.net>
.br
Jon Davis <ine@engineer.com>
.br
Johnny C. Lam <lamj@stat.cmu.edu>
.br
Wolfgang Schlueschen <Wolfgang.Schlueschen@hamburg.sc.philips.com>
.br
Nico Coetzee <nicc@mweb.co.za>
.br
Juha 'Jippo' Pohjalainen <jmp+gate@iki.fi>
.br
Hermann Boeken <hermann.boeken@fen.baynet.de>
.br
Dimitris Logothetis <logos@algonet.se>
.br
Michael Klein <mklein@murphy.ruhr.de>
.br
Takeshi Morishima <morishim@cig.mot.com>
.br
Peter J Arnold <pjarnold@uq.net.au>
.br
Athanasios Kanaris <kanaris@cheng.auth.gr>
.br
Kent Gibson <kent.gibson@iname.com>
.br
Greg Ushomirsky <gregus@geminga.Berkeley.EDU>
.br
Detlef Steuer <Detlef.Steuer@gmx.de>
.br
John Caradimas <sv1cec@hol.gr>
.br
Jason Buszta <Jason.Buszta@sequoia.panurgy.com>
.br
Andrew Bettison <andrewb@zip.com.au>
.br
Sundeep Mediratta <smedi@home.com>
.br
Silviu Minut <minutsil@msu.edu>
.br
Jari Eskelinen <jari.eskelinen@mbnet.fi>
.br
Istvn Vradi <ivaradi@freemail.c3.hu>
.br
Pierre Gaufillet <gaufille@magic.fr>
.br
Eberhard Schruefer <Eberhard.Schruefer@gmd.de>
.SH COPYRIGHT
xisp is Copyright (C) 1997-2002  Dimitrios P. Bouras
.PP
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
.PP
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.PP
Additionally to the conditions of the GNU Public License, the
following condition also applies to xisp:
.PP
You may link this software with XForms (Copyright (C) by T.C. Zhao
and Mark Overmars) and distribute the resulting binary, under the
restrictions in clause 3 of the GPL, even though the resulting binary
is not, as a whole, covered by the GPL. If a derivative no longer
requires XForms, you may use the unsupplemented GPL as its license by
deleting this paragraph and therefore removing this exemption for
XForms.

