###############################################################
# TkNet - Utilities Module
# Charlie KEMPSON - charlie@siren.demon.co.uk
# http://public.logica.com/~kempsonc/tknet.htm
# Version 1.1
###############################################################

###############################################################
#
#    Copyright (c) 1995-1996 Charlie Kempson
#
#    This program is free software; you can redistribute it 
#    and/or modify it under the terms of the GNU General 
#    Public License as published by the Free Software 
#    Foundation (version 2 of the License).
#
#    This program is distributed in the hope that it will 
#    be useful, but WITHOUT ANY WARRANTY; without even the 
#    implied warranty of MERCHANTABILITY or FITNESS FOR A 
#    PARTICULAR PURPOSE.  See the GNU General Public License 
#    for more details.
#
#    For a copy of the GNU General Public License, write to the 
#    Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
#    MA 02139, USA.
###############################################################

# Globals
set g_selected_file ""
set g_selected_file_filter ""

###############################################################
# Create a scrolled text widget
proc ScrolledText { f width height horiz } {

   # Global 
   global FIXED_FONT_SMALL

   frame $f
   # The setgrid setting allows the window to be resized.
   text $f.text -width $width -height $height \
      -setgrid true  -width $width -wrap word \
      -yscrollcommand [list $f.yscroll set] \
      -font $FIXED_FONT_SMALL
   if {$horiz == 1} {
      $f.text configure -xscrollcommand [list \
         $f.xscroll set] -wrap none 
      scrollbar $f.xscroll -orient horizontal \
         -command [list $f.text xview]
      pack $f.xscroll -side bottom -fill x
   }
   scrollbar $f.yscroll -orient vertical \
      -command [list $f.text yview]
   pack $f.yscroll -side right -fill y

   # The fill and expand are needed when resizing.
   pack $f.text -side left -fill both -expand true
   pack $f -side top -fill both -expand true
   return $f.text
}

###############################################################
# Create a scrolled text widget
proc ScrolledList { frame width height mode horiz } {

   frame $frame
   # The setgrid setting allows the window to be resized.
   listbox $frame.list -width $width -height $height \
      -setgrid true -yscrollcommand [list $frame.yscroll set] \
      -selectmode $mode
   if {$horiz == 1} {
      $frame.list configure -xscrollcommand [list \
         $frame.xscroll set] -wrap none 
      scrollbar $frame.xscroll -orient horizontal \
         -command [list $frame.list xview]
      pack $frame.xscroll -side bottom -fill x
   }
   scrollbar $frame.yscroll -orient vertical \
      -command [list $frame.list yview]
   pack $frame.yscroll -side right -fill y

   # The fill and expand are needed when resizing.
   pack $frame.list -side left -fill both -expand true
   pack $frame -side top -fill both -expand true
   return $frame.list
}

###############################################################
# The procedure for popping up a popup menu
proc Popup_Menu { parent window } {

   # Get current mouse position
   set x [ winfo pointerx $parent ]
   set y [ winfo pointery $parent ]

   # Popup the menu
   tk_popup $window $x $y
}

###############################################################
# The procedure for checking whether a process is running
proc Is_Process_Running { process } {

   # NOTE: This *still* doesn't work!!!
   # puts "Checking for process ..."
   catch {eval exec sh -c \"ps -ax | awk '\{print \$1\}' | grep \
$process >& /dev/null; echo \$?\"} result
   if { $result == 0 } {return 1} else {return 0}
}

###############################################################
# The procedure for killing a process
proc Kill_Process { process } {

   # Globals
   global g_log_file

   # Attempt to kill the process.  Note that this won't
   # work if DIP is running setuid.  Don't bother
   # displaying the error info though...
   catch {eval exec kill -TERM $process >>& $g_log_file} \
      error_text
}

###############################################################
# Change cursor to an hourglass and back again
proc WatchCursor {} {

   # Loop through children setting the cursor
        set busy ""
        foreach w [winfo children .] {
                lappend busy [list $w [lindex [$w config -cursor] 4]]
        }
        foreach w $busy {catch {[lindex $w 0] config -cursor watch}}
        update idletasks
}
proc NormalCursor {} {

   # Loop through children setting the cursor
        set busy ""
        foreach w [winfo children .] {
                lappend notbusy [list $w [lindex [$w config -cursor] 4]]
        }
        foreach w $notbusy {catch {[lindex $w 0] config -cursor hand2}}
        update idletasks
}


###############################################################
# The procedure for creating images
proc Create_Image { file } {

   # This procedure attempts to create an image from
   # the data specified in the named file.  If the 
   # file is non-existant, or the image type is not
   # supported, -1 is returned and a dialogue is
   # displayed.

   if [file exists $file] {

      # Create the image
      set name $file"_image"
      if [catch {image create bitmap $name -file $file} text] {
         # Not a bitmap, try pixmap
         if [catch {image create pixmap $name -file $file} text] {
            # Not a pixmap, try gif
            if [catch {image create photo $name -file $file} text] {
               # Give up!
               Info_Dialog . "Image $file has an unrecognised type!"
               return -1
            }
         }
      }
      return $name
   } else {
      Info_Dialog . "File $file does not exists!"
      return -1
   }
}

###############################################################
# The procedure for selecting a file
proc File_Select { {title "Select File"} {filter "*"} \
   {dir ""} {nofile 0} } {

   # This procedure pops up a file selection box
   # and returns the selected file.
   #
   # Arguments : title - Dialogue title
   # filter - Default file filter
   # dir - Start directory
   # nofile - Set to 1 if you wish to select a directory only

   # Globals
   global TEXT_COLOUR DEFAULT_PADDING RIDGE_BORDER \
      g_selected_file g_selected_file_filter
   set g_selected_file_filter $filter
   
   # Popup a selection window
   set window .fileselect
   if [winfo exists $window] {
       # Pop it up!
       wm deiconify $window
       raise $window
       return
   }

   # Otherwise create the window
   toplevel $window
   wm title $window $title
   wm transient $window .

   # Create a frame containing the filter
   frame $window.filter_fr -borderwidth $RIDGE_BORDER -relief groove
   pack $window.filter_fr -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING \
      -side top -fill x
   label $window.filter_fr.label -text "Filter"
   entry $window.filter_fr.entry -width 15 -bg $TEXT_COLOUR \
      -textvariable g_selected_file_filter
   button $window.filter_fr.filter -text "Filter" -command \
      Populate_File_Select 
   bind $window.filter_fr.entry <Return> Populate_File_Select
   pack $window.filter_fr.label $window.filter_fr.entry \
      $window.filter_fr.filter -side left \
      -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING

   # Create the directory list and file list
   frame $window.list_fr
   pack $window.list_fr -fill both -expand true
   set dirlist [ScrolledList $window.list_fr.dir_fr 0 10 browse 0]
   set filelist [ScrolledList $window.list_fr.file_fr 0 10 browse 0]
   $dirlist configure -bg $TEXT_COLOUR
   $filelist configure -bg $TEXT_COLOUR
   pack forget $window.list_fr.dir_fr $window.list_fr.file_fr
   pack $window.list_fr.dir_fr $window.list_fr.file_fr -side left -fill \
      both -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING \
      -expand true
   
   # Create a frame to display the current directory
   frame $window.dir_fr -borderwidth $RIDGE_BORDER -relief groove
   pack $window.dir_fr -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING \
      -side top -fill x
   label $window.dir_fr.label -text "Directory : "
   entry $window.dir_fr.dir -width 15 -bg $TEXT_COLOUR 
   button $window.dir_fr.goto -text "Change" -command \
      "Change_Directory"
   bind $window.dir_fr.dir <Return> "Change_Directory"
   pack $window.dir_fr.label $window.dir_fr.dir $window.dir_fr.goto \
      -side left -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING -fill x

   # Create a frame containing an entry field
   frame $window.sel_fr -borderwidth $RIDGE_BORDER -relief groove
   pack $window.sel_fr -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING \
      -side top -fill x
   label $window.sel_fr.label -text "File"
   set entry [entry $window.sel_fr.entry -width 30 -bg $TEXT_COLOUR]
   pack $window.sel_fr.label $window.sel_fr.entry -side left \
      -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING -fill x

   # If nofile is selected (i.e the user is being asked to select
   # a directory, then unmanage the file list and entry field)
   if {$nofile == 1} {
      pack forget $window.sel_fr $window.list_fr.file_fr
   }

   # And add buttons to the window
   set frame [frame $window.button_fr]
   pack $frame -side bottom -fill x
   button $frame.close -text Cancel -command {
      destroy .fileselect
      set g_selected_file ""
   }
   button $frame.ok -text OK -command {
      set file [.fileselect.sel_fr.entry get]
      set dir [pwd]
      set g_selected_file "$dir/$file"
      destroy .fileselect
   }
   bind $window.sel_fr.entry <Return> "$frame.ok invoke"
   pack $frame.ok $frame.close -side right -padx $DEFAULT_PADDING -pady \
      $DEFAULT_PADDING

   # Change to desired directory (if specified)
   if {$dir != ""} {
      if [catch {cd $dir}] {
         Info_Dialog . "Unable to change to requested directory $dir!"
      }
   }

   # Retrieve the list
   Populate_File_Select

   # And now centre it on its parent
   Centre_Dialog $window default
   focus $window.sel_fr.entry

   # Add bindings on list
   bind $dirlist <Double-ButtonRelease-1> {
      set page [.fileselect.list_fr.dir_fr.list get \
         [.fileselect.list_fr.dir_fr.list curselection]]
      if {$page == ".."} {cd ..} else {cd $page}
      Populate_File_Select
   }
   bind $filelist <Double-ButtonRelease-1> {
      set page [.fileselect.list_fr.file_fr.list get \
         [.fileselect.list_fr.file_fr.list curselection]]
      after 400 destroy .fileselect
      set dir [pwd]
      set g_selected_file "$dir/$page"
   }
   bind $filelist <ButtonRelease-1> {
      set page [.fileselect.list_fr.file_fr.list get \
         [.fileselect.list_fr.file_fr.list curselection]]
      .fileselect.sel_fr.entry delete 0 end
      .fileselect.sel_fr.entry insert end "$page"
   }

   # Wait for destruction of window
   tkwait variable g_selected_file
   return $g_selected_file
}

###############################################################
# The procedure for selecting a file
proc Populate_File_Select { } {

   # Globals 
   global g_selected_file_filter 
   set filter $g_selected_file_filter

   # Retrieve new information
   set files [lsort [glob -nocomplain $filter]]
   set dirs [lsort [glob -nocomplain "*"]]
   .fileselect.list_fr.dir_fr.list delete 0 end
   .fileselect.list_fr.dir_fr.list insert end ".."
   .fileselect.list_fr.file_fr.list delete 0 end

   # Loop through returned items (note that globbing of ~'s
   # is disabled via ./ prefixes)
   foreach file $files {
      if ![file isdirectory ./$file] {
         .fileselect.list_fr.file_fr.list insert end $file
      }
   }
   foreach file $dirs {
      if [file isdirectory ./$file] {
         .fileselect.list_fr.dir_fr.list insert end $file
      }
   }

   # Set the current directory
   .fileselect.dir_fr.dir delete 0 end
   .fileselect.dir_fr.dir insert end [pwd]
   .fileselect.dir_fr.dir xview moveto 1
}

###############################################################
# The procedure for selecting a file
proc Field_File_Select { entry {title "Select File"} {filter "*"} } {

   # This procedure pops up a file selection box
   # and returns the selected file into the 
   # given field.

   set file [File_Select]
   if {$file != ""} {
      $entry delete 0 end
      $entry insert end $file
   }
}

###############################################################
# The procedure for changing directory
proc Change_Directory {} {
   # This function responds to a user request to
   # change the current directory.

   if [catch {cd [.fileselect.dir_fr.dir get]}] {
      Info_Dialog . "Unable to change to requested directory!"
   }

   # Update details
   Populate_File_Select
}

###############################################################
# The procedure for converting a hex address into an IP address
proc Hex_To_IP { hex_num } {
   # Hex number must be of the form NNNNNNNN (i.e four lots of 
   # 8 bits)
   scan $hex_num "%2x%2x%2x%2x" num1 num2 num3 num4
   set ip_addr "$num4.$num3.$num2.$num1"
   #Info_Dialog . $ip_addr
   return $ip_addr
}

