###############################################################
# TkNet - Setup Module
# Charlie KEMPSON - charlie@siren.demon.co.uk
# http://public.logica.com/~kempsonc/tknet.htm
# Version 1.1
###############################################################

###############################################################
#
#    Copyright (c) 1995-1996 Charlie Kempson
#
#    This program is free software; you can redistribute it 
#    and/or modify it under the terms of the GNU General 
#    Public License as published by the Free Software 
#    Foundation (version 2 of the License).
#
#    This program is distributed in the hope that it will 
#    be useful, but WITHOUT ANY WARRANTY; without even the 
#    implied warranty of MERCHANTABILITY or FITNESS FOR A 
#    PARTICULAR PURPOSE.  See the GNU General Public License 
#    for more details.
#
#    For a copy of the GNU General Public License, write to the 
#    Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
#    MA 02139, USA.
###############################################################

###############################################################
# Globals for this module

# Flags
set g_option_number     0
set g_separator_number  0
set g_setup_changed     0
set g_setup_file        /usr/local/lib/TkNet/tknet.setup

# Geometry
set TKNET_SETUP_GEOMETRY "+408+51"

# Files
set TKNET_GLOBAL_SETUP_FILE "$GLOBAL_INCLUDE/tknet.setup"
set TKNET_LOCAL_SETUP_FILE "$TKNET_USER_HOME/.tknet_setup"

# Options list
set gls_setup_list [list g_ping_command g_runq_command g_mailtool \
                         g_check_remote_mail g_check_local_mail \
                         g_log_file g_max_wait_time gs_remote_mail_indicator \
                         gs_local_mail_indicator gs_spool_dir \
                         g_pppd_command g_chat_command g_rgb_file \
                         g_gethostname]

set gs_ping_command_text "Keepalive connection"
set g_ping_command      "ping -c 1 nether.demon.co.uk"

set gs_runq_command_text "Run the mail queue"
set g_runq_command      "su1 sendmail -q"

set gs_mailtool_text    "Start mail reader"
set g_mailtool          "exmh"

set gs_check_remote_mail_text "Remote mail queue"
set g_check_remote_mail "finger siren@post.demon.co.uk"

set gs_check_local_mail_text "Local mail queue"
set g_check_local_mail  "sendmail -bp"

set gs_log_file_text    "TkNet log file"
set g_log_file          "$TKNET_USER_HOME/.tknetlog"

set gs_remote_mail_indicator_text "Remote mail indicator"
set gs_remote_mail_indicator "From"

set gs_local_mail_indicator_text "Local mail indicator"
set gs_local_mail_indicator "Size"

set gs_spool_dir_text   "Spool directory"
set gs_spool_dir        "/usr/spool/mail"

set g_pppd_command_text "Location of pppd"
set g_pppd_command "/usr/sbin/pppd"

set g_chat_command_text "Location of chat"
set g_chat_command "/usr/sbin/chat"

set g_rgb_file_text "RGB Colour File"
set g_rgb_file "/usr/lib/X11/rgb.txt"

set g_gethostname_text "Hostname command"
set g_gethostname "hostname -f"

###############################################################
# The procedure to read the setup files
# Argument must be 0=Both 1=Global or 2=Local 
proc Source_Setup  { file } {
   Debug "Source_Setup"

   # Globals
   global TKNET_GLOBAL_SETUP_FILE TKNET_LOCAL_SETUP_FILE \
      gls_setup_list
   eval global [split $gls_setup_list]
      
   # Read the global setup file
   if {$file != 2 && [file exists $TKNET_GLOBAL_SETUP_FILE]} {
      source $TKNET_GLOBAL_SETUP_FILE
   }
   
   # Read the user's own config file if it exists
   if {$file != 1 && [file exists $TKNET_LOCAL_SETUP_FILE]} {
      # Override with users own
      source $TKNET_LOCAL_SETUP_FILE
   }

   # Note that if neither exist the defaults are
   # taken from the internal settings corresponding
   # to my home settings.
}

###############################################################
# Show the setup panel
proc Show_Setup { } {
   Debug "Show_Setup"

   # Globals
   global FONT_NORMAL FONT_BOLD DEFAULT_PADDING RIDGE_BORDER \
      gs_ping_command_text gs_runq_command_text gs_mailtool_text \
      gs_check_remote_mail_text gs_check_local_mail_text \
      gs_log_file_text gs_remote_mail_indicator_text \
      gs_local_mail_indicator_text gs_spool_dir_text \
      g_option_number g_setup_changed TKNET_SETUP_GEOMETRY \
      g_separator_number g_pppd_command_text g_chat_command_text \
      g_rgb_file_text g_gethostname g_gethostname_text

   # Create the setup toplevel as a transient from the main window
   set window .setup_window
   if [winfo exists $window] return
   toplevel $window
   wm title $window "TkNet Setup"
   wm transient $window .
   wm geometry $window $TKNET_SETUP_GEOMETRY
   wm protocol $window WM_DELETE_WINDOW Close_Setup_Window

   ###########################################################################
   # Create Menu Bar
   set menu [frame $window.mbar -relief raised -bd 2]
   pack $menu -side top -fill x

   menubutton $menu.file -text File -underline 0 -menu $menu.file.menu
   pack $menu.file -side left

   menu $menu.file.menu -tearoff 0
      $menu.file.menu add command -label "Save" \
         -command { Save_Setup } -underline 0
      $menu.file.menu add command -label \
         "Set Defaults from Global" -command \
         { set g_setup_changed 1 ; Source_Setup 1 } -underline 4
      $menu.file.menu add separator
      $menu.file.menu add command -label "Close" \
         -command { Close_Setup_Window } -underline 0
   tk_menuBar $menu $menu.file

   ###############################################################
   # Create the main panel
   label $window.label -text "Enter the configuration \
items necessary for your setup in the fields below.  To obtain \
help on any item, click on the corresponding label." -wraplength 500 \
      -justify center
   pack $window.label -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING \
      -side top -fill x
   set frame [frame $window.setup_fr -borderwidth $RIDGE_BORDER \
      -relief groove ]
   pack $frame -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING \
      -side top -expand true -fill both
   set canvas [canvas $frame.c -yscrollcom "$frame.sy set" -scrollregion \
      "0 0 600 0" -width 480 -highlightthickness 0]
   pack [scrollbar $frame.sy -orient v -com "$frame.c yview"] \
      -side right -fill y
   pack $canvas -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING \
      -side top -fill both -expand true -exp 1

   ###############################################################
   # Create the individual settings
   set g_option_number 0
   set g_separator_number 0
   Create_Option_Separator "Commands"
   Create_Option_Entry $gs_ping_command_text g_ping_command PingCommand 1
   Create_Option_Entry $gs_runq_command_text g_runq_command RunMailQueueCommand 1
   Create_Option_Entry $gs_mailtool_text g_mailtool MailtoolCommand 1
   Create_Option_Entry $g_pppd_command_text g_pppd_command PppdCommand 1
   Create_Option_Entry $g_chat_command_text g_chat_command ChatCommand 1
   Create_Option_Entry $g_gethostname_text g_gethostname NetworkInformation 1
   Create_Option_Entry $g_rgb_file_text g_rgb_file RGBFileName 1
   Create_Option_Separator "Mail Settings"
   Create_Option_Entry $gs_check_remote_mail_text g_check_remote_mail RemoteMailQueueCommand 1
   Create_Option_Entry $gs_check_local_mail_text g_check_local_mail LocalMailQueueCommand 1
   Create_Option_Entry $gs_remote_mail_indicator_text gs_remote_mail_indicator RemoteMailIndicator
   Create_Option_Entry $gs_local_mail_indicator_text gs_local_mail_indicator LocalMailIndicator
   Create_Option_Entry $gs_spool_dir_text gs_spool_dir MailSpoolDirectory
   Create_Option_Separator "Other Settings"
   Create_Option_Entry $gs_log_file_text g_log_file LogFileName 1

   frame .setup_window.button_frame -borderwidth $DEFAULT_PADDING
   pack .setup_window.button_frame -side bottom -fill x
   button .setup_window.button_frame.close -font $FONT_NORMAL \
       -text Close -command { Close_Setup_Window }
   pack .setup_window.button_frame.close
}

###############################################################
# Create a button, entry pair
proc Create_Option_Entry {text variable help {select 0}} {
   Debug "Create_Option_Entry"

   # Globals
   global FONT_NORMAL DEFAULT_PADDING g_option_number \
      OPTION_TEXT_LENGTH OPTION_LABEL_LENGTH \
      g_setup_changed $help

   # Work out the canvas height
   set canvas .setup_window.setup_fr.c
   set canvas_height [$canvas cget -scrollregion]
   scan $canvas_height "%*d %*d %*d %d" canvas_height
   set canvas_height [expr $canvas_height + 40]
   $canvas configure -scrollregion "0 0 600 $canvas_height"

   # Create a label/textentry pair
   frame $canvas.$g_option_number
   button $canvas.$g_option_number.b -text $text -width \
       $OPTION_LABEL_LENGTH -relief flat -command "MH_MiniHelp $help"
   set entry [entry $canvas.$g_option_number.e -textvariable $variable \
      -width $OPTION_TEXT_LENGTH]
   bind $entry <KeyPress> {set g_setup_changed 1}
   pack $canvas.$g_option_number.b $canvas.$g_option_number.e -side left \
      -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING
   if {$select != 0} {
      button $canvas.$g_option_number.s -text "..." -command \
         "Field_File_Select $entry"
      bind $canvas.$g_option_number.s <ButtonPress> {set g_setup_changed 1}
      pack $canvas.$g_option_number.s -side left -padx $DEFAULT_PADDING \
         -pady $DEFAULT_PADDING
   }

   set offset [expr $canvas_height -40]
   $canvas create window 15 $offset -window $canvas.$g_option_number \
      -anchor nw

   # Increment option number
   incr g_option_number
}

###############################################################
# Create a button, entry pair
proc Create_Option_Separator {text} {
   Debug "Create_Option_Separator"

   # Globals
   global FONT_BOLD DEFAULT_PADDING g_separator_number

   # Work out the canvas height
   set canvas .setup_window.setup_fr.c
   set canvas_height [$canvas cget -scrollregion]
   scan $canvas_height "%*d %*d %*d %d" canvas_height
   set canvas_height [expr $canvas_height + 40]
   $canvas configure -scrollregion "0 0 600 $canvas_height"

   # Create a label/textentry pair
   frame $canvas.s$g_separator_number
   label $canvas.s$g_separator_number.l \
      -text "_______________________ $text \
_______________________" -font $FONT_BOLD
   pack $canvas.s$g_separator_number.l \
      -fill x -side top -padx $DEFAULT_PADDING -pady \
      $DEFAULT_PADDING
   set offset [expr $canvas_height -40]
   $canvas create window 15 $offset -window $canvas.s$g_separator_number \
      -anchor nw -width 600

   # Increment option number
   incr g_separator_number
}

###############################################################
# The procedure for quitting the setup window
proc Close_Setup_Window {} {
   Debug "Close_Setup_Window"

   # Globals
   global g_setup_changed

   # Check to see whether anything has changed.
   if {$g_setup_changed == 1 && ![Question_Dialog .setup_window \
      "Do you wish to save changes?" "Save" "Reset Changes"]} {

      # Save requested
      Save_Setup
   } else {

      # Re-read defaults from file
      Source_Setup 0
      set g_setup_changed 0
   }

   # Destroy the window
   destroy .setup_window 
}

###############################################################
# The procedure for saving the configuration
proc Save_Setup {} {
   Debug "Save_Setup"

   # Globals
   global g_option_number g_setup_file g_setup_changed \
      TKNET_USER TKNET_GLOBAL_SETUP_FILE \
      TKNET_LOCAL_SETUP_FILE GREEN \
      gls_setup_list

   # Save the setup to file
   # For each of the piars of items in the window,
   # ascertain the variable name being modified, then
   # write the output to a temporary file

   # If root save to global settings, else save to users
   # local ~/.tknet_setup file
   if {$TKNET_USER == "root" && [Question_Dialog \
      . "Where do you want to save setup to?" \
      "Local" "Global"]} {
         set g_setup_file $TKNET_GLOBAL_SETUP_FILE
   } else {
      set g_setup_file $TKNET_LOCAL_SETUP_FILE
   }

   # Open the file
   set file_id [ open $g_setup_file w ]
   puts $file_id "## TkNet Setup Information"

   # Write all information   
   foreach option $gls_setup_list {

      # Write 
      global $option
      puts $file_id [join [list "set" "$option" \
        \"[eval subst {\$$option}]"]]
   }

   # Close file
   close $file_id

   # Display a dialog
   Set_Message "Setup Saved to $g_setup_file" $GREEN
   set g_setup_changed 0
}


