###############################################################
# TkNet - PPP Setup Module
# Charlie KEMPSON - charlie@siren.demon.co.uk
# http://public.logica.com/~kempsonc/tknet.htm
# Version 1.1
###############################################################

###############################################################
#
#    Copyright (c) 1995-1996 Charlie Kempson
#
#    This program is free software; you can redistribute it 
#    and/or modify it under the terms of the GNU General 
#    Public License as published by the Free Software 
#    Foundation (version 2 of the License).
#
#    This program is distributed in the hope that it will 
#    be useful, but WITHOUT ANY WARRANTY; without even the 
#    implied warranty of MERCHANTABILITY or FITNESS FOR A 
#    PARTICULAR PURPOSE.  See the GNU General Public License 
#    for more details.
#
#    For a copy of the GNU General Public License, write to the 
#    Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
#    MA 02139, USA.
###############################################################

###############################################################
# Globals for this module

# Geometry
set TKNET_SCRIPT_SELECT_GEOMETRY "+408+51"

###############################################################
# Routine to show window to set up scripts
proc Show_Interactive_Scripts {} {
   Debug "Show_Interactive_Scripts"

   # Globals
   global TKNET_SCRIPT_SELECT_GEOMETRY RIDGE_BORDER \
     DEFAULT_PADDING

   # Popup a selection window
   set window .script_select_window
   if [winfo exists $window] {
       # Pop it up!
       wm deiconify $window
       raise $window
       update
       return
   }
   # Otherwise create the window
   toplevel $window
   wm title $window "Script Setup"
   wm transient $window .
   wm geometry $window $TKNET_SCRIPT_SELECT_GEOMETRY

   ###########################################################################
   # Create Menu Bar
   frame $window.mbar -relief raised -bd 2
   pack $window.mbar -side top -fill x

   # Create the buttons   
   menubutton $window.mbar.file -text File -underline 0 -menu \
      $window.mbar.file.menu
   menubutton $window.mbar.script -text Edit -underline 0 \
      -menu $window.mbar.script.menu
   menubutton $window.mbar.help -text Help -underline 0 \
      -menu $window.mbar.help.menu
   pack $window.mbar.file $window.mbar.script \
      -side left
   pack $window.mbar.help -side right

   # Create each menu item
   menu $window.mbar.file.menu -tearoff 0
      $window.mbar.file.menu add command -label "Close" \
         -command "Return_Selected_Script $window" \
         -underline 0
   menu $window.mbar.script.menu -tearoff 0
      $window.mbar.script.menu add command -label "New" \
         -command "New_Script $window" -underline 0
      $window.mbar.script.menu add command -label "Edit" \
         -command "Edit_Script $window" -underline 0
      $window.mbar.script.menu add command -label "Delete" \
         -command "Delete_Script $window" -underline 0
   menu $window.mbar.help.menu -tearoff 0
      $window.mbar.help.menu add command -label "Show Help..." \
         -command "MH_MiniHelp ScriptListWindow" -underline 0

   # Create the menu
   tk_menuBar $window.mbar $window.mbar.file \
      $window.mbar.script $window.mbar.help
   bind $window <Button-3> "Popup_Menu $window \
      $window.mbar.script.menu"
   bind $window <Button-2> "Popup_Menu $window \
      $window.mbar.script.menu"

   # Create a frame containing a list and an entry field
   frame $window.sel_fr -borderwidth $RIDGE_BORDER \
      -relief groove
   pack $window.sel_fr -padx $DEFAULT_PADDING \
      -pady $DEFAULT_PADDING -side top -fill x
   label $window.sel_fr.label -text "Selected Script"
   entry $window.sel_fr.entry 
   $window.sel_fr.entry configure -state disabled
   pack $window.sel_fr.label \
      $window.sel_fr.entry -side left \
      -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING
   set list [ScrolledList $window.list_fr \
      0 10 browse 0]
   pack forget $window.list_fr
   pack $window.list_fr -side top -fill both \
      -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING \
      -expand true

   # Add bindings to the list.  Single click should copy the
   # entry into the selected area, double click should do that
   # and return.
   bind $list <ButtonRelease-1> "Select_Script $window $list"
   bind $list <Double-ButtonRelease-1> "Select_Script $window \
      $list; Edit_Script $window"

   # Refresh the listing
   Display_Interactive_Scripts $list
}

###############################################################
# Routine to display network scripts in the list
proc Display_Interactive_Scripts { list } {
   Debug "Display_Interactive_Scripts"

   # Add items to the list for the relevant types
   # (1) PPP scrips
   # (2) Commands

   # Delete current script information from memory
   set search "gs_ppp_*"
   set globals_list [info globals $search]
   foreach global $globals_list {
      global $global
      unset $global
   }
   set search "gs_cmd_*"
   set globals_list [info globals $search]
   foreach global $globals_list {
      global $global
      unset $global
   }

   # Re-read data from file
   PPP_Source_Scripts 0

   # Empty the list
   $list delete 0 end
 
   # Find all pppd network scripts
   set scripts [info globals "gs_ppp_name_*"]
   foreach script $scripts {
      # Get the script name
      global $script
      set script [subst $$script]
      $list insert end $script
   }

   # Find all cmd network scripts
   set scripts [info globals "gs_cmd_name_*"]
   foreach script $scripts {
      # Get the script name
      global $script
      set script [subst $$script]
      $list insert end $script
   }
}

###############################################################
# Routine to add a return the selected script to the script
# setup window
proc Return_Selected_Script { window } {
   Debug "Return_Selected_Script"

   # Copy the selected text into the entry field on
   # the scripts setup window.  Check that the user
   # hasn't dismissed the script setup window, though!
   if [winfo exists .script_setup] {
      # Ask the user if (s)he wishes to update all
      # the menus in the caller.  This will undo all
      # changes since the last save.
      if {[Question_Dialog \
         . "Reset the scripts window?  This will undo
all changes since the last save." \
         "Yes" "No"] == 0} {
         Show_Script_Setup
      }
   }

   if [winfo exists .launcher_setup] {
      # Ask the user if (s)he wishes to update all
      # the menus in the caller.  This will undo all
      # changes since the last save.
      if {[Question_Dialog \
         . "Reset the launcher setup window?  This will undo
all changes since the last save." \
         "Yes" "No"] == 0} {
         Show_Launcher_Setup
      }
   }

   # Destroy the window
   after 300 "destroy $window"
}

###############################################################
# Routine called when an item is selected from the script list
proc Select_Script { window list } {
   Debug "Select_Script"

   # Copy the selected item into the entry field
   $window.sel_fr.entry configure -state normal
   $window.sel_fr.entry delete 0 end
   $window.sel_fr.entry insert end [$list \
      get [$list curselection]]
   $window.sel_fr.entry configure -state disabled
}

###############################################################
# Routine to add a new script of type
proc New_Script { window } {
   Debug "New_Script"

   # Ask the user whether this is to be a command or a 
   # PPP setup
   if {[Question_Dialog \
      . "Create a PPP script or a command?" \
      "PPP" "Command"]} {
      CMD_Create_Session $window NEW New
   } else {
      PPP_Create_Session $window NEW New
   }
}

###############################################################
# Routine to edit a script of type
proc Edit_Script { window } {
   Debug "Edit_Script"

   # Check that a script has been selected
   set text [$window.sel_fr.entry get]
   if {$text == ""} {
      Info_Dialog . "Please select a script to edit!"
   } else {
      # Check to see whether the script is a command
      # or a PPP session
      regsub -all {[\ ]+} $text {_} search
      set scripts [info globals "gs_ppp_name_$search"]
      if {[llength $scripts] > 0} {
         # Start up PPP editor
         PPP_Create_Session $window EDIT $text
      } else {
         # Start up command editor
         CMD_Create_Session $window EDIT $text
      }
   }
}

###############################################################
# Routine to delete a new script of type
proc Delete_Script { window } {
   Debug "Delete_Script"

   # Globals
   global TKNET_USER TKNET_GLOBAL_NETWORK_FILE \
      TKNET_LOCAL_NETWORK_FILE

   # Confirm operation
   set text [$window.sel_fr.entry get]
   if {$text == ""} {
      Info_Dialog . "No script selected!"
      return
   } else {
      if {[Question_Dialog \
         . "Really delete script '$text'?" \
         "Yes" "No"]} {
         # Cancelled operation
         return
      }
   }

   if {$TKNET_USER == "root" && [Question_Dialog \
      . "Where do you want to delete the network script from?" \
      "Local" "Global"]} {
         set setup_file $TKNET_GLOBAL_NETWORK_FILE
   } else {
      set setup_file $TKNET_LOCAL_NETWORK_FILE
   }

   # Find and delete the script
   set fd [open $setup_file r]
   set file_text [read $fd]
   close $fd

   # Determine the type of script to be deleted
   regsub -all {[\ ]+} $text {_} script
   set scripts [info globals "gs_ppp_name_$script"]
   if {[llength $scripts] > 0} {
      set title_variable "gs_ppp_name_$script"
   } else {
      set title_variable "gs_cmd_name_$script"
   }

   set start [string first "### $title_variable" $file_text]
   if {$start != -1} {
      set rest_file [string range $file_text [expr \
         $start + 4] end]
      set end [string first "###" $rest_file]
      set file_text [string range $file_text \
         0 [expr $start -1]]
      if {$end != -1} {
         set rest_file [string range $rest_file $end end]
         append file_text $rest_file
      }

      # And then overwrite the existing file
      set fd [open $setup_file w 755]
      puts -nonewline $fd $file_text
      flush $fd
      close $fd
      Info_Dialog $window "Script '$text' deleted"
   } else {
      Info_Dialog . "Unable to delete script '$text' : Not found"
   }

   # Refresh the list
   Display_Interactive_Scripts $window.list_fr.list
}
