###############################################################
# TkNet - Options Module
# Charlie KEMPSON - charlie@siren.demon.co.uk
# http://public.logica.com/~kempsonc/tknet.htm
# Version 1.1
###############################################################

###############################################################
#
#    Copyright (c) 1995-1996 Charlie Kempson
#
#    This program is free software; you can redistribute it 
#    and/or modify it under the terms of the GNU General 
#    Public License as published by the Free Software 
#    Foundation (version 2 of the License).
#
#    This program is distributed in the hope that it will 
#    be useful, but WITHOUT ANY WARRANTY; without even the 
#    implied warranty of MERCHANTABILITY or FITNESS FOR A 
#    PARTICULAR PURPOSE.  See the GNU General Public License 
#    for more details.
#
#    For a copy of the GNU General Public License, write to the 
#    Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
#    MA 02139, USA.
###############################################################

###############################################################
# Globals for this module

# Geometry
set TKNET_DISPLAY_OPTIONS_GEOMETRY "+500+150"
set TKNET_STARTUP_OPTIONS_GEOMETRY "+500+150"
set TKNET_CONNECT_OPTIONS_GEOMETRY "+500+150"

# Files
set TKNET_GLOBAL_OPTIONS_FILE "$GLOBAL_INCLUDE/tknet.preferences"
set TKNET_LOCAL_OPTIONS_FILE "$TKNET_USER_HOME/.tknet_preferences"

# Flags
set gls_options_list [list gb_ping_connection gb_auto_reconnect \
                          gb_reset_clock_on_connect gb_beep_on_connect \
                          gb_beep_on_new_mail gb_show_microhelp \
                          gb_show_launcher_at_startup gb_confirm_quit \
                          gb_launcher_window gi_launcher_button_style \
                          gb_show_time gb_show_buttons gb_show_messages\
                          gb_save_positions gb_check_for_mail \
                          gb_startup_iconified gb_launcher_vertical \
                          gb_show_stats gb_display_compact gb_show_mail\
                          gb_connect_on_startup g_graph_bg g_graph_fg \
                          g_graph_max g_graph_units g_graph_lineincr \
                          g_graph_height g_graph_width g_graph_markline \
                          g_graph_pixelsec g_message_display_time \
                          g_connected_pixmap g_disconnected_pixmap \
                          g_num_launcher_rows g_mail_refresh_freq \
                          g_clock_refresh_freq g_network_check_freq \
                          g_link_stats g_idle_disconnect_time \
                          g_biff_check g_mail_pixmap g_nomail_pixmap \
                          gb_have_sendmail]
set gls_geometry_list [list TKNET_GEOMETRY \
                          TKNET_LOG_GEOMETRY TKNET_SETUP_GEOMETRY \
                          TKNET_LAUNCHER_SETUP_GEOMETRY \
                          TKNET_MAIL_GEOMETRY TKNET_LAUNCHER_GEOMETRY \
                          TKNET_HELP_GEOMETRY TKNET_SCRIPT_SETUP_GEOMETRY \
                          TKNET_NET_GEOMETRY TKNET_SCRIPT_SELECT_GEOMETRY \
                          TKNET_PPP_GEOMETRY TKNET_DISPLAY_OPTIONS_GEOMETRY \
                          TKNET_GRAPH_OPTIONS_GEOMETRY \
                          TKNET_STARTUP_OPTIONS_GEOMETRY \
                          TKNET_CONNECT_OPTIONS_GEOMETRY \
                          TKNET_COLOUR_GEOMETRY]
set gb_ping_connection  1
set gb_auto_reconnect   0
set gb_reset_clock_on_connect 0
set gb_beep_on_connect  1
set gb_check_for_mail   1
set gb_beep_on_new_mail 0
set gb_show_microhelp   0
set gb_show_mail        0
set gb_show_launcher_at_startup 1
set gb_launcher_window  0
#1=labels,2=bitmaps,3=both
set gi_launcher_button_style 1 
set gb_confirm_quit     1
set gb_show_time        1
set gb_show_buttons     1
set gb_show_messages    1
set gb_save_positions   0
set gb_startup_iconified 0
set gb_launcher_vertical 0
set gb_show_stats       0
set gb_display_compact  0
set gb_connect_on_startup 0
set g_graph_bg          Grey60
set g_graph_fg          HotPink
set g_graph_max         3000
set g_graph_units       "Pckt/sec"
set g_graph_lineincr    1000
set g_graph_height      60
set g_graph_width       100
set g_graph_markline    1
set g_graph_pixelsec    2
set g_message_display_time 7
set g_connected_pixmap "/usr/include/X11/pixmaps/tknetup.xpm"
set g_disconnected_pixmap "/usr/include/X11/pixmaps/tknetdn.xpm"
set g_num_launcher_rows 1
set g_mail_refresh_freq 20
set g_clock_refresh_freq 1
set g_network_check_freq 5
set g_link_stats        2
set g_idle_disconnect_time 0
set g_biff_check        5
set g_mail_pixmap       ""
set g_nomail_pixmap     ""
set gb_have_sendmail    1

###############################################################
# The procedure to read the options files
# Argument must be 0=Both 1=Global or 2=Local 
proc Source_Options { file } {
   Debug "Source_Options"

   # Globals
   global TKNET_GLOBAL_OPTIONS_FILE TKNET_LOCAL_OPTIONS_FILE \
      gls_options_list gls_geometry_list
   eval global [split $gls_options_list]
   eval global [split $gls_geometry_list]

   # Read the global options file
   if {$file != 2 && [file exists $TKNET_GLOBAL_OPTIONS_FILE]} {
      source $TKNET_GLOBAL_OPTIONS_FILE
   }
   
   # Read the user's own config file if it exists
   if {$file != 1 && [file exists $TKNET_LOCAL_OPTIONS_FILE]} {
      # Override with users own
      source $TKNET_LOCAL_OPTIONS_FILE
   }

   # Note that if neither exist the defaults are
   # taken from the internal settings corresponding
   # to my home settings.
}

###############################################################
# The procedure for saving the configuration options
proc Save_Options {} {
   Debug "Save_Options"

   # Globals
   global g_option_number g_option_file \
      TKNET_USER TKNET_GLOBAL_OPTIONS_FILE \
      TKNET_LOCAL_OPTIONS_FILE GREEN \
      gls_options_list gls_geometry_list 

   # Save the setup to file
   # For each of the piars of items in the window,
   # ascertain the variable name being modified, then
   # write the output to a temporary file

   # If root save to global settings, else save to users
   # local ~/.tknet_preferences file
   if {$TKNET_USER == "root" && [Question_Dialog \
      . "Where do you want to save options to?" \
      "Local" "Global"]} {
         set g_setup_file $TKNET_GLOBAL_OPTIONS_FILE
   } else {
      set g_setup_file $TKNET_LOCAL_OPTIONS_FILE
   }

   # Open the file
   set file_id [ open $g_setup_file w ]
   puts $file_id "## TkNet Options Information"

   foreach option $gls_options_list {

      # Write 
      global $option
      puts $file_id [join [list "set" "$option" \
        \"[eval subst {\$$option}]"]]
   }

   if {$gb_save_positions == 1} {

      # Get the current geometry information
      Get_Current_Geometry

      puts $file_id " "
      puts $file_id "## TkNet Geometry Information"
      foreach option $gls_geometry_list {

         # Write geometry info
         global $option
         puts $file_id [join [list "set" "$option" \
           \"[eval subst {\$$option}]"]]
      }
   }

   # Close file
   close $file_id

   # Display a dialog
   Set_Message "Options Saved to $g_setup_file" $GREEN
}

###############################################################
# The procedure for getting the geometry of currently
# displayed windows
proc Get_Current_Geometry {} {
   Debug "Get_Current_Geometry"

   # Globals
   global gls_geometry_list
   eval global [split $gls_geometry_list]

   # Get the following information only
   # if window currently mapped
   update 

   if [winfo exists .] {set TKNET_GEOMETRY [Get_Geometry .]}
   if [winfo exists .log_window] {set TKNET_LOG_GEOMETRY [Get_Geometry .log_window]}
   if [winfo exists .launcher_setup] {set TKNET_LAUNCHER_SETUP_GEOMETRY [Get_Geometry .launcher_setup]}
   if [winfo exists .launcher_window] {set TKNET_LAUNCHER_GEOMETRY [Get_Geometry .launcher_window]}
   if [winfo exists .setup_window] {set TKNET_SETUP_GEOMETRY [Get_Geometry .setup_window]}
   if [winfo exists .mail_window] {set TKNET_MAIL_GEOMETRY [Get_Geometry .mail_window]}
   if [winfo exists .mini_help_window] {set TKNET_HELP_GEOMETRY [Get_Geometry .mini_help_window]}
   if [winfo exists .script_setup] {set TKNET_SCRIPT_SETUP_GEOMETRY [Get_Geometry .script_setup]}
   if [winfo exists .net_window] {set TKNET_NET_GEOMETRY [Get_Geometry .net_window]}
   if [winfo exists .script_select_window] {set TKNET_SCRIPT_SELECT_GEOMETRY [Get_Geometry .script_select_window]}
   # Note that this saves the position of the first window invoked.
   if [winfo exists .ppp_window_0] {set TKNET_PPP_GEOMETRY [Get_Geometry .ppp_window_0]}
   if [winfo exists .graph_options_window] {set TKNET_GRAPH_OPTIONS_GEOMETRY [Get_Geometry .graph_options_window]}
   if [winfo exists .display_options_window] {set TKNET_DISPLAY_OPTIONS_GEOMETRY [Get_Geometry .display_options_window]}
   if [winfo exists .startup_options_window] {set TKNET_STARTUP_OPTIONS_GEOMETRY [Get_Geometry .startup_options_window]}
   if [winfo exists .connect_options_window] {set TKNET_CONNECT_OPTIONS_GEOMETRY [Get_Geometry .connect_options_window]}
   if [winfo exists .graph_options_window] {set TKNET_COLOUR_GEOMETRY [Get_Geometry .graph_options_window]}
}

###############################################################
# Get the window position
proc Get_Geometry { window } {
   Debug "Get_Geometry"

   set y [winfo y $window]
   if {$y < 0} {set y 0}
   set x [winfo x $window]
   if {$x < 0} {set x 0}

   # Return the geometry for the window
   return "+$x+$y"
}

###############################################################
# Function to modify Startup options
proc Show_Display_Setup {} {
   Debug "Show_Display_Setup"

   # Create the interface and fill with the options
   # information.  The globals maintained using this
   # interface are:
   #
   # gb_display_compact - Whether the main window should
   #   be displayed in compact form or not.
   # gb_show_time - Whether the time information is displayed
   # gb_show_buttons - Whether the buttons are displayed
   # gb_show_stats - Whether the statistics are displayed
   # gb_show_messages - Whether messages are displayed
   # gb_show_microhelp - Whether microhelp is turned on
   #
   # g_message_display_time - Number of seconds to show messages
   # g_connected_pixmap - Pixmap when connected
   # g_disconnected_pixmap - Pixmap when not connected
   # g_mail_pixmap - Pixmap when new mail
   # g_nomail_pixmap - Pixmap when no new mail
   # g_num_launcher_rows - Number of rows in the launcher

   # Globals
   global TKNET_DISPLAY_OPTIONS_GEOMETRY RIDGE_BORDER DEFAULT_PADDING \
      gb_display_compact gb_show_time gb_show_buttons gb_show_stats \
      gb_show_messages gb_show_microhelp gb_show_mail \
      g_message_display_time g_connected_pixmap g_disconnected_pixmap \
      g_num_launcher_rows g_mail_pixmap g_nomail_pixmap

   # Popup a selection window
   set window .display_options_window
   if [winfo exists $window] {
       # Pop it up!
       wm deiconify $window
       raise $window
       update
       return
   }

   # Otherwise create the window
   toplevel $window
   wm title $window "Display Options"
   wm transient $window .
   wm geometry $window $TKNET_DISPLAY_OPTIONS_GEOMETRY
   wm protocol $window WM_DELETE_WINDOW "Apply_Display_Settings; \
      destroy $window"
   set frame [frame $window.fr1]
   pack $frame -fill x -anchor nw 

   ############################################################
   # Create a frame for the options
   set frame1 [frame $frame.type -borderwidth $RIDGE_BORDER -relief \
      groove]
   label $frame1.label -text "Main Window Display"
   radiobutton $frame1.1 -text "Normal" -variable \
      gb_display_compact -value 0
   radiobutton $frame1.2 -text "Compact" -variable \
      gb_display_compact -value 1
   pack $frame1.label $frame1.1 $frame1.2 -anchor nw

   ############################################################
   # Create a second frame for the options
   set frame2 [frame $frame.mail -borderwidth $RIDGE_BORDER -relief \
      groove]
   label $frame2.label -text "Display Elements"
   checkbutton $frame2.1 -text "Time Connected" -variable \
      gb_show_time
   checkbutton $frame2.2 -text "Connection Statistics" -variable \
      gb_show_stats
   checkbutton $frame2.6 -text "Mailbox Status" -variable \
      gb_show_mail
   checkbutton $frame2.3 -text "Convenience Buttons" -variable \
      gb_show_buttons
   checkbutton $frame2.4 -text "Messages" -variable \
      gb_show_messages
   checkbutton $frame2.5 -text "Microhelp" -variable \
      gb_show_microhelp
   pack $frame2.label $frame2.1 $frame2.2 $frame2.6 $frame2.3 \
      $frame2.4 $frame2.5 -anchor nw

   # Pack the frames
   pack $frame1 $frame2 -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING \
      -side left -fill both -expand true

   # Now for a frame to hold the display settings
   set frame [frame $window.fr2]
   pack $frame -fill x -expand true -anchor nw

   ############################################################
   # Create a frame for the options
   set frame1 [canvas $frame.opts -borderwidth $RIDGE_BORDER -relief \
      groove -width 400 -height 200 -highlightthickness 0]
   pack $frame1 -fill x -expand true -anchor nw -padx $DEFAULT_PADDING 

   # Build the items
   set offset 5
   set xoffset 200
   set xoffset2 360
   set temp [label $frame1.label -text "Display Settings"]
   $frame1 create window 5 $offset -window $temp -anchor nw

   incr offset 26
   set temp [label $frame1.l1 -text "Number of Launcher Rows"]
   $frame1 create window 5 $offset -window $temp -anchor nw
   set temp [entry $frame1.e1 -width 5 -textvariable g_num_launcher_rows]
   $frame1 create window $xoffset $offset -window $temp -anchor nw

   incr offset 26
   set temp [label $frame1.l2 -text "Display Messages for (secs)"]
   $frame1 create window 5 $offset -window $temp -anchor nw
   set temp [entry $frame1.e2 -width 5 -textvariable g_message_display_time]
   $frame1 create window $xoffset $offset -window $temp -anchor nw

   incr offset 26
   set temp [label $frame1.l3 -text "Pixmap when Connected"]
   $frame1 create window 5 $offset -window $temp -anchor nw
   set temp [entry $frame1.e3 -width 18 -textvariable g_connected_pixmap]
   $frame1 create window $xoffset $offset -window $temp -anchor nw
   set temp [button $frame1.b3 -text "..." -command \
      "Field_File_Select $frame1.e3"]
   $frame1 create window $xoffset2 $offset -window $temp -anchor nw

   incr offset 26
   set temp [label $frame1.l4 -text "Pixmap when Connected"]
   $frame1 create window 5 $offset -window $temp -anchor nw
   set temp [entry $frame1.e4 -width 18 -textvariable g_disconnected_pixmap]
   $frame1 create window $xoffset $offset -window $temp -anchor nw
   set temp [button $frame1.b4 -text "..." -command \
      "Field_File_Select $frame1.e4"]
   $frame1 create window $xoffset2 $offset -window $temp -anchor nw

   incr offset 26
   set temp [label $frame1.l5 -text "Pixmap when No Mail"]
   $frame1 create window 5 $offset -window $temp -anchor nw
   set temp [entry $frame1.e5 -width 18 -textvariable g_nomail_pixmap]
   $frame1 create window $xoffset $offset -window $temp -anchor nw
   set temp [button $frame1.b5 -text "..." -command \
      "Field_File_Select $frame1.e5"]
   $frame1 create window $xoffset2 $offset -window $temp -anchor nw

   incr offset 26
   set temp [label $frame1.l6 -text "Pixmap when New Mail"]
   $frame1 create window 5 $offset -window $temp -anchor nw
   set temp [entry $frame1.e6 -width 18 -textvariable g_mail_pixmap]
   $frame1 create window $xoffset $offset -window $temp -anchor nw
   set temp [button $frame1.b6 -text "..." -command \
      "Field_File_Select $frame1.e6"]
   $frame1 create window $xoffset2 $offset -window $temp -anchor nw

   ############################################################
   # Now for a close button
   set frame [frame $window.button_fr]
   pack $frame -side bottom -fill x
   button $frame.apply -text Apply -command Apply_Display_Settings
   button $frame.help -text Help -command "MH_MiniHelp DisplaySettings"
   button $frame.close -text Close -command \
      "Apply_Display_Settings; destroy $window"
   pack $frame.close $frame.apply $frame.help -side right -padx \
      $DEFAULT_PADDING -pady $DEFAULT_PADDING
}

###############################################################
# Function to modify Startup options
proc Apply_Display_Settings {} {
   Debug "Apply_Display_Settings"

   # Globals
   global gb_display_compact gb_show_time gb_show_buttons gb_show_stats \
      gb_show_messages gb_show_microhelp gb_show_mail

   # Apply the options - check the compact flag

   # And the rest
   Show_Status 1
   Show_Mail_Row $gb_show_mail
   Show_Time $gb_show_time
   Show_Buttons $gb_show_buttons
   Show_Stats $gb_show_stats
   Show_Messages $gb_show_messages
}

###############################################################
# Function to modify Startup options
proc Show_Startup_Setup {} {
   Debug "Show_Startup_Setup"

   # Create the interface and fill with the options
   # information.  The globals maintained using this
   # interface are:
   #
   # gb_startup_iconified - Whether to start iconified
   # gb_connect_on_startup - Whether to connect on startup

   # Globals
   global TKNET_STARTUP_OPTIONS_GEOMETRY RIDGE_BORDER DEFAULT_PADDING \
      gb_startup_iconified gb_connect_on_startup

   # Popup a selection window
   set window .startup_options_window
   if [winfo exists $window] {
       # Pop it up!
       wm deiconify $window
       raise $window
       update
       return
   }

   # Otherwise create the window
   toplevel $window
   wm title $window "Startup Options"
   wm transient $window .
   wm geometry $window $TKNET_STARTUP_OPTIONS_GEOMETRY
   wm protocol $window WM_DELETE_WINDOW "destroy $window"
   set frame [frame $window.fr]
   pack $frame

   ############################################################
   # Create a frame for the options
   set frame1 [frame $frame.type -borderwidth $RIDGE_BORDER -relief \
      groove]
   label $frame1.label -text "Startup Options"
   checkbutton $frame1.1 -text "Startup Iconified" -variable \
      gb_startup_iconified
   checkbutton $frame1.2 -text "Connect on Startup" -variable \
      gb_connect_on_startup
   pack $frame1.label $frame1.1 $frame1.2 -anchor nw

   # Pack the frames
   pack $frame1 -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING \
      -fill y -side left

   # Now for a close button
   set frame [frame $window.button_fr]
   pack $frame -side bottom -fill x
   button $frame.close -text Close -command "destroy $window"
   button $frame.help -text Help -command "MH_MiniHelp StartupOptions"
   pack $frame.close $frame.help -side right -padx $DEFAULT_PADDING -pady \
      $DEFAULT_PADDING
}

###############################################################
# Function to modify connect and mail options
proc Show_Connect_Setup {} {
   Debug "Show_Connect_Setup"

   # Create the interface and fill with the options
   # information.  The globals maintained using this
   # interface are:
   #
   # gb_ping_connection - Ping when connected
   # gb_auto_reconnect - Reconnect on Disconnect
   # gb_reset_clock_on_connect - Reset the clock when connection made
   # gb_beep_on_connect - Beep on connect and disconnect
   # g_mail_refresh_freq - Mail refresh frequency (in mail window)
   # g_clock_refresh_freq - Frequency with which to update the clock
   # g_network_check_freq - Frequency with which to check the connection
   # g_link_stats - Network statistics every (secs)
   # g_idle_disconnect_time - Mins after which to disconnect
   # 
   # gb_check_for_mail - Run internal BIFF function
   # gb_beep_on_new_mail - Beep when new mail detected
   # g_biff_check - Check for mail every (secs)
   # gb_have_sendmail - Do you use sendmail?

   # Globals
   global TKNET_CONNECT_OPTIONS_GEOMETRY RIDGE_BORDER DEFAULT_PADDING \
      gb_ping_connection gb_auto_reconnect gb_reset_clock_on_connect \
      gb_beep_on_connect gb_check_for_mail gb_beep_on_new_mail \
      g_biff_check g_mail_refresh_freq g_clock_refresh_freq \
      g_network_check_freq g_link_stats g_idle_disconnect_time \
      gb_have_sendmail

   # Popup a selection window
   set window .connect_options_window
   if [winfo exists $window] {
       # Pop it up!
       wm deiconify $window
       raise $window
       update
       return
   }

   # Otherwise create the window
   toplevel $window
   wm title $window "Connection and Mail Options"
   wm transient $window .
   wm geometry $window $TKNET_CONNECT_OPTIONS_GEOMETRY
   wm protocol $window WM_DELETE_WINDOW "destroy $window"
   set frame [frame $window.fr]
   pack $frame -fill both

   ############################################################
   # Create a frame for the options
   set frame1 [frame $frame.connect -borderwidth $RIDGE_BORDER -relief \
      groove]
   label $frame1.label -text "Connection Options"
   checkbutton $frame1.1 -text "Ping when Connected" -variable \
      gb_ping_connection
   checkbutton $frame1.2 -text "Reconnect on Disconnect" -variable \
      gb_auto_reconnect
   checkbutton $frame1.3 -text "Reset Clock on Connection" -variable \
      gb_reset_clock_on_connect
   checkbutton $frame1.4 -text "Beep on Connect & Disconnect" -variable \
      gb_beep_on_connect
   pack $frame1.label $frame1.1 $frame1.2 $frame1.3 $frame1.4 -anchor nw

   ############################################################
   # Create a second frame for the options
   set frame2 [frame $frame.mail -borderwidth $RIDGE_BORDER -relief \
      groove]
   label $frame2.label -text "Mail Options"
   checkbutton $frame2.1 -text "Check for New Mail" -variable \
      gb_check_for_mail
   checkbutton $frame2.2 -text "Beep on New Mail" -variable \
      gb_beep_on_new_mail
   checkbutton $frame2.3 -text "Have Sendmail?" -variable \
      gb_have_sendmail
   pack $frame2.label $frame2.1 $frame2.2 $frame2.3 -anchor nw

   # Pack the frames
   pack $frame1 $frame2 -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING \
      -fill both -side left

   ############################################################
   # Create a frame for the options
   set frame [canvas $window.opts -borderwidth $RIDGE_BORDER -relief \
      groove -width 300 -height 170 -highlightthickness 0]
   pack $frame -fill both -expand true -anchor nw -padx $DEFAULT_PADDING 

   # Build the items
   set offset 5
   set xoffset 250
   set temp [label $frame.label -text "Timing Information"]
   $frame create window 5 $offset -window $temp -anchor nw

   # g_mail_refresh_freq - Mail refresh frequency (in mail window)
   # g_clock_refresh_freq - Frequency with which to update the clock
   # g_network_check_freq - Frequency with which to check the connection
   # g_link_stats - Network statistics every (secs)
   # g_idle_disconnect_time - Mins after which to disconnect

   incr offset 26
   set temp [label $frame.l$offset -text "Mail window refresh (secs)"]
   $frame create window 5 $offset -window $temp -anchor nw
   set temp [entry $frame.e$offset -width 5 -textvariable g_mail_refresh_freq]
   $frame create window $xoffset $offset -window $temp -anchor nw

   incr offset 26
   set temp [label $frame.l$offset -text "Clock update frequency (secs)"]
   $frame create window 5 $offset -window $temp -anchor nw
   set temp [entry $frame.e$offset -width 5 -textvariable g_clock_refresh_freq]
   $frame create window $xoffset $offset -window $temp -anchor nw

   incr offset 26
   set temp [label $frame.l$offset -text "Network check every (secs)"]
   $frame create window 5 $offset -window $temp -anchor nw
   set temp [entry $frame.e$offset -width 5 -textvariable g_network_check_freq]
   $frame create window $xoffset $offset -window $temp -anchor nw

   incr offset 26
   set temp [label $frame.l$offset -text "Link statistics every (secs)"]
   $frame create window 5 $offset -window $temp -anchor nw
   set temp [entry $frame.e$offset -width 5 -textvariable g_link_stats ]
   $frame create window $xoffset $offset -window $temp -anchor nw

   incr offset 26
   set temp [label $frame.l$offset -text "Disconnect after idle (mins)"]
   $frame create window 5 $offset -window $temp -anchor nw
   set temp [entry $frame.e$offset -width 5 -textvariable g_idle_disconnect_time]
   $frame create window $xoffset $offset -window $temp -anchor nw

   # Now for a close button
   set frame [frame $window.button_fr]
   pack $frame -side bottom -fill x
   button $frame.close -text Close -command "destroy $window"
   button $frame.help -text Help -command "MH_MiniHelp ConnectMailOptions"
   pack $frame.close $frame.help -side right -padx $DEFAULT_PADDING \
      -pady $DEFAULT_PADDING
}


