###############################################################
# TkNet - Mail Module
# Charlie KEMPSON - charlie@siren.demon.co.uk
# http://public.logica.com/~kempsonc/tknet.htm
# Version 1.1
###############################################################

###############################################################
#
#    Copyright (c) 1995-1996 Charlie Kempson
#
#    This program is free software; you can redistribute it 
#    and/or modify it under the terms of the GNU General 
#    Public License as published by the Free Software 
#    Foundation (version 2 of the License).
#
#    This program is distributed in the hope that it will 
#    be useful, but WITHOUT ANY WARRANTY; without even the 
#    implied warranty of MERCHANTABILITY or FITNESS FOR A 
#    PARTICULAR PURPOSE.  See the GNU General Public License 
#    for more details.
#
#    For a copy of the GNU General Public License, write to the 
#    Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
#    MA 02139, USA.
###############################################################

###############################################################
# Globals for this module

# Flags
set gb_mail_window_up   0
set gb_delivering_mail  0
set gs_incoming_mail    ""
set gs_outgoing_mail    ""
set g_spool_file_size   0

# Geometry
set TKNET_MAIL_GEOMETRY "+21+262"

###############################################################
# The procedure for delivering mail
proc Deliver_Mail { } {
   Debug "Deliver_Mail"

   # Globals
   global GREEN RED gb_delivering_mail

   # Set an hourglass
   WatchCursor
   Set_Message "Fetching / delivering mail ..." $GREEN

   # Start the connection process in the background
   Net_Connect

   # Set the disconnect when mail delivered flag.   This is checked by the
   # Background_Mail_Check routine - when there is no mail left to deliver
   # a disconnect is performed and the mail window is closed.
   set gb_delivering_mail 1

   # Open the mail window
   Show_Mail

   # Reset the hourglass
   NormalCursor
}

###############################################################
# Show the mail panel
proc Show_Mail { } {
   Debug "Show_Mail"

   # Globals
   global gt_incoming_mail gt_outgoing_mail FONT_NORMAL \
      FIXED_FONT_SMALL RIDGE_BORDER DEFAULT_PADDING GREEN \
      gb_mail_window_up gs_incoming_mail gs_outgoing_mail \
      TKNET_MAIL_GEOMETRY

   # Create the mail toplevel as a transient from the main window
   set window .mail_window
   if [winfo exists $window] return
   toplevel $window
   wm title $window "Manage Mail"
   wm transient $window .
   wm geometry $window $TKNET_MAIL_GEOMETRY
   wm protocol $window WM_DELETE_WINDOW Close_Mail_Window

   # The mail window comprises three areas, plus menus + buttons
   # A menu bar duplicates the buttons and provides close
   # functions.  The next area is a list of outgoing mail -
   # use sendmail -bq?   The third area is a list of mail
   # waiting on the server - ping siren@post.demon.co.uk.
   # The fourth area is a message line which indicates the
   # current state of the connection, i.e. network down,
   # SMTP connections made, no mail left on demon, no
   # mail left to deliver etc.  At the bottom of the
   # screen is a button bar which allows exmh to be started
   # and the window to be dismissed.

   ###########################################################################
   # Create Menu Bar
   set menu [frame $window.mbar -relief raised -bd 2]
   frame $window.dummy -width 10c -height 5m
   pack $window.mbar $window.dummy -side top -fill x

   menubutton $menu.file -text File -underline 0 -menu $menu.file.menu
   menubutton $menu.mail -text Mail -underline 0 -menu $menu.mail.menu
   menubutton $menu.help -text Help -underline 0 -menu $menu.help.menu
   pack $menu.file $menu.mail -side left
   pack $menu.help -side right

   menu $menu.file.menu -tearoff 0
      $menu.file.menu add command -label "Close" \
         -command { Close_Mail_Window } -underline 0
   menu $menu.mail.menu -tearoff 0
      $menu.mail.menu add command -label \
         "Deliver Queued Mail" -command {Run_Mail_Queue} -underline 0
      $menu.mail.menu add command -label \
         "Start Mailtool" -command {Run_Mail_Tool} -underline 0
   menu $menu.help.menu -tearoff 0
      $menu.help.menu add command -label "Show Help" \
         -command {MH_MiniHelp MailWindow} -underline 0

   tk_menuBar $menu $menu.file $menu.mail $menu.help
   set frame [frame $window.main_fr]
   pack $frame

   ###############################################################
   # Create the incoming mail panel
   set frame1 [frame $frame.incoming_fr -borderwidth $RIDGE_BORDER \
      -relief groove]
   label $frame1.label -text "Incoming Mail"
   pack $frame1.label -side top -anchor w
   set gt_incoming_mail [ScrolledText $frame1.log_st 60 10 1]
   $gt_incoming_mail configure -takefocus 0 -font $FIXED_FONT_SMALL

   ###############################################################
   # Create the outgoing mail panel
   set frame2 [frame $frame.outgoing_fr -borderwidth $RIDGE_BORDER \
      -relief groove]
   pack $frame2 -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING -side top \
      -expand true -fill both
   label $frame2.label -text "Outgoing Mail"
   pack $frame2.label -side top -anchor w
   set gt_outgoing_mail [ScrolledText $frame2.log_st 60 10 1]
   $gt_outgoing_mail configure -takefocus 0 -font $FIXED_FONT_SMALL
   pack $frame1 $frame2 -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING \
      -side top -expand true -fill both

   ###############################################################
   # Create the buttons below the frame
   set frame [frame $window.button_frame \
      -borderwidth $DEFAULT_PADDING]
   pack $frame -side bottom -fill x
   button $frame.close -text Close -command {Close_Mail_Window}
   button $frame.mailtool -text "Mailtool ..." -command {Run_Mail_Tool}
   button $frame.help -text "Help" -command {MH_MiniHelp MailWindow}
   pack $frame.close $frame.mailtool $frame.help -side right \
      -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING

   ###############################################################
   # Startup the background processing
   set gb_mail_window_up 1
   Background_Mail_Check
}

###############################################################
# Run the mail queue
proc Run_Mail_Queue { } {
   Debug "Run_Mail_Queue"

   # Globals
   global g_runq_command GREEN RED g_log_file

   # Set global hourglassing
   WatchCursor

   # Run the sendmail queue
   if [catch { eval exec $g_runq_command >>& $g_log_file } \
      error_text] {
      Set_Message "Unable to run mail queue" $RED
   } else {
      Set_Message "Mail queue run successfully" $GREEN
   }

   # Undo hourglassing
   NormalCursor
}

###############################################################
# Run mailtool (exmh)
proc Run_Mail_Tool { } {
   Debug "Run_Mail_Tool"

   # Globals
   global g_mailtool GREEN RED g_log_file

   # Set global hourglassing
   WatchCursor

   # Run the mailtool
   if [catch { eval exec $g_mailtool >>& $g_log_file & } \
      error_text] {
      Set_Message "Unable to start $g_mailtool" $RED
   } else {
      Set_Message "Mailtool starting ..." $GREEN
   }

   # Undo hourglassing
   NormalCursor
}

###############################################################
# The procedure for checking mail
# If manual_flag is 1, message is written even when no new mail
proc Biff { manual_flag } {
   Debug "Biff"

   # Globals
   global gs_spool_dir g_spool_file_size gb_beep_on_new_mail \
      TKNET_USER g_biff_check RED gb_check_for_mail g_mail_status \
      g_mail_pixmap g_nomail_pixmap

   # Now check the TKNET_USER's spool file for new mail
   if {$gb_check_for_mail == 1 || $manual_flag == 1} {
      if [catch {set spool_size [file size "$gs_spool_dir/$TKNET_USER"]}] {
         Info_Dialog . "TkNet connot find your mail spool file!
Check the Environment Settings window.
Mail checking has been disabled."
         $g_mail_status configure -text "Mail?"
         return
      }
      if {$manual_flag == 1} {set g_spool_file_size 0}
      if { $spool_size > $g_spool_file_size } {
   
         # Spool file has new data in it
         Set_Message "YOU HAVE NEW MAIL!" $RED
   
         # Beep if option set
         if {$gb_beep_on_new_mail == 1} {
            bell
         }

         # Set the pixmap if one is specified
         if {$g_mail_pixmap != ""} {
            set Image [Create_Image $g_mail_pixmap]
            if {$Image != -1} {
               $g_mail_status configure -image $Image
            } else {
               # Image creation did not work, so turn it off!
               $g_mail_status configure -text "New Mail!"
               set g_mail_pixmap ""
            }
         } else {
            $g_mail_status configure -text "New Mail!"
         }

      } else {
         # Spool file has no new data in it
         # Set the pixmap if one is specified
         if {$spool_size == 0} {
            if {$g_nomail_pixmap != ""} {
               set Image [Create_Image $g_nomail_pixmap]
               if {$Image != -1} {
                  $g_mail_status configure -image $Image
               } else {
                  # Image creation did not work, so turn it off!
                  $g_mail_status configure -text "No Mail"
                  set g_nomail_pixmap ""
               }
            } else if {$spool_size == 0} {
               $g_mail_status configure -text "No Mail"
            }
         }
      }

      # Remember the new size
      set g_spool_file_size $spool_size
   }

   # Recall after N secs
   if {$g_biff_check > 0} {
      set run_after [ expr $g_biff_check * 1000 ]
      after $run_after Biff 0
   }
}

###############################################################
# The procedure for checking mail
proc Background_Mail_Check {} {
   Debug "Background_Mail_Check"

   # Globals
   global gb_connection_down g_mail_refresh_freq gt_incoming_mail \
      gt_outgoing_mail g_check_remote_mail g_check_local_mail \
      GREEN RED gb_mail_window_up gb_delivering_mail \
      gs_incoming_mail gs_outgoing_mail gs_remote_mail_indicator \
      gs_local_mail_indicator gt_incoming_mail gt_outgoing_mail \
      gs_spool_dir g_spool_file_size gb_beep_on_new_mail \
      TKNET_USER g_log_file gb_have_sendmail

   # Only perform this processing if the mail window
   # is still active
   if {$gb_mail_window_up == 1} {

      # Set global hourglassing
      WatchCursor
   
      # Only get remote info if connected
      Set_Connection_Flag
   
      if {$gb_connection_down == 0} {
   
         # Remote mail i.e. incoming
         catch { eval exec $g_check_remote_mail} \
            gs_incoming_mail

         # Display in textbox
         $gt_incoming_mail delete 1.0 end
         $gt_incoming_mail insert end $gs_incoming_mail
         $gt_incoming_mail insert end "\n"

      } else {
   
         # Log the fact that remote mail info is unavailable
         $gt_incoming_mail delete 1.0 end
         $gt_incoming_mail insert end "Incoming mail information is unavailable"
         $gt_incoming_mail insert end "\n"
      }
   
      # Check for local mail
      catch { eval exec $g_check_local_mail} \
         gs_outgoing_mail
      set display $gs_outgoing_mail
      
      # Format the mail (if sendmailis specified)
      if {$gb_have_sendmail == 1} {
         set display ""
         set incoming_list [split $gs_outgoing_mail "\n"]
         # Strip first line of spaces and add to display
         regsub -all "\t" [lindex $incoming_list 0] "" line
         append display "$line\n\n"
         append display "Size\t\tSender\t\tRecipient\n"
         append display "-------------------------------------------------------------\n"
         # Ignore second line - loop through message details
         set line_num 2
         while {$line_num < [llength $incoming_list]} {
            # First line_num has sender + size
            regsub -all "  " [lindex $incoming_list $line_num] " " line
            set list [split $line]
            # Check for valid start of queued item
            if {[lindex $list 0] == ""} {continue}
            set line [lindex $list 3]
            append display "$line\t\t"
            set line [lindex $list 8]
            append display "$line\t"
            # Third line has recipient
            incr line_num 2
            regsub -all "\t" [lindex $incoming_list $line_num] "" line
            regsub -all " " $line "" line
            append display "$line\n"
            incr line_num 1
         }
      }
   
      # Display in textbox
      $gt_outgoing_mail delete 1.0 end
      $gt_outgoing_mail insert end $display
      $gt_outgoing_mail insert end "\n"

      # This routine not only fetches and displays information
      # about mail to be delivered locally and mail being held
      # on the remote server, but also determines whether there
      # is any mail left to deliver.  When the gb_delivering_mail
      # flag is set, after the routine has determined that there
      # is no more mail to deliver, it closes the window and
      # the netowrk connection.
      if {$gb_connection_down == 0 && \
         $gb_delivering_mail == 1} {

         # Note : both checks must FAIL, i.e. the strings
         # given in the configuration section are strings
         # that are known to appear when mail is present 
         # on the servers.
         if { [ string first $gs_local_mail_indicator \
            $gs_outgoing_mail ] == -1 && \
            [ string first $gs_remote_mail_indicator \
            $gs_incoming_mail ] == -1} {

            # No more messages to deliver
            Set_Message \
               "No more messages to deliver - disconnecting" \
               $GREEN
 
            # Disconnect from network
            Net_Disconnect

            # Close the mail window
            Close_Mail_Window
         }
      }

      # Rerun after N secs
      if {$g_mail_refresh_freq > 0} {
         set run_after [ expr $g_mail_refresh_freq * 1000 ]
         after $run_after Background_Mail_Check
      } else {
         after 30000 Background_Mail_Check
      }

      # Undo hourglassing
      NormalCursor
   }
}

###############################################################
# The procedure for quitting the mail window
proc Close_Mail_Window {} {
   Debug "Close_Mail_Window"

   # Globals
   global gb_mail_window_up

   # Reset the flag
   set gb_mail_window_up 0

   # Destroy the window
   destroy .mail_window 
}


