###############################################################
# TkNet - Log Module
# Charlie KEMPSON - charlie@siren.demon.co.uk
# http://public.logica.com/~kempsonc/tknet.htm
# Version 1.1
###############################################################

###############################################################
#
#    Copyright (c) 1995-1996 Charlie Kempson
#
#    This program is free software; you can redistribute it 
#    and/or modify it under the terms of the GNU General 
#    Public License as published by the Free Software 
#    Foundation (version 2 of the License).
#
#    This program is distributed in the hope that it will 
#    be useful, but WITHOUT ANY WARRANTY; without even the 
#    implied warranty of MERCHANTABILITY or FITNESS FOR A 
#    PARTICULAR PURPOSE.  See the GNU General Public License 
#    for more details.
#
#    For a copy of the GNU General Public License, write to the 
#    Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
#    MA 02139, USA.
###############################################################

###############################################################
# Globals for this module

# Flags
set g_log_file_size     0
set g_log_messages      0

# Geometry
set TKNET_LOG_GEOMETRY  "+500+51"

###############################################################
# Show the log panel
proc Show_Log { } {
   Debug "Show_Log"

   # Globals
   global FONT_NORMAL FIXED_FONT_SMALL RIDGE_BORDER \
      DEFAULT_PADDING g_log_messages TKNET_LOG_GEOMETRY \
      g_log_file g_log_file_id

   # Create the log toplevel as a transient from the main window
   set window .log_window
   if [winfo exists $window] return
   toplevel $window
   wm title $window "View Log"
   wm transient $window .
   wm geometry $window $TKNET_LOG_GEOMETRY
   wm protocol $window WM_DELETE_WINDOW Close_Log_Window

   ###############################################################
   # Create the log panel
   set frame [frame $window.log_fr -borderwidth $RIDGE_BORDER \
      -relief groove]
   pack $frame -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING \
      -side top -expand true -fill both
   label $frame.log_label -text "Messages" 
   pack $frame.log_label -side top -anchor w
   set g_log_messages [ScrolledText $frame.log_st 60 20 1]
   $g_log_messages configure -takefocus 0 -font $FIXED_FONT_SMALL

   ###############################################################
   # Create the buttons below the frame
   set frame [frame $window.button_frame -borderwidth $DEFAULT_PADDING]
   pack $frame -side bottom -fill x
   button $frame.close -text Close -command {destroy .log_window}
   button $frame.help -text Help -command {MH_MiniHelp LogWindow}
   pack $frame.close $frame.help -side right -padx $DEFAULT_PADDING \
      -pady $DEFAULT_PADDING

   ###############################################################
   # Read the log file
   Read_Log_File
}

###############################################################
# The procedure for reading from the log file
proc Read_Log_File {} {
   # Debug "Read_Log_File"

   # Globals
   global g_log_file g_log_file_size g_log_messages

   #Info_Dialog . "Reading data"
   if {[winfo exists $g_log_messages]} {

      # Read the file data if more available
      set log_file_size [file size $g_log_file]
      if {$log_file_size > $g_log_file_size} {
         $g_log_messages configure -state normal
         $g_log_messages delete 1.0 end
         $g_log_messages insert end [eval exec \
            tail -50 $g_log_file]
         $g_log_messages insert end \n
         $g_log_messages see end
         $g_log_messages configure -state disabled
      }
      set g_log_file_size $log_file_size
      after 5000 Read_Log_File
   }
}

###############################################################
# The procedure for quitting the log window
proc Close_Log_Window {} {
   Debug "Close_Log_Window"

   # Globals
   global g_read_log_file_id g_log_file_size

   # Ensure that when the window is reopened the file is read
   set g_log_file_size 0

   # Destroy the window
   destroy .log_window 
}


