###############################################################
# TkNet - Help Module
# Charlie KEMPSON - charlie@siren.demon.co.uk
# http://public.logica.com/~kempsonc/tknet.htm
# Version 1.1
###############################################################

###############################################################
#
#    Copyright (c) 1995-1996 Charlie Kempson
#
#    This program is free software; you can redistribute it 
#    and/or modify it under the terms of the GNU General 
#    Public License as published by the Free Software 
#    Foundation (version 2 of the License).
#
#    This program is distributed in the hope that it will 
#    be useful, but WITHOUT ANY WARRANTY; without even the 
#    implied warranty of MERCHANTABILITY or FITNESS FOR A 
#    PARTICULAR PURPOSE.  See the GNU General Public License 
#    for more details.
#
#    For a copy of the GNU General Public License, write to the 
#    Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
#    MA 02139, USA.
###############################################################

###############################################################
# Globals for this module
set gb_show_formatted 1

# Flags
set gas_history ""

# Geometry
set TKNET_HELP_GEOMETRY "+200+200"

###############################################################
# Show the mini-help panel
proc MH_MiniHelp {text} {

   # The argument to MH_MiniHelp must be the name of the page
   # as created by MiniHelp.  Th global avariable containing
   # the help text has this name plus a gs_HELPTEXT_ prefix
   # for uniqueness.

   # Globals
   global RIDGE_BORDER DEFAULT_PADDING FONT_NORMAL \
      gt_mini_help TKNET_HELP_GEOMETRY gas_history
   if {[string first "gs_HELPTEXT_" $text] != -1} {
      set global_help $text
   } else {
      set global_help "gs_HELPTEXT_$text"
   }
   global $global_help
   set local_text [subst \$$global_help]

   # Perform substitution of invalid tcl characters
   # e.g. ${}[]"'
   set charlist [list \$ \{ \} \[ \] \" \' \\ ]
   set replacelist [list \&dollar\; \&lbrace\; \&rbrace\; \&lsquare\; \
      \&rsquare\; \&quot\; \&squot\; \&backslash\; ]
   set count 0
   set char [lindex $charlist $count]
   set repl [lindex $replacelist $count]
   while {$count < [llength $charlist]} {
      # Search and replace
      regsub -all $repl $local_text $char local_text

      # Get the next item
      incr count
      set char [lindex $charlist $count]
      set repl [lindex $replacelist $count]
   }

   WatchCursor
   # Test for window
   if ![winfo exists .mini_help_window] {
   
      # Create the mini-help screen
      set window [toplevel .mini_help_window]
      wm title .mini_help_window "Help"
      wm transient .mini_help_window .
      wm geometry .mini_help_window $TKNET_HELP_GEOMETRY

      ###########################################################################
      # Create Menu Bar
      frame $window.mbar -relief raised -bd 2
      pack $window.mbar -side top -fill x

      # Create the buttons   
      menubutton $window.mbar.file -text File -underline 0 -menu \
         $window.mbar.file.menu
      menubutton $window.mbar.navigate -text Navigate -underline 0 \
         -menu $window.mbar.navigate.menu
      pack $window.mbar.file $window.mbar.navigate \
         -side left

      # Create each menu item
      menu $window.mbar.file.menu -tearoff 0
         $window.mbar.file.menu add command -label "Close" \
            -command "destroy $window" -underline 0
      menu $window.mbar.navigate.menu -tearoff 0
         $window.mbar.navigate.menu add command -label "Back" \
            -command MH_NavigateBack -underline 0
         $window.mbar.navigate.menu add separator
         $window.mbar.navigate.menu add command -label "Contents" \
            -command "MH_MiniHelp Contents" -underline 0
         $window.mbar.navigate.menu add command -label "History" \
            -command "MH_ShowHelpHistory" -underline 0

      # Create the menu
      tk_menuBar $window.mbar $window.mbar.file \
      $window.mbar.navigate

      ###############################################################
      # Create the log panel
      frame .mini_help_window.fr -borderwidth $RIDGE_BORDER \
         -relief groove
      pack .mini_help_window.fr -padx $DEFAULT_PADDING -pady \
         $DEFAULT_PADDING -side top -expand true -fill both
      set gt_mini_help [ScrolledText \
         .mini_help_window.fr.help 80 25 0]
      $gt_mini_help configure -font $FONT_NORMAL
      pack .mini_help_window.fr.help -side top -anchor w
   
      ###############################################################
      # Create the buttons below the frame
      frame .mini_help_window.button_frame -borderwidth $DEFAULT_PADDING
      pack .mini_help_window.button_frame -side bottom -fill x
      button .mini_help_window.button_frame.close -font $FONT_NORMAL \
          -text Close -command { destroy .mini_help_window }
      pack .mini_help_window.button_frame.close

   }

   # Check for minimised state and raise it
   wm deiconify .mini_help_window
   raise .mini_help_window
   
   # Put the help text in the window
   # $gt_mini_help configure -state normal
   $gt_mini_help delete 1.0 end
   $gt_mini_help insert end $local_text
   MH_ParseHelp 1
   # $gt_mini_help configure -state disabled -font $FONT_NORMAL

   # Add to the history list (removing any other references to
   # the page on the way - there will be at most one given the
   # nature of the check)
   set item [lsearch -exact $gas_history $global_help]
   if {$item != -1} {set gas_history [lreplace $gas_history $item $item]}
   lappend gas_history $global_help

   NormalCursor
}

###############################################################
# The procedure for finding tags in the help
proc MH_ParseHelp { is_run_time } {

   # If the argument is_run_time is True (1), then 
   # the help text should be interpreted as being
   # run-time help text.  Otherwise, it should be 
   # interpreted as being for the Minihelp editor

   # Globals
   global gt_mini_help search FONT_BOLD FONT_ITALIC \
      FIXED_FONT TEXT_COLOUR RED GREEN gb_show_formatted

   # If show is true, redisplay the text in formatted form.
   # Otherwise, leave unformatted.
   if {$gb_show_formatted == 1} {
      # Now redisplay the text and disable the save button
      # $gt_mini_help configure -state normal
   } else {
      # Disable text
      # $gt_mini_help configure -state disabled
      return
   }

   # Format list
   set format_list [list TITLE BOLD ITALIC FIXED UNDERLINE CENTER \
      LEFT RIGHT]

   # Keyworks and formatting
   set TITLE "TITLE"
   set TITLE_FORMAT "-font $FONT_BOLD -underline True -justify center"
   set BOLD  "B"
   set BOLD_FORMAT "-font $FONT_BOLD"
   set ITALIC "I"
   set ITALIC_FORMAT "-font $FONT_ITALIC"
   set FIXED "TT"
   set FIXED_FORMAT "-font $FIXED_FONT"
   set UNDERLINE "U"
   set UNDERLINE_FORMAT "-underline True"
   set CENTER "CENTER"
   set CENTER_FORMAT "-justify center"
   set LEFT "LEFT"
   set LEFT_FORMAT "-justify left"
   set RIGHT "RIGHT"
   set RIGHT_FORMAT "-justify right"

   # Loop round the declared types
   foreach type $format_list {

      # Start at the beginning
      set location    1.0
      while {$location != ""} {
         set start [eval $gt_mini_help search -nocase "<$$type>" \
            $location end]
         if {$start != ""} {
            set location [eval $gt_mini_help search -nocase </$$type> \
               $start end]
            if {$location != ""} {
               $gt_mini_help tag add $type $start $location
            } else {
               # Skip this code
               set location [$gt_mini_help index "$start  +1c wordend +1c"]
            }
         } else {set location ""}
      }
      # DO FORMATTING
      set format [eval subst \$${type}_FORMAT]
      eval $gt_mini_help tag configure $type $format
      $gt_mini_help tag raise $type

      # Delete codes and format headers
      set start 1.0
      set end 1.0
      while {$start != "" || $end != ""} {
         set start [eval $gt_mini_help search -nocase "<$$type>" \
            $start end]
         if {$start != ""} {
            $gt_mini_help delete $start "$start +1c wordend +1c"}
         set end [eval $gt_mini_help search -nocase "</$$type>" \
            $end end]
         if {$end != ""} {
            $gt_mini_help delete $end "$end +2c wordend +1c"}
      }
   }

   # And now for the hyperlinks to other parts of the help text
   # These are refered to in the text as <XREF location>, where
   # location is the name of the next peice of text, e.g.
   # <XREF gs_site_specific_help>Goto Site Specific help</XREF>

   # Start at the beginning
   set location    1.0
   while {$location != ""} {
      set start [eval $gt_mini_help search -nocase "<XREF" \
         $location end]
      if {$start != ""} {
         set location [eval $gt_mini_help search -nocase </XREF> \
            $start end]
         if {$location != ""} {
            # Get the hyperlink location (note that for this to be
            # successful the tag must start within 3 characters of
            # the <XREF tag.
            set hyper [$gt_mini_help get "$start +1c wordend +3c wordstart" \
               "$start +1c wordend +3c wordend"]
            $gt_mini_help tag add $hyper $start $location
            $gt_mini_help tag raise $hyper
            $gt_mini_help tag configure $hyper -foreground \
               $GREEN -font $FONT_BOLD
            $gt_mini_help tag bind $hyper <Enter> \
               "$gt_mini_help tag configure $hyper -foreground $RED"
            $gt_mini_help tag bind $hyper <Leave> \
               "+$gt_mini_help tag configure $hyper -foreground $GREEN"
            if {$is_run_time == 1} {
               $gt_mini_help tag bind $hyper <ButtonPress> "MH_MiniHelp $hyper"
            } else {
               $gt_mini_help tag bind $hyper <ButtonPress> "MH_ShowHyperMenu $hyper"
            }
         } else {
            # Skip this code
            set location [$gt_mini_help index "$start  +1c wordend +1c"]
         }
      } else {
         set location ""
      }
   }

   # Delete codes and format headers
   set start 1.0
   set end 1.0
   while {$start != "" || $end != ""} {
      set start [eval $gt_mini_help search -nocase "<XREF" \
         $start end]
      if {$start != ""} {
         $gt_mini_help delete $start "$start +1c wordend +3c wordend +1c"}
      set end [eval $gt_mini_help search -nocase "</XREF>" \
         $end end]
      if {$end != ""} {
         $gt_mini_help delete $end "$end +2c wordend +1c"}
   }

   # And now for the embedded images, which have locators in
   # the text of the form <IMG SRC=Name>, where Name is the
   # filename of the image to be displayed.

   # Start at the beginning
   set location    1.0
   while {$location != ""} {
      set location [$gt_mini_help search -nocase "<IMG SRC=" \
         $location end]
      if {$location != ""} {
         # Get the image location
         set end [$gt_mini_help search -nocase ">" $location end]
         set image [$gt_mini_help get "$location +1c wordend +3c wordend \
            +1c" $end]
         #MH_InfoDialog . $image
         MH_InsertImage $location $image
         set location $end
      }
   }

   # Delete codes and format headers
   set start 1.0
   while {$start != ""} {
      set start [$gt_mini_help search -nocase "<IMG SRC" \
         $start end]
      if {$start != ""} {
         set end [$gt_mini_help search -nocase ">" $start end]
         $gt_mini_help delete $start "$end +1c"
      }
   }
}

###############################################################
# The procedure for placing an image into the text
proc MH_InsertImage { location {name ""} } {

   # Globals
   global gt_mini_help RIDGE_BORDER g_image_path \
      gs_image_base_dir gs_current_project \
      RIDGE_BORDER DEFAULT_PADDING TEXT_COLOUR

   # Images are created for the current page with the 
   # names 1,2,3 etc... and are tagged with the tag
   # name 'image<N>' where N is the image name.

   if {$name == ""} {
      set image_name [File_Select "Select Image..." "*" \
         $gs_image_base_dir]
      if {$image_name == ""} {return}

      # Strip leading directories if relative directory specified
      if {$g_image_path == "Relative"} {
         # Check specified directory
         set dir [file dirname $image_name]
         if {$dir != $gs_image_base_dir} {
            Info_Dialog . "Warning:  Directory $dir specified 
does not match image directory $gs_image_base_dir.
Your image may not display properly."
         }
         # Strip off the directory and leading slash
         regsub $dir $image_name {} image_name
         set image_name [string range $image_name 1 end]
      }
      if {$image_name == ""} {return}
   } else {
      set image_name $name
   }

   # Check for existence
   # Info_Dialog . $image_name
   if [file exists $image_name] {
      set image [Create_Image $image_name]
   } elseif [file exists $gs_image_base_dir/$image_name] {
      set image [Create_Image $gs_image_base_dir/$image_name]
   } else {
      # Image does not exist
      set image -1
   }

   if {$image != -1} {
      set num_windows [llength [$gt_mini_help window names]]
      incr num_windows

      # Create the image in a frame
      frame $gt_mini_help.$num_windows
      label $gt_mini_help.$num_windows.l -image $image -background \
         $TEXT_COLOUR -bd 0 -highlightthickness 0
      label $gt_mini_help.$num_windows.name -text $image_name
      pack $gt_mini_help.$num_windows.l -side top
      $gt_mini_help window create $location -padx 5 -pady 5 \
         -window $gt_mini_help.$num_windows
      $gt_mini_help tag add image$num_windows $location
   } else {
      set num_windows [llength [$gt_mini_help window names]]
      incr num_windows

      # Create the image in a frame
      frame $gt_mini_help.$num_windows
      label $gt_mini_help.$num_windows.name -text $image_name
      pack $gt_mini_help.$num_windows.name -side top
      $gt_mini_help window create $location -padx 10 -pady 10 \
         -window $gt_mini_help.$num_windows
      $gt_mini_help tag add image$num_windows $location
   }
}

###############################################################
# The procedure to navigate backwards through the history
proc MH_NavigateBack {} {

   # Globals
   global gas_history 

   # The list gas_history contains a list of all help pages
   # visited.  Simply extract the second to last page, and
   # delete the last item in the list, then dislpay the 
   # page.
   if {[llength $gas_history] < 2} {
      # Nowhere to return to
      return
   }
   
   # Get the last page
   set help [lindex $gas_history [expr [llength $gas_history] - 2]]

   # Delete the two last items (note that one of them is recreated
   # when we call MH_MiniHelp).
   set gas_history [lreplace $gas_history [expr [llength $gas_history] \
      - 2] end]

   # And show the help page
   MH_MiniHelp $help
}

###############################################################
# The procedure to navigate backwards through the history
proc MH_ShowHelpHistory {} {

   # Globals
   global gas_history RIDGE_BORDER \
      DEFAULT_PADDING

   # Test for window
   # Popup a selection window
   set window .mini_help_history
   if [winfo exists $window] {
       # Pop it up!
       wm deiconify $window
       raise $window
       update
       return
   }

   # Create the mini-help screen
   toplevel $window
   wm title $window "Help History"
   wm transient $window .

   # Create a frame containing a list
   frame $window.sel_fr -borderwidth $RIDGE_BORDER -relief groove
   pack $window.sel_fr -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING \
      -side top -fill x
   set list [ScrolledList $window.list_fr 0 10 browse 0]
   pack forget $window.list_fr
   pack $window.list_fr -side top -fill both -padx $DEFAULT_PADDING \
      -pady $DEFAULT_PADDING -expand true

   # Add the help pages title to the list
   foreach item $gas_history {
      # Get the help text title for the page
      set text "Unknown Help Page"
      global $item
      set local_text [subst \$$item]
      set start [string first "<title>" $local_text]
      if {$start == -1} {set start [string first "<TITLE>" $local_text]}
      set end [string first "</title>" $local_text]
      if {$end == -1} {set end [string first "</TITLE>" $local_text]}

      if {$start != -1} {
         set start [expr [string wordend $local_text [expr $start + 1]] +1]
         set end [expr [string wordstart $local_text $end] -1]
         set text [string range $local_text $start $end]
         set text [string trimleft $text]
      } else {
         Info_Dialog . "Error in help text (${item})!  
All pages must begin with a title e.g. 
<title>Contents</title> or
<TITLE>Contents</TITLE>"
      }
      $list insert end $text
   }

   # Now for a goto, close and contents button
   set frame [frame $window.button_fr]
   pack $frame -side bottom -fill x
   button $frame.close -text Close -command "destroy $window"
   button $frame.contents -text Contents -command "MH_MiniHelp Contents"
   button $frame.goto -text Goto -command "MH_GotoHelp $window $list"
   pack $frame.close $frame.contents $frame.goto -side right \
      -padx $DEFAULT_PADDING -pady $DEFAULT_PADDING

   # And now centre it on its parent
   Centre_Dialog $window widget .mini_help_window
}

###############################################################
# The procedure to goto a specified page from the history
proc MH_GotoHelp { window list } {

   # Globals
   global gas_history

   set selected [$list curselection]
   if {$selected == ""} {return}
   set text [lindex $gas_history $selected]
   set gas_history [lreplace $gas_history $selected end]

   # Show the new page
   MH_MiniHelp $text
   destroy $window
}

###############################################################
# The procedure to start up an edit session using MiniHelp
proc MH_EditHelp { } {

   # Globals
   global TKNET_USER GLOBAL_INCLUDE

   # Check that the user is root - if not, disallow operation
   if {$TKNET_USER != "root"} {
      Info_Dialog . "You must be root to edit the help!"
   } else {
      # Start the edit session
      if [catch {eval exec wish -f $GLOBAL_INCLUDE/modules/MiniHelp.tcl &} errortext] {
         Info_Dialog . "MiniHelp edit session failed with error:\n$errortext"
      }
   }
}


